# encoding: utf-8
# module lib2to3.fixes.fix_map
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixes/fix_map.pyo by generator 1.99
"""
Fixer that changes map(F, ...) into list(map(F, ...)) unless there
exists a 'from future_builtins import map' statement in the top-level
namespace.

As a special case, map(None, X) is changed into list(X).  (This is
necessary because the semantics are changed in this case -- the new
map(None, X) is equivalent to [(x,) for x in X].)

We avoid the transformation (except for the special case mentioned
above) if the map() call is directly contained in iter(<>), list(<>),
tuple(<>), sorted(<>), ...join(<>), or for V in <>:.

NOTE: This is still not correct if the original code was depending on
map(F, X, Y, ...) to go on until the longest argument is exhausted,
substituting None for missing values -- like zip(), it now stops as
soon as the shortest argument is exhausted.
"""

# imports
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixer_base.pyc
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pgen2/token.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base


# functions

def Call(func_name, args=None, prefix=None): # reliably restored by inspect
    """ A function call """
    pass


def in_special_context(node): # reliably restored by inspect
    """
    Returns true if node is in an environment where all that is required
            of it is being itterable (ie, it doesn't matter if it returns a list
            or an itterator).
            See test_map_nochange in test_fixers.py for some examples and tests.
    """
    pass


def ListComp(xp, fp, it, test=None): # reliably restored by inspect
    """
    A list comprehension of the form [xp for fp in it if test].
    
        If test is None, the "if test" part is omitted.
    """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


# classes

class FixMap(__lib2to3_fixer_base.ConditionalFix):
    # no doc
    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    BM_compatible = True
    PATTERN = "\n    map_none=power<\n        'map'\n        trailer< '(' arglist< 'None' ',' arg=any [','] > ')' >\n    >\n    |\n    map_lambda=power<\n        'map'\n        trailer<\n            '('\n            arglist<\n                lambdef< 'lambda'\n                         (fp=NAME | vfpdef< '(' fp=NAME ')'> ) ':' xp=any\n                >\n                ','\n                it=any\n            >\n            ')'\n        >\n    >\n    |\n    power<\n        'map' trailer< '(' [arglist=any] ')' >\n    >\n    "
    skip_on = 'future_builtins.map'


# variables with complex values

syms = None # (!) real value is ''

