# encoding: utf-8
# module lib2to3.fixes.fix_raise
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixes/fix_raise.pyo by generator 1.99
"""
Fixer for 'raise E, V, T'

raise         -> raise
raise E       -> raise E
raise E, V    -> raise E(V)
raise E, V, T -> raise E(V).with_traceback(T)
raise E, None, T -> raise E.with_traceback(T)

raise (((E, E'), E''), E'''), V -> raise E(V)
raise "foo", V, T               -> warns about string exceptions


CAVEATS:
1) "raise E, V" will be incorrectly translated if V is an exception
   instance. The correct Python 3 idiom is

        raise E from V

   but since we can't detect instance-hood by syntax alone and since
   any client code would have to be changed as well, we don't automate
   this.
"""

# imports
import lib2to3.pytree as pytree # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pytree.pyc
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/fixer_base.pyc
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib2to3/pgen2/token.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base


# functions

def ArgList(args, lparen="Leaf(7, u'(')", rparen="Leaf(8, u')')"): # reliably restored by inspect
    """ A parenthesised argument list, used by Call() """
    pass


def Attr(obj, attr): # reliably restored by inspect
    """ A node tuple for obj.attr """
    pass


def Call(func_name, args=None, prefix=None): # reliably restored by inspect
    """ A function call """
    pass


def is_tuple(node): # reliably restored by inspect
    """ Does the node represent a tuple literal? """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


# classes

class FixRaise(__lib2to3_fixer_base.BaseFix):
    # no doc
    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    BM_compatible = True
    PATTERN = "\n    raise_stmt< 'raise' exc=any [',' val=any [',' tb=any]] >\n    "


