# encoding: utf-8
# module logging.config
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/config.pyo by generator 1.99
"""
Configuration functions for the logging package for Python. The core package
is based on PEP 282 and comments thereto in comp.lang.python, and influenced
by Apache's log4j system.

Copyright (C) 2001-2010 Vinay Sajip. All Rights Reserved.

To use, simply 'import logging' and log away!
"""

# imports
import cStringIO as cStringIO # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/cStringIO.so
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/struct.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import sys as sys # <module 'sys' (built-in)>
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/types.pyc
import logging as logging # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/__init__.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/socket.pyc
import thread as thread # <module 'thread' (built-in)>
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/traceback.pyc
import threading as threading # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/threading.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

DEFAULT_LOGGING_CONFIG_PORT = 9030

RESET_ERROR = 104

_listener = None

# functions

def dictConfig(config): # reliably restored by inspect
    """ Configure logging using a dictionary. """
    pass


def fileConfig(fname, defaults=None, disable_existing_loggers=True): # reliably restored by inspect
    """
    Read the logging configuration from a ConfigParser-format file.
    
        This can be called several times from an application, allowing an end user
        the ability to select from various pre-canned configurations (if the
        developer provides a mechanism to present the choices and load the chosen
        configuration).
    """
    pass


def listen(port=9030): # reliably restored by inspect
    """
    Start up a socket server on the specified port, and listen for new
        configurations.
    
        These will be sent as a file suitable for processing by fileConfig().
        Returns a Thread object on which you can call start() to start the server,
        and which you can join() when appropriate. To stop the server, call
        stopListening().
    """
    pass


def stopListening(): # reliably restored by inspect
    """ Stop the listening server which was created with a call to listen(). """
    pass


def valid_ident(s): # reliably restored by inspect
    # no doc
    pass


def _create_formatters(cp): # reliably restored by inspect
    """ Create and return formatters """
    pass


def _encoded(s): # reliably restored by inspect
    # no doc
    pass


def _install_handlers(cp, formatters): # reliably restored by inspect
    """ Install and return handlers """
    pass


def _install_loggers(cp, handlers, disable_existing_loggers): # reliably restored by inspect
    """ Create and install loggers """
    pass


def _resolve(name): # reliably restored by inspect
    """ Resolve a dotted name to a global object. """
    pass


def _strip_spaces(alist): # reliably restored by inspect
    # no doc
    pass


# classes

class BaseConfigurator(object):
    """ The configurator base class which defines some useful defaults. """
    def as_tuple(self, *args, **kwargs): # real signature unknown
        """ Utility function which converts lists to tuples. """
        pass

    def cfg_convert(self, *args, **kwargs): # real signature unknown
        """ Default converter for the cfg:// protocol. """
        pass

    def configure_custom(self, *args, **kwargs): # real signature unknown
        """ Configure an object with a user-supplied factory. """
        pass

    def convert(self, *args, **kwargs): # real signature unknown
        """
        Convert values to an appropriate type. dicts, lists and tuples are
                replaced by their converting alternatives. Strings are checked to
                see if they have a conversion format and are converted if they do.
        """
        pass

    def ext_convert(self, *args, **kwargs): # real signature unknown
        """ Default converter for the ext:// protocol. """
        pass

    def importer(self, *args, **kwargs): # real signature unknown
        """
        __import__(name, globals={}, locals={}, fromlist=[], level=-1) -> module
        
        Import a module.  The globals are only used to determine the context;
        they are not modified.  The locals are currently unused.  The fromlist
        should be a list of names to emulate ``from name import ...'', or an
        empty list to emulate ``import name''.
        When importing a module from a package, note that __import__('A.B', ...)
        returns package A when fromlist is empty, but its submodule B when
        fromlist is not empty.  Level is used to determine whether to perform 
        absolute or relative imports.  -1 is the original strategy of attempting
        both absolute and relative imports, 0 is absolute, a positive number
        is the number of parent directories to search relative to the current module.
        """
        pass

    def resolve(self, *args, **kwargs): # real signature unknown
        """
        Resolve strings to objects using standard import and attribute
                syntax.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    CONVERT_PATTERN = None # (!) real value is ''
    DIGIT_PATTERN = None # (!) real value is ''
    DOT_PATTERN = None # (!) real value is ''
    INDEX_PATTERN = None # (!) real value is ''
    value_converters = {
        'cfg': 'cfg_convert',
        'ext': 'ext_convert',
    }
    WORD_PATTERN = None # (!) real value is ''
    __dict__ = None # (!) real value is ''


class ConvertingDict(dict):
    """ A converting dictionary wrapper. """
    def get(self, *args, **kwargs): # real signature unknown
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class ConvertingList(list):
    """ A converting list wrapper. """
    def pop(self, *args, **kwargs): # real signature unknown
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class ConvertingTuple(tuple):
    """ A converting tuple wrapper. """
    def __getitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __dict__ = None # (!) real value is ''


class DictConfigurator(BaseConfigurator):
    """
    Configure logging using a dictionary-like object to describe the
        configuration.
    """
    def add_filters(self, *args, **kwargs): # real signature unknown
        """ Add filters to a filterer from a list of names. """
        pass

    def add_handlers(self, *args, **kwargs): # real signature unknown
        """ Add handlers to a logger from a list of names. """
        pass

    def common_logger_config(self, *args, **kwargs): # real signature unknown
        """ Perform configuration which is common to root and non-root loggers. """
        pass

    def configure(self, *args, **kwargs): # real signature unknown
        """ Do the configuration. """
        pass

    def configure_filter(self, *args, **kwargs): # real signature unknown
        """ Configure a filter from a dictionary. """
        pass

    def configure_formatter(self, *args, **kwargs): # real signature unknown
        """ Configure a formatter from a dictionary. """
        pass

    def configure_handler(self, *args, **kwargs): # real signature unknown
        """ Configure a handler from a dictionary. """
        pass

    def configure_logger(self, *args, **kwargs): # real signature unknown
        """ Configure a non-root logger from a dictionary. """
        pass

    def configure_root(self, *args, **kwargs): # real signature unknown
        """ Configure a root logger from a dictionary. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


dictConfigClass = DictConfigurator


# variables with complex values

IDENTIFIER = None # (!) real value is ''

StreamRequestHandler = None # (!) real value is ''

ThreadingTCPServer = None # (!) real value is ''

