# encoding: utf-8
# module logging.handlers
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/handlers.pyo by generator 1.99
"""
Additional handlers for the logging package for Python. The core package is
based on PEP 282 and comments thereto in comp.lang.python, and influenced by
Apache's log4j system.

Copyright (C) 2001-2010 Vinay Sajip. All Rights Reserved.

To use, simply 'import logging.handlers' and log away!
"""

# imports
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/struct.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import cPickle as cPickle # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/cPickle.so
import codecs as codecs # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/codecs.pyc
import logging as logging # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/logging/__init__.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/socket.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/time.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import logging as __logging


# Variables with simple values

DEFAULT_HTTP_LOGGING_PORT = 9022

DEFAULT_SOAP_LOGGING_PORT = 9023

DEFAULT_TCP_LOGGING_PORT = 9020

DEFAULT_UDP_LOGGING_PORT = 9021

ST_DEV = 2
ST_INO = 1
ST_MTIME = 8

SYSLOG_TCP_PORT = 514

SYSLOG_UDP_PORT = 514

_MIDNIGHT = 86400

_unicode = True

# no functions
# classes

class BaseRotatingHandler(__logging.FileHandler):
    """
    Base class for handlers that rotate log files at a certain point.
        Not meant to be instantiated directly.  Instead, use RotatingFileHandler
        or TimedRotatingFileHandler.
    """
    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                Output the record to the file, catering for rollover as described
                in doRollover().
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Use the specified filename for streamed logging """
        pass


class BufferingHandler(__logging.Handler):
    """
    A handler class which buffers logging records in memory. Whenever each
      record is added to the buffer, a check is made to see if the buffer should
      be flushed. If it should, then flush() is expected to do what's needed.
    """
    def close(self): # real signature unknown; restored from __doc__
        """
        Close the handler.
        
                This version just flushes and chains to the parent class' close().
        """
        pass

    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                Append the record. If shouldFlush() tells us to, call flush() to process
                the buffer.
        """
        pass

    def flush(self, *args, **kwargs): # real signature unknown
        """
        Override to implement custom flushing behaviour.
        
                This version just zaps the buffer to empty.
        """
        pass

    def shouldFlush(self, *args, **kwargs): # real signature unknown
        """
        Should the handler flush its buffer?
        
                Returns true if the buffer is up to capacity. This method can be
                overridden to implement custom flushing strategies.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initialize the handler with the buffer size. """
        pass


class SocketHandler(__logging.Handler):
    """
    A handler class which writes logging records, in pickle format, to
        a streaming socket. The socket is kept open across logging calls.
        If the peer resets it, an attempt is made to reconnect on the next call.
        The pickle which is sent is that of the LogRecord's attribute dictionary
        (__dict__), so that the receiver does not need to have the logging module
        installed in order to process the logging event.
    
        To unpickle the record at the receiving end into a LogRecord, use the
        makeLogRecord function.
    """
    def close(self, *args, **kwargs): # real signature unknown
        """ Closes the socket. """
        pass

    def createSocket(self, *args, **kwargs): # real signature unknown
        """
        Try to create a socket, using an exponential backoff with
                a max retry time. Thanks to Robert Olson for the original patch
                (SF #815911) which has been slightly refactored.
        """
        pass

    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                Pickles the record and writes it to the socket in binary format.
                If there is an error with the socket, silently drop the packet.
                If there was a problem with the socket, re-establishes the
                socket.
        """
        pass

    def handleError(self, *args, **kwargs): # real signature unknown
        """
        Handle an error during logging.
        
                An error has occurred during logging. Most likely cause -
                connection lost. Close the socket so that we can retry on the
                next event.
        """
        pass

    def makePickle(self, *args, **kwargs): # real signature unknown
        """
        Pickles the record in binary format with a length prefix, and
                returns it ready for transmission across the socket.
        """
        pass

    def makeSocket(self, *args, **kwargs): # real signature unknown
        """
        A factory method which allows subclasses to define the precise
                type of socket they want.
        """
        pass

    def send(self, *args, **kwargs): # real signature unknown
        """
        Send a pickled string to the socket.
        
                This function allows for partial sends which can happen when the
                network is busy.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializes the handler with a specific host address and port.
        
                The attribute 'closeOnError' is set to 1 - which means that if
                a socket error occurs, the socket is silently closed and then
                reopened on the next logging call.
        """
        pass


class DatagramHandler(SocketHandler):
    """
    A handler class which writes logging records, in pickle format, to
        a datagram socket.  The pickle which is sent is that of the LogRecord's
        attribute dictionary (__dict__), so that the receiver does not need to
        have the logging module installed in order to process the logging event.
    
        To unpickle the record at the receiving end into a LogRecord, use the
        makeLogRecord function.
    """
    def makeSocket(self, *args, **kwargs): # real signature unknown
        """
        The factory method of SocketHandler is here overridden to create
                a UDP socket (SOCK_DGRAM).
        """
        pass

    def send(self, *args, **kwargs): # real signature unknown
        """
        Send a pickled string to a socket.
        
                This function no longer allows for partial sends which can happen
                when the network is busy - UDP does not guarantee delivery and
                can deliver packets out of sequence.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Initializes the handler with a specific host address and port. """
        pass


class HTTPHandler(__logging.Handler):
    """
    A class which sends records to a Web server, using either GET or
        POST semantics.
    """
    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                Send the record to the Web server as a percent-encoded dictionary
        """
        pass

    def mapLogRecord(self, *args, **kwargs): # real signature unknown
        """
        Default implementation of mapping the log record into a dict
                that is sent as the CGI data. Overwrite in your class.
                Contributed by Franz  Glasner.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize the instance with the host, the request URL, and the method
                ("GET" or "POST")
        """
        pass


class MemoryHandler(BufferingHandler):
    """
    A handler class which buffers logging records in memory, periodically
        flushing them to a target handler. Flushing occurs whenever the buffer
        is full, or when an event of a certain severity or greater is seen.
    """
    def close(self, *args, **kwargs): # real signature unknown
        """ Flush, set the target to None and lose the buffer. """
        pass

    def flush(self, *args, **kwargs): # real signature unknown
        """
        For a MemoryHandler, flushing means just sending the buffered
                records to the target, if there is one. Override if you want
                different behaviour.
        """
        pass

    def setTarget(self, *args, **kwargs): # real signature unknown
        """ Set the target handler for this handler. """
        pass

    def shouldFlush(self, *args, **kwargs): # real signature unknown
        """ Check for buffer full or a record at the flushLevel or higher. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize the handler with the buffer size, the level at which
                flushing should occur and an optional target.
        
                Note that without a target being set either here or via setTarget(),
                a MemoryHandler is no use to anyone!
        """
        pass


class NTEventLogHandler(__logging.Handler):
    """
    A handler class which sends events to the NT Event Log. Adds a
        registry entry for the specified application name. If no dllname is
        provided, win32service.pyd (which contains some basic message
        placeholders) is used. Note that use of these placeholders will make
        your event logs big, as the entire message source is held in the log.
        If you want slimmer logs, you have to pass in the name of your own DLL
        which contains the message definitions you want to use in the event log.
    """
    def close(self, *args, **kwargs): # real signature unknown
        """
        Clean up this handler.
        
                You can remove the application name from the registry as a
                source of event log entries. However, if you do this, you will
                not be able to see the events as you intended in the Event Log
                Viewer - it needs to be able to access the registry to get the
                DLL name.
        """
        pass

    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                Determine the message ID, event category and event type. Then
                log the message in the NT event log.
        """
        pass

    def getEventCategory(self, *args, **kwargs): # real signature unknown
        """
        Return the event category for the record.
        
                Override this if you want to specify your own categories. This version
                returns 0.
        """
        pass

    def getEventType(self, *args, **kwargs): # real signature unknown
        """
        Return the event type for the record.
        
                Override this if you want to specify your own types. This version does
                a mapping using the handler's typemap attribute, which is set up in
                __init__() to a dictionary which contains mappings for DEBUG, INFO,
                WARNING, ERROR and CRITICAL. If you are using your own levels you will
                either need to override this method or place a suitable dictionary in
                the handler's typemap attribute.
        """
        pass

    def getMessageID(self, *args, **kwargs): # real signature unknown
        """
        Return the message ID for the event record. If you are using your
                own messages, you could do this by having the msg passed to the
                logger being an ID rather than a formatting string. Then, in here,
                you could use a dictionary lookup to get the message ID. This
                version returns 1, which is the base message ID in win32service.pyd.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class RotatingFileHandler(BaseRotatingHandler):
    """
    Handler for logging to a set of files, which switches from one file
        to the next when the current file reaches a certain size.
    """
    def doRollover(self, *args, **kwargs): # real signature unknown
        """ Do a rollover, as described in __init__(). """
        pass

    def shouldRollover(self, *args, **kwargs): # real signature unknown
        """
        Determine if rollover should occur.
        
                Basically, see if the supplied record would cause the file to exceed
                the size limit we have.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Open the specified file and use it as the stream for logging.
        
                By default, the file grows indefinitely. You can specify particular
                values of maxBytes and backupCount to allow the file to rollover at
                a predetermined size.
        
                Rollover occurs whenever the current log file is nearly maxBytes in
                length. If backupCount is >= 1, the system will successively create
                new files with the same pathname as the base file, but with extensions
                ".1", ".2" etc. appended to it. For example, with a backupCount of 5
                and a base file name of "app.log", you would get "app.log",
                "app.log.1", "app.log.2", ... through to "app.log.5". The file being
                written to is always "app.log" - when it gets filled up, it is closed
                and renamed to "app.log.1", and if files "app.log.1", "app.log.2" etc.
                exist, then they are renamed to "app.log.2", "app.log.3" etc.
                respectively.
        
                If maxBytes is zero, rollover never occurs.
        """
        pass


class SMTPHandler(__logging.Handler):
    """ A handler class which sends an SMTP email for each logging event. """
    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                Format the record and send it to the specified addressees.
        """
        pass

    def getSubject(self, *args, **kwargs): # real signature unknown
        """
        Determine the subject for the email.
        
                If you want to specify a subject line which is record-dependent,
                override this method.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initialize the handler.
        
                Initialize the instance with the from and to addresses and subject
                line of the email. To specify a non-standard SMTP port, use the
                (host, port) tuple format for the mailhost argument. To specify
                authentication credentials, supply a (username, password) tuple
                for the credentials argument. To specify the use of a secure
                protocol (TLS), pass in a tuple for the secure argument. This will
                only be used when authentication credentials are supplied. The tuple
                will be either an empty tuple, or a single-value tuple with the name
                of a keyfile, or a 2-value tuple with the names of the keyfile and
                certificate file. (This tuple is passed to the `starttls` method).
        """
        pass


class SysLogHandler(__logging.Handler):
    """
    A handler class which sends formatted logging records to a syslog
        server. Based on Sam Rushing's syslog module:
        http://www.nightmare.com/squirl/python-ext/misc/syslog.py
        Contributed by Nicolas Untz (after which minor refactoring changes
        have been made).
    """
    def close(self, *args, **kwargs): # real signature unknown
        """ Closes the socket. """
        pass

    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                The record is formatted, and then sent to the syslog server. If
                exception information is present, it is NOT sent to the server.
        """
        pass

    def encodePriority(self, *args, **kwargs): # real signature unknown
        """
        Encode the facility and priority. You can pass in strings or
                integers - if strings are passed, the facility_names and
                priority_names mapping dictionaries are used to convert them to
                integers.
        """
        pass

    def mapPriority(self, *args, **kwargs): # real signature unknown
        """
        Map a logging level name to a key in the priority_names map.
                This is useful in two scenarios: when custom levels are being
                used, and in the case where you can't do a straightforward
                mapping by lowercasing the logging level name because of locale-
                specific issues (see SF #1524081).
        """
        pass

    def _connect_unixsocket(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, address=None): # real signature unknown; restored from __doc__
        """
        Initialize a handler.
        
                If address is specified as a string, a UNIX socket is used. To log to a
                local syslogd, "SysLogHandler(address="/dev/log")" can be used.
                If facility is not specified, LOG_USER is used.
        """
        pass

    facility_names = {
        'auth': 4,
        'authpriv': 10,
        'cron': 9,
        'daemon': 3,
        'ftp': 11,
        'kern': 0,
        'local0': 16,
        'local1': 17,
        'local2': 18,
        'local3': 19,
        'local4': 20,
        'local5': 21,
        'local6': 22,
        'local7': 23,
        'lpr': 6,
        'mail': 2,
        'news': 7,
        'security': 4,
        'syslog': 5,
        'user': 1,
        'uucp': 8,
    }
    LOG_ALERT = 1
    LOG_AUTH = 4
    LOG_AUTHPRIV = 10
    LOG_CRIT = 2
    LOG_CRON = 9
    LOG_DAEMON = 3
    LOG_DEBUG = 7
    LOG_EMERG = 0
    LOG_ERR = 3
    log_format_string = '<%d>%s\x00'
    LOG_FTP = 11
    LOG_INFO = 6
    LOG_KERN = 0
    LOG_LOCAL0 = 16
    LOG_LOCAL1 = 17
    LOG_LOCAL2 = 18
    LOG_LOCAL3 = 19
    LOG_LOCAL4 = 20
    LOG_LOCAL5 = 21
    LOG_LOCAL6 = 22
    LOG_LOCAL7 = 23
    LOG_LPR = 6
    LOG_MAIL = 2
    LOG_NEWS = 7
    LOG_NOTICE = 5
    LOG_SYSLOG = 5
    LOG_USER = 1
    LOG_UUCP = 8
    LOG_WARNING = 4
    priority_map = {
        'CRITICAL': 'critical',
        'DEBUG': 'debug',
        'ERROR': 'error',
        'INFO': 'info',
        'WARNING': 'warning',
    }
    priority_names = {
        'alert': 1,
        'crit': 2,
        'critical': 2,
        'debug': 7,
        'emerg': 0,
        'err': 3,
        'error': 3,
        'info': 6,
        'notice': 5,
        'panic': 0,
        'warn': 4,
        'warning': 4,
    }


class TimedRotatingFileHandler(BaseRotatingHandler):
    """
    Handler for logging to a file, rotating the log file at certain timed
        intervals.
    
        If backupCount is > 0, when rollover is done, no more than backupCount
        files are kept - the oldest ones are deleted.
    """
    def computeRollover(self, *args, **kwargs): # real signature unknown
        """ Work out the rollover time based on the specified time. """
        pass

    def doRollover(self, *args, **kwargs): # real signature unknown
        """
        do a rollover; in this case, a date/time stamp is appended to the filename
                when the rollover happens.  However, you want the file to be named for the
                start of the interval, not the current time.  If there is a backup count,
                then we have to get a list of matching filenames, sort them and remove
                the one with the oldest suffix.
        """
        pass

    def getFilesToDelete(self, *args, **kwargs): # real signature unknown
        """
        Determine the files to delete when rolling over.
        
                More specific than the earlier method, which just used glob.glob().
        """
        pass

    def shouldRollover(self, *args, **kwargs): # real signature unknown
        """
        Determine if rollover should occur.
        
                record is not used, as we are just comparing times, but it is needed so
                the method signatures are the same
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class WatchedFileHandler(__logging.FileHandler):
    """
    A handler for logging to a file, which watches the file
        to see if it has changed while in use. This can happen because of
        usage of programs such as newsyslog and logrotate which perform
        log file rotation. This handler, intended for use under Unix,
        watches the file to see if it has changed since the last emit.
        (A file has changed if its device or inode have changed.)
        If it has changed, the old file stream is closed, and the file
        opened to get a new stream.
    
        This handler is not appropriate for use under Windows, because
        under Windows open files cannot be moved or renamed - logging
        opens the files with exclusive locks - and so there is no need
        for such a handler. Furthermore, ST_INO is not supported under
        Windows; stat always returns zero for this value.
    
        This handler is based on a suggestion and patch by Chad J.
        Schroeder.
    """
    def emit(self, *args, **kwargs): # real signature unknown
        """
        Emit a record.
        
                First check if the underlying file has changed, and if it
                has, close the old stream and reopen the file to get the
                current stream.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


