# encoding: utf-8
# module optparse
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/optparse.pyo by generator 1.99
"""
A powerful, extensible, and easy-to-use option parser.

By Greg Ward <gward@python.net>

Originally distributed as Optik.

For support, use the optik-users@lists.sourceforge.net mailing list
(http://lists.sourceforge.net/lists/listinfo/optik-users).

Simple usage example:

   from optparse import OptionParser

   parser = OptionParser()
   parser.add_option("-f", "--file", dest="filename",
                     help="write report to FILE", metavar="FILE")
   parser.add_option("-q", "--quiet",
                     action="store_false", dest="verbose", default=True,
                     help="don't print status messages to stdout")

   (options, args) = parser.parse_args()
"""

# imports
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/types.pyc
import textwrap as textwrap # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/textwrap.pyc
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

SUPPRESS_HELP = 'SUPPRESSHELP'
SUPPRESS_USAGE = 'SUPPRESSUSAGE'

__copyright__ = '\nCopyright (c) 2001-2006 Gregory P. Ward.  All rights reserved.\nCopyright (c) 2002-2006 Python Software Foundation.  All rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are\nmet:\n\n  * Redistributions of source code must retain the above copyright\n    notice, this list of conditions and the following disclaimer.\n\n  * Redistributions in binary form must reproduce the above copyright\n    notice, this list of conditions and the following disclaimer in the\n    documentation and/or other materials provided with the distribution.\n\n  * Neither the name of the author nor the names of its\n    contributors may be used to endorse or promote products derived from\n    this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS\nIS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED\nTO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A\nPARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\nEXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\nPROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\nPROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\nLIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n'

__version__ = '1.5.3'

# functions

def check_builtin(option, opt, value): # reliably restored by inspect
    # no doc
    pass


def check_choice(option, opt, value): # reliably restored by inspect
    # no doc
    pass


def gettext(message): # reliably restored by inspect
    # no doc
    pass


def isbasestring(x): # reliably restored by inspect
    # no doc
    pass


def _(message): # reliably restored by inspect
    # no doc
    pass


def _match_abbrev(s, wordmap): # reliably restored by inspect
    """
    _match_abbrev(s : string, wordmap : {string : Option}) -> string
    
        Return the string key in 'wordmap' for which 's' is an unambiguous
        abbreviation.  If 's' is found to be ambiguous or doesn't match any of
        'words', raise BadOptionError.
    """
    pass


def _parse_int(val): # reliably restored by inspect
    # no doc
    pass


def _parse_long(val): # reliably restored by inspect
    # no doc
    pass


def _parse_num(val, type): # reliably restored by inspect
    # no doc
    pass


def _repr(self): # reliably restored by inspect
    # no doc
    pass


# classes

class OptParseError(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class BadOptionError(OptParseError):
    """ Raised if an invalid option is seen on the command line. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class AmbiguousOptionError(BadOptionError):
    """ Raised if an ambiguous option is seen on the command line. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class OptionError(OptParseError):
    """
    Raised if an Option instance is created with invalid or
        inconsistent arguments.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class OptionConflictError(OptionError):
    """ Raised if conflicting options are added to an OptionParser. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class OptionValueError(OptParseError):
    """
    Raised if an invalid option value is encountered on the command
        line.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

HelpFormatter = None # (!) real value is ''

IndentedHelpFormatter = None # (!) real value is ''

make_option = None # (!) forward: Option, real value is ''

NO_DEFAULT = (
    'NO',
    'DEFAULT',
)

Option = None # (!) real value is ''

OptionContainer = None # (!) real value is ''

OptionGroup = None # (!) real value is ''

OptionParser = None # (!) real value is ''

TitledHelpFormatter = None # (!) real value is ''

Values = None # (!) real value is ''

_builtin_cvt = {
    'complex': (
        complex,
        'complex',
    ),
    'float': (
        float,
        'floating-point',
    ),
    'int': (
        _parse_int,
        'integer',
    ),
    'long': (
        _parse_long,
        'long integer',
    ),
}

__all__ = [
    'Option',
    'make_option',
    'SUPPRESS_HELP',
    'SUPPRESS_USAGE',
    'Values',
    'OptionContainer',
    'OptionGroup',
    'OptionParser',
    'HelpFormatter',
    'IndentedHelpFormatter',
    'TitledHelpFormatter',
    'OptParseError',
    'OptionError',
    'OptionConflictError',
    'OptionValueError',
    'BadOptionError',
]

