# encoding: utf-8
# module pipes
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/pipes.pyo by generator 1.99
"""
Conversion pipeline templates.

The problem:
------------

Suppose you have some data that you want to convert to another format,
such as from GIF image format to PPM image format.  Maybe the
conversion involves several steps (e.g. piping it through compress or
uuencode).  Some of the conversion steps may require that their input
is a disk file, others may be able to read standard input; similar for
their output.  The input to the entire conversion may also be read
from a disk file or from an open file, and similar for its output.

The module lets you construct a pipeline template by sticking one or
more conversion steps together.  It will take care of creating and
removing temporary files if they are necessary to hold intermediate
data.  You can then use the template to do conversions from many
different sources to many different destinations.  The temporary
file names used are different each time the template is used.

The templates are objects so you can create templates for many
different conversion steps and store them in a dictionary, for
instance.


Directions:
-----------

To create a template:
    t = Template()

To add a conversion step to a template:
   t.append(command, kind)
where kind is a string of two characters: the first is '-' if the
command reads its standard input or 'f' if it requires a file; the
second likewise for the output. The command must be valid /bin/sh
syntax.  If input or output files are required, they are passed as
$IN and $OUT; otherwise, it must be  possible to use the command in
a pipeline.

To add a conversion step at the beginning:
   t.prepend(command, kind)

To convert a file to another file using a template:
  sts = t.copy(infile, outfile)
If infile or outfile are the empty string, standard input is read or
standard output is written, respectively.  The return value is the
exit status of the conversion pipeline.

To open a file for reading or writing through a conversion pipeline:
   fp = t.open(file, mode)
where mode is 'r' to read the file, or 'w' to write it -- just like
for the built-in function open() or for os.popen().

To create a new template object initialized to a given one:
   t2 = t.clone()

For an example, see the function test() at the end of the file.
"""

# imports
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/string.pyc
import tempfile as tempfile # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/tempfile.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

FILEIN_FILEOUT = 'ff'
FILEIN_STDOUT = 'f-'

SINK = '-.'

SOURCE = '.-'

STDIN_FILEOUT = '-f'
STDIN_STDOUT = '--'

# functions

def makepipeline(infile, steps, outfile): # reliably restored by inspect
    # no doc
    pass


def quote(file): # reliably restored by inspect
    """ Return a shell-escaped version of the file string. """
    pass


# no classes
# variables with complex values

stepkinds = [
    'ff',
    '-f',
    'f-',
    '--',
    '.-',
    '-.',
]

Template = None # (!) real value is ''

_safechars = None # (!) real value is ''

__all__ = [
    'Template',
]

