# encoding: utf-8
# module platform
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/platform.pyo by generator 1.99
"""
This module tries to retrieve as much platform-identifying data as
    possible. It makes this information available via function APIs.

    If called from the command line, it prints the platform
    information concatenated as single string to stdout. The output
    format is useable as part of a filename.
"""

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/string.pyc
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

DEV_NULL = '/dev/null'

_uname_cache = None

__copyright__ = '\n    Copyright (c) 1999-2000, Marc-Andre Lemburg; mailto:mal@lemburg.com\n    Copyright (c) 2000-2010, eGenix.com Software GmbH; mailto:info@egenix.com\n\n    Permission to use, copy, modify, and distribute this software and its\n    documentation for any purpose and without fee or royalty is hereby granted,\n    provided that the above copyright notice appear in all copies and that\n    both that copyright notice and this permission notice appear in\n    supporting documentation or portions thereof, including modifications,\n    that you make.\n\n    EGENIX.COM SOFTWARE GMBH DISCLAIMS ALL WARRANTIES WITH REGARD TO\n    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND\n    FITNESS, IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,\n    INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING\n    FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,\n    NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION\n    WITH THE USE OR PERFORMANCE OF THIS SOFTWARE !\n\n'

__version__ = '1.0.7'

# functions

def architecture(executable=None, bits=None, linkage=None): # reliably restored by inspect
    """
    Queries the given executable (defaults to the Python interpreter
            binary) for various architecture information.
    
            Returns a tuple (bits,linkage) which contains information about
            the bit architecture and the linkage format used for the
            executable. Both values are returned as strings.
    
            Values that cannot be determined are returned as given by the
            parameter presets. If bits is given as '', the sizeof(pointer)
            (or sizeof(long) on Python version < 1.5.2) is used as
            indicator for the supported pointer size.
    
            The function relies on the system's "file" command to do the
            actual work. This is available on most if not all Unix
            platforms. On some non-Unix platforms where the "file" command
            does not exist and the executable is set to the Python interpreter
            binary defaults from _default_architecture are used.
    """
    pass


def dist(distname=None, version=None, id=None, supported_dists="('SuSE', 'debian', 'fedora', 'redhat', 'centos', 'mandrake', 'mandriva', 'rocks', 'slackware', 'yellowdog', 'gentoo', 'UnitedLinux', 'turbolinux')"): # reliably restored by inspect
    """
    Tries to determine the name of the Linux OS distribution name.
    
            The function first looks for a distribution release file in
            /etc and then reverts to _dist_try_harder() in case no
            suitable files are found.
    
            Returns a tuple (distname,version,id) which default to the
            args given as parameters.
    """
    pass


def java_ver(release=None, vendor=None, vminfo="('', '', '')", osinfo="('', '', '')"): # reliably restored by inspect
    """
    Version interface for Jython.
    
            Returns a tuple (release,vendor,vminfo,osinfo) with vminfo being
            a tuple (vm_name,vm_release,vm_vendor) and osinfo being a
            tuple (os_name,os_version,os_arch).
    
            Values which cannot be determined are set to the defaults
            given as parameters (which all default to '').
    """
    pass


def libc_ver(executable=None, lib=None, version=None, chunksize=2048): # reliably restored by inspect
    """
    Tries to determine the libc version that the file executable
            (which defaults to the Python interpreter) is linked against.
    
            Returns a tuple of strings (lib,version) which default to the
            given parameters in case the lookup fails.
    
            Note that the function has intimate knowledge of how different
            libc versions add symbols to the executable and thus is probably
            only useable for executables compiled using gcc.
    
            The file is read and scanned in chunks of chunksize bytes.
    """
    pass


def linux_distribution(distname=None, version=None, id=None, supported_dists="('SuSE', 'debian', 'fedora', 'redhat', 'centos', 'mandrake', 'mandriva', 'rocks', 'slackware', 'yellowdog', 'gentoo', 'UnitedLinux', 'turbolinux')", full_distribution_name=1): # reliably restored by inspect
    """
    Tries to determine the name of the Linux OS distribution name.
    
            The function first looks for a distribution release file in
            /etc and then reverts to _dist_try_harder() in case no
            suitable files are found.
    
            supported_dists may be given to define the set of Linux
            distributions to look for. It defaults to a list of currently
            supported Linux distributions identified by their release file
            name.
    
            If full_distribution_name is true (default), the full
            distribution read from the OS is returned. Otherwise the short
            name taken from supported_dists is used.
    
            Returns a tuple (distname,version,id) which default to the
            args given as parameters.
    """
    pass


def machine(): # reliably restored by inspect
    """
    Returns the machine type, e.g. 'i386'
    
            An empty string is returned if the value cannot be determined.
    """
    pass


def mac_ver(release=None, versioninfo="('', '', '')", machine=None): # reliably restored by inspect
    """
    Get MacOS version information and return it as tuple (release,
            versioninfo, machine) with versioninfo being a tuple (version,
            dev_stage, non_release_version).
    
            Entries which cannot be determined are set to the paramter values
            which default to ''. All tuple entries are strings.
    """
    pass


def node(): # reliably restored by inspect
    """
    Returns the computer's network name (which may not be fully
            qualified)
    
            An empty string is returned if the value cannot be determined.
    """
    pass


def platform(aliased=0, terse=0): # reliably restored by inspect
    """
    Returns a single string identifying the underlying platform
            with as much useful information as possible (but no more :).
    
            The output is intended to be human readable rather than
            machine parseable. It may look different on different
            platforms and this is intended.
    
            If "aliased" is true, the function will use aliases for
            various platforms that report system names which differ from
            their common names, e.g. SunOS will be reported as
            Solaris. The system_alias() function is used to implement
            this.
    
            Setting terse to true causes the function to return only the
            absolute minimum information needed to identify the platform.
    """
    pass


def popen(cmd, mode=None, bufsize=None): # reliably restored by inspect
    """ Portable popen() interface. """
    pass


def processor(): # reliably restored by inspect
    """
    Returns the (true) processor name, e.g. 'amdk6'
    
            An empty string is returned if the value cannot be
            determined. Note that many platforms do not provide this
            information or simply return the same value as for machine(),
            e.g.  NetBSD does this.
    """
    pass


def python_branch(): # reliably restored by inspect
    """
    Returns a string identifying the Python implementation
            branch.
    
            For CPython this is the Subversion branch from which the
            Python binary was built.
    
            If not available, an empty string is returned.
    """
    pass


def python_build(): # reliably restored by inspect
    """
    Returns a tuple (buildno, builddate) stating the Python
            build number and date as strings.
    """
    pass


def python_compiler(): # reliably restored by inspect
    """
    Returns a string identifying the compiler used for compiling
            Python.
    """
    pass


def python_implementation(): # reliably restored by inspect
    """
    Returns a string identifying the Python implementation.
    
            Currently, the following implementations are identified:
            'CPython' (C implementation of Python),
            'IronPython' (.NET implementation of Python),
            'Jython' (Java implementation of Python).
    """
    pass


def python_revision(): # reliably restored by inspect
    """
    Returns a string identifying the Python implementation
            revision.
    
            For CPython this is the Subversion revision from which the
            Python binary was built.
    
            If not available, an empty string is returned.
    """
    pass


def python_version(): # reliably restored by inspect
    """
    Returns the Python version as string 'major.minor.patchlevel'
    
            Note that unlike the Python sys.version, the returned value
            will always include the patchlevel (it defaults to 0).
    """
    pass


def python_version_tuple(): # reliably restored by inspect
    """
    Returns the Python version as tuple (major, minor, patchlevel)
            of strings.
    
            Note that unlike the Python sys.version, the returned value
            will always include the patchlevel (it defaults to 0).
    """
    pass


def release(): # reliably restored by inspect
    """
    Returns the system's release, e.g. '2.2.0' or 'NT'
    
            An empty string is returned if the value cannot be determined.
    """
    pass


def system(): # reliably restored by inspect
    """
    Returns the system/OS name, e.g. 'Linux', 'Windows' or 'Java'.
    
            An empty string is returned if the value cannot be determined.
    """
    pass


def system_alias(system, release, version): # reliably restored by inspect
    """
    Returns (system,release,version) aliased to common
            marketing names used for some systems.
    
            It also does some reordering of the information in some cases
            where it would otherwise cause confusion.
    """
    pass


def uname(): # reliably restored by inspect
    """
    Fairly portable uname interface. Returns a tuple
            of strings (system,node,release,version,machine,processor)
            identifying the underlying platform.
    
            Note that unlike the os.uname function this also returns
            possible processor information as an additional tuple entry.
    
            Entries which cannot be determined are set to ''.
    """
    pass


def version(): # reliably restored by inspect
    """
    Returns the system's release version, e.g. '#3 on degas'
    
            An empty string is returned if the value cannot be determined.
    """
    pass


def win32_ver(release=None, version=None, csd=None, ptype=None): # reliably restored by inspect
    """
    Get additional version information from the Windows Registry
            and return a tuple (version,csd,ptype) referring to version
            number, CSD level and OS type (multi/single
            processor).
    
            As a hint: ptype returns 'Uniprocessor Free' on single
            processor NT machines and 'Multiprocessor Free' on multi
            processor machines. The 'Free' refers to the OS version being
            free of debugging code. It could also state 'Checked' which
            means the OS version uses debugging code, i.e. code that
            checks arguments, ranges, etc. (Thomas Heller).
    
            Note: this function works best with Mark Hammond's win32
            package installed, but also on Python 2.3 and later. It
            obviously only runs on Win32 compatible platforms.
    """
    pass


def _abspath(path): # reliably restored by inspect
    """ Return an absolute path. """
    pass


def _architecture_split(*args, **kwargs): # real signature unknown
    """
    split(string[, maxsplit = 0])  --> list.
        Split string by the occurrences of pattern.
    """
    pass


def _bcd2str(bcd): # reliably restored by inspect
    # no doc
    pass


def _dist_try_harder(distname, version, id): # reliably restored by inspect
    """
    Tries some special tricks to get the distribution
            information in case the default method fails.
    
            Currently supports older SuSE Linux, Caldera OpenLinux and
            Slackware Linux distributions.
    """
    pass


def _follow_symlinks(filepath): # reliably restored by inspect
    """
    In case filepath is a symlink, follow it until a
            real file is reached.
    """
    pass


def _java_getprop(name, default): # reliably restored by inspect
    # no doc
    pass


def _mac_ver_gestalt(): # reliably restored by inspect
    """
    Thanks to Mark R. Levinson for mailing documentation links and
            code examples for this function. Documentation for the
            gestalt() API is available online at:
    
               http://www.rgaros.nl/gestalt/
    """
    pass


def _mac_ver_lookup(selectors, default=None): # reliably restored by inspect
    # no doc
    pass


def _mac_ver_xml(): # reliably restored by inspect
    # no doc
    pass


def _node(default=None): # reliably restored by inspect
    """ Helper to determine the node name of this machine. """
    pass


def _norm_version(version, build=None): # reliably restored by inspect
    """
    Normalize the version and build strings and return a single
            version string using the format major.minor.build (or patchlevel).
    """
    pass


def _parse_release_file(firstline): # reliably restored by inspect
    # no doc
    pass


def _platform(*args): # reliably restored by inspect
    """
    Helper to format the platform string in a filename
            compatible format e.g. "system-version-machine".
    """
    pass


def _syscmd_file(target, default=None): # reliably restored by inspect
    """
    Interface to the system's file command.
    
            The function uses the -b option of the file command to have it
            ommit the filename in its output and if possible the -L option
            to have the command follow symlinks. It returns default in
            case the command should fail.
    """
    pass


def _syscmd_uname(option, default=None): # reliably restored by inspect
    """ Interface to the system's uname command. """
    pass


def _syscmd_ver(system=None, release=None, version=None, supported_platforms="('win32', 'win16', 'dos', 'os2')"): # reliably restored by inspect
    """
    Tries to figure out the OS version used and returns
            a tuple (system,release,version).
    
            It uses the "ver" shell command for this which is known
            to exists on Windows, DOS and OS/2. XXX Others too ?
    
            In case this fails, the given parameters are used as
            defaults.
    """
    pass


def _sys_version(sys_version=None): # reliably restored by inspect
    """
    Returns a parsed version of Python's sys.version as tuple
            (name, version, branch, revision, buildno, builddate, compiler)
            referring to the Python implementation name, version, branch,
            revision, build number, build date/time as string and the compiler
            identification string.
    
            Note that unlike the Python sys.version, the returned value
            for the Python version will always include the patchlevel (it
            defaults to '.0').
    
            The function returns empty strings for tuple entries that
            cannot be determined.
    
            sys_version may be given to parse an alternative version
            string, e.g. if the version was read from a different Python
            interpreter.
    """
    pass


def _win32_getvalue(key, name, default=None): # reliably restored by inspect
    """
    Read a value for name from the registry key.
    
            In case this fails, default is returned.
    """
    pass


# no classes
# variables with complex values

_default_architecture = {
    'dos': (
        '',
        'MSDOS',
    ),
    'win16': (
        '',
        'Windows',
    ),
    'win32': (
        '',
        'WindowsPE',
    ),
}

_ironpython_sys_version_parser = None # (!) real value is ''

_libc_search = None # (!) real value is ''

_lsb_release_version = None # (!) real value is ''

_platform_cache = {}

_popen = None # (!) real value is ''

_pypy_sys_version_parser = None # (!) real value is ''

_release_filename = None # (!) real value is ''

_release_version = None # (!) real value is ''

_supported_dists = (
    'SuSE',
    'debian',
    'fedora',
    'redhat',
    'centos',
    'mandrake',
    'mandriva',
    'rocks',
    'slackware',
    'yellowdog',
    'gentoo',
    'UnitedLinux',
    'turbolinux',
)

_sys_version_cache = {}

_sys_version_parser = None # (!) real value is ''

_ver_output = None # (!) real value is ''

