# encoding: utf-8
# module posixpath
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/posixpath.pyo by generator 1.99
"""
Common operations on Posix pathnames.

Instead of importing this module directly, import os and refer to
this module as os.path.  The "os.path" name is an alias for this
module on Posix systems; on other systems (e.g. Mac, Windows),
os.path provides the same operations in a manner specific to that
platform, and is an alias to another module (e.g. macpath, ntpath).

Some of this can actually be useful on non-Posix systems too, e.g.
for manipulation of the pathname component of URLs.
"""

# imports
import genericpath as genericpath # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/genericpath.pyc
import stat as stat # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/stat.pyc
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc

# Variables with simple values

altsep = None

curdir = '.'

defpath = ':/bin:/usr/bin'
devnull = '/dev/null'

extsep = '.'

pardir = '..'
pathsep = ':'

sep = '/'

supports_unicode_filenames = True

_varprog = None

# functions

def abspath(path): # reliably restored by inspect
    """ Return an absolute path. """
    pass


def basename(p): # reliably restored by inspect
    """ Returns the final component of a pathname """
    pass


def commonprefix(m): # reliably restored by inspect
    """ Given a list of pathnames, returns the longest common leading component """
    pass


def dirname(p): # reliably restored by inspect
    """ Returns the directory component of a pathname """
    pass


def exists(path): # reliably restored by inspect
    """ Test whether a path exists.  Returns False for broken symbolic links """
    pass


def expanduser(path): # reliably restored by inspect
    """
    Expand ~ and ~user constructions.  If user or $HOME is unknown,
        do nothing.
    """
    pass


def expandvars(path): # reliably restored by inspect
    """
    Expand shell variables of form $var and ${var}.  Unknown variables
        are left unchanged.
    """
    pass


def getatime(filename): # reliably restored by inspect
    """ Return the last access time of a file, reported by os.stat(). """
    pass


def getctime(filename): # reliably restored by inspect
    """ Return the metadata change time of a file, reported by os.stat(). """
    pass


def getmtime(filename): # reliably restored by inspect
    """ Return the last modification time of a file, reported by os.stat(). """
    pass


def getsize(filename): # reliably restored by inspect
    """ Return the size of a file, reported by os.stat(). """
    pass


def isabs(s): # reliably restored by inspect
    """ Test whether a path is absolute """
    pass


def isdir(s): # reliably restored by inspect
    """ Return true if the pathname refers to an existing directory. """
    pass


def isfile(path): # reliably restored by inspect
    """ Test whether a path is a regular file """
    pass


def islink(path): # reliably restored by inspect
    """ Test whether a path is a symbolic link """
    pass


def ismount(path): # reliably restored by inspect
    """ Test whether a path is a mount point """
    pass


def join(a, *p): # reliably restored by inspect
    """
    Join two or more pathname components, inserting '/' as needed.
        If any component is an absolute path, all previous path components
        will be discarded.
    """
    pass


def lexists(path): # reliably restored by inspect
    """ Test whether a path exists.  Returns True for broken symbolic links """
    pass


def normcase(s): # reliably restored by inspect
    """ Normalize case of pathname.  Has no effect under Posix """
    pass


def normpath(path): # reliably restored by inspect
    """ Normalize path, eliminating double slashes, etc. """
    pass


def realpath(filename): # reliably restored by inspect
    """
    Return the canonical path of the specified filename, eliminating any
    symbolic links encountered in the path.
    """
    pass


def relpath(path, start=None): # reliably restored by inspect
    """ Return a relative version of a path """
    pass


def samefile(f1, f2): # reliably restored by inspect
    """ Test whether two pathnames reference the same actual file """
    pass


def sameopenfile(fp1, fp2): # reliably restored by inspect
    """ Test whether two open file objects reference the same file """
    pass


def samestat(s1, s2): # reliably restored by inspect
    """ Test whether two stat buffers reference the same file """
    pass


def split(p): # reliably restored by inspect
    """
    Split a pathname.  Returns tuple "(head, tail)" where "tail" is
        everything after the final slash.  Either part may be empty.
    """
    pass


def splitdrive(p): # reliably restored by inspect
    """
    Split a pathname into drive and path. On Posix, drive is always
        empty.
    """
    pass


def splitext(p): # reliably restored by inspect
    """
    Split the extension from a pathname.
    
        Extension is everything from the last dot to the end, ignoring
        leading dots.  Returns "(root, ext)"; ext may be empty.
    """
    pass


def walk(top, func, arg): # reliably restored by inspect
    """
    Directory tree walk with callback function.
    
        For each directory in the directory tree rooted at top (including top
        itself, but excluding '.' and '..'), call func(arg, dirname, fnames).
        dirname is the name of the directory, and fnames a list of the names of
        the files and subdirectories in dirname (excluding '.' and '..').  func
        may modify the fnames list in-place (e.g. via del or slice assignment),
        and walk will only recurse into the subdirectories whose names remain in
        fnames; this can be used to implement a filter, or to impose a specific
        order of visiting.  No semantics are defined for, or required of, arg,
        beyond that arg is always passed to func.  It can be used, e.g., to pass
        a filename pattern, or a mutable object designed to accumulate
        statistics.  Passing None for arg is common.
    """
    pass


def _resolve_link(path): # reliably restored by inspect
    """
    Internal helper function.  Takes a path and follows symlinks
        until we either arrive at something that isn't a symlink, or
        encounter a path we've seen before (meaning that there's a loop).
    """
    pass


# no classes
# variables with complex values

__all__ = [
    'normcase',
    'isabs',
    'join',
    'splitdrive',
    'split',
    'splitext',
    'basename',
    'dirname',
    'commonprefix',
    'getsize',
    'getmtime',
    'getatime',
    'getctime',
    'islink',
    'exists',
    'lexists',
    'isdir',
    'isfile',
    'ismount',
    'walk',
    'expanduser',
    'expandvars',
    'normpath',
    'abspath',
    'samefile',
    'sameopenfile',
    'samestat',
    'curdir',
    'pardir',
    'sep',
    'pathsep',
    'defpath',
    'altsep',
    'extsep',
    'devnull',
    'realpath',
    'supports_unicode_filenames',
    'relpath',
]

