# encoding: utf-8
# module sets
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/sets.pyo by generator 1.99
"""
Classes to represent arbitrary sets (including sets of sets).

This module implements sets using dictionaries whose values are
ignored.  The usual operations (union, intersection, deletion, etc.)
are provided as both methods and operators.

Important: sets are not sequences!  While they support 'x in s',
'len(s)', and 'for x in s', none of those operations are unique for
sequences; for example, mappings support all three as well.  The
characteristic operation for sequences is subscripting with small
integers: s[i], for i in range(len(s)).  Sets don't support
subscripting at all.  Also, sequences allow multiple occurrences and
their elements have a definite order; sets on the other hand don't
record multiple occurrences and don't remember the order of element
insertion (which is why they don't support s[i]).

The following classes are provided:

BaseSet -- All the operations common to both mutable and immutable
    sets. This is an abstract class, not meant to be directly
    instantiated.

Set -- Mutable sets, subclass of BaseSet; not hashable.

ImmutableSet -- Immutable sets, subclass of BaseSet; hashable.
    An iterable argument is mandatory to create an ImmutableSet.

_TemporarilyImmutableSet -- A wrapper around a Set, hashable,
    giving the same hash value as the immutable set equivalent
    would have.  Do not use this class directly.

Only hashable objects can be added to a Set. In particular, you cannot
really add a Set as an element to another Set; if you try, what is
actually added is an ImmutableSet built from it (it compares equal to
the one you tried adding).

When you ask if `x in y' where x is a Set and y is a Set or
ImmutableSet, x is wrapped into a _TemporarilyImmutableSet z, and
what's tested is actually `z in y'.
"""

# imports
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
from itertools import ifilter, ifilterfalse


# no functions
# classes

class BaseSet(object):
    """ Common base class for mutable and immutable sets. """
    def copy(self, *args, **kwargs): # real signature unknown
        """ Return a shallow copy of a set. """
        pass

    def difference(self, *args, **kwargs): # real signature unknown
        """
        Return the difference of two sets as a new Set.
        
                (I.e. all elements that are in this set and not in the other.)
        """
        pass

    def intersection(self, *args, **kwargs): # real signature unknown
        """
        Return the intersection of two sets as a new set.
        
                (I.e. all elements that are in both sets.)
        """
        pass

    def issubset(self, *args, **kwargs): # real signature unknown
        """ Report whether another set contains this set. """
        pass

    def issuperset(self, *args, **kwargs): # real signature unknown
        """ Report whether this set contains another set. """
        pass

    def symmetric_difference(self, *args, **kwargs): # real signature unknown
        """
        Return the symmetric difference of two sets as a new set.
        
                (I.e. all elements that are in exactly one of the sets.)
        """
        pass

    def union(self, *args, **kwargs): # real signature unknown
        """
        Return the union of two sets as a new set.
        
                (I.e. all elements that are in either set.)
        """
        pass

    def _binary_sanity_check(self, *args, **kwargs): # real signature unknown
        pass

    def _compute_hash(self, *args, **kwargs): # real signature unknown
        pass

    def _repr(self, *args, **kwargs): # real signature unknown
        pass

    def _update(self, *args, **kwargs): # real signature unknown
        pass

    def __and__(self, *args, **kwargs): # real signature unknown
        """
        Return the intersection of two sets as a new set.
        
                (I.e. all elements that are in both sets.)
        """
        pass

    def __cmp__(self, *args, **kwargs): # real signature unknown
        pass

    def __contains__(self, *args, **kwargs): # real signature unknown
        """
        Report whether an element is a member of a set.
        
                (Called in response to the expression `element in self'.)
        """
        pass

    def __copy__(self, *args, **kwargs): # real signature unknown
        """ Return a shallow copy of a set. """
        pass

    def __deepcopy__(self, *args, **kwargs): # real signature unknown
        """ Return a deep copy of a set; used by copy module. """
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __ge__(self, *args, **kwargs): # real signature unknown
        """ Report whether this set contains another set. """
        pass

    def __gt__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ This is an abstract class. """
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        """
        Return an iterator over the elements or a set.
        
                This is the keys iterator for the underlying dict.
        """
        pass

    def __len__(self, *args, **kwargs): # real signature unknown
        """ Return the number of elements of a set. """
        pass

    def __le__(self, *args, **kwargs): # real signature unknown
        """ Report whether another set contains this set. """
        pass

    def __lt__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __or__(self, *args, **kwargs): # real signature unknown
        """
        Return the union of two sets as a new set.
        
                (I.e. all elements that are in either set.)
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """
        Return string representation of a set.
        
                This looks like 'Set([<list of elements>])'.
        """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """
        Return string representation of a set.
        
                This looks like 'Set([<list of elements>])'.
        """
        pass

    def __sub__(self, *args, **kwargs): # real signature unknown
        """
        Return the difference of two sets as a new Set.
        
                (I.e. all elements that are in this set and not in the other.)
        """
        pass

    def __xor__(self, *args, **kwargs): # real signature unknown
        """
        Return the symmetric difference of two sets as a new set.
        
                (I.e. all elements that are in exactly one of the sets.)
        """
        pass

    _data = property(lambda self: object()) # default

    __hash__ = None
    __slots__ = [
        '_data',
    ]


class ImmutableSet(BaseSet):
    """ Immutable set class. """
    def __getstate__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Construct an immutable set from an optional iterable. """
        pass

    def __setstate__(self, *args, **kwargs): # real signature unknown
        pass

    _hashcode = property(lambda self: object()) # default

    __slots__ = [
        '_hashcode',
    ]


class Set(BaseSet):
    """ Mutable set class. """
    def add(self, *args, **kwargs): # real signature unknown
        """
        Add an element to a set.
        
                This has no effect if the element is already present.
        """
        pass

    def clear(self, *args, **kwargs): # real signature unknown
        """ Remove all elements from this set. """
        pass

    def difference_update(self, *args, **kwargs): # real signature unknown
        """ Remove all elements of another set from this set. """
        pass

    def discard(self, *args, **kwargs): # real signature unknown
        """
        Remove an element from a set if it is a member.
        
                If the element is not a member, do nothing.
        """
        pass

    def intersection_update(self, *args, **kwargs): # real signature unknown
        """ Update a set with the intersection of itself and another. """
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        """ Remove and return an arbitrary set element. """
        pass

    def remove(self, *args, **kwargs): # real signature unknown
        """
        Remove an element from a set; it must be a member.
        
                If the element is not a member, raise a KeyError.
        """
        pass

    def symmetric_difference_update(self, *args, **kwargs): # real signature unknown
        """ Update a set with the symmetric difference of itself and another. """
        pass

    def union_update(self, *args, **kwargs): # real signature unknown
        """ Update a set with the union of itself and another. """
        pass

    def update(self, *args, **kwargs): # real signature unknown
        """ Add all values from an iterable (such as a list or file). """
        pass

    def __as_immutable__(self, *args, **kwargs): # real signature unknown
        pass

    def __as_temporarily_immutable__(self, *args, **kwargs): # real signature unknown
        pass

    def __getstate__(self, *args, **kwargs): # real signature unknown
        pass

    def __iand__(self, *args, **kwargs): # real signature unknown
        """ Update a set with the intersection of itself and another. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Construct a set from an optional iterable. """
        pass

    def __ior__(self, *args, **kwargs): # real signature unknown
        """ Update a set with the union of itself and another. """
        pass

    def __isub__(self, *args, **kwargs): # real signature unknown
        """ Remove all elements of another set from this set. """
        pass

    def __ixor__(self, *args, **kwargs): # real signature unknown
        """ Update a set with the symmetric difference of itself and another. """
        pass

    def __setstate__(self, *args, **kwargs): # real signature unknown
        pass

    __slots__ = []


class _TemporarilyImmutableSet(BaseSet):
    # no doc
    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

__all__ = [
    'BaseSet',
    'Set',
    'ImmutableSet',
]

