# encoding: utf-8
# module shutil
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/shutil.pyo by generator 1.99
"""
Utility functions for copying and archiving files and directory trees.

XXX The functions here don't copy the resource fork or other metadata on Mac.
"""

# imports
import errno as errno # <module 'errno' (built-in)>
import collections as collections # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/collections.pyc
import stat as stat # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/stat.pyc
import sys as sys # <module 'sys' (built-in)>
import fnmatch as fnmatch # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/fnmatch.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
from grp import getgrnam

from pwd import getpwnam


# Variables with simple values

WindowsError = None

# functions

def abspath(path): # reliably restored by inspect
    """ Return an absolute path. """
    pass


def copy(src, dst): # reliably restored by inspect
    """
    Copy data and mode bits ("cp src dst").
    
        The destination may be a directory.
    """
    pass


def copy2(src, dst): # reliably restored by inspect
    """
    Copy data and all stat info ("cp -p src dst").
    
        The destination may be a directory.
    """
    pass


def copyfile(src, dst): # reliably restored by inspect
    """ Copy data from src to dst """
    pass


def copyfileobj(fsrc, fdst, length=16384): # reliably restored by inspect
    """ copy data from file-like object fsrc to file-like object fdst """
    pass


def copymode(src, dst): # reliably restored by inspect
    """ Copy mode bits from src to dst """
    pass


def copystat(src, dst): # reliably restored by inspect
    """ Copy all stat info (mode bits, atime, mtime, flags) from src to dst """
    pass


def copytree(src, dst, symlinks=False, ignore=None): # reliably restored by inspect
    """
    Recursively copy a directory tree using copy2().
    
        The destination directory must not already exist.
        If exception(s) occur, an Error is raised with a list of reasons.
    
        If the optional symlinks flag is true, symbolic links in the
        source tree result in symbolic links in the destination tree; if
        it is false, the contents of the files pointed to by symbolic
        links are copied.
    
        The optional ignore argument is a callable. If given, it
        is called with the `src` parameter, which is the directory
        being visited by copytree(), and `names` which is the list of
        `src` contents, as returned by os.listdir():
    
            callable(src, names) -> ignored_names
    
        Since copytree() is called recursively, the callable will be
        called once for each directory that is copied. It returns a
        list of names relative to the `src` directory that should
        not be copied.
    
        XXX Consider this example code rather than the ultimate tool.
    """
    pass


def get_archive_formats(): # reliably restored by inspect
    """
    Returns a list of supported formats for archiving and unarchiving.
    
        Each element of the returned sequence is a tuple (name, description)
    """
    pass


def ignore_patterns(*patterns): # reliably restored by inspect
    """
    Function that can be used as copytree() ignore parameter.
    
        Patterns is a sequence of glob-style patterns
        that are used to exclude files
    """
    pass


def make_archive(base_name, format, root_dir=None, base_dir=None, verbose=0, dry_run=0, owner=None, group=None, logger=None): # reliably restored by inspect
    """
    Create an archive file (eg. zip or tar).
    
        'base_name' is the name of the file to create, minus any format-specific
        extension; 'format' is the archive format: one of "zip", "tar", "bztar"
        or "gztar".
    
        'root_dir' is a directory that will be the root directory of the
        archive; ie. we typically chdir into 'root_dir' before creating the
        archive.  'base_dir' is the directory where we start archiving from;
        ie. 'base_dir' will be the common prefix of all files and
        directories in the archive.  'root_dir' and 'base_dir' both default
        to the current directory.  Returns the name of the archive file.
    
        'owner' and 'group' are used when creating a tar archive. By default,
        uses the current owner and group.
    """
    pass


def move(src, dst): # reliably restored by inspect
    """
    Recursively move a file or directory to another location. This is
        similar to the Unix "mv" command.
    
        If the destination is a directory or a symlink to a directory, the source
        is moved inside the directory. The destination path must not already
        exist.
    
        If the destination already exists but is not a directory, it may be
        overwritten depending on os.rename() semantics.
    
        If the destination is on our current filesystem, then rename() is used.
        Otherwise, src is copied to the destination and then removed.
        A lot more could be done here...  A look at a mv.c shows a lot of
        the issues this implementation glosses over.
    """
    pass


def register_archive_format(name, function, extra_args=None, description=None): # reliably restored by inspect
    """
    Registers an archive format.
    
        name is the name of the format. function is the callable that will be
        used to create archives. If provided, extra_args is a sequence of
        (name, value) tuples that will be passed as arguments to the callable.
        description can be provided to describe the format, and will be returned
        by the get_archive_formats() function.
    """
    pass


def rmtree(path, ignore_errors=False, onerror=None): # reliably restored by inspect
    """
    Recursively delete a directory tree.
    
        If ignore_errors is set, errors are ignored; otherwise, if onerror
        is set, it is called to handle the error with arguments (func,
        path, exc_info) where func is os.listdir, os.remove, or os.rmdir;
        path is the argument to that function that caused it to fail; and
        exc_info is a tuple returned by sys.exc_info().  If ignore_errors
        is false and onerror is None, an exception is raised.
    """
    pass


def unregister_archive_format(name): # reliably restored by inspect
    # no doc
    pass


def _basename(path): # reliably restored by inspect
    # no doc
    pass


def _call_external_zip(base_dir, zip_filename, verbose=False, dry_run=False): # reliably restored by inspect
    # no doc
    pass


def _destinsrc(src, dst): # reliably restored by inspect
    # no doc
    pass


def _get_gid(name): # reliably restored by inspect
    """ Returns a gid, given a group name. """
    pass


def _get_uid(name): # reliably restored by inspect
    """ Returns an uid, given a user name. """
    pass


def _make_tarball(base_name, base_dir, compress=None, verbose=0, dry_run=0, owner=None, group=None, logger=None): # reliably restored by inspect
    """
    Create a (possibly compressed) tar file from all the files under
        'base_dir'.
    
        'compress' must be "gzip" (the default), "bzip2", or None.
    
        'owner' and 'group' can be used to define an owner and a group for the
        archive that is being built. If not provided, the current owner and group
        will be used.
    
        The output tar file will be named 'base_dir' +  ".tar", possibly plus
        the appropriate compression extension (".gz", or ".bz2").
    
        Returns the output filename.
    """
    pass


def _make_zipfile(base_name, base_dir, verbose=0, dry_run=0, logger=None): # reliably restored by inspect
    """
    Create a zip file from all the files under 'base_dir'.
    
        The output zip file will be named 'base_dir' + ".zip".  Uses either the
        "zipfile" Python module (if available) or the InfoZIP "zip" utility
        (if installed and found on the default search path).  If neither tool is
        available, raises ExecError.  Returns the name of the output zip
        file.
    """
    pass


def _samefile(src, dst): # reliably restored by inspect
    # no doc
    pass


# classes

class Error(EnvironmentError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class ExecError(EnvironmentError):
    """ Raised when a command could not be executed """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class SpecialFileError(EnvironmentError):
    """
    Raised when trying to do a kind of operation (e.g. copying) which is
        not supported on a special file (e.g. a named pipe)
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

_ARCHIVE_FORMATS = {
    'bztar': (
        _make_tarball,
        [
            (
                'compress',
                'bzip2',
            ),
        ],
        "bzip2'ed tar-file",
    ),
    'gztar': (
        '<value is a self-reference, replaced by this string>',
        [
            (
                'compress',
                'gzip',
            ),
        ],
        "gzip'ed tar-file",
    ),
    'tar': (
        '<value is a self-reference, replaced by this string>',
        [
            (
                'compress',
                None,
            ),
        ],
        'uncompressed tar file',
    ),
    'zip': (
        _make_zipfile,
        [],
        'ZIP file',
    ),
}

__all__ = [
    'copyfileobj',
    'copyfile',
    'copymode',
    'copystat',
    'copy',
    'copy2',
    'copytree',
    'move',
    'rmtree',
    'Error',
    'SpecialFileError',
    'ExecError',
    'make_archive',
    'get_archive_formats',
    'register_archive_format',
    'unregister_archive_format',
]

