# encoding: utf-8
# module socket
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/socket.pyo by generator 1.99
"""
This module provides socket operations and some related functions.
On Unix, it supports IP (Internet Protocol) and Unix domain sockets.
On other systems, it only supports IP. Functions specific for a
socket are available as methods of the socket object.

Functions:

socket() -- create a new socket object
socketpair() -- create a pair of new socket objects [*]
fromfd() -- create a socket object from an open file descriptor [*]
gethostname() -- return the current hostname
gethostbyname() -- map a hostname to its IP number
gethostbyaddr() -- map an IP number or hostname to DNS info
getservbyname() -- map a service name and a protocol name to a port number
getprotobyname() -- map a protocol name (e.g. 'tcp') to a number
ntohs(), ntohl() -- convert 16, 32 bit int from network to host byte order
htons(), htonl() -- convert 16, 32 bit int from host to network byte order
inet_aton() -- convert IP addr string (123.45.67.89) to 32-bit packed format
inet_ntoa() -- convert 32-bit packed format IP to string (123.45.67.89)
ssl() -- secure socket layer support (only available if configured)
socket.getdefaulttimeout() -- get the default timeout value
socket.setdefaulttimeout() -- set the default timeout value
create_connection() -- connects to an address, with an optional timeout and
                       optional source address.

 [*] not available on all platforms!

Special objects:

SocketType -- type object for socket objects
error -- exception raised for I/O errors
has_ipv6 -- boolean value indicating if IPv6 is supported

Integer constants:

AF_INET, AF_UNIX -- socket domains (first argument to socket() call)
SOCK_STREAM, SOCK_DGRAM, SOCK_RAW -- socket types (second argument)

Many other constants may be defined; these may be used in calls to
the setsockopt() and getsockopt() methods.
"""

# imports
import _ssl as _ssl # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/_ssl.so
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/os.pyc
import errno as errno # <module 'errno' (built-in)>
import _socket as _socket # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-dynload/_socket.so
import sys as sys # <module 'sys' (built-in)>
from cStringIO import StringIO

from _socket import (_realsocket, fromfd, getaddrinfo, getdefaulttimeout, 
    gethostbyaddr, gethostbyname, gethostbyname_ex, gethostname, getnameinfo, 
    getprotobyname, getservbyname, getservbyport, htonl, htons, inet_aton, 
    inet_ntoa, inet_ntop, inet_pton, ntohl, ntohs, setdefaulttimeout, 
    socketpair)

from _ssl import RAND_add, RAND_egd, RAND_status


# Variables with simple values

AF_APPLETALK = 16
AF_DECnet = 12
AF_INET = 2
AF_INET6 = 30
AF_IPX = 23
AF_ROUTE = 17
AF_SNA = 11
AF_UNIX = 1
AF_UNSPEC = 0

AI_ADDRCONFIG = 1024
AI_ALL = 256
AI_CANONNAME = 2
AI_DEFAULT = 1536
AI_MASK = 5127
AI_NUMERICHOST = 4
AI_NUMERICSERV = 4096
AI_PASSIVE = 1
AI_V4MAPPED = 2048

AI_V4MAPPED_CFG = 512

EAI_ADDRFAMILY = 1
EAI_AGAIN = 2
EAI_BADFLAGS = 3
EAI_BADHINTS = 12
EAI_FAIL = 4
EAI_FAMILY = 5
EAI_MAX = 15
EAI_MEMORY = 6
EAI_NODATA = 7
EAI_NONAME = 8
EAI_OVERFLOW = 14
EAI_PROTOCOL = 13
EAI_SERVICE = 9
EAI_SOCKTYPE = 10
EAI_SYSTEM = 11

EBADF = 9

EINTR = 4

has_ipv6 = True

INADDR_ALLHOSTS_GROUP = 3758096385

INADDR_ANY = 0
INADDR_BROADCAST = 4294967295
INADDR_LOOPBACK = 2130706433

INADDR_MAX_LOCAL_GROUP = 3758096639

INADDR_NONE = 4294967295

INADDR_UNSPEC_GROUP = 3758096384

IPPORT_RESERVED = 1024
IPPORT_USERRESERVED = 5000

IPPROTO_AH = 51
IPPROTO_DSTOPTS = 60
IPPROTO_EGP = 8
IPPROTO_EON = 80
IPPROTO_ESP = 50
IPPROTO_FRAGMENT = 44
IPPROTO_GGP = 3
IPPROTO_GRE = 47
IPPROTO_HELLO = 63
IPPROTO_HOPOPTS = 0
IPPROTO_ICMP = 1
IPPROTO_ICMPV6 = 58
IPPROTO_IDP = 22
IPPROTO_IGMP = 2
IPPROTO_IP = 0
IPPROTO_IPCOMP = 108
IPPROTO_IPIP = 4
IPPROTO_IPV4 = 4
IPPROTO_IPV6 = 41
IPPROTO_MAX = 256
IPPROTO_ND = 77
IPPROTO_NONE = 59
IPPROTO_PIM = 103
IPPROTO_PUP = 12
IPPROTO_RAW = 255
IPPROTO_ROUTING = 43
IPPROTO_RSVP = 46
IPPROTO_TCP = 6
IPPROTO_TP = 29
IPPROTO_UDP = 17
IPPROTO_XTP = 36

IPV6_CHECKSUM = 26

IPV6_JOIN_GROUP = 12

IPV6_LEAVE_GROUP = 13

IPV6_MULTICAST_HOPS = 10
IPV6_MULTICAST_IF = 9
IPV6_MULTICAST_LOOP = 11

IPV6_RECVTCLASS = 35

IPV6_RTHDR_TYPE_0 = 0

IPV6_TCLASS = 36

IPV6_UNICAST_HOPS = 4

IPV6_V6ONLY = 27

IP_ADD_MEMBERSHIP = 12

IP_DEFAULT_MULTICAST_LOOP = 1
IP_DEFAULT_MULTICAST_TTL = 1

IP_DROP_MEMBERSHIP = 13

IP_HDRINCL = 2

IP_MAX_MEMBERSHIPS = 4095

IP_MULTICAST_IF = 9
IP_MULTICAST_LOOP = 11
IP_MULTICAST_TTL = 10

IP_OPTIONS = 1
IP_RECVDSTADDR = 7
IP_RECVOPTS = 5
IP_RECVRETOPTS = 6
IP_RETOPTS = 8
IP_TOS = 3
IP_TTL = 4

MSG_CTRUNC = 32
MSG_DONTROUTE = 4
MSG_DONTWAIT = 128
MSG_EOR = 8
MSG_OOB = 1
MSG_PEEK = 2
MSG_TRUNC = 16
MSG_WAITALL = 64

NI_DGRAM = 16
NI_MAXHOST = 1025
NI_MAXSERV = 32
NI_NAMEREQD = 4
NI_NOFQDN = 1
NI_NUMERICHOST = 2
NI_NUMERICSERV = 8

SHUT_RD = 0
SHUT_RDWR = 2
SHUT_WR = 1

SOCK_DGRAM = 2
SOCK_RAW = 3
SOCK_RDM = 4
SOCK_SEQPACKET = 5
SOCK_STREAM = 1

SOL_IP = 0
SOL_SOCKET = 65535
SOL_TCP = 6
SOL_UDP = 17

SOMAXCONN = 128
SO_ACCEPTCONN = 2
SO_BROADCAST = 32
SO_DEBUG = 1
SO_DONTROUTE = 16
SO_ERROR = 4103
SO_KEEPALIVE = 8
SO_LINGER = 128
SO_OOBINLINE = 256
SO_RCVBUF = 4098
SO_RCVLOWAT = 4100
SO_RCVTIMEO = 4102
SO_REUSEADDR = 4
SO_REUSEPORT = 512
SO_SNDBUF = 4097
SO_SNDLOWAT = 4099
SO_SNDTIMEO = 4101
SO_TYPE = 4104
SO_USELOOPBACK = 64

SSL_ERROR_EOF = 8

SSL_ERROR_INVALID_ERROR_CODE = 9

SSL_ERROR_SSL = 1
SSL_ERROR_SYSCALL = 5

SSL_ERROR_WANT_CONNECT = 7
SSL_ERROR_WANT_READ = 2
SSL_ERROR_WANT_WRITE = 3

SSL_ERROR_WANT_X509_LOOKUP = 4

SSL_ERROR_ZERO_RETURN = 6

TCP_MAXSEG = 2
TCP_NODELAY = 1

_m = 'shutdown'

# functions

def create_connection(address, timeout='<object object at 0x10711a0c0>', source_address=None): # reliably restored by inspect
    """
    Connect to *address* and return the socket object.
    
        Convenience function.  Connect to *address* (a 2-tuple ``(host,
        port)``) and return the socket object.  Passing the optional
        *timeout* parameter will set the timeout on the socket instance
        before attempting to connect.  If no *timeout* is supplied, the
        global default timeout setting returned by :func:`getdefaulttimeout`
        is used.  If *source_address* is set it must be a tuple of (host, port)
        for the socket to bind as a source address before making the connection.
        An host of '' or port 0 tells the OS to use the default.
    """
    pass


def getfqdn(name=None): # reliably restored by inspect
    """
    Get fully qualified domain name from name.
    
        An empty argument is interpreted as meaning the local host.
    
        First the hostname returned by gethostbyaddr() is checked, then
        possibly existing aliases. In case no FQDN is available, hostname
        from gethostname() is returned.
    """
    pass


def m(*args, **kwargs): # real signature unknown
    """
    shutdown(flag)
    
    Shut down the reading side of the socket (flag == SHUT_RD), the writing side
    of the socket (flag == SHUT_WR), or both ends (flag == SHUT_RDWR).
    """
    pass


def meth(name, self, *args): # reliably restored by inspect
    # no doc
    pass


def p(*args, **kwargs): # real signature unknown
    """
    shutdown(flag)
    
    Shut down the reading side of the socket (flag == SHUT_RD), the writing side
    of the socket (flag == SHUT_WR), or both ends (flag == SHUT_RDWR).
    """
    pass


def ssl(sock, keyfile=None, certfile=None): # reliably restored by inspect
    # no doc
    pass


# classes

class error(IOError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class gaierror(error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class herror(error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class MethodType(object):
    """
    instancemethod(function, instance, class)
    
    Create an instance method object.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __get__(self, obj, type=None): # real signature unknown; restored from __doc__
        """ descr.__get__(obj[, type]) -> value """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, function, instance, p_class): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    im_class = property(lambda self: object()) # default
    im_func = property(lambda self: object()) # default
    im_self = property(lambda self: object()) # default
    __func__ = property(lambda self: object()) # default
    __self__ = property(lambda self: object()) # default


class partial(object):
    """
    partial(func, *args, **keywords) - new function with partial application
        of the given arguments and keywords.
    """
    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, func, *args, **keywords): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    def __setstate__(self, *args, **kwargs): # real signature unknown
        pass

    args = property(lambda self: object()) # default
    func = property(lambda self: object()) # default
    keywords = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _socketobject(object):
    """
    socket([family[, type[, proto]]]) -> socket object
    
    Open a socket of the given type.  The family argument specifies the
    address family; it defaults to AF_INET.  The type argument specifies
    whether this is a stream (SOCK_STREAM, this is the default)
    or datagram (SOCK_DGRAM) socket.  The protocol argument defaults to 0,
    specifying the default protocol.  Keyword arguments are accepted.
    
    A socket object represents one endpoint of a network connection.
    
    Methods of socket objects (keyword arguments not allowed):
    
    accept() -- accept a connection, returning new socket and client address
    bind(addr) -- bind the socket to a local address
    close() -- close the socket
    connect(addr) -- connect the socket to a remote address
    connect_ex(addr) -- connect, return an error code instead of an exception
    dup() -- return a new socket object identical to the current one [*]
    fileno() -- return underlying file descriptor
    getpeername() -- return remote address [*]
    getsockname() -- return local address
    getsockopt(level, optname[, buflen]) -- get socket options
    gettimeout() -- return timeout or None
    listen(n) -- start listening for incoming connections
    makefile([mode, [bufsize]]) -- return a file object for the socket [*]
    recv(buflen[, flags]) -- receive data
    recv_into(buffer[, nbytes[, flags]]) -- receive data (into a buffer)
    recvfrom(buflen[, flags]) -- receive data and sender's address
    recvfrom_into(buffer[, nbytes, [, flags])
      -- receive data and sender's address (into a buffer)
    sendall(data[, flags]) -- send all data
    send(data[, flags]) -- send data, may not send all of it
    sendto(data[, flags], addr) -- send data to a given address
    setblocking(0 | 1) -- set or clear the blocking I/O flag
    setsockopt(level, optname, value) -- set socket options
    settimeout(None | float) -- set or clear the timeout
    shutdown(how) -- shut down traffic in one or both directions
    
     [*] not available on all platforms!
    """
    def accept(self): # real signature unknown; restored from __doc__
        """
        accept() -> (socket object, address info)
        
        Wait for an incoming connection.  Return a new socket representing the
        connection, and the address of the client.  For IP sockets, the address
        info is a pair (hostaddr, port).
        """
        pass

    def bind(self, address): # real signature unknown; restored from __doc__
        """
        bind(address)
        
        Bind the socket to a local address.  For IP sockets, the address is a
        pair (host, port); the host must refer to the local host. For raw packet
        sockets the address is a tuple (ifname, proto [,pkttype [,hatype]])
        """
        pass

    def close(self): # real signature unknown; restored from __doc__
        """
        close()
        
        Close the socket.  It cannot be used after this call.
        """
        pass

    def connect(self, address): # real signature unknown; restored from __doc__
        """
        connect(address)
        
        Connect the socket to a remote address.  For IP sockets, the address
        is a pair (host, port).
        """
        pass

    def connect_ex(self, address): # real signature unknown; restored from __doc__
        """
        connect_ex(address) -> errno
        
        This is like connect(address), but returns an error code (the errno value)
        instead of raising an exception when an error occurs.
        """
        return errno

    def dup(self): # real signature unknown; restored from __doc__
        """
        dup() -> socket object
        
                Return a new socket object connected to the same system resource.
        """
        return socket

    def fileno(self): # real signature unknown; restored from __doc__
        """
        fileno() -> integer
        
        Return the integer file descriptor of the socket.
        """
        return 0

    def getpeername(self): # real signature unknown; restored from __doc__
        """
        getpeername() -> address info
        
        Return the address of the remote endpoint.  For IP sockets, the address
        info is a pair (hostaddr, port).
        """
        pass

    def getsockname(self): # real signature unknown; restored from __doc__
        """
        getsockname() -> address info
        
        Return the address of the local endpoint.  For IP sockets, the address
        info is a pair (hostaddr, port).
        """
        pass

    def getsockopt(self, level, option, buffersize=None): # real signature unknown; restored from __doc__
        """
        getsockopt(level, option[, buffersize]) -> value
        
        Get a socket option.  See the Unix manual for level and option.
        If a nonzero buffersize argument is given, the return value is a
        string of that length; otherwise it is an integer.
        """
        pass

    def gettimeout(self): # real signature unknown; restored from __doc__
        """
        gettimeout() -> timeout
        
        Returns the timeout in floating seconds associated with socket 
        operations. A timeout of None indicates that timeouts on socket 
        operations are disabled.
        """
        return timeout

    def listen(self, backlog): # real signature unknown; restored from __doc__
        """
        listen(backlog)
        
        Enable a server to accept connections.  The backlog argument must be at
        least 1; it specifies the number of unaccepted connection that the system
        will allow before refusing new connections.
        """
        pass

    def makefile(self, mode=None, bufsize=None): # real signature unknown; restored from __doc__
        """
        makefile([mode[, bufsize]]) -> file object
        
                Return a regular file object corresponding to the socket.  The mode
                and bufsize arguments are as for the built-in open() function.
        """
        return file('/dev/null')

    def sendall(self, data, flags=None): # real signature unknown; restored from __doc__
        """
        sendall(data[, flags])
        
        Send a data string to the socket.  For the optional flags
        argument, see the Unix manual.  This calls send() repeatedly
        until all data is sent.  If an error occurs, it's impossible
        to tell how much data has been sent.
        """
        pass

    def setblocking(self, flag): # real signature unknown; restored from __doc__
        """
        setblocking(flag)
        
        Set the socket to blocking (flag is true) or non-blocking (false).
        setblocking(True) is equivalent to settimeout(None);
        setblocking(False) is equivalent to settimeout(0.0).
        """
        pass

    def setsockopt(self, level, option, value): # real signature unknown; restored from __doc__
        """
        setsockopt(level, option, value)
        
        Set a socket option.  See the Unix manual for level and option.
        The value argument can either be an integer or a string.
        """
        pass

    def settimeout(self, timeout): # real signature unknown; restored from __doc__
        """
        settimeout(timeout)
        
        Set a timeout on socket operations.  'timeout' can be a float,
        giving in seconds, or None.  Setting a timeout of None disables
        the timeout feature and is equivalent to setblocking(1).
        Setting a timeout of zero is the same as setblocking(0).
        """
        pass

    def shutdown(self, flag): # real signature unknown; restored from __doc__
        """
        shutdown(flag)
        
        Shut down the reading side of the socket (flag == SHUT_RD), the writing side
        of the socket (flag == SHUT_WR), or both ends (flag == SHUT_RDWR).
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    family = property(lambda self: object()) # default
    proto = property(lambda self: object()) # default
    recv = property(lambda self: object()) # default
    recvfrom = property(lambda self: object()) # default
    recvfrom_into = property(lambda self: object()) # default
    recv_into = property(lambda self: object()) # default
    send = property(lambda self: object()) # default
    sendto = property(lambda self: object()) # default
    type = property(lambda self: object()) # default
    _sock = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    __slots__ = [
        '_sock',
        '__weakref__',
        'recv',
        'recvfrom',
        'recv_into',
        'recvfrom_into',
        'send',
        'sendto',
    ]


SocketType = _socketobject


socket = _socketobject


class sslerror(error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class timeout(error):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _closedsocket(object):
    # no doc
    def recv(self, *args, **kwargs): # real signature unknown
        pass

    def recvfrom(self, *args, **kwargs): # real signature unknown
        pass

    def recvfrom_into(self, *args, **kwargs): # real signature unknown
        pass

    def recv_into(self, *args, **kwargs): # real signature unknown
        pass

    def send(self, *args, **kwargs): # real signature unknown
        pass

    def sendto(self, *args, **kwargs): # real signature unknown
        pass

    def _dummy(self, *args, **kwargs): # real signature unknown
        pass

    def __getattr__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __slots__ = []


class _fileobject(object):
    """ Faux file object attached to a socket object. """
    def close(self, *args, **kwargs): # real signature unknown
        pass

    def fileno(self, *args, **kwargs): # real signature unknown
        pass

    def flush(self, *args, **kwargs): # real signature unknown
        pass

    def next(self, *args, **kwargs): # real signature unknown
        pass

    def read(self, *args, **kwargs): # real signature unknown
        pass

    def readline(self, *args, **kwargs): # real signature unknown
        pass

    def readlines(self, *args, **kwargs): # real signature unknown
        pass

    def write(self, *args, **kwargs): # real signature unknown
        pass

    def writelines(self, *args, **kwargs): # real signature unknown
        pass

    def _getclosed(self, *args, **kwargs): # real signature unknown
        pass

    def __del__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    bufsize = property(lambda self: object()) # default
    closed = property(lambda self: object()) # default
    mode = property(lambda self: object()) # default
    softspace = property(lambda self: object()) # default
    _close = property(lambda self: object()) # default
    _rbuf = property(lambda self: object()) # default
    _rbufsize = property(lambda self: object()) # default
    _sock = property(lambda self: object()) # default
    _wbuf = property(lambda self: object()) # default
    _wbufsize = property(lambda self: object()) # default
    _wbuf_len = property(lambda self: object()) # default

    default_bufsize = 8192
    name = '<socket>'
    __slots__ = [
        'mode',
        'bufsize',
        'softspace',
        '_sock',
        '_rbufsize',
        '_wbufsize',
        '_rbuf',
        '_wbuf',
        '_wbuf_len',
        '_close',
    ]


# variables with complex values

CAPI = _socket.CAPI

_delegate_methods = (
    'recv',
    'recvfrom',
    'recv_into',
    'recvfrom_into',
    'send',
    'sendto',
)

_GLOBAL_DEFAULT_TIMEOUT = None # (!) real value is ''

_socketmethods = (
    'bind',
    'connect',
    'connect_ex',
    'fileno',
    'listen',
    'getpeername',
    'getsockname',
    'getsockopt',
    'setsockopt',
    'sendall',
    'setblocking',
    'settimeout',
    'gettimeout',
    'shutdown',
)

__all__ = [
    'getfqdn',
    'create_connection',
    'AF_APPLETALK',
    'AF_DECnet',
    'AF_INET',
    'AF_INET6',
    'AF_IPX',
    'AF_ROUTE',
    'AF_SNA',
    'AF_UNIX',
    'AF_UNSPEC',
    'AI_ADDRCONFIG',
    'AI_ALL',
    'AI_CANONNAME',
    'AI_DEFAULT',
    'AI_MASK',
    'AI_NUMERICHOST',
    'AI_NUMERICSERV',
    'AI_PASSIVE',
    'AI_V4MAPPED',
    'AI_V4MAPPED_CFG',
    'CAPI',
    'EAI_ADDRFAMILY',
    'EAI_AGAIN',
    'EAI_BADFLAGS',
    'EAI_BADHINTS',
    'EAI_FAIL',
    'EAI_FAMILY',
    'EAI_MAX',
    'EAI_MEMORY',
    'EAI_NODATA',
    'EAI_NONAME',
    'EAI_OVERFLOW',
    'EAI_PROTOCOL',
    'EAI_SERVICE',
    'EAI_SOCKTYPE',
    'EAI_SYSTEM',
    'INADDR_ALLHOSTS_GROUP',
    'INADDR_ANY',
    'INADDR_BROADCAST',
    'INADDR_LOOPBACK',
    'INADDR_MAX_LOCAL_GROUP',
    'INADDR_NONE',
    'INADDR_UNSPEC_GROUP',
    'IPPORT_RESERVED',
    'IPPORT_USERRESERVED',
    'IPPROTO_AH',
    'IPPROTO_DSTOPTS',
    'IPPROTO_EGP',
    'IPPROTO_EON',
    'IPPROTO_ESP',
    'IPPROTO_FRAGMENT',
    'IPPROTO_GGP',
    'IPPROTO_GRE',
    'IPPROTO_HELLO',
    'IPPROTO_HOPOPTS',
    'IPPROTO_ICMP',
    'IPPROTO_ICMPV6',
    'IPPROTO_IDP',
    'IPPROTO_IGMP',
    'IPPROTO_IP',
    'IPPROTO_IPCOMP',
    'IPPROTO_IPIP',
    'IPPROTO_IPV4',
    'IPPROTO_IPV6',
    'IPPROTO_MAX',
    'IPPROTO_ND',
    'IPPROTO_NONE',
    'IPPROTO_PIM',
    'IPPROTO_PUP',
    'IPPROTO_RAW',
    'IPPROTO_ROUTING',
    'IPPROTO_RSVP',
    'IPPROTO_TCP',
    'IPPROTO_TP',
    'IPPROTO_UDP',
    'IPPROTO_XTP',
    'IPV6_CHECKSUM',
    'IPV6_JOIN_GROUP',
    'IPV6_LEAVE_GROUP',
    'IPV6_MULTICAST_HOPS',
    'IPV6_MULTICAST_IF',
    'IPV6_MULTICAST_LOOP',
    'IPV6_RECVTCLASS',
    'IPV6_RTHDR_TYPE_0',
    'IPV6_TCLASS',
    'IPV6_UNICAST_HOPS',
    'IPV6_V6ONLY',
    'IP_ADD_MEMBERSHIP',
    'IP_DEFAULT_MULTICAST_LOOP',
    'IP_DEFAULT_MULTICAST_TTL',
    'IP_DROP_MEMBERSHIP',
    'IP_HDRINCL',
    'IP_MAX_MEMBERSHIPS',
    'IP_MULTICAST_IF',
    'IP_MULTICAST_LOOP',
    'IP_MULTICAST_TTL',
    'IP_OPTIONS',
    'IP_RECVDSTADDR',
    'IP_RECVOPTS',
    'IP_RECVRETOPTS',
    'IP_RETOPTS',
    'IP_TOS',
    'IP_TTL',
    'MSG_CTRUNC',
    'MSG_DONTROUTE',
    'MSG_DONTWAIT',
    'MSG_EOR',
    'MSG_OOB',
    'MSG_PEEK',
    'MSG_TRUNC',
    'MSG_WAITALL',
    'NI_DGRAM',
    'NI_MAXHOST',
    'NI_MAXSERV',
    'NI_NAMEREQD',
    'NI_NOFQDN',
    'NI_NUMERICHOST',
    'NI_NUMERICSERV',
    'SHUT_RD',
    'SHUT_RDWR',
    'SHUT_WR',
    'SOCK_DGRAM',
    'SOCK_RAW',
    'SOCK_RDM',
    'SOCK_SEQPACKET',
    'SOCK_STREAM',
    'SOL_IP',
    'SOL_SOCKET',
    'SOL_TCP',
    'SOL_UDP',
    'SOMAXCONN',
    'SO_ACCEPTCONN',
    'SO_BROADCAST',
    'SO_DEBUG',
    'SO_DONTROUTE',
    'SO_ERROR',
    'SO_KEEPALIVE',
    'SO_LINGER',
    'SO_OOBINLINE',
    'SO_RCVBUF',
    'SO_RCVLOWAT',
    'SO_RCVTIMEO',
    'SO_REUSEADDR',
    'SO_REUSEPORT',
    'SO_SNDBUF',
    'SO_SNDLOWAT',
    'SO_SNDTIMEO',
    'SO_TYPE',
    'SO_USELOOPBACK',
    'SocketType',
    'TCP_MAXSEG',
    'TCP_NODELAY',
    'error',
    'fromfd',
    'gaierror',
    'getaddrinfo',
    'getdefaulttimeout',
    'gethostbyaddr',
    'gethostbyname',
    'gethostbyname_ex',
    'gethostname',
    'getnameinfo',
    'getprotobyname',
    'getservbyname',
    'getservbyport',
    'has_ipv6',
    'herror',
    'htonl',
    'htons',
    'inet_aton',
    'inet_ntoa',
    'inet_ntop',
    'inet_pton',
    'ntohl',
    'ntohs',
    'setdefaulttimeout',
    'socket',
    'socketpair',
    'timeout',
]

