# encoding: utf-8
# module ttk
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-tk/ttk.pyo by generator 1.99
"""
Ttk wrapper.

This module provides classes to allow using Tk themed widget set.

Ttk is based on a revised and enhanced version of
TIP #48 (http://tip.tcl.tk/48) specified style engine.

Its basic idea is to separate, to the extent possible, the code
implementing a widget's behavior from the code implementing its
appearance. Widget class bindings are primarily responsible for
maintaining the widget state and invoking callbacks, all aspects
of the widgets appearance lies at Themes.
"""

# imports
import Tkinter as Tkinter # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/lib-tk/Tkinter.pyc
from _tkinter import _flatten


# Variables with simple values

_REQUIRE_TILE = False

__author__ = 'Guilherme Polo <ggpolo@gmail.com>'

__version__ = '0.3.1'

# functions

def setup_master(master=None): # reliably restored by inspect
    """
    If master is not None, itself is returned. If master is None,
        the default master is returned if there is one, otherwise a new
        master is created and returned.
    
        If it is not allowed to use the default root and master is None,
        RuntimeError is raised.
    """
    pass


def tclobjs_to_py(adict): # reliably restored by inspect
    """
    Returns adict with its values converted from Tcl objects to Python
        objects.
    """
    pass


def _convert_stringval(value): # reliably restored by inspect
    """ Converts a value to, hopefully, a more appropriate Python object. """
    pass


def _dict_from_tcltuple(ttuple, cut_minus=True): # reliably restored by inspect
    """
    Break tuple in pairs, format it properly, then build the return
        dict. If cut_minus is True, the supposed '-' prefixing options will
        be removed.
    
        ttuple is expected to contain an even number of elements.
    """
    pass


def _format_elemcreate(etype, script=False, *args, **kw): # reliably restored by inspect
    """ Formats args and kw according to the given element factory etype. """
    pass


def _format_layoutlist(layout, indent=0, indent_size=2): # reliably restored by inspect
    """
    Formats a layout list so we can pass the result to ttk::style
        layout and ttk::style settings. Note that the layout doesn't has to
        be a list necessarily.
    
        E.g.:
          [("Menubutton.background", None),
           ("Menubutton.button", {"children":
               [("Menubutton.focus", {"children":
                   [("Menubutton.padding", {"children":
                    [("Menubutton.label", {"side": "left", "expand": 1})]
                   })]
               })]
           }),
           ("Menubutton.indicator", {"side": "right"})
          ]
    
          returns:
    
          Menubutton.background
          Menubutton.button -children {
            Menubutton.focus -children {
              Menubutton.padding -children {
                Menubutton.label -side left -expand 1
              }
            }
          }
          Menubutton.indicator -side right
    """
    pass


def _format_mapdict(mapdict, script=False): # reliably restored by inspect
    """
    Formats mapdict to pass it to tk.call.
    
        E.g. (script=False):
          {'expand': [('active', 'selected', 'grey'), ('focus', [1, 2, 3, 4])]}
    
          returns:
    
          ('-expand', '{active selected} grey focus {1, 2, 3, 4}')
    """
    pass


def _format_optdict(optdict, script=False, ignore=None): # reliably restored by inspect
    """
    Formats optdict to a tuple to pass it to tk.call.
    
        E.g. (script=False):
          {'foreground': 'blue', 'padding': [1, 2, 3, 4]} returns:
          ('-foreground', 'blue', '-padding', '1 2 3 4')
    """
    pass


def _list_from_layouttuple(ltuple): # reliably restored by inspect
    """
    Construct a list from the tuple returned by ttk::layout, this is
        somewhat the reverse of _format_layoutlist.
    """
    pass


def _list_from_statespec(stuple): # reliably restored by inspect
    """
    Construct a list from the given statespec tuple according to the
        accepted statespec accepted by _format_mapdict.
    """
    pass


def _load_tile(master): # reliably restored by inspect
    # no doc
    pass


def _script_from_settings(settings): # reliably restored by inspect
    """
    Returns an appropriate script, based on settings, according to
        theme_settings definition to be used by theme_settings and
        theme_create.
    """
    pass


def _val_or_dict(options, func, *args): # reliably restored by inspect
    """
    Format options then call func with args and options and return
        the appropriate result.
    
        If no option is specified, a dict is returned. If a option is
        specified with the None value, the value for that option is returned.
        Otherwise, the function just sets the passed options and the caller
        shouldn't be expecting a return value anyway.
    """
    pass


# classes

class LabeledScale(Frame, object):
    """
    A Ttk Scale widget with a Ttk Label widget indicating its
        current value.
    
        The Ttk Scale can be accessed through instance.scale, and Ttk Label
        can be accessed through instance.label
    """
    def destroy(self, *args, **kwargs): # real signature unknown
        """ Destroy this widget and possibly its associated variable. """
        pass

    def _adjust(self, *args, **kwargs): # real signature unknown
        """ Adjust the label position according to the scale. """
        pass

    def _get_value(self, *args, **kwargs): # real signature unknown
        """ Return current scale value. """
        pass

    def _set_value(self, *args, **kwargs): # real signature unknown
        """ Set new scale value. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Construct an horizontal LabeledScale with parent master, a
                variable to be associated with the Ttk Scale widget and its range.
                If variable is not specified, a Tkinter.IntVar is created.
        
                WIDGET-SPECIFIC OPTIONS
        
                    compound: 'top' or 'bottom'
                        Specifies how to display the label relative to the scale.
                        Defaults to 'top'.
        """
        pass

    value = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Style(object):
    """ Manipulate style database. """
    def configure(self, *args, **kwargs): # real signature unknown
        """
        Query or sets the default value of the specified option(s) in
                style.
        
                Each key in kw is an option and each value is either a string or
                a sequence identifying the value for that option.
        """
        pass

    def element_create(self, *args, **kwargs): # real signature unknown
        """ Create a new element in the current theme of given etype. """
        pass

    def element_names(self, *args, **kwargs): # real signature unknown
        """ Returns the list of elements defined in the current theme. """
        pass

    def element_options(self, *args, **kwargs): # real signature unknown
        """ Return the list of elementname's options. """
        pass

    def layout(self, *args, **kwargs): # real signature unknown
        """
        Define the widget layout for given style. If layoutspec is
                omitted, return the layout specification for given style.
        
                layoutspec is expected to be a list or an object different than
                None that evaluates to False if you want to "turn off" that style.
                If it is a list (or tuple, or something else), each item should be
                a tuple where the first item is the layout name and the second item
                should have the format described below:
        
                LAYOUTS
        
                    A layout can contain the value None, if takes no options, or
                    a dict of options specifying how to arrange the element.
                    The layout mechanism uses a simplified version of the pack
                    geometry manager: given an initial cavity, each element is
                    allocated a parcel. Valid options/values are:
        
                        side: whichside
                            Specifies which side of the cavity to place the
                            element; one of top, right, bottom or left. If
                            omitted, the element occupies the entire cavity.
        
                        sticky: nswe
                            Specifies where the element is placed inside its
                            allocated parcel.
        
                        children: [sublayout... ]
                            Specifies a list of elements to place inside the
                            element. Each element is a tuple (or other sequence)
                            where the first item is the layout name, and the other
                            is a LAYOUT.
        """
        pass

    def lookup(self, *args, **kwargs): # real signature unknown
        """
        Returns the value specified for option in style.
        
                If state is specified it is expected to be a sequence of one
                or more states. If the default argument is set, it is used as
                a fallback value in case no specification for option is found.
        """
        pass

    def map(self, *args, **kwargs): # real signature unknown
        """
        Query or sets dynamic values of the specified option(s) in
                style.
        
                Each key in kw is an option and each value should be a list or a
                tuple (usually) containing statespecs grouped in tuples, or list,
                or something else of your preference. A statespec is compound of
                one or more states and then a value.
        """
        pass

    def theme_create(self, *args, **kwargs): # real signature unknown
        """
        Creates a new theme.
        
                It is an error if themename already exists. If parent is
                specified, the new theme will inherit styles, elements and
                layouts from the specified parent theme. If settings are present,
                they are expected to have the same syntax used for theme_settings.
        """
        pass

    def theme_names(self, *args, **kwargs): # real signature unknown
        """ Returns a list of all known themes. """
        pass

    def theme_settings(self, *args, **kwargs): # real signature unknown
        """
        Temporarily sets the current theme to themename, apply specified
                settings and then restore the previous theme.
        
                Each key in settings is a style and each value may contain the
                keys 'configure', 'map', 'layout' and 'element create' and they
                are expected to have the same format as specified by the methods
                configure, map, layout and element_create respectively.
        """
        pass

    def theme_use(self, *args, **kwargs): # real signature unknown
        """
        If themename is None, returns the theme in use, otherwise, set
                the current theme to themename, refreshes all widgets and emits
                a <<ThemeChanged>> event.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _name = 'ttk::style'
    __dict__ = None # (!) real value is ''


# variables with complex values

Button = None # (!) real value is ''

Checkbutton = None # (!) real value is ''

Combobox = None # (!) real value is ''

Entry = None # (!) real value is ''

Frame = None # (!) real value is ''

Label = None # (!) real value is ''

Labelframe = None # (!) real value is ''

LabelFrame = Labelframe

Menubutton = None # (!) real value is ''

Notebook = None # (!) real value is ''

OptionMenu = None # (!) real value is ''

PanedWindow = None # (!) real value is ''

Panedwindow = PanedWindow

Progressbar = None # (!) real value is ''

Radiobutton = None # (!) real value is ''

Scale = None # (!) real value is ''

Scrollbar = None # (!) real value is ''

Separator = None # (!) real value is ''

Sizegrip = None # (!) real value is ''

Treeview = None # (!) real value is ''

Widget = None # (!) real value is ''

__all__ = [
    'Button',
    'Checkbutton',
    'Combobox',
    'Entry',
    'Frame',
    'Label',
    'Labelframe',
    'LabelFrame',
    'Menubutton',
    'Notebook',
    'Panedwindow',
    'PanedWindow',
    'Progressbar',
    'Radiobutton',
    'Scale',
    'Scrollbar',
    'Separator',
    'Sizegrip',
    'Style',
    'Treeview',
    'LabeledScale',
    'OptionMenu',
    'tclobjs_to_py',
    'setup_master',
]

