# encoding: utf-8
# module unittest.__init__
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/unittest/__init__.pyo by generator 1.99
"""
Python unit testing framework, based on Erich Gamma's JUnit and Kent Beck's
Smalltalk testing framework.

This module contains the core framework classes that form the basis of
specific test cases and suites (TestCase, TestSuite etc.), and also a
text-based utility class for running the tests and reporting the results
 (TextTestRunner).

Simple usage:

    import unittest

    class IntegerArithmenticTestCase(unittest.TestCase):
        def testAdd(self):  ## test method names begin 'test*'
            self.assertEqual((1 + 2), 3)
            self.assertEqual(0 + 1, 1)
        def testMultiply(self):
            self.assertEqual((0 * 10), 0)
            self.assertEqual((5 * 8), 40)

    if __name__ == '__main__':
        unittest.main()

Further information is available in the bundled documentation, and from

  http://docs.python.org/library/unittest.html

Copyright (c) 1999-2003 Steve Purcell
Copyright (c) 2003-2010 Python Software Foundation
This module is free software, and you may redistribute it and/or modify
it under the same terms as Python itself, so long as this copyright message
and disclaimer are retained in their original form.

IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF
THIS CODE, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE.  THE CODE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS,
AND THERE IS NO OBLIGATION WHATSOEVER TO PROVIDE MAINTENANCE,
SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
"""

# imports
from unittest.main import TestProgram, main

import unittest.case as __unittest_case
import unittest.result as __unittest_result
import unittest.suite as __unittest_suite


# Variables with simple values

__unittest = True

# functions

def expectedFailure(func): # reliably restored by inspect
    # no doc
    pass


def findTestCases(module, prefix=None, sortUsing=cmp, suiteClass="<class 'unittest.suite.TestSuite'>"): # reliably restored by inspect
    # no doc
    pass


def getTestCaseNames(testCaseClass, prefix, sortUsing=cmp): # reliably restored by inspect
    # no doc
    pass


def installHandler(): # reliably restored by inspect
    # no doc
    pass


def makeSuite(testCaseClass, prefix=None, sortUsing=cmp, suiteClass="<class 'unittest.suite.TestSuite'>"): # reliably restored by inspect
    # no doc
    pass


def registerResult(result): # reliably restored by inspect
    # no doc
    pass


def removeHandler(method=None): # reliably restored by inspect
    # no doc
    pass


def removeResult(result): # reliably restored by inspect
    # no doc
    pass


def skip(reason): # reliably restored by inspect
    """ Unconditionally skip a test. """
    pass


def skipIf(condition, reason): # reliably restored by inspect
    """ Skip a test if the condition is true. """
    pass


def skipUnless(condition, reason): # reliably restored by inspect
    """ Skip a test unless the condition is true. """
    pass


# classes

class BaseTestSuite(object):
    """ A simple test suite that doesn't provide class or module shared fixtures. """
    def addTest(self, *args, **kwargs): # real signature unknown
        pass

    def addTests(self, *args, **kwargs): # real signature unknown
        pass

    def countTestCases(self, *args, **kwargs): # real signature unknown
        pass

    def debug(self, *args, **kwargs): # real signature unknown
        """ Run the tests without collecting errors in a TestResult """
        pass

    def run(self, *args, **kwargs): # real signature unknown
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''
    __hash__ = None


class TestCase(object):
    """
    A class whose instances are single test cases.
    
        By default, the test code itself should be placed in a method named
        'runTest'.
    
        If the fixture may be used for many test cases, create as
        many test methods as are needed. When instantiating such a TestCase
        subclass, specify in the constructor arguments the name of the test method
        that the instance is to execute.
    
        Test authors should subclass TestCase for their own tests. Construction
        and deconstruction of the test's environment ('fixture') can be
        implemented by overriding the 'setUp' and 'tearDown' methods respectively.
    
        If it is necessary to override the __init__ method, the base class
        __init__ method must always be called. It is important that subclasses
        should not change the signature of their __init__ method, since instances
        of the classes are instantiated automatically by parts of the framework
        in order to be run.
    """
    def addCleanup(self, *args, **kwargs): # real signature unknown
        """
        Add a function, with arguments, to be called when the test is
                completed. Functions added are called on a LIFO basis and are
                called after tearDown on test failure or success.
        
                Cleanup items are called even if setUp fails (unlike tearDown).
        """
        pass

    def addTypeEqualityFunc(self, *args, **kwargs): # real signature unknown
        """
        Add a type specific assertEqual style function to compare a type.
        
                This method is for use by TestCase subclasses that need to register
                their own type equality functions to provide nicer error messages.
        
                Args:
                    typeobj: The data type to call this function on when both values
                            are of the same type in assertEqual().
                    function: The callable taking two arguments and an optional
                            msg= argument that raises self.failureException with a
                            useful error message when the two arguments are not equal.
        """
        pass

    def assertAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is more than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   If the two objects compare equal then they will automatically
                   compare almost equal.
        """
        pass

    def assertAlmostEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is more than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   If the two objects compare equal then they will automatically
                   compare almost equal.
        """
        pass

    def assertDictContainsSubset(self, *args, **kwargs): # real signature unknown
        """ Checks whether actual is a superset of expected. """
        pass

    def assertDictEqual(self, *args, **kwargs): # real signature unknown
        pass

    def assertEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by the '=='
                   operator.
        """
        pass

    def assertEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by the '=='
                   operator.
        """
        pass

    def assertFalse(self, *args, **kwargs): # real signature unknown
        """ Fail the test if the expression is true. """
        pass

    def assertGreater(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a > b), but with a nicer default message. """
        pass

    def assertGreaterEqual(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a >= b), but with a nicer default message. """
        pass

    def assertIn(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a in b), but with a nicer default message. """
        pass

    def assertIs(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a is b), but with a nicer default message. """
        pass

    def assertIsInstance(self, *args, **kwargs): # real signature unknown
        """
        Same as self.assertTrue(isinstance(obj, cls)), with a nicer
                default message.
        """
        pass

    def assertIsNone(self, *args, **kwargs): # real signature unknown
        """ Same as self.assertTrue(obj is None), with a nicer default message. """
        pass

    def assertIsNot(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a is not b), but with a nicer default message. """
        pass

    def assertIsNotNone(self, *args, **kwargs): # real signature unknown
        """ Included for symmetry with assertIsNone. """
        pass

    def assertItemsEqual(self, *args, **kwargs): # real signature unknown
        """
        An unordered sequence / set specific comparison. It asserts that
                expected_seq and actual_seq contain the same elements. It is
                the equivalent of::
        
                    self.assertEqual(sorted(expected_seq), sorted(actual_seq))
        
                Raises with an error message listing which elements of expected_seq
                are missing from actual_seq and vice versa if any.
        
                Asserts that each element has the same count in both sequences.
                Example:
                    - [0, 1, 1] and [1, 0, 1] compare equal.
                    - [0, 0, 1] and [0, 1] compare unequal.
        """
        pass

    def assertLess(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a < b), but with a nicer default message. """
        pass

    def assertLessEqual(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a <= b), but with a nicer default message. """
        pass

    def assertListEqual(self, *args, **kwargs): # real signature unknown
        """
        A list-specific equality assertion.
        
                Args:
                    list1: The first list to compare.
                    list2: The second list to compare.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        """
        pass

    def assertMultiLineEqual(self, *args, **kwargs): # real signature unknown
        """ Assert that two multi-line strings are equal. """
        pass

    def assertNotAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is less than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   Objects that are equal automatically fail.
        """
        pass

    def assertNotAlmostEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is less than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   Objects that are equal automatically fail.
        """
        pass

    def assertNotEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by the '=='
                   operator.
        """
        pass

    def assertNotEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by the '=='
                   operator.
        """
        pass

    def assertNotIn(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a not in b), but with a nicer default message. """
        pass

    def assertNotIsInstance(self, *args, **kwargs): # real signature unknown
        """ Included for symmetry with assertIsInstance. """
        pass

    def assertNotRegexpMatches(self, *args, **kwargs): # real signature unknown
        """ Fail the test if the text matches the regular expression. """
        pass

    def assertRaises(self, SomeException): # real signature unknown; restored from __doc__
        """
        Fail unless an exception of class excClass is thrown
                   by callableObj when invoked with arguments args and keyword
                   arguments kwargs. If a different type of exception is
                   thrown, it will not be caught, and the test case will be
                   deemed to have suffered an error, exactly as for an
                   unexpected exception.
        
                   If called with callableObj omitted or None, will return a
                   context object used like this::
        
                        with self.assertRaises(SomeException):
                            do_something()
        
                   The context manager keeps a reference to the exception as
                   the 'exception' attribute. This allows you to inspect the
                   exception after the assertion::
        
                       with self.assertRaises(SomeException) as cm:
                           do_something()
                       the_exception = cm.exception
                       self.assertEqual(the_exception.error_code, 3)
        """
        pass

    def assertRaisesRegexp(self, *args, **kwargs): # real signature unknown
        """
        Asserts that the message in a raised exception matches a regexp.
        
                Args:
                    expected_exception: Exception class expected to be raised.
                    expected_regexp: Regexp (re pattern object or string) expected
                            to be found in error message.
                    callable_obj: Function to be called.
                    args: Extra args.
                    kwargs: Extra kwargs.
        """
        pass

    def assertRegexpMatches(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the text matches the regular expression. """
        pass

    def assertSequenceEqual(self, *args, **kwargs): # real signature unknown
        """
        An equality assertion for ordered sequences (like lists and tuples).
        
                For the purposes of this function, a valid ordered sequence type is one
                which can be indexed, has a length, and has an equality operator.
        
                Args:
                    seq1: The first sequence to compare.
                    seq2: The second sequence to compare.
                    seq_type: The expected datatype of the sequences, or None if no
                            datatype should be enforced.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        """
        pass

    def assertSetEqual(self, *args, **kwargs): # real signature unknown
        """
        A set-specific equality assertion.
        
                Args:
                    set1: The first set to compare.
                    set2: The second set to compare.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        
                assertSetEqual uses ducktyping to support different types of sets, and
                is optimized for sets specifically (parameters must support a
                difference method).
        """
        pass

    def assertTrue(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the expression is true. """
        pass

    def assertTupleEqual(self, *args, **kwargs): # real signature unknown
        """
        A tuple-specific equality assertion.
        
                Args:
                    tuple1: The first tuple to compare.
                    tuple2: The second tuple to compare.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        """
        pass

    def assert_(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the expression is true. """
        pass

    def countTestCases(self, *args, **kwargs): # real signature unknown
        pass

    def debug(self, *args, **kwargs): # real signature unknown
        """ Run the test without collecting errors in a TestResult """
        pass

    def defaultTestResult(self, *args, **kwargs): # real signature unknown
        pass

    def doCleanups(self, *args, **kwargs): # real signature unknown
        """
        Execute all cleanup functions. Normally called for you after
                tearDown.
        """
        pass

    def fail(self, *args, **kwargs): # real signature unknown
        """ Fail immediately, with the given message. """
        pass

    def failIf(self, *args, **kwargs): # real signature unknown
        pass

    def failIfAlmostEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failIfEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failUnless(self, *args, **kwargs): # real signature unknown
        pass

    def failUnlessAlmostEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failUnlessEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failUnlessRaises(self, *args, **kwargs): # real signature unknown
        pass

    def failureException(self, *args, **kwargs): # real signature unknown
        """ Assertion failed. """
        pass

    def id(self, *args, **kwargs): # real signature unknown
        pass

    def run(self, *args, **kwargs): # real signature unknown
        pass

    def setUp(self, *args, **kwargs): # real signature unknown
        """ Hook method for setting up the test fixture before exercising it. """
        pass

    @classmethod
    def setUpClass(cls, *args, **kwargs): # real signature unknown
        """ Hook method for setting up class fixture before running tests in the class. """
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        """
        Returns a one-line description of the test, or None if no
                description has been provided.
        
                The default implementation of this method returns the first line of
                the specified test method's docstring.
        """
        pass

    def skipTest(self, *args, **kwargs): # real signature unknown
        """ Skip this test. """
        pass

    def tearDown(self, *args, **kwargs): # real signature unknown
        """ Hook method for deconstructing the test fixture after testing it. """
        pass

    @classmethod
    def tearDownClass(cls, *args, **kwargs): # real signature unknown
        """ Hook method for deconstructing the class fixture after running all tests in the class. """
        pass

    def _addSkip(self, *args, **kwargs): # real signature unknown
        pass

    def _baseAssertEqual(self, *args, **kwargs): # real signature unknown
        """ The default assertEqual implementation, not type specific. """
        pass

    def _deprecate(self, *args, **kwargs): # real signature unknown
        pass

    def _formatMessage(self, *args, **kwargs): # real signature unknown
        """
        Honour the longMessage attribute when generating failure messages.
                If longMessage is False this means:
                * Use only an explicit message if it is provided
                * Otherwise use the standard message for the assert
        
                If longMessage is True:
                * Use the standard message
                * If an explicit message is provided, plus ' : ' and the explicit message
        """
        pass

    def _getAssertEqualityFunc(self, *args, **kwargs): # real signature unknown
        """
        Get a detailed comparison function for the types of the two args.
        
                Returns: A callable accepting (first, second, msg=None) that will
                raise a failure exception if first != second with a useful human
                readable error message for those types.
        """
        pass

    def _truncateMessage(self, *args, **kwargs): # real signature unknown
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Create an instance of the class that will use the named test
                   method when executed. Raises a ValueError if the instance does
                   not have a method with the specified name.
        """
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    longMessage = False
    maxDiff = 640
    _classSetupFailed = False
    __dict__ = None # (!) real value is ''


class FunctionTestCase(__unittest_case.TestCase):
    """
    A test case that wraps a test function.
    
        This is useful for slipping pre-existing test functions into the
        unittest framework. Optionally, set-up and tidy-up functions can be
        supplied. As with TestCase, the tidy-up ('tearDown') function will
        always be called if the set-up ('setUp') function ran successfully.
    """
    def id(self, *args, **kwargs): # real signature unknown
        pass

    def runTest(self, *args, **kwargs): # real signature unknown
        pass

    def setUp(self, *args, **kwargs): # real signature unknown
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        pass

    def tearDown(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class SkipTest(Exception):
    """
    Raise this exception in a test to skip it.
    
        Usually you can use TestResult.skip() or one of the skipping decorators
        instead of raising this directly.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class TestLoader(object):
    """
    This class is responsible for loading tests according to various criteria
        and returning them wrapped in a TestSuite
    """
    def discover(self): # real signature unknown; restored from __doc__
        """
        Find and return all test modules from the specified start
                directory, recursing into subdirectories to find them. Only test files
                that match the pattern will be loaded. (Using shell style pattern
                matching.)
        
                All test modules must be importable from the top level of the project.
                If the start directory is not the top level directory then the top
                level directory must be specified separately.
        
                If a test package name (directory with '__init__.py') matches the
                pattern then the package will be checked for a 'load_tests' function. If
                this exists then it will be called with loader, tests, pattern.
        
                If load_tests exists then discovery does  *not* recurse into the package,
                load_tests is responsible for loading all tests in the package.
        
                The pattern is deliberately not stored as a loader attribute so that
                packages can continue discovery themselves. top_level_dir is stored so
                load_tests does not need to pass this argument in to loader.discover().
        """
        pass

    def getTestCaseNames(self, *args, **kwargs): # real signature unknown
        """ Return a sorted sequence of method names found within testCaseClass """
        pass

    def loadTestsFromModule(self, *args, **kwargs): # real signature unknown
        """ Return a suite of all tests cases contained in the given module """
        pass

    def loadTestsFromName(self, *args, **kwargs): # real signature unknown
        """
        Return a suite of all tests cases given a string specifier.
        
                The name may resolve either to a module, a test case class, a
                test method within a test case class, or a callable object which
                returns a TestCase or TestSuite instance.
        
                The method optionally resolves the names relative to a given module.
        """
        pass

    def loadTestsFromNames(self, *args, **kwargs): # real signature unknown
        """
        Return a suite of all tests cases found using the given sequence
                of string specifiers. See 'loadTestsFromName()'.
        """
        pass

    def loadTestsFromTestCase(self, *args, **kwargs): # real signature unknown
        """ Return a suite of all tests cases contained in testCaseClass """
        pass

    def sortTestMethodsUsing(self, *args, **kwargs): # real signature unknown
        """
        cmp(x, y) -> integer
        
        Return negative if x<y, zero if x==y, positive if x>y.
        """
        pass

    def suiteClass(self, *args, **kwargs): # real signature unknown
        """
        A test suite is a composite test consisting of a number of TestCases.
        
            For use, create an instance of TestSuite, then add test case instances.
            When all tests have been added, the suite can be passed to a test
            runner, such as TextTestRunner. It will run the individual test cases
            in the order in which they were added, aggregating the results. When
            subclassing, do not forget to call the base class constructor.
        """
        pass

    def _find_tests(self, *args, **kwargs): # real signature unknown
        """ Used by discovery. Yields test suites it loads. """
        pass

    def _get_directory_containing_module(self, *args, **kwargs): # real signature unknown
        pass

    def _get_module_from_name(self, *args, **kwargs): # real signature unknown
        pass

    def _get_name_from_path(self, *args, **kwargs): # real signature unknown
        pass

    def _match_path(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    testMethodPrefix = 'test'
    _top_level_dir = None
    __dict__ = None # (!) real value is ''


class TestResult(object):
    """
    Holder for test result information.
    
        Test results are automatically managed by the TestCase and TestSuite
        classes, and do not need to be explicitly manipulated by writers of tests.
    
        Each instance holds the total number of tests run, and collections of
        failures and errors that occurred among those test runs. The collections
        contain tuples of (testcase, exceptioninfo), where exceptioninfo is the
        formatted traceback of the error that occurred.
    """
    def addError(self, *args, **kwargs): # real signature unknown
        """
        Called when an error has occurred. 'err' is a tuple of values as
                returned by sys.exc_info().
        """
        pass

    def addExpectedFailure(self, *args, **kwargs): # real signature unknown
        """ Called when an expected failure/error occured. """
        pass

    def addFailure(self, *args, **kwargs): # real signature unknown
        """
        Called when an error has occurred. 'err' is a tuple of values as
                returned by sys.exc_info().
        """
        pass

    def addSkip(self, *args, **kwargs): # real signature unknown
        """ Called when a test is skipped. """
        pass

    def addSuccess(self, *args, **kwargs): # real signature unknown
        """ Called when a test has completed successfully """
        pass

    def addUnexpectedSuccess(self, *args, **kwargs): # real signature unknown
        """ Called when a test was expected to fail, but succeed. """
        pass

    def printErrors(self, *args, **kwargs): # real signature unknown
        """ Called by TestRunner after test run """
        pass

    def startTest(self, *args, **kwargs): # real signature unknown
        """ Called when the given test is about to be run """
        pass

    def startTestRun(self, *args, **kwargs): # real signature unknown
        """
        Called once before any tests are executed.
        
                See startTest for a method called before each test.
        """
        pass

    def stop(self, *args, **kwargs): # real signature unknown
        """ Indicates that the tests should be aborted """
        pass

    def stopTest(self, *args, **kwargs): # real signature unknown
        """ Called when the given test has been run """
        pass

    def stopTestRun(self, *args, **kwargs): # real signature unknown
        """
        Called once after all tests are executed.
        
                See stopTest for a method called after each test.
        """
        pass

    def wasSuccessful(self, *args, **kwargs): # real signature unknown
        """ Tells whether or not this result was a success """
        pass

    def _count_relevant_tb_levels(self, *args, **kwargs): # real signature unknown
        pass

    def _exc_info_to_string(self, *args, **kwargs): # real signature unknown
        """ Converts a sys.exc_info()-style tuple of values into a string. """
        pass

    def _is_relevant_tb_level(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _moduleSetUpFailed = False
    _previousTestClass = None
    _testRunEntered = False
    __dict__ = None # (!) real value is ''


class TestSuite(__unittest_suite.BaseTestSuite):
    """
    A test suite is a composite test consisting of a number of TestCases.
    
        For use, create an instance of TestSuite, then add test case instances.
        When all tests have been added, the suite can be passed to a test
        runner, such as TextTestRunner. It will run the individual test cases
        in the order in which they were added, aggregating the results. When
        subclassing, do not forget to call the base class constructor.
    """
    def debug(self, *args, **kwargs): # real signature unknown
        """ Run the tests without collecting errors in a TestResult """
        pass

    def run(self, *args, **kwargs): # real signature unknown
        pass

    def _addClassOrModuleLevelException(self, *args, **kwargs): # real signature unknown
        pass

    def _get_previous_module(self, *args, **kwargs): # real signature unknown
        pass

    def _handleClassSetUp(self, *args, **kwargs): # real signature unknown
        pass

    def _handleModuleFixture(self, *args, **kwargs): # real signature unknown
        pass

    def _handleModuleTearDown(self, *args, **kwargs): # real signature unknown
        pass

    def _tearDownPreviousClass(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class _TextTestResult(__unittest_result.TestResult):
    """
    A test result class that can print formatted text results to a stream.
    
        Used by TextTestRunner.
    """
    def addError(self, *args, **kwargs): # real signature unknown
        pass

    def addExpectedFailure(self, *args, **kwargs): # real signature unknown
        pass

    def addFailure(self, *args, **kwargs): # real signature unknown
        pass

    def addSkip(self, *args, **kwargs): # real signature unknown
        pass

    def addSuccess(self, *args, **kwargs): # real signature unknown
        pass

    def addUnexpectedSuccess(self, *args, **kwargs): # real signature unknown
        pass

    def getDescription(self, *args, **kwargs): # real signature unknown
        pass

    def printErrorList(self, *args, **kwargs): # real signature unknown
        pass

    def printErrors(self, *args, **kwargs): # real signature unknown
        pass

    def startTest(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    separator1 = '======================================================================'
    separator2 = '----------------------------------------------------------------------'


TextTestResult = _TextTestResult


class TextTestRunner(object):
    """
    A test runner class that displays results in textual form.
    
        It prints out the names of tests as they are run, errors as they
        occur, and a summary of the results at the end of the test run.
    """
    def resultclass(self, *args, **kwargs): # real signature unknown
        """
        A test result class that can print formatted text results to a stream.
        
            Used by TextTestRunner.
        """
        pass

    def run(self, *args, **kwargs): # real signature unknown
        """ Run the given test case or test suite. """
        pass

    def _makeResult(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

defaultTestLoader = None # (!) real value is ''

__all__ = [
    'TestResult',
    'TestCase',
    'TestSuite',
    'TextTestRunner',
    'TestLoader',
    'FunctionTestCase',
    'main',
    'defaultTestLoader',
    'SkipTest',
    'skip',
    'skipIf',
    'skipUnless',
    'expectedFailure',
    'TextTestResult',
    'installHandler',
    'registerResult',
    'removeResult',
    'removeHandler',
    'getTestCaseNames',
    'makeSuite',
    'findTestCases',
]

