# encoding: utf-8
# module unittest.case
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/unittest/case.pyo by generator 1.99
""" Test case implementation """

# imports
import functools as functools # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/functools.pyc
import unittest.result as result # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/unittest/result.pyc
import pprint as pprint # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/pprint.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/re.pyc
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/warnings.pyc
import sys as sys # <module 'sys' (built-in)>
import difflib as difflib # /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/difflib.pyc

# Variables with simple values

DIFF_OMITTED = '\nDiff is %s characters long. Set self.maxDiff to None to see it.'

__unittest = True

# functions

def expectedFailure(func): # reliably restored by inspect
    # no doc
    pass


def safe_repr(obj, short=False): # reliably restored by inspect
    # no doc
    pass


def skip(reason): # reliably restored by inspect
    """ Unconditionally skip a test. """
    pass


def skipIf(condition, reason): # reliably restored by inspect
    """ Skip a test if the condition is true. """
    pass


def skipUnless(condition, reason): # reliably restored by inspect
    """ Skip a test unless the condition is true. """
    pass


def sorted_list_difference(expected, actual): # reliably restored by inspect
    """
    Finds elements in only one or the other of two, sorted input lists.
    
        Returns a two-element tuple of lists.    The first list contains those
        elements in the "expected" list but not in the "actual" list, and the
        second contains those elements in the "actual" list but not in the
        "expected" list.    Duplicate elements in either input list are ignored.
    """
    pass


def strclass(cls): # reliably restored by inspect
    # no doc
    pass


def unorderable_list_difference(expected, actual, ignore_duplicate=False): # reliably restored by inspect
    """
    Same behavior as sorted_list_difference but
        for lists of unorderable items (like dicts).
    
        As it does a linear search per item (remove) it
        has O(n*n) performance.
    """
    pass


def _id(obj): # reliably restored by inspect
    # no doc
    pass


# classes

class TestCase(object):
    """
    A class whose instances are single test cases.
    
        By default, the test code itself should be placed in a method named
        'runTest'.
    
        If the fixture may be used for many test cases, create as
        many test methods as are needed. When instantiating such a TestCase
        subclass, specify in the constructor arguments the name of the test method
        that the instance is to execute.
    
        Test authors should subclass TestCase for their own tests. Construction
        and deconstruction of the test's environment ('fixture') can be
        implemented by overriding the 'setUp' and 'tearDown' methods respectively.
    
        If it is necessary to override the __init__ method, the base class
        __init__ method must always be called. It is important that subclasses
        should not change the signature of their __init__ method, since instances
        of the classes are instantiated automatically by parts of the framework
        in order to be run.
    """
    def addCleanup(self, *args, **kwargs): # real signature unknown
        """
        Add a function, with arguments, to be called when the test is
                completed. Functions added are called on a LIFO basis and are
                called after tearDown on test failure or success.
        
                Cleanup items are called even if setUp fails (unlike tearDown).
        """
        pass

    def addTypeEqualityFunc(self, *args, **kwargs): # real signature unknown
        """
        Add a type specific assertEqual style function to compare a type.
        
                This method is for use by TestCase subclasses that need to register
                their own type equality functions to provide nicer error messages.
        
                Args:
                    typeobj: The data type to call this function on when both values
                            are of the same type in assertEqual().
                    function: The callable taking two arguments and an optional
                            msg= argument that raises self.failureException with a
                            useful error message when the two arguments are not equal.
        """
        pass

    def assertAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is more than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   If the two objects compare equal then they will automatically
                   compare almost equal.
        """
        pass

    def assertAlmostEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is more than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   If the two objects compare equal then they will automatically
                   compare almost equal.
        """
        pass

    def assertDictContainsSubset(self, *args, **kwargs): # real signature unknown
        """ Checks whether actual is a superset of expected. """
        pass

    def assertDictEqual(self, *args, **kwargs): # real signature unknown
        pass

    def assertEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by the '=='
                   operator.
        """
        pass

    def assertEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by the '=='
                   operator.
        """
        pass

    def assertFalse(self, *args, **kwargs): # real signature unknown
        """ Fail the test if the expression is true. """
        pass

    def assertGreater(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a > b), but with a nicer default message. """
        pass

    def assertGreaterEqual(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a >= b), but with a nicer default message. """
        pass

    def assertIn(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a in b), but with a nicer default message. """
        pass

    def assertIs(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a is b), but with a nicer default message. """
        pass

    def assertIsInstance(self, *args, **kwargs): # real signature unknown
        """
        Same as self.assertTrue(isinstance(obj, cls)), with a nicer
                default message.
        """
        pass

    def assertIsNone(self, *args, **kwargs): # real signature unknown
        """ Same as self.assertTrue(obj is None), with a nicer default message. """
        pass

    def assertIsNot(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a is not b), but with a nicer default message. """
        pass

    def assertIsNotNone(self, *args, **kwargs): # real signature unknown
        """ Included for symmetry with assertIsNone. """
        pass

    def assertItemsEqual(self, *args, **kwargs): # real signature unknown
        """
        An unordered sequence / set specific comparison. It asserts that
                expected_seq and actual_seq contain the same elements. It is
                the equivalent of::
        
                    self.assertEqual(sorted(expected_seq), sorted(actual_seq))
        
                Raises with an error message listing which elements of expected_seq
                are missing from actual_seq and vice versa if any.
        
                Asserts that each element has the same count in both sequences.
                Example:
                    - [0, 1, 1] and [1, 0, 1] compare equal.
                    - [0, 0, 1] and [0, 1] compare unequal.
        """
        pass

    def assertLess(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a < b), but with a nicer default message. """
        pass

    def assertLessEqual(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a <= b), but with a nicer default message. """
        pass

    def assertListEqual(self, *args, **kwargs): # real signature unknown
        """
        A list-specific equality assertion.
        
                Args:
                    list1: The first list to compare.
                    list2: The second list to compare.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        """
        pass

    def assertMultiLineEqual(self, *args, **kwargs): # real signature unknown
        """ Assert that two multi-line strings are equal. """
        pass

    def assertNotAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is less than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   Objects that are equal automatically fail.
        """
        pass

    def assertNotAlmostEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero, or by comparing that the
                   between the two objects is less than the given delta.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        
                   Objects that are equal automatically fail.
        """
        pass

    def assertNotEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by the '=='
                   operator.
        """
        pass

    def assertNotEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by the '=='
                   operator.
        """
        pass

    def assertNotIn(self, *args, **kwargs): # real signature unknown
        """ Just like self.assertTrue(a not in b), but with a nicer default message. """
        pass

    def assertNotIsInstance(self, *args, **kwargs): # real signature unknown
        """ Included for symmetry with assertIsInstance. """
        pass

    def assertNotRegexpMatches(self, *args, **kwargs): # real signature unknown
        """ Fail the test if the text matches the regular expression. """
        pass

    def assertRaises(self, SomeException): # real signature unknown; restored from __doc__
        """
        Fail unless an exception of class excClass is thrown
                   by callableObj when invoked with arguments args and keyword
                   arguments kwargs. If a different type of exception is
                   thrown, it will not be caught, and the test case will be
                   deemed to have suffered an error, exactly as for an
                   unexpected exception.
        
                   If called with callableObj omitted or None, will return a
                   context object used like this::
        
                        with self.assertRaises(SomeException):
                            do_something()
        
                   The context manager keeps a reference to the exception as
                   the 'exception' attribute. This allows you to inspect the
                   exception after the assertion::
        
                       with self.assertRaises(SomeException) as cm:
                           do_something()
                       the_exception = cm.exception
                       self.assertEqual(the_exception.error_code, 3)
        """
        pass

    def assertRaisesRegexp(self, *args, **kwargs): # real signature unknown
        """
        Asserts that the message in a raised exception matches a regexp.
        
                Args:
                    expected_exception: Exception class expected to be raised.
                    expected_regexp: Regexp (re pattern object or string) expected
                            to be found in error message.
                    callable_obj: Function to be called.
                    args: Extra args.
                    kwargs: Extra kwargs.
        """
        pass

    def assertRegexpMatches(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the text matches the regular expression. """
        pass

    def assertSequenceEqual(self, *args, **kwargs): # real signature unknown
        """
        An equality assertion for ordered sequences (like lists and tuples).
        
                For the purposes of this function, a valid ordered sequence type is one
                which can be indexed, has a length, and has an equality operator.
        
                Args:
                    seq1: The first sequence to compare.
                    seq2: The second sequence to compare.
                    seq_type: The expected datatype of the sequences, or None if no
                            datatype should be enforced.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        """
        pass

    def assertSetEqual(self, *args, **kwargs): # real signature unknown
        """
        A set-specific equality assertion.
        
                Args:
                    set1: The first set to compare.
                    set2: The second set to compare.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        
                assertSetEqual uses ducktyping to support different types of sets, and
                is optimized for sets specifically (parameters must support a
                difference method).
        """
        pass

    def assertTrue(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the expression is true. """
        pass

    def assertTupleEqual(self, *args, **kwargs): # real signature unknown
        """
        A tuple-specific equality assertion.
        
                Args:
                    tuple1: The first tuple to compare.
                    tuple2: The second tuple to compare.
                    msg: Optional message to use on failure instead of a list of
                            differences.
        """
        pass

    def assert_(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the expression is true. """
        pass

    def countTestCases(self, *args, **kwargs): # real signature unknown
        pass

    def debug(self, *args, **kwargs): # real signature unknown
        """ Run the test without collecting errors in a TestResult """
        pass

    def defaultTestResult(self, *args, **kwargs): # real signature unknown
        pass

    def doCleanups(self, *args, **kwargs): # real signature unknown
        """
        Execute all cleanup functions. Normally called for you after
                tearDown.
        """
        pass

    def fail(self, *args, **kwargs): # real signature unknown
        """ Fail immediately, with the given message. """
        pass

    def failIf(self, *args, **kwargs): # real signature unknown
        pass

    def failIfAlmostEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failIfEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failUnless(self, *args, **kwargs): # real signature unknown
        pass

    def failUnlessAlmostEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failUnlessEqual(self, *args, **kwargs): # real signature unknown
        pass

    def failUnlessRaises(self, *args, **kwargs): # real signature unknown
        pass

    def failureException(self, *args, **kwargs): # real signature unknown
        """ Assertion failed. """
        pass

    def id(self, *args, **kwargs): # real signature unknown
        pass

    def run(self, *args, **kwargs): # real signature unknown
        pass

    def setUp(self, *args, **kwargs): # real signature unknown
        """ Hook method for setting up the test fixture before exercising it. """
        pass

    @classmethod
    def setUpClass(cls, *args, **kwargs): # real signature unknown
        """ Hook method for setting up class fixture before running tests in the class. """
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        """
        Returns a one-line description of the test, or None if no
                description has been provided.
        
                The default implementation of this method returns the first line of
                the specified test method's docstring.
        """
        pass

    def skipTest(self, *args, **kwargs): # real signature unknown
        """ Skip this test. """
        pass

    def tearDown(self, *args, **kwargs): # real signature unknown
        """ Hook method for deconstructing the test fixture after testing it. """
        pass

    @classmethod
    def tearDownClass(cls, *args, **kwargs): # real signature unknown
        """ Hook method for deconstructing the class fixture after running all tests in the class. """
        pass

    def _addSkip(self, *args, **kwargs): # real signature unknown
        pass

    def _baseAssertEqual(self, *args, **kwargs): # real signature unknown
        """ The default assertEqual implementation, not type specific. """
        pass

    def _deprecate(self, *args, **kwargs): # real signature unknown
        pass

    def _formatMessage(self, *args, **kwargs): # real signature unknown
        """
        Honour the longMessage attribute when generating failure messages.
                If longMessage is False this means:
                * Use only an explicit message if it is provided
                * Otherwise use the standard message for the assert
        
                If longMessage is True:
                * Use the standard message
                * If an explicit message is provided, plus ' : ' and the explicit message
        """
        pass

    def _getAssertEqualityFunc(self, *args, **kwargs): # real signature unknown
        """
        Get a detailed comparison function for the types of the two args.
        
                Returns: A callable accepting (first, second, msg=None) that will
                raise a failure exception if first != second with a useful human
                readable error message for those types.
        """
        pass

    def _truncateMessage(self, *args, **kwargs): # real signature unknown
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Create an instance of the class that will use the named test
                   method when executed. Raises a ValueError if the instance does
                   not have a method with the specified name.
        """
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    longMessage = False
    maxDiff = 640
    _classSetupFailed = False
    __dict__ = None # (!) real value is ''


class FunctionTestCase(TestCase):
    """
    A test case that wraps a test function.
    
        This is useful for slipping pre-existing test functions into the
        unittest framework. Optionally, set-up and tidy-up functions can be
        supplied. As with TestCase, the tidy-up ('tearDown') function will
        always be called if the set-up ('setUp') function ran successfully.
    """
    def id(self, *args, **kwargs): # real signature unknown
        pass

    def runTest(self, *args, **kwargs): # real signature unknown
        pass

    def setUp(self, *args, **kwargs): # real signature unknown
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        pass

    def tearDown(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class SkipTest(Exception):
    """
    Raise this exception in a test to skip it.
    
        Usually you can use TestResult.skip() or one of the skipping decorators
        instead of raising this directly.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class _AssertRaisesContext(object):
    """ A context manager used to implement TestCase.assertRaises* methods. """
    def __enter__(self, *args, **kwargs): # real signature unknown
        pass

    def __exit__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _ExpectedFailure(Exception):
    """
    Raise this when a test is expected to fail.
    
        This is an implementation detail.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class _UnexpectedSuccess(Exception):
    """ The test was supposed to fail, but it didn't! """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


