# encoding: utf-8
# module urlparse
# from /System/Library/Frameworks/Python.framework/Versions/2.7/lib/python2.7/urlparse.pyo by generator 1.99
"""
Parse (absolute and relative) URLs.

urlparse module is based upon the following RFC specifications.

RFC 3986 (STD66): "Uniform Resource Identifiers" by T. Berners-Lee, R. Fielding
and L.  Masinter, January 2005.

RFC 2732 : "Format for Literal IPv6 Addresses in URL's by R.Hinden, B.Carpenter
and L.Masinter, December 1999.

RFC 2396:  "Uniform Resource Identifiers (URI)": Generic Syntax by T.
Berners-Lee, R. Fielding, and L. Masinter, August 1998.

RFC 2368: "The mailto URL scheme", by P.Hoffman , L Masinter, J. Zwinski, July 1998.

RFC 1808: "Relative Uniform Resource Locators", by R. Fielding, UC Irvine, June
1995.

RFC 1738: "Uniform Resource Locators (URL)" by T. Berners-Lee, L. Masinter, M.
McCahill, December 1994

RFC 3986 is considered the current standard and any future changes to
urlparse module should conform with it.  The urlparse module is
currently not entirely compliant with this RFC due to defacto
scenarios for parsing, and for backward compatibility purposes, some
parsing quirks from older RFCs are retained. The testcases in
test_urlparse.py provides a good indicator of parsing behavior.
"""
# no imports

# Variables with simple values

MAX_CACHE_SIZE = 20

scheme_chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.'

_hexdig = '0123456789ABCDEFabcdef'

# functions

def clear_cache(): # reliably restored by inspect
    """ Clear the parse cache. """
    pass


def namedtuple(typename, field_names, verbose=False, rename=False): # reliably restored by inspect
    """
    Returns a new subclass of tuple with named fields.
    
        >>> Point = namedtuple('Point', 'x y')
        >>> Point.__doc__                   # docstring for the new class
        'Point(x, y)'
        >>> p = Point(11, y=22)             # instantiate with positional args or keywords
        >>> p[0] + p[1]                     # indexable like a plain tuple
        33
        >>> x, y = p                        # unpack like a regular tuple
        >>> x, y
        (11, 22)
        >>> p.x + p.y                       # fields also accessable by name
        33
        >>> d = p._asdict()                 # convert to a dictionary
        >>> d['x']
        11
        >>> Point(**d)                      # convert from a dictionary
        Point(x=11, y=22)
        >>> p._replace(x=100)               # _replace() is like str.replace() but targets named fields
        Point(x=100, y=22)
    """
    pass


def parse_qs(qs, keep_blank_values=0, strict_parsing=0): # reliably restored by inspect
    """
    Parse a query given as a string argument.
    
            Arguments:
    
            qs: percent-encoded query string to be parsed
    
            keep_blank_values: flag indicating whether blank values in
                percent-encoded queries should be treated as blank strings.
                A true value indicates that blanks should be retained as
                blank strings.  The default false value indicates that
                blank values are to be ignored and treated as if they were
                not included.
    
            strict_parsing: flag indicating what to do with parsing errors.
                If false (the default), errors are silently ignored.
                If true, errors raise a ValueError exception.
    """
    pass


def parse_qsl(qs, keep_blank_values=0, strict_parsing=0): # reliably restored by inspect
    """
    Parse a query given as a string argument.
    
        Arguments:
    
        qs: percent-encoded query string to be parsed
    
        keep_blank_values: flag indicating whether blank values in
            percent-encoded queries should be treated as blank strings.  A
            true value indicates that blanks should be retained as blank
            strings.  The default false value indicates that blank values
            are to be ignored and treated as if they were  not included.
    
        strict_parsing: flag indicating what to do with parsing errors. If
            false (the default), errors are silently ignored. If true,
            errors raise a ValueError exception.
    
        Returns a list, as G-d intended.
    """
    pass


def unquote(s): # reliably restored by inspect
    """ unquote('abc%20def') -> 'abc def'. """
    pass


def urldefrag(url): # reliably restored by inspect
    """
    Removes any existing fragment from URL.
    
        Returns a tuple of the defragmented URL and the fragment.  If
        the URL contained no fragments, the second element is the
        empty string.
    """
    pass


def urljoin(base, url, allow_fragments=True): # reliably restored by inspect
    """
    Join a base URL and a possibly relative URL to form an absolute
        interpretation of the latter.
    """
    pass


def urlparse(url, scheme=None, allow_fragments=True): # reliably restored by inspect
    """
    Parse a URL into 6 components:
        <scheme>://<netloc>/<path>;<params>?<query>#<fragment>
        Return a 6-tuple: (scheme, netloc, path, params, query, fragment).
        Note that we don't break the components up in smaller bits
        (e.g. netloc is a single string) and we don't expand % escapes.
    """
    pass


def urlsplit(url, scheme=None, allow_fragments=True): # reliably restored by inspect
    """
    Parse a URL into 5 components:
        <scheme>://<netloc>/<path>?<query>#<fragment>
        Return a 5-tuple: (scheme, netloc, path, query, fragment).
        Note that we don't break the components up in smaller bits
        (e.g. netloc is a single string) and we don't expand % escapes.
    """
    pass


def urlunparse(data): # reliably restored by inspect
    """
    Put a parsed URL back together again.  This may result in a
        slightly different, but equivalent URL, if the URL that was parsed
        originally had redundant delimiters, e.g. a ? with an empty query
        (the draft states that these are equivalent).
    """
    pass


def urlunsplit(data): # reliably restored by inspect
    """
    Combine the elements of a tuple as returned by urlsplit() into a
        complete URL as a string. The data argument can be any five-item iterable.
        This may result in a slightly different, but equivalent URL, if the URL that
        was parsed originally had unnecessary delimiters (for example, a ? with an
        empty query; the RFC states that these are equivalent).
    """
    pass


def _splitnetloc(url, start=0): # reliably restored by inspect
    # no doc
    pass


def _splitparams(url): # reliably restored by inspect
    # no doc
    pass


# classes

class ResultMixin(object):
    """ Shared methods for the parsed result objects. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    hostname = property(lambda self: object()) # default
    password = property(lambda self: object()) # default
    port = property(lambda self: object()) # default
    username = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class ParseResult(ParseResult, ResultMixin):
    # no doc
    def geturl(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __dict__ = None # (!) real value is ''
    __slots__ = ()


class SplitResult(SplitResult, ResultMixin):
    # no doc
    def geturl(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __dict__ = None # (!) real value is ''
    __slots__ = ()


# variables with complex values

non_hierarchical = [
    'gopher',
    'hdl',
    'mailto',
    'news',
    'telnet',
    'wais',
    'imap',
    'snews',
    'sip',
    'sips',
]

uses_fragment = [
    'ftp',
    'hdl',
    'http',
    'gopher',
    'news',
    'nntp',
    'wais',
    'https',
    'shttp',
    'snews',
    'file',
    'prospero',
    '',
]

uses_netloc = [
    'ftp',
    'http',
    'gopher',
    'nntp',
    'telnet',
    'imap',
    'wais',
    'file',
    'mms',
    'https',
    'shttp',
    'snews',
    'prospero',
    'rtsp',
    'rtspu',
    'rsync',
    '',
    'svn',
    'svn+ssh',
    'sftp',
    'nfs',
    'git',
    'git+ssh',
]

uses_params = [
    'ftp',
    'hdl',
    'prospero',
    'http',
    'imap',
    'https',
    'shttp',
    'rtsp',
    'rtspu',
    'sip',
    'sips',
    'mms',
    '',
    'sftp',
]

uses_query = [
    'http',
    'wais',
    'imap',
    'https',
    'shttp',
    'mms',
    'gopher',
    'rtsp',
    'rtspu',
    'sip',
    'sips',
    '',
]

uses_relative = [
    'ftp',
    'http',
    'gopher',
    'nntp',
    'imap',
    'wais',
    'file',
    'https',
    'shttp',
    'mms',
    'prospero',
    'rtsp',
    'rtspu',
    '',
    'sftp',
]

_hextochr = {
    '00': '\x00',
    '01': '\x01',
    '02': '\x02',
    '03': '\x03',
    '04': '\x04',
    '05': '\x05',
    '06': '\x06',
    '07': '\x07',
    '08': '\x08',
    '09': '\t',
    '0A': '\n',
    '0B': '\x0b',
    '0C': '\x0c',
    '0D': '\r',
    '0E': '\x0e',
    '0F': '\x0f',
    '0a': '\n',
    '0b': '\x0b',
    '0c': '\x0c',
    '0d': '\r',
    '0e': '\x0e',
    '0f': '\x0f',
    '10': '\x10',
    '11': '\x11',
    '12': '\x12',
    '13': '\x13',
    '14': '\x14',
    '15': '\x15',
    '16': '\x16',
    '17': '\x17',
    '18': '\x18',
    '19': '\x19',
    '1A': '\x1a',
    '1B': '\x1b',
    '1C': '\x1c',
    '1D': '\x1d',
    '1E': '\x1e',
    '1F': '\x1f',
    '1a': '\x1a',
    '1b': '\x1b',
    '1c': '\x1c',
    '1d': '\x1d',
    '1e': '\x1e',
    '1f': '\x1f',
    '20': ' ',
    '21': '!',
    '22': '"',
    '23': '#',
    '24': '$',
    '25': '%',
    '26': '&',
    '27': "'",
    '28': '(',
    '29': ')',
    '2A': '*',
    '2B': '+',
    '2C': ',',
    '2D': '-',
    '2E': '.',
    '2F': '/',
    '2a': '*',
    '2b': '+',
    '2c': ',',
    '2d': '-',
    '2e': '.',
    '2f': '/',
    '30': '0',
    '31': '1',
    '32': '2',
    '33': '3',
    '34': '4',
    '35': '5',
    '36': '6',
    '37': '7',
    '38': '8',
    '39': '9',
    '3A': ':',
    '3B': ';',
    '3C': '<',
    '3D': '=',
    '3E': '>',
    '3F': '?',
    '3a': ':',
    '3b': ';',
    '3c': '<',
    '3d': '=',
    '3e': '>',
    '3f': '?',
    '40': '@',
    '41': 'A',
    '42': 'B',
    '43': 'C',
    '44': 'D',
    '45': 'E',
    '46': 'F',
    '47': 'G',
    '48': 'H',
    '49': 'I',
    '4A': 'J',
    '4B': 'K',
    '4C': 'L',
    '4D': 'M',
    '4E': 'N',
    '4F': 'O',
    '4a': 'J',
    '4b': 'K',
    '4c': 'L',
    '4d': 'M',
    '4e': 'N',
    '4f': 'O',
    '50': 'P',
    '51': 'Q',
    '52': 'R',
    '53': 'S',
    '54': 'T',
    '55': 'U',
    '56': 'V',
    '57': 'W',
    '58': 'X',
    '59': 'Y',
    '5A': 'Z',
    '5B': '[',
    '5C': '\\',
    '5D': ']',
    '5E': '^',
    '5F': '_',
    '5a': 'Z',
    '5b': '[',
    '5c': '\\',
    '5d': ']',
    '5e': '^',
    '5f': '_',
    '60': '`',
    '61': 'a',
    '62': 'b',
    '63': 'c',
    '64': 'd',
    '65': 'e',
    '66': 'f',
    '67': 'g',
    '68': 'h',
    '69': 'i',
    '6A': 'j',
    '6B': 'k',
    '6C': 'l',
    '6D': 'm',
    '6E': 'n',
    '6F': 'o',
    '6a': 'j',
    '6b': 'k',
    '6c': 'l',
    '6d': 'm',
    '6e': 'n',
    '6f': 'o',
    '70': 'p',
    '71': 'q',
    '72': 'r',
    '73': 's',
    '74': 't',
    '75': 'u',
    '76': 'v',
    '77': 'w',
    '78': 'x',
    '79': 'y',
    '7A': 'z',
    '7B': '{',
    '7C': '|',
    '7D': '}',
    '7E': '~',
    '7F': '\x7f',
    '7a': 'z',
    '7b': '{',
    '7c': '|',
    '7d': '}',
    '7e': '~',
    '7f': '\x7f',
    '80': '\x80',
    '81': '\x81',
    '82': '\x82',
    '83': '\x83',
    '84': '\x84',
    '85': '\x85',
    '86': '\x86',
    '87': '\x87',
    '88': '\x88',
    '89': '\x89',
    '8A': '\x8a',
    '8B': '\x8b',
    '8C': '\x8c',
    '8D': '\x8d',
    '8E': '\x8e',
    '8F': '\x8f',
    '8a': '\x8a',
    '8b': '\x8b',
    '8c': '\x8c',
    '8d': '\x8d',
    '8e': '\x8e',
    '8f': '\x8f',
    '90': '\x90',
    '91': '\x91',
    '92': '\x92',
    '93': '\x93',
    '94': '\x94',
    '95': '\x95',
    '96': '\x96',
    '97': '\x97',
    '98': '\x98',
    '99': '\x99',
    '9A': '\x9a',
    '9B': '\x9b',
    '9C': '\x9c',
    '9D': '\x9d',
    '9E': '\x9e',
    '9F': '\x9f',
    '9a': '\x9a',
    '9b': '\x9b',
    '9c': '\x9c',
    '9d': '\x9d',
    '9e': '\x9e',
    '9f': '\x9f',
    'A0': '\xa0',
    'A1': '\xa1',
    'A2': '\xa2',
    'A3': '\xa3',
    'A4': '\xa4',
    'A5': '\xa5',
    'A6': '\xa6',
    'A7': '\xa7',
    'A8': '\xa8',
    'A9': '\xa9',
    'AA': '\xaa',
    'AB': '\xab',
    'AC': '\xac',
    'AD': '\xad',
    'AE': '\xae',
    'AF': '\xaf',
    'Aa': '\xaa',
    'Ab': '\xab',
    'Ac': '\xac',
    'Ad': '\xad',
    'Ae': '\xae',
    'Af': '\xaf',
    'B0': '\xb0',
    'B1': '\xb1',
    'B2': '\xb2',
    'B3': '\xb3',
    'B4': '\xb4',
    'B5': '\xb5',
    'B6': '\xb6',
    'B7': '\xb7',
    'B8': '\xb8',
    'B9': '\xb9',
    'BA': '\xba',
    'BB': '\xbb',
    'BC': '\xbc',
    'BD': '\xbd',
    'BE': '\xbe',
    'BF': '\xbf',
    'Ba': '\xba',
    'Bb': '\xbb',
    'Bc': '\xbc',
    'Bd': '\xbd',
    'Be': '\xbe',
    'Bf': '\xbf',
    'C0': '\xc0',
    'C1': '\xc1',
    'C2': '\xc2',
    'C3': '\xc3',
    'C4': '\xc4',
    'C5': '\xc5',
    'C6': '\xc6',
    'C7': '\xc7',
    'C8': '\xc8',
    'C9': '\xc9',
    'CA': '\xca',
    'CB': '\xcb',
    'CC': '\xcc',
    'CD': '\xcd',
    'CE': '\xce',
    'CF': '\xcf',
    'Ca': '\xca',
    'Cb': '\xcb',
    'Cc': '\xcc',
    'Cd': '\xcd',
    'Ce': '\xce',
    'Cf': '\xcf',
    'D0': '\xd0',
    'D1': '\xd1',
    'D2': '\xd2',
    'D3': '\xd3',
    'D4': '\xd4',
    'D5': '\xd5',
    'D6': '\xd6',
    'D7': '\xd7',
    'D8': '\xd8',
    'D9': '\xd9',
    'DA': '\xda',
    'DB': '\xdb',
    'DC': '\xdc',
    'DD': '\xdd',
    'DE': '\xde',
    'DF': '\xdf',
    'Da': '\xda',
    'Db': '\xdb',
    'Dc': '\xdc',
    'Dd': '\xdd',
    'De': '\xde',
    'Df': '\xdf',
    'E0': '\xe0',
    'E1': '\xe1',
    'E2': '\xe2',
    'E3': '\xe3',
    'E4': '\xe4',
    'E5': '\xe5',
    'E6': '\xe6',
    'E7': '\xe7',
    'E8': '\xe8',
    'E9': '\xe9',
    'EA': '\xea',
    'EB': '\xeb',
    'EC': '\xec',
    'ED': '\xed',
    'EE': '\xee',
    'EF': '\xef',
    'Ea': '\xea',
    'Eb': '\xeb',
    'Ec': '\xec',
    'Ed': '\xed',
    'Ee': '\xee',
    'Ef': '\xef',
    'F0': '\xf0',
    'F1': '\xf1',
    'F2': '\xf2',
    'F3': '\xf3',
    'F4': '\xf4',
    'F5': '\xf5',
    'F6': '\xf6',
    'F7': '\xf7',
    'F8': '\xf8',
    'F9': '\xf9',
    'FA': '\xfa',
    'FB': '\xfb',
    'FC': '\xfc',
    'FD': '\xfd',
    'FE': '\xfe',
    'FF': '\xff',
    'Fa': '\xfa',
    'Fb': '\xfb',
    'Fc': '\xfc',
    'Fd': '\xfd',
    'Fe': '\xfe',
    'Ff': '\xff',
    'a0': '\xa0',
    'a1': '\xa1',
    'a2': '\xa2',
    'a3': '\xa3',
    'a4': '\xa4',
    'a5': '\xa5',
    'a6': '\xa6',
    'a7': '\xa7',
    'a8': '\xa8',
    'a9': '\xa9',
    'aA': '\xaa',
    'aB': '\xab',
    'aC': '\xac',
    'aD': '\xad',
    'aE': '\xae',
    'aF': '\xaf',
    'aa': '\xaa',
    'ab': '\xab',
    'ac': '\xac',
    'ad': '\xad',
    'ae': '\xae',
    'af': '\xaf',
    'b0': '\xb0',
    'b1': '\xb1',
    'b2': '\xb2',
    'b3': '\xb3',
    'b4': '\xb4',
    'b5': '\xb5',
    'b6': '\xb6',
    'b7': '\xb7',
    'b8': '\xb8',
    'b9': '\xb9',
    'bA': '\xba',
    'bB': '\xbb',
    'bC': '\xbc',
    'bD': '\xbd',
    'bE': '\xbe',
    'bF': '\xbf',
    'ba': '\xba',
    'bb': '\xbb',
    'bc': '\xbc',
    'bd': '\xbd',
    'be': '\xbe',
    'bf': '\xbf',
    'c0': '\xc0',
    'c1': '\xc1',
    'c2': '\xc2',
    'c3': '\xc3',
    'c4': '\xc4',
    'c5': '\xc5',
    'c6': '\xc6',
    'c7': '\xc7',
    'c8': '\xc8',
    'c9': '\xc9',
    'cA': '\xca',
    'cB': '\xcb',
    'cC': '\xcc',
    'cD': '\xcd',
    'cE': '\xce',
    'cF': '\xcf',
    'ca': '\xca',
    'cb': '\xcb',
    'cc': '\xcc',
    'cd': '\xcd',
    'ce': '\xce',
    'cf': '\xcf',
    'd0': '\xd0',
    'd1': '\xd1',
    'd2': '\xd2',
    'd3': '\xd3',
    'd4': '\xd4',
    'd5': '\xd5',
    'd6': '\xd6',
    'd7': '\xd7',
    'd8': '\xd8',
    'd9': '\xd9',
    'dA': '\xda',
    'dB': '\xdb',
    'dC': '\xdc',
    'dD': '\xdd',
    'dE': '\xde',
    'dF': '\xdf',
    'da': '\xda',
    'db': '\xdb',
    'dc': '\xdc',
    'dd': '\xdd',
    'de': '\xde',
    'df': '\xdf',
    'e0': '\xe0',
    'e1': '\xe1',
    'e2': '\xe2',
    'e3': '\xe3',
    'e4': '\xe4',
    'e5': '\xe5',
    'e6': '\xe6',
    'e7': '\xe7',
    'e8': '\xe8',
    'e9': '\xe9',
    'eA': '\xea',
    'eB': '\xeb',
    'eC': '\xec',
    'eD': '\xed',
    'eE': '\xee',
    'eF': '\xef',
    'ea': '\xea',
    'eb': '\xeb',
    'ec': '\xec',
    'ed': '\xed',
    'ee': '\xee',
    'ef': '\xef',
    'f0': '\xf0',
    'f1': '\xf1',
    'f2': '\xf2',
    'f3': '\xf3',
    'f4': '\xf4',
    'f5': '\xf5',
    'f6': '\xf6',
    'f7': '\xf7',
    'f8': '\xf8',
    'f9': '\xf9',
    'fA': '\xfa',
    'fB': '\xfb',
    'fC': '\xfc',
    'fD': '\xfd',
    'fE': '\xfe',
    'fF': '\xff',
    'fa': '\xfa',
    'fb': '\xfb',
    'fc': '\xfc',
    'fd': '\xfd',
    'fe': '\xfe',
    'ff': '\xff',
}

_parse_cache = {}

__all__ = [
    'urlparse',
    'urlunparse',
    'urljoin',
    'urldefrag',
    'urlsplit',
    'urlunsplit',
    'parse_qs',
    'parse_qsl',
]

