# encoding: utf-8
# module _pickle
# from (built-in) by generator 1.99
""" Optimized C implementation for the Python pickle module. """
# no imports

# functions

def dump(obj, file, protocol=None, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
    """
    dump(obj, file, protocol=None, *, fix_imports=True) -> None
    
    Write a pickled representation of obj to the open file object file.  This
    is equivalent to ``Pickler(file, protocol).dump(obj)``, but may be more
    efficient.
    
    The optional protocol argument tells the pickler to use the given protocol;
    supported protocols are 0, 1, 2, 3.  The default protocol is 3; a
    backward-incompatible protocol designed for Python 3.0.
    
    Specifying a negative protocol version selects the highest protocol version
    supported.  The higher the protocol used, the more recent the version of
    Python needed to read the pickle produced.
    
    The file argument must have a write() method that accepts a single bytes
    argument.  It can thus be a file object opened for binary writing, a
    io.BytesIO instance, or any other custom object that meets this interface.
    
    If fix_imports is True and protocol is less than 3, pickle will try to
    map the new Python 3.x names to the old module names used in Python 2.x,
    so that the pickle data stream is readable with Python 2.x.
    """
    pass


def dumps(obj, protocol=None, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
    """
    dumps(obj, protocol=None, *, fix_imports=True) -> bytes
    
    Return the pickled representation of the object as a bytes
    object, instead of writing it to a file.
    
    The optional protocol argument tells the pickler to use the given protocol;
    supported protocols are 0, 1, 2, 3.  The default protocol is 3; a
    backward-incompatible protocol designed for Python 3.0.
    
    Specifying a negative protocol version selects the highest protocol version
    supported.  The higher the protocol used, the more recent the version of
    Python needed to read the pickle produced.
    
    If fix_imports is True and *protocol* is less than 3, pickle will try to
    map the new Python 3.x names to the old module names used in Python 2.x,
    so that the pickle data stream is readable with Python 2.x.
    """
    pass


def load(file, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
    """
    load(file, *, fix_imports=True, encoding='ASCII', errors='strict') -> object
    
    Read a pickled object representation from the open file object file and
    return the reconstituted object hierarchy specified therein.  This is
    equivalent to ``Unpickler(file).load()``, but may be more efficient.
    
    The protocol version of the pickle is detected automatically, so no protocol
    argument is needed.  Bytes past the pickled object's representation are
    ignored.
    
    The argument file must have two methods, a read() method that takes an
    integer argument, and a readline() method that requires no arguments.  Both
    methods should return bytes.  Thus *file* can be a binary file object opened
    for reading, a BytesIO object, or any other custom object that meets this
    interface.
    
    Optional keyword arguments are fix_imports, encoding and errors,
    which are used to control compatiblity support for pickle stream generated
    by Python 2.x.  If fix_imports is True, pickle will try to map the old
    Python 2.x names to the new names used in Python 3.x.  The encoding and
    errors tell pickle how to decode 8-bit string instances pickled by Python
    2.x; these default to 'ASCII' and 'strict', respectively.
    """
    pass


def loads(input, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
    """
    loads(input, *, fix_imports=True, encoding='ASCII', errors='strict') -> object
    
    Read a pickled object hierarchy from a bytes object and return the
    reconstituted object hierarchy specified therein
    
    The protocol version of the pickle is detected automatically, so no protocol
    argument is needed.  Bytes past the pickled object's representation are
    ignored.
    
    Optional keyword arguments are fix_imports, encoding and errors, which
    are used to control compatiblity support for pickle stream generated
    by Python 2.x.  If fix_imports is True, pickle will try to map the old
    Python 2.x names to the new names used in Python 3.x.  The encoding and
    errors tell pickle how to decode 8-bit string instances pickled by Python
    2.x; these default to 'ASCII' and 'strict', respectively.
    """
    pass


# classes

class PickleError(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class Pickler(object):
    """
    Pickler(file, protocol=None)
    This takes a binary file for writing a pickle data stream.
    
    The optional protocol argument tells the pickler to use the
    given protocol; supported protocols are 0, 1, 2, 3.  The default
    protocol is 3; a backward-incompatible protocol designed for
    Python 3.0.
    
    Specifying a negative protocol version selects the highest
    protocol version supported.  The higher the protocol used, the
    more recent the version of Python needed to read the pickle
    produced.
    
    The file argument must have a write() method that accepts a single
    bytes argument. It can thus be a file object opened for binary
    writing, a io.BytesIO instance, or any other custom object that
    meets this interface.
    
    If fix_imports is True and protocol is less than 3, pickle will try to
    map the new Python 3.x names to the old module names used in Python
    2.x, so that the pickle data stream is readable with Python 2.x.
    """
    def clear_memo(self): # real signature unknown; restored from __doc__
        """
        clear_memo() -> None. Clears the pickler's "memo".
        The memo is the data structure that remembers which objects the
        pickler has already seen, so that shared or recursive objects are
        pickled by reference and not by value.  This method is useful when
        re-using picklers.
        """
        pass

    def dump(self, obj): # real signature unknown; restored from __doc__
        """ dump(obj) -> None. Write a pickled representation of obj to the open file. """
        pass

    def __init__(self, file, protocol=None): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    bin = property(lambda self: object()) # default
    fast = property(lambda self: object()) # default
    memo = property(lambda self: object()) # default
    persistent_id = property(lambda self: object()) # default


class PicklingError(PickleError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class Unpickler(object):
    """
    Unpickler(file, *, encoding='ASCII', errors='strict')
    This takes a binary file for reading a pickle data stream.
    
    The protocol version of the pickle is detected automatically, so no
    proto argument is needed.
    
    The file-like object must have two methods, a read() method
    that takes an integer argument, and a readline() method that
    requires no arguments.  Both methods should return bytes.
    Thus file-like object can be a binary file object opened for
    reading, a BytesIO object, or any other custom object that
    meets this interface.
    
    Optional keyword arguments are *fix_imports*, *encoding* and *errors*,
    which are used to control compatiblity support for pickle stream
    generated by Python 2.x.  If *fix_imports* is True, pickle will try to
    map the old Python 2.x names to the new names used in Python 3.x.  The
    *encoding* and *errors* tell pickle how to decode 8-bit string
    instances pickled by Python 2.x; these default to 'ASCII' and
    'strict', respectively.
    """
    def find_class(self, module_name, global_name): # real signature unknown; restored from __doc__
        """
        find_class(module_name, global_name) -> object.
        
        Return an object from a specified module, importing the module if
        necessary.  Subclasses may override this method (e.g. to restrict
        unpickling of arbitrary classes and functions).
        
        This method is called whenever a class or a function object is
        needed.  Both arguments passed are str objects.
        """
        pass

    def load(self): # real signature unknown; restored from __doc__
        """
        load() -> object. Load a pickle.
        Read a pickled object representation from the open file object given in
        the constructor, and return the reconstituted object hierarchy specified
        therein.
        """
        pass

    def __init__(self, file, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    memo = property(lambda self: object()) # default
    persistent_load = property(lambda self: object()) # default


class UnpicklingError(PickleError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


