# encoding: utf-8
# module _struct
# from C:\Python32\DLLs\_ssl.pyd by generator 1.99
"""
Functions to convert between Python values and C structs.
Python bytes objects are used to hold the data representing the C struct
and also as format strings (explained below) to describe the layout of data
in the C struct.

The optional first format char indicates byte order, size and alignment:
  @: native order, size & alignment (default)
  =: native order, std. size & alignment
  <: little-endian, std. size & alignment
  >: big-endian, std. size & alignment
  !: same as >

The remaining chars indicate types of args and must match exactly;
these can be preceded by a decimal repeat count:
  x: pad byte (no data); c:char; b:signed byte; B:unsigned byte;
  ?: _Bool (requires C99; if not available, char is used instead)
  h:short; H:unsigned short; i:int; I:unsigned int;
  l:long; L:unsigned long; f:float; d:double.
Special cases (preceding decimal count indicates length):
  s:string (array of char); p: pascal string (with count byte).
Special case (only available in native format):
  P:an integer type that is wide enough to hold a pointer.
Special case (not in native mode unless 'long long' in platform C):
  q:long long; Q:unsigned long long
Whitespace between formats is ignored.

The variable struct.error is an exception raised on errors.
"""
# no imports

# functions

def calcsize(fmt): # real signature unknown; restored from __doc__
    """
    calcsize(fmt) -> integer
    
    Return size in bytes of the struct described by the format string fmt.
    """
    return 0


def pack(fmt, v1, v2, *more): # real signature unknown; restored from __doc__
    """
    pack(fmt, v1, v2, ...) -> bytes
    
    Return a bytes object containing the values v1, v2, ... packed according
    to the format string fmt.  See help(struct) for more on format strings.
    """
    return b""


def pack_into(fmt, buffer, offset, v1, v2, *more): # real signature unknown; restored from __doc__
    """
    pack_into(fmt, buffer, offset, v1, v2, ...)
    
    Pack the values v1, v2, ... according to the format string fmt and write
    the packed bytes into the writable buffer buf starting at offset.  Note
    that the offset is a required argument.  See help(struct) for more
    on format strings.
    """
    pass


def unpack(fmt, buffer): # real signature unknown; restored from __doc__
    """
    unpack(fmt, buffer) -> (v1, v2, ...)
    
    Return a tuple containing values unpacked according to the format string
    fmt.  Requires len(buffer) == calcsize(fmt). See help(struct) for more
    on format strings.
    """
    pass


def unpack_from(fmt, buffer, offset=0): # real signature unknown; restored from __doc__
    """
    unpack_from(fmt, buffer, offset=0) -> (v1, v2, ...)
    
    Return a tuple containing values unpacked according to the format string
    fmt.  Requires len(buffer[offset:]) >= calcsize(fmt).  See help(struct)
    for more on format strings.
    """
    pass


def _clearcache(*args, **kwargs): # real signature unknown
    """ Clear the internal cache. """
    pass


# classes

class error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class Struct(object):
    """
    Struct(fmt) --> compiled struct object
    
    Return a new Struct object which writes and reads binary data according to
    the format string fmt.  See help(struct) for more on format strings.
    """
    def pack(self, v1, v2, *more): # real signature unknown; restored from __doc__
        """
        S.pack(v1, v2, ...) -> bytes
        
        Return a bytes object containing values v1, v2, ... packed according
        to the format string S.format.  See help(struct) for more on format
        strings.
        """
        return b""

    def pack_into(self, buffer, offset, v1, v2, *more): # real signature unknown; restored from __doc__
        """
        S.pack_into(buffer, offset, v1, v2, ...)
        
        Pack the values v1, v2, ... according to the format string S.format
        and write the packed bytes into the writable buffer buf starting at
        offset.  Note that the offset is a required argument.  See
        help(struct) for more on format strings.
        """
        pass

    def unpack(self, buffer): # real signature unknown; restored from __doc__
        """
        S.unpack(buffer) -> (v1, v2, ...)
        
        Return a tuple containing values unpacked according to the format
        string S.format.  Requires len(buffer) == S.size.  See help(struct)
        for more on format strings.
        """
        pass

    def unpack_from(self, buffer, offset=0): # real signature unknown; restored from __doc__
        """
        S.unpack_from(buffer, offset=0) -> (v1, v2, ...)
        
        Return a tuple containing values unpacked according to the format
        string S.format.  Requires len(buffer[offset:]) >= S.size.  See
        help(struct) for more on format strings.
        """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __init__(self, fmt): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    format = property(lambda self: object()) # default
    size = property(lambda self: object()) # default


