# encoding: utf-8
# module Cookie
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/Cookie.pyo by generator 1.99
"""
Here's a sample session to show how to use this module.
At the moment, this is the only documentation.

The Basics
----------

Importing is easy..

   >>> import Cookie

Most of the time you start by creating a cookie.  Cookies come in
three flavors, each with slightly different encoding semantics, but
more on that later.

   >>> C = Cookie.SimpleCookie()
   >>> C = Cookie.SerialCookie()
   >>> C = Cookie.SmartCookie()

[Note: Long-time users of Cookie.py will remember using
Cookie.Cookie() to create an Cookie object.  Although deprecated, it
is still supported by the code.  See the Backward Compatibility notes
for more information.]

Once you've created your Cookie, you can add values just as if it were
a dictionary.

   >>> C = Cookie.SmartCookie()
   >>> C["fig"] = "newton"
   >>> C["sugar"] = "wafer"
   >>> C.output()
   'Set-Cookie: fig=newton\r\nSet-Cookie: sugar=wafer'

Notice that the printable representation of a Cookie is the
appropriate format for a Set-Cookie: header.  This is the
default behavior.  You can change the header and printed
attributes by using the .output() function

   >>> C = Cookie.SmartCookie()
   >>> C["rocky"] = "road"
   >>> C["rocky"]["path"] = "/cookie"
   >>> print C.output(header="Cookie:")
   Cookie: rocky=road; Path=/cookie
   >>> print C.output(attrs=[], header="Cookie:")
   Cookie: rocky=road

The load() method of a Cookie extracts cookies from a string.  In a
CGI script, you would use this method to extract the cookies from the
HTTP_COOKIE environment variable.

   >>> C = Cookie.SmartCookie()
   >>> C.load("chips=ahoy; vienna=finger")
   >>> C.output()
   'Set-Cookie: chips=ahoy\r\nSet-Cookie: vienna=finger'

The load() method is darn-tootin smart about identifying cookies
within a string.  Escaped quotation marks, nested semicolons, and other
such trickeries do not confuse it.

   >>> C = Cookie.SmartCookie()
   >>> C.load('keebler="E=everybody; L=\\"Loves\\"; fudge=\\012;";')
   >>> print C
   Set-Cookie: keebler="E=everybody; L=\"Loves\"; fudge=\012;"

Each element of the Cookie also supports all of the RFC 2109
Cookie attributes.  Here's an example which sets the Path
attribute.

   >>> C = Cookie.SmartCookie()
   >>> C["oreo"] = "doublestuff"
   >>> C["oreo"]["path"] = "/"
   >>> print C
   Set-Cookie: oreo=doublestuff; Path=/

Each dictionary element has a 'value' attribute, which gives you
back the value associated with the key.

   >>> C = Cookie.SmartCookie()
   >>> C["twix"] = "none for you"
   >>> C["twix"].value
   'none for you'


A Bit More Advanced
-------------------

As mentioned before, there are three different flavors of Cookie
objects, each with different encoding/decoding semantics.  This
section briefly discusses the differences.

SimpleCookie

The SimpleCookie expects that all values should be standard strings.
Just to be sure, SimpleCookie invokes the str() builtin to convert
the value to a string, when the values are set dictionary-style.

   >>> C = Cookie.SimpleCookie()
   >>> C["number"] = 7
   >>> C["string"] = "seven"
   >>> C["number"].value
   '7'
   >>> C["string"].value
   'seven'
   >>> C.output()
   'Set-Cookie: number=7\r\nSet-Cookie: string=seven'


SerialCookie

The SerialCookie expects that all values should be serialized using
cPickle (or pickle, if cPickle isn't available).  As a result of
serializing, SerialCookie can save almost any Python object to a
value, and recover the exact same object when the cookie has been
returned.  (SerialCookie can yield some strange-looking cookie
values, however.)

   >>> C = Cookie.SerialCookie()
   >>> C["number"] = 7
   >>> C["string"] = "seven"
   >>> C["number"].value
   7
   >>> C["string"].value
   'seven'
   >>> C.output()
   'Set-Cookie: number="I7\\012."\r\nSet-Cookie: string="S\'seven\'\\012p1\\012."'

Be warned, however, if SerialCookie cannot de-serialize a value (because
it isn't a valid pickle'd object), IT WILL RAISE AN EXCEPTION.


SmartCookie

The SmartCookie combines aspects of each of the other two flavors.
When setting a value in a dictionary-fashion, the SmartCookie will
serialize (ala cPickle) the value *if and only if* it isn't a
Python string.  String objects are *not* serialized.  Similarly,
when the load() method parses out values, it attempts to de-serialize
the value.  If it fails, then it fallsback to treating the value
as a string.

   >>> C = Cookie.SmartCookie()
   >>> C["number"] = 7
   >>> C["string"] = "seven"
   >>> C["number"].value
   7
   >>> C["string"].value
   'seven'
   >>> C.output()
   'Set-Cookie: number="I7\\012."\r\nSet-Cookie: string=seven'


Backwards Compatibility
-----------------------

In order to keep compatibilty with earlier versions of Cookie.py,
it is still possible to use Cookie.Cookie() to create a Cookie.  In
fact, this simply returns a SmartCookie.

   >>> C = Cookie.Cookie()
   >>> print C.__class__.__name__
   SmartCookie


Finis.
"""

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/string.pyc
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/warnings.pyc
from cPickle import dumps, loads


# Variables with simple values

_idmap = '\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff'

_LegalChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$%&'*+-.^_`|~"
_LegalCharsPatt = "[\\w\\d!#%&'~_`><@,:/\\$\\*\\+\\-\\.\\^\\|\\)\\(\\?\\}\\{\\=]"

# functions

def _getdate(future=0, weekdayname="['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']", monthname="[None, 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']"): # reliably restored by inspect
    # no doc
    pass


def _nulljoin(*args, **kwargs): # real signature unknown
    """
    S.join(sequence) -> string
    
    Return a string which is the concatenation of the strings in the
    sequence.  The separator between elements is S.
    """
    pass


def _quote(str, LegalChars=None, idmap=None, translate='<function translate at 0x101134398>'): # reliably restored by inspect
    # no doc
    pass


def _semispacejoin(*args, **kwargs): # real signature unknown
    """
    S.join(sequence) -> string
    
    Return a string which is the concatenation of the strings in the
    sequence.  The separator between elements is S.
    """
    pass


def _spacejoin(*args, **kwargs): # real signature unknown
    """
    S.join(sequence) -> string
    
    Return a string which is the concatenation of the strings in the
    sequence.  The separator between elements is S.
    """
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


def _unquote(str): # reliably restored by inspect
    # no doc
    pass


# classes

class BaseCookie(dict):
    # no doc
    def js_output(self, *args, **kwargs): # real signature unknown
        """ Return a string suitable for JavaScript. """
        pass

    def load(self, *args, **kwargs): # real signature unknown
        """
        Load cookies from a string (presumably HTTP_COOKIE) or
                from a dictionary.  Loading cookies from a dictionary 'd'
                is equivalent to calling:
                    map(Cookie.__setitem__, d.keys(), d.values())
        """
        pass

    def output(self, *args, **kwargs): # real signature unknown
        """ Return a string suitable for HTTP. """
        pass

    def value_decode(self, STRING): # real signature unknown; restored from __doc__
        """
        real_value, coded_value = value_decode(STRING)
                Called prior to setting a cookie's value from the network
                representation.  The VALUE is the value read from HTTP
                header.
                Override this function to modify the behavior of cookies.
        """
        pass

    def value_encode(self, VALUE): # real signature unknown; restored from __doc__
        """
        real_value, coded_value = value_encode(VALUE)
                Called prior to setting a cookie's value from the dictionary
                representation.  The VALUE is the value being assigned.
                Override this function to modify the behavior of cookies.
        """
        pass

    def _BaseCookie__ParseString(self, *args, **kwargs): # real signature unknown
        pass

    def _BaseCookie__set(self, *args, **kwargs): # real signature unknown
        """ Private method for setting a cookie's value """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __setitem__(self, *args, **kwargs): # real signature unknown
        """ Dictionary style assignment. """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """ Return a string suitable for HTTP. """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class SmartCookie(BaseCookie):
    """
    SmartCookie
        SmartCookie supports arbitrary objects as cookie values.  If the
        object is a string, then it is quoted.  If the object is not a
        string, however, then SmartCookie will use cPickle to serialize
        the object into a string representation.
    
        Note: Large cookie values add overhead because they must be
        retransmitted on every HTTP transaction.
    
        Note: HTTP has a 2k limit on the size of a cookie.  This class
        does not check for this limit, so be careful!!!
    """
    def value_decode(self, *args, **kwargs): # real signature unknown
        pass

    def value_encode(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


Cookie = SmartCookie


class CookieError(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class Morsel(dict):
    # no doc
    def isReservedKey(self, *args, **kwargs): # real signature unknown
        pass

    def js_output(self, *args, **kwargs): # real signature unknown
        pass

    def output(self, *args, **kwargs): # real signature unknown
        pass

    def OutputString(self, *args, **kwargs): # real signature unknown
        pass

    def set(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __setitem__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    _reserved = {
        'comment': 'Comment',
        'domain': 'Domain',
        'expires': 'expires',
        'httponly': 'httponly',
        'max-age': 'Max-Age',
        'path': 'Path',
        'secure': 'secure',
        'version': 'Version',
    }
    __dict__ = None # (!) real value is ''


class SerialCookie(BaseCookie):
    """
    SerialCookie
        SerialCookie supports arbitrary objects as cookie values. All
        values are serialized (using cPickle) before being sent to the
        client.  All incoming values are assumed to be valid Pickle
        representations.  IF AN INCOMING VALUE IS NOT IN A VALID PICKLE
        FORMAT, THEN AN EXCEPTION WILL BE RAISED.
    
        Note: Large cookie values add overhead because they must be
        retransmitted on every HTTP transaction.
    
        Note: HTTP has a 2k limit on the size of a cookie.  This class
        does not check for this limit, so be careful!!!
    """
    def value_decode(self, *args, **kwargs): # real signature unknown
        pass

    def value_encode(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SimpleCookie(BaseCookie):
    """
    SimpleCookie
        SimpleCookie supports strings as cookie values.  When setting
        the value using the dictionary assignment notation, SimpleCookie
        calls the builtin str() to convert the value to a string.  Values
        received from HTTP are kept as strings.
    """
    def value_decode(self, *args, **kwargs): # real signature unknown
        pass

    def value_encode(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

_CookiePattern = None # (!) real value is ''

_monthname = [
    None,
    'Jan',
    'Feb',
    'Mar',
    'Apr',
    'May',
    'Jun',
    'Jul',
    'Aug',
    'Sep',
    'Oct',
    'Nov',
    'Dec',
]

_OctalPatt = None # (!) real value is ''

_QuotePatt = None # (!) real value is ''

_Translator = {
    '\x00': '\\000',
    '\x01': '\\001',
    '\x02': '\\002',
    '\x03': '\\003',
    '\x04': '\\004',
    '\x05': '\\005',
    '\x06': '\\006',
    '\x07': '\\007',
    '\x08': '\\010',
    '\t': '\\011',
    '\n': '\\012',
    '\x0b': '\\013',
    '\x0c': '\\014',
    '\r': '\\015',
    '\x0e': '\\016',
    '\x0f': '\\017',
    '\x10': '\\020',
    '\x11': '\\021',
    '\x12': '\\022',
    '\x13': '\\023',
    '\x14': '\\024',
    '\x15': '\\025',
    '\x16': '\\026',
    '\x17': '\\027',
    '\x18': '\\030',
    '\x19': '\\031',
    '\x1a': '\\032',
    '\x1b': '\\033',
    '\x1c': '\\034',
    '\x1d': '\\035',
    '\x1e': '\\036',
    '\x1f': '\\037',
    '"': '\\"',
    '\\': '\\\\',
    '\x7f': '\\177',
    '\x80': '\\200',
    '\x81': '\\201',
    '\x82': '\\202',
    '\x83': '\\203',
    '\x84': '\\204',
    '\x85': '\\205',
    '\x86': '\\206',
    '\x87': '\\207',
    '\x88': '\\210',
    '\x89': '\\211',
    '\x8a': '\\212',
    '\x8b': '\\213',
    '\x8c': '\\214',
    '\x8d': '\\215',
    '\x8e': '\\216',
    '\x8f': '\\217',
    '\x90': '\\220',
    '\x91': '\\221',
    '\x92': '\\222',
    '\x93': '\\223',
    '\x94': '\\224',
    '\x95': '\\225',
    '\x96': '\\226',
    '\x97': '\\227',
    '\x98': '\\230',
    '\x99': '\\231',
    '\x9a': '\\232',
    '\x9b': '\\233',
    '\x9c': '\\234',
    '\x9d': '\\235',
    '\x9e': '\\236',
    '\x9f': '\\237',
    '\xa0': '\\240',
    '\xa1': '\\241',
    '\xa2': '\\242',
    '\xa3': '\\243',
    '\xa4': '\\244',
    '\xa5': '\\245',
    '\xa6': '\\246',
    '\xa7': '\\247',
    '\xa8': '\\250',
    '\xa9': '\\251',
    '\xaa': '\\252',
    '\xab': '\\253',
    '\xac': '\\254',
    '\xad': '\\255',
    '\xae': '\\256',
    '\xaf': '\\257',
    '\xb0': '\\260',
    '\xb1': '\\261',
    '\xb2': '\\262',
    '\xb3': '\\263',
    '\xb4': '\\264',
    '\xb5': '\\265',
    '\xb6': '\\266',
    '\xb7': '\\267',
    '\xb8': '\\270',
    '\xb9': '\\271',
    '\xba': '\\272',
    '\xbb': '\\273',
    '\xbc': '\\274',
    '\xbd': '\\275',
    '\xbe': '\\276',
    '\xbf': '\\277',
    '\xc0': '\\300',
    '\xc1': '\\301',
    '\xc2': '\\302',
    '\xc3': '\\303',
    '\xc4': '\\304',
    '\xc5': '\\305',
    '\xc6': '\\306',
    '\xc7': '\\307',
    '\xc8': '\\310',
    '\xc9': '\\311',
    '\xca': '\\312',
    '\xcb': '\\313',
    '\xcc': '\\314',
    '\xcd': '\\315',
    '\xce': '\\316',
    '\xcf': '\\317',
    '\xd0': '\\320',
    '\xd1': '\\321',
    '\xd2': '\\322',
    '\xd3': '\\323',
    '\xd4': '\\324',
    '\xd5': '\\325',
    '\xd6': '\\326',
    '\xd7': '\\327',
    '\xd8': '\\330',
    '\xd9': '\\331',
    '\xda': '\\332',
    '\xdb': '\\333',
    '\xdc': '\\334',
    '\xdd': '\\335',
    '\xde': '\\336',
    '\xdf': '\\337',
    '\xe0': '\\340',
    '\xe1': '\\341',
    '\xe2': '\\342',
    '\xe3': '\\343',
    '\xe4': '\\344',
    '\xe5': '\\345',
    '\xe6': '\\346',
    '\xe7': '\\347',
    '\xe8': '\\350',
    '\xe9': '\\351',
    '\xea': '\\352',
    '\xeb': '\\353',
    '\xec': '\\354',
    '\xed': '\\355',
    '\xee': '\\356',
    '\xef': '\\357',
    '\xf0': '\\360',
    '\xf1': '\\361',
    '\xf2': '\\362',
    '\xf3': '\\363',
    '\xf4': '\\364',
    '\xf5': '\\365',
    '\xf6': '\\366',
    '\xf7': '\\367',
    '\xf8': '\\370',
    '\xf9': '\\371',
    '\xfa': '\\372',
    '\xfb': '\\373',
    '\xfc': '\\374',
    '\xfd': '\\375',
    '\xfe': '\\376',
    '\xff': '\\377',
}

_weekdayname = [
    'Mon',
    'Tue',
    'Wed',
    'Thu',
    'Fri',
    'Sat',
    'Sun',
]

__all__ = [
    'CookieError',
    'BaseCookie',
    'SimpleCookie',
    'SerialCookie',
    'SmartCookie',
    'Cookie',
]

