# encoding: utf-8
# module _strptime
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/_strptime.pyo by generator 1.99
"""
Strptime-related classes and functions.

CLASSES:
    LocaleTime -- Discovers and stores locale-specific time information
    TimeRE -- Creates regexes for pattern matching a string of text containing
                time information

FUNCTIONS:
    _getlang -- Figure out what language is being used for the locale
    strptime -- Calculates the time struct represented by the passed-in string
"""

# imports
import locale as locale # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/locale.pyc
import calendar as calendar # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/calendar.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/time.so
from datetime import datetime_date

from thread import _thread_allocate_lock


# Variables with simple values

IGNORECASE = 2

_CACHE_MAX_SIZE = 5

# functions

def re_compile(pattern, flags=0): # reliably restored by inspect
    """ Compile a regular expression pattern, returning a pattern object. """
    pass


def re_escape(pattern): # reliably restored by inspect
    """ Escape all non-alphanumeric characters in pattern. """
    pass


def _calc_julian_from_U_or_W(year, week_of_year, day_of_week, week_starts_Mon): # reliably restored by inspect
    """
    Calculate the Julian day based on the year, week of the year, and day of
        the week, with week_start_day representing whether the week of the year
        assumes the week starts on Sunday or Monday (6 or 0).
    """
    pass


def _getlang(): # reliably restored by inspect
    # no doc
    pass


def _strptime(data_string, format=None): # reliably restored by inspect
    """ Return a time struct based on the input string and the format string. """
    pass


def _strptime_time(data_string, format=None): # reliably restored by inspect
    # no doc
    pass


# classes

class LocaleTime(object):
    """
    Stores and handles locale-specific information related to time.
    
        ATTRIBUTES:
            f_weekday -- full weekday names (7-item list)
            a_weekday -- abbreviated weekday names (7-item list)
            f_month -- full month names (13-item list; dummy value in [0], which
                        is added by code)
            a_month -- abbreviated month names (13-item list, dummy value in
                        [0], which is added by code)
            am_pm -- AM/PM representation (2-item list)
            LC_date_time -- format string for date/time representation (string)
            LC_date -- format string for date representation (string)
            LC_time -- format string for time representation (string)
            timezone -- daylight- and non-daylight-savings timezone representation
                        (2-item list of sets)
            lang -- Language used by instance (2-item tuple)
    """
    def _LocaleTime__calc_am_pm(self, *args, **kwargs): # real signature unknown
        pass

    def _LocaleTime__calc_date_time(self, *args, **kwargs): # real signature unknown
        pass

    def _LocaleTime__calc_month(self, *args, **kwargs): # real signature unknown
        pass

    def _LocaleTime__calc_timezone(self, *args, **kwargs): # real signature unknown
        pass

    def _LocaleTime__calc_weekday(self, *args, **kwargs): # real signature unknown
        pass

    def _LocaleTime__pad(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Set all attributes.
        
                Order of methods called matters for dependency reasons.
        
                The locale language is set at the offset and then checked again before
                exiting.  This is to make sure that the attributes were not set with a
                mix of information from more than one locale.  This would most likely
                happen when using threads where one thread calls a locale-dependent
                function while another thread changes the locale while the function in
                the other thread is still running.  Proper coding would call for
                locks to prevent changing the locale while locale-dependent code is
                running.  The check here is done in case someone does not think about
                doing this.
        
                Only other possible issue is if someone changed the timezone and did
                not call tz.tzset .  That is an issue for the programmer, though,
                since changing the timezone is worthless without that call.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class TimeRE(dict):
    """ Handle conversion from format directives to regexes. """
    def compile(self, *args, **kwargs): # real signature unknown
        """ Return a compiled re object for the format string. """
        pass

    def pattern(self, *args, **kwargs): # real signature unknown
        """
        Return regex pattern for the format string.
        
                Need to make sure that any characters that might be interpreted as
                regex syntax are escaped.
        """
        pass

    def _TimeRE__seqToRE(self, *args, **kwargs): # real signature unknown
        """
        Convert a list to a regex string for matching a directive.
        
                Want possible matching values to be from longest to shortest.  This
                prevents the possibility of a match occuring for a value that also
                a substring of a larger value that should have matched (e.g., 'abc'
                matching when 'abcdef' should have been the match).
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Create keys/values.
        
                Order of execution is important for dependency reasons.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

_cache_lock = None # (!) real value is ''

_regex_cache = {}

_TimeRE_cache = {
    '%': '%',
    'A': '(?P<A>wednesday|thursday|saturday|tuesday|monday|friday|sunday)',
    'B': '(?P<B>september|february|november|december|january|october|august|march|april|june|july|may)',
    'H': '(?P<H>2[0-3]|[0-1]\\d|\\d)',
    'I': '(?P<I>1[0-2]|0[1-9]|[1-9])',
    'M': '(?P<M>[0-5]\\d|\\d)',
    'S': '(?P<S>6[0-1]|[0-5]\\d|\\d)',
    'U': '(?P<U>5[0-3]|[0-4]\\d|\\d)',
    'W': '(?P<W>5[0-3]|[0-4]\\d|\\d)',
    'X': '(?P<H>2[0-3]|[0-1]\\d|\\d):(?P<M>[0-5]\\d|\\d):(?P<S>6[0-1]|[0-5]\\d|\\d)',
    'Y': '(?P<Y>\\d\\d\\d\\d)',
    'Z': '(?P<Z>utc|msk|gmt|msd)',
    'a': '(?P<a>mon|tue|wed|thu|fri|sat|sun)',
    'b': '(?P<b>jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)',
    'c': '(?P<a>mon|tue|wed|thu|fri|sat|sun)\\s+(?P<b>jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\\s+(?P<d>3[0-1]|[1-2]\\d|0[1-9]|[1-9]| [1-9])\\s+(?P<H>2[0-3]|[0-1]\\d|\\d):(?P<M>[0-5]\\d|\\d):(?P<S>6[0-1]|[0-5]\\d|\\d)\\s+(?P<Y>\\d\\d\\d\\d)',
    'd': '(?P<d>3[0-1]|[1-2]\\d|0[1-9]|[1-9]| [1-9])',
    'f': '(?P<f>[0-9]{1,6})',
    'j': '(?P<j>36[0-6]|3[0-5]\\d|[1-2]\\d\\d|0[1-9]\\d|00[1-9]|[1-9]\\d|0[1-9]|[1-9])',
    'm': '(?P<m>1[0-2]|0[1-9]|[1-9])',
    'p': '(?P<p>am|pm)',
    'w': '(?P<w>[0-6])',
    'x': '(?P<m>1[0-2]|0[1-9]|[1-9])/(?P<d>3[0-1]|[1-2]\\d|0[1-9]|[1-9]| [1-9])/(?P<y>\\d\\d)',
    'y': '(?P<y>\\d\\d)',
}

__all__ = []

