# encoding: utf-8
# module anydbm
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/anydbm.pyo by generator 1.99
"""
Generic interface to all dbm clones.

Instead of

        import dbm
        d = dbm.open(file, 'w', 0666)

use

        import anydbm
        d = anydbm.open(file, 'w')

The returned object is a dbhash, gdbm, dbm or dumbdbm object,
dependent on the type of database being opened (determined by whichdb
module) in the case of an existing dbm. If the dbm does not exist and
the create or new flag ('c' or 'n') was specified, the dbm type will
be determined by the availability of the modules (tested in the above
order).

It has the following interface (key and data are strings):

        d[key] = data   # store data at key (may override data at
                        # existing key)
        data = d[key]   # retrieve data at key (raise KeyError if no
                        # such key)
        del d[key]      # delete data stored at key (raises KeyError
                        # if no such key)
        flag = key in d   # true if the key exists
        list = d.keys() # return a list of all existing keys (slow!)

Future versions may change the order in which implementations are
tested for existence, add interfaces to other dbm-like
implementations.

The open function has an optional second argument.  This can be 'r',
for read-only access, 'w', for read-write access of an existing
database, 'c' for read-write access to a new or existing database, and
'n' for read-write access to a new database.  The default is 'r'.

Note: 'r' and 'w' fail if the database doesn't exist; 'c' creates it
only if it doesn't exist; and 'n' always creates a new database.
"""

# imports
import dumbdbm as _mod # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/dumbdbm.pyc
import dbm as _defaultmod # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/dbm.so

# Variables with simple values

_name = 'dumbdbm'

# functions

def open(file, flag=None, mode=438): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

error = (
    None, # (!) real value is ''
    _defaultmod.error,
    IOError,
)

_errors = [
    None, # (!) real value is ''
    _defaultmod.error,
    IOError,
]

_names = [
    'dbhash',
    'gdbm',
    'dbm',
    'dumbdbm',
]

