# encoding: utf-8
# module codecs
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/codecs.pyo by generator 1.99
"""
codecs -- Python Codec Registry, API and helpers.


Written by Marc-Andre Lemburg (mal@lemburg.com).

(c) Copyright CNRI, All Rights Reserved. NO WARRANTY.
"""

# imports
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>
import sys as sys # <module 'sys' (built-in)>
from _codecs import (ascii_decode, ascii_encode, charbuffer_encode, 
    charmap_build, charmap_decode, charmap_encode, decode, encode, 
    escape_decode, escape_encode, latin_1_decode, latin_1_encode, lookup, 
    lookup_error, raw_unicode_escape_decode, raw_unicode_escape_encode, 
    readbuffer_encode, register, register_error, unicode_escape_decode, 
    unicode_escape_encode, unicode_internal_decode, unicode_internal_encode, 
    utf_16_be_decode, utf_16_be_encode, utf_16_decode, utf_16_encode, 
    utf_16_ex_decode, utf_16_le_decode, utf_16_le_encode, utf_32_be_decode, 
    utf_32_be_encode, utf_32_decode, utf_32_encode, utf_32_ex_decode, 
    utf_32_le_decode, utf_32_le_encode, utf_7_decode, utf_7_encode, 
    utf_8_decode, utf_8_encode)


# Variables with simple values

BOM = '\xff\xfe'

BOM32_BE = '\xfe\xff'
BOM32_LE = '\xff\xfe'

BOM64_BE = '\x00\x00\xfe\xff'
BOM64_LE = '\xff\xfe\x00\x00'

BOM_BE = '\xfe\xff'
BOM_LE = '\xff\xfe'
BOM_UTF16 = '\xff\xfe'

BOM_UTF16_BE = '\xfe\xff'
BOM_UTF16_LE = '\xff\xfe'

BOM_UTF32 = '\xff\xfe\x00\x00'

BOM_UTF32_BE = '\x00\x00\xfe\xff'
BOM_UTF32_LE = '\xff\xfe\x00\x00'

BOM_UTF8 = '\xef\xbb\xbf'

_false = 0

# functions

def backslashreplace_errors(*args, **kwargs): # real signature unknown
    pass


def EncodedFile(file, data_encoding, file_encoding=None, errors=None): # reliably restored by inspect
    """
    Return a wrapped version of file which provides transparent
            encoding translation.
    
            Strings written to the wrapped file are interpreted according
            to the given data_encoding and then written to the original
            file as string using file_encoding. The intermediate encoding
            will usually be Unicode but depends on the specified codecs.
    
            Strings are read from the file using file_encoding and then
            passed back to the caller as string using data_encoding.
    
            If file_encoding is not given, it defaults to data_encoding.
    
            errors may be given to define the error handling. It defaults
            to 'strict' which causes ValueErrors to be raised in case an
            encoding error occurs.
    
            The returned wrapped file object provides two extra attributes
            .data_encoding and .file_encoding which reflect the given
            parameters of the same name. The attributes can be used for
            introspection by Python programs.
    """
    pass


def getdecoder(encoding): # reliably restored by inspect
    """
    Lookup up the codec for the given encoding and return
            its decoder function.
    
            Raises a LookupError in case the encoding cannot be found.
    """
    pass


def getencoder(encoding): # reliably restored by inspect
    """
    Lookup up the codec for the given encoding and return
            its encoder function.
    
            Raises a LookupError in case the encoding cannot be found.
    """
    pass


def getincrementaldecoder(encoding): # reliably restored by inspect
    """
    Lookup up the codec for the given encoding and return
            its IncrementalDecoder class or factory function.
    
            Raises a LookupError in case the encoding cannot be found
            or the codecs doesn't provide an incremental decoder.
    """
    pass


def getincrementalencoder(encoding): # reliably restored by inspect
    """
    Lookup up the codec for the given encoding and return
            its IncrementalEncoder class or factory function.
    
            Raises a LookupError in case the encoding cannot be found
            or the codecs doesn't provide an incremental encoder.
    """
    pass


def getreader(encoding): # reliably restored by inspect
    """
    Lookup up the codec for the given encoding and return
            its StreamReader class or factory function.
    
            Raises a LookupError in case the encoding cannot be found.
    """
    pass


def getwriter(encoding): # reliably restored by inspect
    """
    Lookup up the codec for the given encoding and return
            its StreamWriter class or factory function.
    
            Raises a LookupError in case the encoding cannot be found.
    """
    pass


def ignore_errors(*args, **kwargs): # real signature unknown
    pass


def iterdecode(iterator, encoding, errors=None, **kwargs): # reliably restored by inspect
    """
    Decoding iterator.
    
        Decodes the input strings from the iterator using a IncrementalDecoder.
    
        errors and kwargs are passed through to the IncrementalDecoder
        constructor.
    """
    pass


def iterencode(iterator, encoding, errors=None, **kwargs): # reliably restored by inspect
    """
    Encoding iterator.
    
        Encodes the input strings from the iterator using a IncrementalEncoder.
    
        errors and kwargs are passed through to the IncrementalEncoder
        constructor.
    """
    pass


def make_encoding_map(decoding_map): # reliably restored by inspect
    """
    Creates an encoding map from a decoding map.
    
            If a target mapping in the decoding map occurs multiple
            times, then that target is mapped to None (undefined mapping),
            causing an exception when encountered by the charmap codec
            during translation.
    
            One example where this happens is cp875.py which decodes
            multiple character to \u001a.
    """
    pass


def make_identity_dict(rng): # reliably restored by inspect
    """
    make_identity_dict(rng) -> dict
    
            Return a dictionary where elements of the rng sequence are
            mapped to themselves.
    """
    pass


def open(filename, mode=None, encoding=None, errors=None, buffering=1): # reliably restored by inspect
    """
    Open an encoded file using the given mode and return
            a wrapped version providing transparent encoding/decoding.
    
            Note: The wrapped version will only accept the object format
            defined by the codecs, i.e. Unicode objects for most builtin
            codecs. Output is also codec dependent and will usually be
            Unicode as well.
    
            Files are always opened in binary mode, even if no binary mode
            was specified. This is done to avoid data loss due to encodings
            using 8-bit values. The default file mode is 'rb' meaning to
            open the file in binary read mode.
    
            encoding specifies the encoding which is to be used for the
            file.
    
            errors may be given to define the error handling. It defaults
            to 'strict' which causes ValueErrors to be raised in case an
            encoding error occurs.
    
            buffering has the same meaning as for the builtin open() API.
            It defaults to line buffered.
    
            The returned wrapped file object provides an extra attribute
            .encoding which allows querying the used encoding. This
            attribute is only available if an encoding was specified as
            parameter.
    """
    pass


def replace_errors(*args, **kwargs): # real signature unknown
    pass


def strict_errors(*args, **kwargs): # real signature unknown
    pass


def xmlcharrefreplace_errors(*args, **kwargs): # real signature unknown
    pass


# classes

class IncrementalDecoder(object):
    """
    An IncrementalDecoder decodes an input in multiple steps. The input can be
        passed piece by piece to the decode() method. The IncrementalDecoder
        remembers the state of the decoding process between calls to decode().
    """
    def decode(self, *args, **kwargs): # real signature unknown
        """ Decodes input and returns the resulting object. """
        pass

    def getstate(self): # real signature unknown; restored from __doc__
        """
        Return the current state of the decoder.
        
                This must be a (buffered_input, additional_state_info) tuple.
                buffered_input must be a bytes object containing bytes that
                were passed to decode() that have not yet been converted.
                additional_state_info must be a non-negative integer
                representing the state of the decoder WITHOUT yet having
                processed the contents of buffered_input.  In the initial state
                and after reset(), getstate() must return (b"", 0).
        """
        pass

    def reset(self, *args, **kwargs): # real signature unknown
        """ Resets the decoder to the initial state. """
        pass

    def setstate(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Set the current state of the decoder.
        
                state must have been returned by getstate().  The effect of
                setstate((b"", 0)) must be equivalent to reset().
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates a IncrementalDecoder instance.
        
                The IncrementalDecoder may use different error handling schemes by
                providing the errors keyword argument. See the module docstring
                for a list of possible values.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class BufferedIncrementalDecoder(IncrementalDecoder):
    """
    This subclass of IncrementalDecoder can be used as the baseclass for an
        incremental decoder if the decoder must be able to handle incomplete byte
        sequences.
    """
    def decode(self, *args, **kwargs): # real signature unknown
        pass

    def getstate(self, *args, **kwargs): # real signature unknown
        pass

    def reset(self, *args, **kwargs): # real signature unknown
        pass

    def setstate(self, *args, **kwargs): # real signature unknown
        pass

    def _buffer_decode(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class IncrementalEncoder(object):
    """
    An IncrementalEncoder encodes an input in multiple steps. The input can be
        passed piece by piece to the encode() method. The IncrementalEncoder remembers
        the state of the Encoding process between calls to encode().
    """
    def encode(self, *args, **kwargs): # real signature unknown
        """ Encodes input and returns the resulting object. """
        pass

    def getstate(self, *args, **kwargs): # real signature unknown
        """ Return the current state of the encoder. """
        pass

    def reset(self, *args, **kwargs): # real signature unknown
        """ Resets the encoder to the initial state. """
        pass

    def setstate(self, *args, **kwargs): # real signature unknown
        """
        Set the current state of the encoder. state must have been
                returned by getstate().
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an IncrementalEncoder instance.
        
                The IncrementalEncoder may use different error handling schemes by
                providing the errors keyword argument. See the module docstring
                for a list of possible values.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class BufferedIncrementalEncoder(IncrementalEncoder):
    """
    This subclass of IncrementalEncoder can be used as the baseclass for an
        incremental encoder if the encoder must keep some of the output in a
        buffer between calls to encode().
    """
    def encode(self, *args, **kwargs): # real signature unknown
        pass

    def getstate(self, *args, **kwargs): # real signature unknown
        pass

    def reset(self, *args, **kwargs): # real signature unknown
        pass

    def setstate(self, *args, **kwargs): # real signature unknown
        pass

    def _buffer_encode(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class CodecInfo(tuple):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(cls, encode, decode, streamreader=None, streamwriter=None, incrementalencoder=None, incrementaldecoder=None, name=None): # reliably restored by inspect
        # no doc
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __dict__ = None # (!) real value is ''


# variables with complex values

Codec = None # (!) real value is ''

StreamReader = None # (!) real value is ''

StreamReaderWriter = None # (!) real value is ''

StreamRecoder = None # (!) real value is ''

StreamWriter = None # (!) real value is ''

__all__ = [
    'register',
    'lookup',
    'open',
    'EncodedFile',
    'BOM',
    'BOM_BE',
    'BOM_LE',
    'BOM32_BE',
    'BOM32_LE',
    'BOM64_BE',
    'BOM64_LE',
    'BOM_UTF8',
    'BOM_UTF16',
    'BOM_UTF16_LE',
    'BOM_UTF16_BE',
    'BOM_UTF32',
    'BOM_UTF32_LE',
    'BOM_UTF32_BE',
    'strict_errors',
    'ignore_errors',
    'replace_errors',
    'xmlcharrefreplace_errors',
    'register_error',
    'lookup_error',
]

