# encoding: utf-8
# module difflib
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/difflib.pyo by generator 1.99
"""
Module difflib -- helpers for computing deltas between objects.

Function get_close_matches(word, possibilities, n=3, cutoff=0.6):
    Use SequenceMatcher to return list of the best "good enough" matches.

Function context_diff(a, b):
    For two lists of strings, return a delta in context diff format.

Function ndiff(a, b):
    Return a delta: the difference between `a` and `b` (lists of strings).

Function restore(delta, which):
    Return one of the two sequences that generated an ndiff delta.

Function unified_diff(a, b):
    For two lists of strings, return a delta in unified diff format.

Class SequenceMatcher:
    A flexible class for comparing pairs of sequences of any type.

Class Differ:
    For producing human-readable deltas from sequences of lines of text.

Class HtmlDiff:
    For producing HTML side by side comparison with change highlights.
"""

# imports
import heapq as heapq # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/heapq.pyc
from _functools import reduce


# Variables with simple values

_file_template = '\n<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n          "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n\n<html>\n\n<head>\n    <meta http-equiv="Content-Type"\n          content="text/html; charset=ISO-8859-1" />\n    <title></title>\n    <style type="text/css">%(styles)s\n    </style>\n</head>\n\n<body>\n    %(table)s%(legend)s\n</body>\n\n</html>'

_legend = '\n    <table class="diff" summary="Legends">\n        <tr> <th colspan="2"> Legends </th> </tr>\n        <tr> <td> <table border="" summary="Colors">\n                      <tr><th> Colors </th> </tr>\n                      <tr><td class="diff_add">&nbsp;Added&nbsp;</td></tr>\n                      <tr><td class="diff_chg">Changed</td> </tr>\n                      <tr><td class="diff_sub">Deleted</td> </tr>\n                  </table></td>\n             <td> <table border="" summary="Links">\n                      <tr><th colspan="2"> Links </th> </tr>\n                      <tr><td>(f)irst change</td> </tr>\n                      <tr><td>(n)ext change</td> </tr>\n                      <tr><td>(t)op</td> </tr>\n                  </table></td> </tr>\n    </table>'

_styles = '\n        table.diff {font-family:Courier; border:medium;}\n        .diff_header {background-color:#e0e0e0}\n        td.diff_header {text-align:right}\n        .diff_next {background-color:#c0c0c0}\n        .diff_add {background-color:#aaffaa}\n        .diff_chg {background-color:#ffff77}\n        .diff_sub {background-color:#ffaaaa}'

_table_template = '\n    <table class="diff" id="difflib_chg_%(prefix)s_top"\n           cellspacing="0" cellpadding="0" rules="groups" >\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        %(header_row)s\n        <tbody>\n%(data_rows)s        </tbody>\n    </table>'

# functions

def context_diff(a, b, fromfile=None, tofile=None, fromfiledate=None, tofiledate=None, n=3, lineterm=None): # reliably restored by inspect
    """
    Compare two sequences of lines; generate the delta as a context diff.
    
        Context diffs are a compact way of showing line changes and a few
        lines of context.  The number of context lines is set by 'n' which
        defaults to three.
    
        By default, the diff control lines (those with *** or ---) are
        created with a trailing newline.  This is helpful so that inputs
        created from file.readlines() result in diffs that are suitable for
        file.writelines() since both the inputs and outputs have trailing
        newlines.
    
        For inputs that do not have trailing newlines, set the lineterm
        argument to "" so that the output will be uniformly newline free.
    
        The context diff format normally has a header for filenames and
        modification times.  Any or all of these may be specified using
        strings for 'fromfile', 'tofile', 'fromfiledate', and 'tofiledate'.
        The modification times are normally expressed in the format returned
        by time.ctime().  If not specified, the strings default to blanks.
    
        Example:
    
        >>> print ''.join(context_diff('one\ntwo\nthree\nfour\n'.splitlines(1),
        ...       'zero\none\ntree\nfour\n'.splitlines(1), 'Original', 'Current',
        ...       'Sat Jan 26 23:30:50 1991', 'Fri Jun 06 10:22:46 2003')),
        *** Original Sat Jan 26 23:30:50 1991
        --- Current Fri Jun 06 10:22:46 2003
        ***************
        *** 1,4 ****
          one
        ! two
        ! three
          four
        --- 1,4 ----
        + zero
          one
        ! tree
          four
    """
    pass


def get_close_matches(word, possibilities, n=3, cutoff=0.59999999999999998): # reliably restored by inspect
    """
    Use SequenceMatcher to return list of the best "good enough" matches.
    
        word is a sequence for which close matches are desired (typically a
        string).
    
        possibilities is a list of sequences against which to match word
        (typically a list of strings).
    
        Optional arg n (default 3) is the maximum number of close matches to
        return.  n must be > 0.
    
        Optional arg cutoff (default 0.6) is a float in [0, 1].  Possibilities
        that don't score at least that similar to word are ignored.
    
        The best (no more than n) matches among the possibilities are returned
        in a list, sorted by similarity score, most similar first.
    
        >>> get_close_matches("appel", ["ape", "apple", "peach", "puppy"])
        ['apple', 'ape']
        >>> import keyword as _keyword
        >>> get_close_matches("wheel", _keyword.kwlist)
        ['while']
        >>> get_close_matches("apple", _keyword.kwlist)
        []
        >>> get_close_matches("accept", _keyword.kwlist)
        ['except']
    """
    pass


def IS_CHARACTER_JUNK(ch, ws=None): # reliably restored by inspect
    """
    Return 1 for ignorable character: iff `ch` is a space or tab.
    
        Examples:
    
        >>> IS_CHARACTER_JUNK(' ')
        True
        >>> IS_CHARACTER_JUNK('\t')
        True
        >>> IS_CHARACTER_JUNK('\n')
        False
        >>> IS_CHARACTER_JUNK('x')
        False
    """
    pass


def IS_LINE_JUNK(line, pat='<built-in method match of _sre.SRE_Pattern object at 0x10057e030>'): # reliably restored by inspect
    """
    Return 1 for ignorable line: iff `line` is blank or contains a single '#'.
    
        Examples:
    
        >>> IS_LINE_JUNK('\n')
        True
        >>> IS_LINE_JUNK('  #   \n')
        True
        >>> IS_LINE_JUNK('hello\n')
        False
    """
    pass


def ndiff(a, b, linejunk=None, charjunk='<function IS_CHARACTER_JUNK at 0x10052ef50>'): # reliably restored by inspect
    """
    Compare `a` and `b` (lists of strings); return a `Differ`-style delta.
    
        Optional keyword parameters `linejunk` and `charjunk` are for filter
        functions (or None):
    
        - linejunk: A function that should accept a single string argument, and
          return true iff the string is junk.  The default is None, and is
          recommended; as of Python 2.3, an adaptive notion of "noise" lines is
          used that does a good job on its own.
    
        - charjunk: A function that should accept a string of length 1. The
          default is module-level function IS_CHARACTER_JUNK, which filters out
          whitespace characters (a blank or tab; note: bad idea to include newline
          in this!).
    
        Tools/scripts/ndiff.py is a command-line front-end to this function.
    
        Example:
    
        >>> diff = ndiff('one\ntwo\nthree\n'.splitlines(1),
        ...              'ore\ntree\nemu\n'.splitlines(1))
        >>> print ''.join(diff),
        - one
        ?  ^
        + ore
        ?  ^
        - two
        - three
        ?  -
        + tree
        + emu
    """
    pass


def restore(delta, which): # reliably restored by inspect
    """
    Generate one of the two sequences that generated a delta.
    
        Given a `delta` produced by `Differ.compare()` or `ndiff()`, extract
        lines originating from file 1 or 2 (parameter `which`), stripping off line
        prefixes.
    
        Examples:
    
        >>> diff = ndiff('one\ntwo\nthree\n'.splitlines(1),
        ...              'ore\ntree\nemu\n'.splitlines(1))
        >>> diff = list(diff)
        >>> print ''.join(restore(diff, 1)),
        one
        two
        three
        >>> print ''.join(restore(diff, 2)),
        ore
        tree
        emu
    """
    pass


def unified_diff(a, b, fromfile=None, tofile=None, fromfiledate=None, tofiledate=None, n=3, lineterm=None): # reliably restored by inspect
    """
    Compare two sequences of lines; generate the delta as a unified diff.
    
        Unified diffs are a compact way of showing line changes and a few
        lines of context.  The number of context lines is set by 'n' which
        defaults to three.
    
        By default, the diff control lines (those with ---, +++, or @@) are
        created with a trailing newline.  This is helpful so that inputs
        created from file.readlines() result in diffs that are suitable for
        file.writelines() since both the inputs and outputs have trailing
        newlines.
    
        For inputs that do not have trailing newlines, set the lineterm
        argument to "" so that the output will be uniformly newline free.
    
        The unidiff format normally has a header for filenames and modification
        times.  Any or all of these may be specified using strings for
        'fromfile', 'tofile', 'fromfiledate', and 'tofiledate'.  The modification
        times are normally expressed in the format returned by time.ctime().
    
        Example:
    
        >>> for line in unified_diff('one two three four'.split(),
        ...             'zero one tree four'.split(), 'Original', 'Current',
        ...             'Sat Jan 26 23:30:50 1991', 'Fri Jun 06 10:20:52 2003',
        ...             lineterm=''):
        ...     print line
        --- Original Sat Jan 26 23:30:50 1991
        +++ Current Fri Jun 06 10:20:52 2003
        @@ -1,4 +1,4 @@
        +zero
         one
        -two
        -three
        +tree
         four
    """
    pass


def _calculate_ratio(matches, length): # reliably restored by inspect
    # no doc
    pass


def _count_leading(line, ch): # reliably restored by inspect
    """
    Return number of `ch` characters at the start of `line`.
    
        Example:
    
        >>> _count_leading('   abc', ' ')
        3
    """
    pass


def _mdiff(fromlines, tolines, context=None, linejunk=None, charjunk='<function IS_CHARACTER_JUNK at 0x10052ef50>'): # reliably restored by inspect
    """
    Returns generator yielding marked up from/to side by side differences.
    
        Arguments:
        fromlines -- list of text lines to compared to tolines
        tolines -- list of text lines to be compared to fromlines
        context -- number of context lines to display on each side of difference,
                   if None, all from/to text lines will be generated.
        linejunk -- passed on to ndiff (see ndiff documentation)
        charjunk -- passed on to ndiff (see ndiff documentation)
    
        This function returns an interator which returns a tuple:
        (from line tuple, to line tuple, boolean flag)
    
        from/to line tuple -- (line num, line text)
            line num -- integer or None (to indicate a context seperation)
            line text -- original line text with following markers inserted:
                '\0+' -- marks start of added text
                '\0-' -- marks start of deleted text
                '\0^' -- marks start of changed text
                '\1' -- marks end of added/deleted/changed text
    
        boolean flag -- None indicates context separation, True indicates
            either "from" or "to" line contains a change, otherwise False.
    
        This function/iterator was originally developed to generate side by side
        file difference for making HTML pages (see HtmlDiff class for example
        usage).
    
        Note, this function utilizes the ndiff function to generate the side by
        side difference markup.  Optional ndiff arguments may be passed to this
        function and they in turn will be passed to ndiff.
    """
    pass


def _namedtuple(typename, field_names, verbose=False): # reliably restored by inspect
    """
    Returns a new subclass of tuple with named fields.
    
        >>> Point = namedtuple('Point', 'x y')
        >>> Point.__doc__                   # docstring for the new class
        'Point(x, y)'
        >>> p = Point(11, y=22)             # instantiate with positional args or keywords
        >>> p[0] + p[1]                     # indexable like a plain tuple
        33
        >>> x, y = p                        # unpack like a regular tuple
        >>> x, y
        (11, 22)
        >>> p.x + p.y                       # fields also accessable by name
        33
        >>> d = p._asdict()                 # convert to a dictionary
        >>> d['x']
        11
        >>> Point(**d)                      # convert from a dictionary
        Point(x=11, y=22)
        >>> p._replace(x=100)               # _replace() is like str.replace() but targets named fields
        Point(x=100, y=22)
    """
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


# classes

class HtmlDiff(object):
    """
    For producing HTML side by side comparison with change highlights.
    
        This class can be used to create an HTML table (or a complete HTML file
        containing the table) showing a side by side, line by line comparison
        of text with inter-line and intra-line change highlights.  The table can
        be generated in either full or contextual difference mode.
    
        The following methods are provided for HTML generation:
    
        make_table -- generates HTML for a single side by side table
        make_file -- generates complete HTML file with a single side by side table
    
        See tools/scripts/diff.py for an example usage of this class.
    """
    def make_file(self, *args, **kwargs): # real signature unknown
        """
        Returns HTML file of side by side comparison with change highlights
        
                Arguments:
                fromlines -- list of "from" lines
                tolines -- list of "to" lines
                fromdesc -- "from" file column header string
                todesc -- "to" file column header string
                context -- set to True for contextual differences (defaults to False
                    which shows full differences).
                numlines -- number of context lines.  When context is set True,
                    controls number of lines displayed before and after the change.
                    When context is False, controls the number of lines to place
                    the "next" link anchors before the next change (so click of
                    "next" link jumps to just before the change).
        """
        pass

    def make_table(self, *args, **kwargs): # real signature unknown
        """
        Returns HTML table of side by side comparison with change highlights
        
                Arguments:
                fromlines -- list of "from" lines
                tolines -- list of "to" lines
                fromdesc -- "from" file column header string
                todesc -- "to" file column header string
                context -- set to True for contextual differences (defaults to False
                    which shows full differences).
                numlines -- number of context lines.  When context is set True,
                    controls number of lines displayed before and after the change.
                    When context is False, controls the number of lines to place
                    the "next" link anchors before the next change (so click of
                    "next" link jumps to just before the change).
        """
        pass

    def _collect_lines(self, *args, **kwargs): # real signature unknown
        """
        Collects mdiff output into separate lists
        
                Before storing the mdiff from/to data into a list, it is converted
                into a single line of text with HTML markup.
        """
        pass

    def _convert_flags(self, *args, **kwargs): # real signature unknown
        """ Makes list of "next" links """
        pass

    def _format_line(self, *args, **kwargs): # real signature unknown
        """
        Returns HTML markup of "from" / "to" text lines
        
                side -- 0 or 1 indicating "from" or "to" text
                flag -- indicates if difference on line
                linenum -- line number (used for line number column)
                text -- line text to be marked up
        """
        pass

    def _line_wrapper(self, *args, **kwargs): # real signature unknown
        """ Returns iterator that splits (wraps) mdiff text lines """
        pass

    def _make_prefix(self, *args, **kwargs): # real signature unknown
        """ Create unique anchor prefixes """
        pass

    def _split_line(self, *args, **kwargs): # real signature unknown
        """
        Builds list of text lines by splitting text lines at wrap point
        
                This function will determine if the input text line needs to be
                wrapped (split) into separate lines.  If so, the first wrap point
                will be determined and the first line appended to the output
                text line list.  This function is used recursively to handle
                the second part of the split line to further split it.
        """
        pass

    def _tab_newline_replace(self, *args, **kwargs): # real signature unknown
        """
        Returns from/to line lists with tabs expanded and newlines removed.
        
                Instead of tab characters being replaced by the number of spaces
                needed to fill in to the next tab stop, this function will fill
                the space with tab characters.  This is done so that the difference
                algorithms can identify changes in a file when tabs are replaced by
                spaces and vice versa.  At the end of the HTML generation, the tab
                characters will be replaced with a nonbreakable space.
        """
        pass

    def __init__(self): # real signature unknown; restored from __doc__
        """
        HtmlDiff instance initializer
        
                Arguments:
                tabsize -- tab stop spacing, defaults to 8.
                wrapcolumn -- column number where lines are broken and wrapped,
                    defaults to None where lines are not wrapped.
                linejunk,charjunk -- keyword arguments passed into ndiff() (used to by
                    HtmlDiff() to generate the side by side HTML differences).  See
                    ndiff() documentation for argument default values and descriptions.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    _default_prefix = 0
    _file_template = '\n<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"\n          "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n\n<html>\n\n<head>\n    <meta http-equiv="Content-Type"\n          content="text/html; charset=ISO-8859-1" />\n    <title></title>\n    <style type="text/css">%(styles)s\n    </style>\n</head>\n\n<body>\n    %(table)s%(legend)s\n</body>\n\n</html>'
    _legend = '\n    <table class="diff" summary="Legends">\n        <tr> <th colspan="2"> Legends </th> </tr>\n        <tr> <td> <table border="" summary="Colors">\n                      <tr><th> Colors </th> </tr>\n                      <tr><td class="diff_add">&nbsp;Added&nbsp;</td></tr>\n                      <tr><td class="diff_chg">Changed</td> </tr>\n                      <tr><td class="diff_sub">Deleted</td> </tr>\n                  </table></td>\n             <td> <table border="" summary="Links">\n                      <tr><th colspan="2"> Links </th> </tr>\n                      <tr><td>(f)irst change</td> </tr>\n                      <tr><td>(n)ext change</td> </tr>\n                      <tr><td>(t)op</td> </tr>\n                  </table></td> </tr>\n    </table>'
    _styles = '\n        table.diff {font-family:Courier; border:medium;}\n        .diff_header {background-color:#e0e0e0}\n        td.diff_header {text-align:right}\n        .diff_next {background-color:#c0c0c0}\n        .diff_add {background-color:#aaffaa}\n        .diff_chg {background-color:#ffff77}\n        .diff_sub {background-color:#ffaaaa}'
    _table_template = '\n    <table class="diff" id="difflib_chg_%(prefix)s_top"\n           cellspacing="0" cellpadding="0" rules="groups" >\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        %(header_row)s\n        <tbody>\n%(data_rows)s        </tbody>\n    </table>'
    __dict__ = None # (!) real value is ''


class Match(tuple):
    """ Match(a, b, size) """
    def _asdict(self, *args, **kwargs): # real signature unknown
        """ Return a new dict which maps field names to their values """
        pass

    @classmethod
    def _make(cls, *args, **kwargs): # real signature unknown
        """ Make a new Match object from a sequence or iterable """
        pass

    def _replace(self, *args, **kwargs): # real signature unknown
        """ Return a new Match object replacing specified fields with new values """
        pass

    def __getnewargs__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, a, b, size): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(cls, a, b, size): # reliably restored by inspect
        # no doc
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    a = property(lambda self: object()) # default
    b = property(lambda self: object()) # default
    size = property(lambda self: object()) # default

    _fields = (
        'a',
        'b',
        'size',
    )
    __slots__ = ()


# variables with complex values

Differ = None # (!) real value is ''

SequenceMatcher = None # (!) real value is ''

__all__ = [
    'get_close_matches',
    'ndiff',
    'restore',
    'SequenceMatcher',
    'Differ',
    'IS_CHARACTER_JUNK',
    'IS_LINE_JUNK',
    'context_diff',
    'unified_diff',
    'HtmlDiff',
    'Match',
]

