# encoding: utf-8
# module distutils.file_util
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/distutils/file_util.pyo by generator 1.99
"""
distutils.file_util

Utility functions for operating on single files.
"""

# imports
import distutils.log as log # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/distutils/log.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
import distutils.errors as __distutils_errors


# Variables with simple values

__revision__ = '$Id: file_util.py 37828 2004-11-10 22:23:15Z loewis $'

# functions

def copy_file(src, dst, preserve_mode=1, preserve_times=1, update=0, link=None, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Copy a file 'src' to 'dst'.  If 'dst' is a directory, then 'src' is
        copied there with the same name; otherwise, it must be a filename.  (If
        the file exists, it will be ruthlessly clobbered.)  If 'preserve_mode'
        is true (the default), the file's mode (type and permission bits, or
        whatever is analogous on the current platform) is copied.  If
        'preserve_times' is true (the default), the last-modified and
        last-access times are copied as well.  If 'update' is true, 'src' will
        only be copied if 'dst' does not exist, or if 'dst' does exist but is
        older than 'src'.
    
        'link' allows you to make hard links (os.link) or symbolic links
        (os.symlink) instead of copying: set it to "hard" or "sym"; if it is
        None (the default), files are copied.  Don't set 'link' on systems that
        don't support it: 'copy_file()' doesn't check if hard or symbolic
        linking is available.
    
        Under Mac OS, uses the native file copy function in macostools; on
        other systems, uses '_copy_file_contents()' to copy file contents.
    
        Return a tuple (dest_name, copied): 'dest_name' is the actual name of
        the output file, and 'copied' is true if the file was copied (or would
        have been copied, if 'dry_run' true).
    """
    pass


def move_file(src, dst, verbose=0, dry_run=0): # reliably restored by inspect
    """
    Move a file 'src' to 'dst'.  If 'dst' is a directory, the file will
        be moved into it with the same name; otherwise, 'src' is just renamed
        to 'dst'.  Return the new full name of the file.
    
        Handles cross-device moves on Unix using 'copy_file()'.  What about
        other systems???
    """
    pass


def write_file(filename, contents): # reliably restored by inspect
    """
    Create a file with the specified name and write 'contents' (a
        sequence of strings without line terminators) to it.
    """
    pass


def _copy_file_contents(src, dst, buffer_size=16384): # reliably restored by inspect
    """
    Copy the file 'src' to 'dst'; both must be filenames.  Any error
        opening either file, reading from 'src', or writing to 'dst', raises
        DistutilsFileError.  Data is read/written in chunks of 'buffer_size'
        bytes (default 16k).  No attempt is made to handle anything apart from
        regular files.
    """
    pass


# classes

class DistutilsFileError(__distutils_errors.DistutilsError):
    """
    Any problems in the filesystem: expected file not found, etc.
        Typically this is for problems that we detect before IOError or
        OSError could be raised.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

_copy_action = {
    None: 'copying',
    'hard': 'hard linking',
    'sym': 'symbolically linking',
}

