# encoding: utf-8
# module encodings.__init__
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/encodings/__init__.pyo by generator 1.99
"""
Standard "encodings" Package

    Standard Python encoding modules are stored in this package
    directory.

    Codec modules must have names corresponding to normalized encoding
    names as defined in the normalize_encoding() function below, e.g.
    'utf-8' must be implemented by the module 'utf_8.py'.

    Each codec module must export the following interface:

    * getregentry() -> codecs.CodecInfo object
    The getregentry() API must a CodecInfo object with encoder, decoder,
    incrementalencoder, incrementaldecoder, streamwriter and streamreader
    atttributes which adhere to the Python Codec Interface Standard.

    In addition, a module may optionally also define the following
    APIs which are then used by the package's codec search function:

    * getaliases() -> sequence of encoding name strings to use as aliases

    Alias names returned by getaliases() must be normalized encoding
    names as defined by normalize_encoding().

Written by Marc-Andre Lemburg (mal@lemburg.com).

(c) Copyright CNRI, All Rights Reserved. NO WARRANTY.
"""

# imports
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>
import codecs as codecs # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/codecs.pyc
import encodings.aliases as aliases # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/encodings/aliases.pyc

# Variables with simple values

_norm_encoding_map = '                                              . 0123456789       ABCDEFGHIJKLMNOPQRSTUVWXYZ      abcdefghijklmnopqrstuvwxyz                                                                                                                                     '

_unknown = '--unknown--'

# functions

def normalize_encoding(encoding): # reliably restored by inspect
    """
    Normalize an encoding name.
    
            Normalization works as follows: all non-alphanumeric
            characters except the dot used for Python package names are
            collapsed and replaced with a single underscore, e.g. '  -;#'
            becomes '_'. Leading and trailing underscores are removed.
    
            Note that encoding names should be ASCII only; if they do use
            non-ASCII characters, these must be Latin-1 compatible.
    """
    pass


def search_function(encoding): # reliably restored by inspect
    # no doc
    pass


# classes

class CodecRegistryError(LookupError, SystemError):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

_aliases = aliases.aliases

_cache = {}

_import_tail = [
    '*',
]

