# encoding: utf-8
# module fileinput
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/fileinput.pyo by generator 1.99
"""
Helper class to quickly write a loop over all standard input files.

Typical use is:

    import fileinput
    for line in fileinput.input():
        process(line)

This iterates over the lines of all files listed in sys.argv[1:],
defaulting to sys.stdin if the list is empty.  If a filename is '-' it
is also replaced by sys.stdin.  To specify an alternative list of
filenames, pass it as the argument to input().  A single file name is
also allowed.

Functions filename(), lineno() return the filename and cumulative line
number of the line that has just been read; filelineno() returns its
line number in the current file; isfirstline() returns true iff the
line just read is the first line of its file; isstdin() returns true
iff the line was read from sys.stdin.  Function nextfile() closes the
current file so that the next iteration will read the first line from
the next file (if any); lines not read from the file will not count
towards the cumulative line count; the filename is not changed until
after the first line of the next file has been read.  Function close()
closes the sequence.

Before any lines have been read, filename() returns None and both line
numbers are zero; nextfile() has no effect.  After all lines have been
read, filename() and the line number functions return the values
pertaining to the last line read; nextfile() has no effect.

All files are opened in text mode by default, you can override this by
setting the mode parameter to input() or FileInput.__init__().
If an I/O error occurs during opening or reading a file, the IOError
exception is raised.

If sys.stdin is used more than once, the second and further use will
return no lines, except perhaps for interactive use, or if it has been
explicitly reset (e.g. using sys.stdin.seek(0)).

Empty files are opened and immediately closed; the only time their
presence in the list of filenames is noticeable at all is when the
last file opened is empty.

It is possible that the last line of a file doesn't end in a newline
character; otherwise lines are returned including the trailing
newline.

Class FileInput is the implementation; its methods filename(),
lineno(), fileline(), isfirstline(), isstdin(), nextfile() and close()
correspond to the functions in the module.  In addition it has a
readline() method which returns the next input line, and a
__getitem__() method which implements the sequence behavior.  The
sequence must be accessed in strictly sequential order; sequence
access and readline() cannot be mixed.

Optional in-place filtering: if the keyword argument inplace=1 is
passed to input() or to the FileInput constructor, the file is moved
to a backup file and standard output is directed to the input file.
This makes it possible to write a filter that rewrites its input file
in place.  If the keyword argument backup=".<some extension>" is also
given, it specifies the extension for the backup file, and the backup
file remains around; by default, the extension is ".bak" and it is
deleted when the output file is closed.  In-place filtering is
disabled when standard input is read.  XXX The current implementation
does not work for MS-DOS 8+3 filesystems.

Performance: this module is unfortunately one of the slower ways of
processing large numbers of input lines.  Nevertheless, a significant
speed-up has been obtained by using readlines(bufsize) instead of
readline().  A new keyword argument, bufsize=N, is present on the
input() function and the FileInput() class to override the default
buffer size.

XXX Possible additions:

- optional getopt argument processing
- isatty()
- read(), read(size), even readlines()
"""

# imports
import sys as sys # <module 'sys' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

DEFAULT_BUFSIZE = 8192

_state = None

# functions

def close(): # reliably restored by inspect
    """ Close the sequence. """
    pass


def filelineno(): # reliably restored by inspect
    """
    Return the line number in the current file. Before the first line
        has been read, returns 0. After the last line of the last file has
        been read, returns the line number of that line within the file.
    """
    pass


def filename(): # reliably restored by inspect
    """
    Return the name of the file currently being read.
        Before the first line has been read, returns None.
    """
    pass


def fileno(): # reliably restored by inspect
    """
    Return the file number of the current file. When no file is currently
        opened, returns -1.
    """
    pass


def hook_compressed(filename, mode): # reliably restored by inspect
    # no doc
    pass


def hook_encoded(encoding): # reliably restored by inspect
    # no doc
    pass


def input(files=None, inplace=0, backup=None, bufsize=0, mode=None, openhook=None): # reliably restored by inspect
    """
    input([files[, inplace[, backup[, mode[, openhook]]]]])
    
        Create an instance of the FileInput class. The instance will be used
        as global state for the functions of this module, and is also returned
        to use during iteration. The parameters to this function will be passed
        along to the constructor of the FileInput class.
    """
    pass


def isfirstline(): # reliably restored by inspect
    """
    Returns true the line just read is the first line of its file,
        otherwise returns false.
    """
    pass


def isstdin(): # reliably restored by inspect
    """
    Returns true if the last line was read from sys.stdin,
        otherwise returns false.
    """
    pass


def lineno(): # reliably restored by inspect
    """
    Return the cumulative line number of the line that has just been read.
        Before the first line has been read, returns 0. After the last line
        of the last file has been read, returns the line number of that line.
    """
    pass


def nextfile(): # reliably restored by inspect
    """
    Close the current file so that the next iteration will read the first
        line from the next file (if any); lines not read from the file will
        not count towards the cumulative line count. The filename is not
        changed until after the first line of the next file has been read.
        Before the first line has been read, this function has no effect;
        it cannot be used to skip the first file. After the last line of the
        last file has been read, this function has no effect.
    """
    pass


def _test(): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

FileInput = None # (!) real value is ''

__all__ = [
    'input',
    'close',
    'nextfile',
    'filename',
    'lineno',
    'filelineno',
    'isfirstline',
    'isstdin',
    'FileInput',
]

