# encoding: utf-8
# module fractions
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/fractions.pyo by generator 1.99
""" Rational, infinite-precision, real numbers. """

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import numbers as numbers # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/numbers.pyc
import operator as operator # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/operator.so
import math as math # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/math.so
import numbers as __numbers


# functions

def gcd(a, b): # reliably restored by inspect
    """
    Calculate the Greatest Common Divisor of a and b.
    
        Unless b==0, the result will have the same sign as b (so that when
        b is divided by it, the result comes out positive).
    """
    pass


# classes

class Rational(__numbers.Real):
    """ .numerator and .denominator should be in lowest terms. """
    def __float__(self, *args, **kwargs): # real signature unknown
        """
        float(self) = self.numerator / self.denominator
        
                It's important that this conversion use the integer's "true"
                division rather than casting one side to float before dividing
                so that ratios of huge integers convert without overflowing.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    denominator = property(lambda self: object()) # default
    numerator = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 11
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Fraction(__numbers.Rational):
    """
    This class implements rational numbers.
    
        Fraction(8, 6) will produce a rational number equivalent to
        4/3. Both arguments must be Integral. The numerator defaults to 0
        and the denominator defaults to 1 so that Fraction(3) == 3 and
        Fraction() == 0.
    
        Fractions can also be constructed from strings of the form
        '[-+]?[0-9]+((/|.)[0-9]+)?', optionally surrounded by spaces.
    """
    @classmethod
    def from_decimal(cls, *args, **kwargs): # real signature unknown
        """ Converts a finite Decimal instance to a rational number, exactly. """
        pass

    @classmethod
    def from_float(cls, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Converts a finite float to a rational number, exactly.
        
                Beware that Fraction.from_float(0.3) != Fraction(3, 10).
        """
        pass

    def limit_denominator(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Closest Fraction to self with denominator at most max_denominator.
        
                >>> Fraction('3.141592653589793').limit_denominator(10)
                Fraction(22, 7)
                >>> Fraction('3.141592653589793').limit_denominator(100)
                Fraction(311, 99)
                >>> Fraction(1234, 5678).limit_denominator(10000)
                Fraction(1234, 5678)
        """
        pass

    def _add(self, *args, **kwargs): # real signature unknown
        """ a + b """
        pass

    def _div(self, *args, **kwargs): # real signature unknown
        """ a / b """
        pass

    def _mul(self, *args, **kwargs): # real signature unknown
        """ a * b """
        pass

    def _operator_fallbacks(self, just_rational_op, operator_op): # real signature unknown; restored from __doc__
        """
        Generates forward and reverse operators given a purely-rational
                operator and a function from the operator module.
        
                Use this like:
                __op__, __rop__ = _operator_fallbacks(just_rational_op, operator.op)
        
                In general, we want to implement the arithmetic operations so
                that mixed-mode operations either call an implementation whose
                author knew about the types of both arguments, or convert both
                to the nearest built in type and do the operation there. In
                Fraction, that means that we define __add__ and __radd__ as:
        
                    def __add__(self, other):
                        # Both types have numerators/denominator attributes,
                        # so do the operation directly
                        if isinstance(other, (int, long, Fraction)):
                            return Fraction(self.numerator * other.denominator +
                                            other.numerator * self.denominator,
                                            self.denominator * other.denominator)
                        # float and complex don't have those operations, but we
                        # know about those types, so special case them.
                        elif isinstance(other, float):
                            return float(self) + other
                        elif isinstance(other, complex):
                            return complex(self) + other
                        # Let the other type take over.
                        return NotImplemented
        
                    def __radd__(self, other):
                        # radd handles more types than add because there's
                        # nothing left to fall back to.
                        if isinstance(other, Rational):
                            return Fraction(self.numerator * other.denominator +
                                            other.numerator * self.denominator,
                                            self.denominator * other.denominator)
                        elif isinstance(other, Real):
                            return float(other) + float(self)
                        elif isinstance(other, Complex):
                            return complex(other) + complex(self)
                        return NotImplemented
        
        
                There are 5 different cases for a mixed-type addition on
                Fraction. I'll refer to all of the above code that doesn't
                refer to Fraction, float, or complex as "boilerplate". 'r'
                will be an instance of Fraction, which is a subtype of
                Rational (r : Fraction <: Rational), and b : B <:
                Complex. The first three involve 'r + b':
        
                    1. If B <: Fraction, int, float, or complex, we handle
                       that specially, and all is well.
                    2. If Fraction falls back to the boilerplate code, and it
                       were to return a value from __add__, we'd miss the
                       possibility that B defines a more intelligent __radd__,
                       so the boilerplate should return NotImplemented from
                       __add__. In particular, we don't handle Rational
                       here, even though we could get an exact answer, in case
                       the other type wants to do something special.
                    3. If B <: Fraction, Python tries B.__radd__ before
                       Fraction.__add__. This is ok, because it was
                       implemented with knowledge of Fraction, so it can
                       handle those instances before delegating to Real or
                       Complex.
        
                The next two situations describe 'b + r'. We assume that b
                didn't know about Fraction in its implementation, and that it
                uses similar boilerplate code:
        
                    4. If B <: Rational, then __radd_ converts both to the
                       builtin rational type (hey look, that's us) and
                       proceeds.
                    5. Otherwise, __radd__ tries to find the nearest common
                       base ABC, and fall back to its builtin type. Since this
                       class doesn't subclass a concrete type, there's no
                       implementation to fall back to, so we need to try as
                       hard as possible to return an actual value, or the user
                       will get a TypeError.
        """
        pass

    def _sub(self, *args, **kwargs): # real signature unknown
        """ a - b """
        pass

    def _subtractAndCompareToZero(self, *args, **kwargs): # real signature unknown
        """
        Helper function for comparison operators.
        
                Subtracts b from a, exactly if possible, and compares the
                result with 0 using op, in such a way that the comparison
                won't recurse. If the difference raises a TypeError, returns
                NotImplemented instead.
        """
        pass

    def __abs__(self, *args, **kwargs): # real signature unknown
        """ abs(a) """
        pass

    def __add__(self, *args, **kwargs): # real signature unknown
        """ a + b """
        pass

    def __copy__(self, *args, **kwargs): # real signature unknown
        pass

    def __deepcopy__(self, *args, **kwargs): # real signature unknown
        pass

    def __div__(self, *args, **kwargs): # real signature unknown
        """ a / b """
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        """ a == b """
        pass

    def __floordiv__(self, *args, **kwargs): # real signature unknown
        """ a // b """
        pass

    def __ge__(self, *args, **kwargs): # real signature unknown
        """ a >= b """
        pass

    def __gt__(self, *args, **kwargs): # real signature unknown
        """ a > b """
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        """
        hash(self)
        
                Tricky because values that are exactly representable as a
                float must have the same hash as that float.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        pass

    def __le__(self, *args, **kwargs): # real signature unknown
        """ a <= b """
        pass

    def __lt__(self, *args, **kwargs): # real signature unknown
        """ a < b """
        pass

    def __mod__(self, *args, **kwargs): # real signature unknown
        """ a % b """
        pass

    def __mul__(self, *args, **kwargs): # real signature unknown
        """ a * b """
        pass

    def __neg__(self, *args, **kwargs): # real signature unknown
        """ -a """
        pass

    @staticmethod # known case of __new__
    def __new__(cls, numerator=0, denominator=1): # reliably restored by inspect
        """
        Constructs a Fraction.
        
                Takes a string like '3/2' or '1.5', another Fraction, or a
                numerator/denominator pair.
        """
        pass

    def __nonzero__(self, *args, **kwargs): # real signature unknown
        """ a != 0 """
        pass

    def __pos__(self, *args, **kwargs): # real signature unknown
        """ +a: Coerces a subclass instance to Fraction """
        pass

    def __pow__(self, *args, **kwargs): # real signature unknown
        """
        a ** b
        
                If b is not an integer, the result will be a float or complex
                since roots are generally irrational. If b is an integer, the
                result will be rational.
        """
        pass

    def __radd__(self, *args, **kwargs): # real signature unknown
        """ a + b """
        pass

    def __rdiv__(self, *args, **kwargs): # real signature unknown
        """ a / b """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ repr(self) """
        pass

    def __rfloordiv__(self, *args, **kwargs): # real signature unknown
        """ a // b """
        pass

    def __rmod__(self, *args, **kwargs): # real signature unknown
        """ a % b """
        pass

    def __rmul__(self, *args, **kwargs): # real signature unknown
        """ a * b """
        pass

    def __rpow__(self, *args, **kwargs): # real signature unknown
        """ a ** b """
        pass

    def __rsub__(self, *args, **kwargs): # real signature unknown
        """ a - b """
        pass

    def __rtruediv__(self, *args, **kwargs): # real signature unknown
        """ a / b """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """ str(self) """
        pass

    def __sub__(self, *args, **kwargs): # real signature unknown
        """ a - b """
        pass

    def __truediv__(self, *args, **kwargs): # real signature unknown
        """ a / b """
        pass

    def __trunc__(self, *args, **kwargs): # real signature unknown
        """ trunc(a) """
        pass

    denominator = property(lambda self: object()) # default
    numerator = property(lambda self: object()) # default
    _denominator = property(lambda self: object()) # default
    _numerator = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 13
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __slots__ = (
        '_numerator',
        '_denominator',
    )


# variables with complex values

division = numbers.division

_RATIONAL_FORMAT = None # (!) real value is ''

__all__ = [
    'Fraction',
    'gcd',
]

