# encoding: utf-8
# module lib2to3.fixes.fix_except
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixes/fix_except.pyo by generator 1.99
"""
Fixer for except statements with named exceptions.

The following cases will be converted:

- "except E, T:" where T is a name:

    except E as T:

- "except E, T:" where T is not a name, tuple or list:

        except E as t:
            T = t

    This is done because the target of an "except" clause must be a
    name.

- "except E, T:" where T is a tuple or list literal:

        except E as t:
            T = t.args
"""

# imports
import lib2to3.pytree as pytree # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pytree.pyc
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixer_base.pyc
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/token.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base


# functions

def Assign(target, source): # reliably restored by inspect
    """ Build an assignment statement """
    pass


def Attr(obj, attr): # reliably restored by inspect
    """ A node tuple for obj.attr """
    pass


def find_excepts(nodes): # reliably restored by inspect
    # no doc
    pass


def is_list(node): # reliably restored by inspect
    """ Does the node represent a list literal? """
    pass


def is_tuple(node): # reliably restored by inspect
    """ Does the node represent a tuple literal? """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


# classes

class FixExcept(__lib2to3_fixer_base.BaseFix):
    # no doc
    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    PATTERN = "\n    try_stmt< 'try' ':' suite\n                  cleanup=(except_clause ':' suite)+\n                  tail=(['except' ':' suite]\n                        ['else' ':' suite]\n                        ['finally' ':' suite]) >\n    "


