# encoding: utf-8
# module lib2to3.fixes.fix_metaclass
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixes/fix_metaclass.pyo by generator 1.99
"""
Fixer for __metaclass__ = X -> (metaclass=X) methods.

   The various forms of classef (inherits nothing, inherits once, inherints
   many) don't parse the same in the CST so we look at ALL classes for
   a __metaclass__ and if we find one normalize the inherits to all be
   an arglist.

   For one-liner classes ('class X: pass') there is no indent/dedent so
   we normalize those into having a suite.

   Moving the __metaclass__ into the classdef can also cause the class
   body to be empty so there is some special casing for that as well.

   This fixer also tries very hard to keep original indenting and spacing
   in all those corner cases.
"""

# imports
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/token.pyc
import lib2to3.fixer_base as fixer_base # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/fixer_base.pyc
import lib2to3.fixer_base as __lib2to3_fixer_base
import lib2to3.pytree as __lib2to3_pytree


# functions

def find_metas(cls_node): # reliably restored by inspect
    # no doc
    pass


def fixup_indent(suite): # reliably restored by inspect
    """
    If an INDENT is followed by a thing with a prefix then nuke the prefix
            Otherwise we get in trouble when removing __metaclass__ at suite start
    """
    pass


def fixup_parse_tree(cls_node): # reliably restored by inspect
    """
    one-line classes don't get a suite in the parse tree so we add
            one to normalize the tree
    """
    pass


def fixup_simple_stmt(parent, i, stmt_node): # reliably restored by inspect
    """
    if there is a semi-colon all the parts count as part of the same
            simple_stmt.  We just want the __metaclass__ part so we move
            everything efter the semi-colon into its own simple_stmt node
    """
    pass


def has_metaclass(parent): # reliably restored by inspect
    """
    we have to check the cls_node without changing it.
            There are two possiblities:
              1)  clsdef => suite => simple_stmt => expr_stmt => Leaf('__meta')
              2)  clsdef => simple_stmt => expr_stmt => Leaf('__meta')
    """
    pass


def Name(name, prefix=None): # reliably restored by inspect
    """ Return a NAME leaf """
    pass


def remove_trailing_newline(node): # reliably restored by inspect
    # no doc
    pass


# classes

class FixMetaclass(__lib2to3_fixer_base.BaseFix):
    # no doc
    def transform(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.  Subclass may override.
        
                Args:
                    options: an dict containing the options passed to RefactoringTool
                    that could be used to customize the fixer through the command line.
                    log: a list to append warnings and other messages to.
        """
        pass

    PATTERN = '\n    classdef<any*>\n    '


class Leaf(__lib2to3_pytree.Base):
    """ Concrete implementation for leaf nodes. """
    def clone(self, *args, **kwargs): # real signature unknown
        """ Returns a cloned (deep) copy of self. """
        pass

    def get_prefix(self, *args, **kwargs): # real signature unknown
        """ Returns the prefix for the node. """
        pass

    def post_order(self, *args, **kwargs): # real signature unknown
        """ Returns a post-order iterator for the tree. """
        pass

    def pre_order(self, *args, **kwargs): # real signature unknown
        """ Returns a pre-order iterator for the tree. """
        pass

    def set_prefix(self, *args, **kwargs): # real signature unknown
        """ Sets the prefix for the node. """
        pass

    def _eq(self, *args, **kwargs): # real signature unknown
        """ Compares two nodes for equality. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Takes a type constant (a token number < 256), a string value,
                and an optional context keyword argument.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Returns a canonical string representation. """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """
        Returns a pretty string representation.
        
                This reproduces the input source exactly.
        """
        pass

    column = 0
    lineno = 0
    prefix = ''


class Node(__lib2to3_pytree.Base):
    """ Concrete implementation for interior nodes. """
    def append_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.append(child)'. This method also
                sets the child's parent attribute appropriately.
        """
        pass

    def clone(self, *args, **kwargs): # real signature unknown
        """ Returns a cloned (deep) copy of self. """
        pass

    def get_prefix(self, *args, **kwargs): # real signature unknown
        """
        Returns the prefix for the node.
        
                This passes the call on to the first child.
        """
        pass

    def insert_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children.insert(i, child)'. This method also
                sets the child's parent attribute appropriately.
        """
        pass

    def post_order(self, *args, **kwargs): # real signature unknown
        """ Returns a post-order iterator for the tree. """
        pass

    def pre_order(self, *args, **kwargs): # real signature unknown
        """ Returns a pre-order iterator for the tree. """
        pass

    def set_child(self, *args, **kwargs): # real signature unknown
        """
        Equivalent to 'node.children[i] = child'. This method also sets the
                child's parent attribute appropriately.
        """
        pass

    def set_prefix(self, *args, **kwargs): # real signature unknown
        """
        Sets the prefix for the node.
        
                This passes the responsibility on to the first child.
        """
        pass

    def _eq(self, *args, **kwargs): # real signature unknown
        """ Compares two nodes for equality. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Initializer.
        
                Takes a type constant (a symbol number >= 256), a sequence of
                child nodes, and an optional context keyword argument.
        
                As a side effect, the parent pointers of the children are updated.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Returns a canonical string representation. """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """
        Returns a pretty string representation.
        
                This reproduces the input source exactly.
        """
        pass


# variables with complex values

syms = None # (!) real value is ''

