# encoding: utf-8
# module lib2to3.pgen2.grammar
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/grammar.pyo by generator 1.99
"""
This module defines the data structures used to represent a grammar.

These are a bit arcane because they are derived from the data
structures used by Python's 'pgen' parser generator.

There's also a table here mapping operators to their names in the
token module; the Python tokenize module reports all operators as the
fallback token code OP, but the parser needs the actual token code.
"""

# imports
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/token.pyc
import lib2to3.pgen2.tokenize as tokenize # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/tokenize.pyc
import pickle as pickle # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/pickle.pyc

# Variables with simple values

line = '-> RARROW'

name = 'RARROW'

op = '->'

opmap_raw = '\n( LPAR\n) RPAR\n[ LSQB\n] RSQB\n: COLON\n, COMMA\n; SEMI\n+ PLUS\n- MINUS\n* STAR\n/ SLASH\n| VBAR\n& AMPER\n< LESS\n> GREATER\n= EQUAL\n. DOT\n% PERCENT\n` BACKQUOTE\n{ LBRACE\n} RBRACE\n@ AT\n== EQEQUAL\n!= NOTEQUAL\n<> NOTEQUAL\n<= LESSEQUAL\n>= GREATEREQUAL\n~ TILDE\n^ CIRCUMFLEX\n<< LEFTSHIFT\n>> RIGHTSHIFT\n** DOUBLESTAR\n+= PLUSEQUAL\n-= MINEQUAL\n*= STAREQUAL\n/= SLASHEQUAL\n%= PERCENTEQUAL\n&= AMPEREQUAL\n|= VBAREQUAL\n^= CIRCUMFLEXEQUAL\n<<= LEFTSHIFTEQUAL\n>>= RIGHTSHIFTEQUAL\n**= DOUBLESTAREQUAL\n// DOUBLESLASH\n//= DOUBLESLASHEQUAL\n-> RARROW\n'

# no functions
# classes

class Grammar(object):
    """
    Pgen parsing tables tables conversion class.
    
        Once initialized, this class supplies the grammar tables for the
        parsing engine implemented by parse.py.  The parsing engine
        accesses the instance variables directly.  The class here does not
        provide initialization of the tables; several subclasses exist to
        do this (see the conv and pgen modules).
    
        The load() method reads the tables from a pickle file, which is
        much faster than the other ways offered by subclasses.  The pickle
        file is written by calling dump() (after loading the grammar
        tables using a subclass).  The report() method prints a readable
        representation of the tables to stdout, for debugging.
    
        The instance variables are as follows:
    
        symbol2number -- a dict mapping symbol names to numbers.  Symbol
                         numbers are always 256 or higher, to distinguish
                         them from token numbers, which are between 0 and
                         255 (inclusive).
    
        number2symbol -- a dict mapping numbers to symbol names;
                         these two are each other's inverse.
    
        states        -- a list of DFAs, where each DFA is a list of
                         states, each state is is a list of arcs, and each
                         arc is a (i, j) pair where i is a label and j is
                         a state number.  The DFA number is the index into
                         this list.  (This name is slightly confusing.)
                         Final states are represented by a special arc of
                         the form (0, j) where j is its own state number.
    
        dfas          -- a dict mapping symbol numbers to (DFA, first)
                         pairs, where DFA is an item from the states list
                         above, and first is a set of tokens that can
                         begin this grammar rule (represented by a dict
                         whose values are always 1).
    
        labels        -- a list of (x, y) pairs where x is either a token
                         number or a symbol number, and y is either None
                         or a string; the strings are keywords.  The label
                         number is the index in this list; label numbers
                         are used to mark state transitions (arcs) in the
                         DFAs.
    
        start         -- the number of the grammar's start symbol.
    
        keywords      -- a dict mapping keyword strings to arc labels.
    
        tokens        -- a dict mapping token numbers to arc labels.
    """
    def dump(self, *args, **kwargs): # real signature unknown
        """ Dump the grammar tables to a pickle file. """
        pass

    def load(self, *args, **kwargs): # real signature unknown
        """ Load the grammar tables from a pickle file. """
        pass

    def report(self, *args, **kwargs): # real signature unknown
        """ Dump the grammar tables to standard output, for debugging. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

opmap = {
    '!=': 29,
    '%': 24,
    '%=': 41,
    '&': 19,
    '&=': 42,
    '(': 7,
    ')': 8,
    '*': 16,
    '**': 36,
    '**=': 47,
    '*=': 39,
    '+': 14,
    '+=': 37,
    ',': 12,
    '-': 15,
    '-=': 38,
    '->': 54,
    '.': 23,
    '/': 17,
    '//': 48,
    '//=': 49,
    '/=': 40,
    ':': 11,
    ';': 13,
    '<': 20,
    '<<': 34,
    '<<=': 45,
    '<=': 30,
    '<>': 29,
    '=': 22,
    '==': 28,
    '>': 21,
    '>=': 31,
    '>>': 35,
    '>>=': 46,
    '@': 50,
    '[': 9,
    ']': 10,
    '^': 33,
    '^=': 44,
    '`': 25,
    '{': 26,
    '|': 18,
    '|=': 43,
    '}': 27,
    '~': 32,
}

