# encoding: utf-8
# module lib2to3.pgen2.parse
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/parse.pyo by generator 1.99
"""
Parser engine for the grammar tables generated by pgen.

The grammar table must be loaded first.

See Parser/parser.c in the Python distribution for additional info on
how this parsing engine works.
"""

# imports
import lib2to3.pgen2.token as token # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/token.pyc

# no functions
# classes

class ParseError(Exception):
    """ Exception to signal the parser is stuck. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class Parser(object):
    """
    Parser engine.
    
        The proper usage sequence is:
    
        p = Parser(grammar, [converter])  # create instance
        p.setup([start])                  # prepare for parsing
        <for each input token>:
            if p.addtoken(...):           # parse a token; may raise ParseError
                break
        root = p.rootnode                 # root of abstract syntax tree
    
        A Parser instance may be reused by calling setup() repeatedly.
    
        A Parser instance contains state pertaining to the current token
        sequence, and should not be used concurrently by different threads
        to parse separate token sequences.
    
        See driver.py for how to get input tokens by tokenizing a file or
        string.
    
        Parsing is complete when addtoken() returns True; the root of the
        abstract syntax tree can then be retrieved from the rootnode
        instance variable.  When a syntax error occurs, addtoken() raises
        the ParseError exception.  There is no error recovery; the parser
        cannot be used after a syntax error was reported (but it can be
        reinitialized by calling setup()).
    """
    def addtoken(self, *args, **kwargs): # real signature unknown
        """ Add a token; return True iff this is the end of the program. """
        pass

    def classify(self, *args, **kwargs): # real signature unknown
        """ Turn a token into a label.  (Internal) """
        pass

    def pop(self, *args, **kwargs): # real signature unknown
        """ Pop a nonterminal.  (Internal) """
        pass

    def push(self, *args, **kwargs): # real signature unknown
        """ Push a nonterminal.  (Internal) """
        pass

    def setup(self): # real signature unknown; restored from __doc__
        """
        Prepare for parsing.
        
                This *must* be called before starting to parse.
        
                The optional argument is an alternative start symbol; it
                defaults to the grammar's start symbol.
        
                You can use a Parser instance to parse any number of programs;
                each time you call setup() the parser is reset to an initial
                state determined by the (implicit or explicit) start symbol.
        """
        pass

    def shift(self, *args, **kwargs): # real signature unknown
        """ Shift a token.  (Internal) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Constructor.
        
                The grammar argument is a grammar.Grammar instance; see the
                grammar module for more information.
        
                The parser is not ready yet for parsing; you must call the
                setup() method to get it started.
        
                The optional convert argument is a function mapping concrete
                syntax tree nodes to abstract syntax tree nodes.  If not
                given, no conversion is done and the syntax tree produced is
                the concrete syntax tree.  If given, it must be a function of
                two arguments, the first being the grammar (a grammar.Grammar
                instance), and the second being the concrete syntax tree node
                to be converted.  The syntax tree is converted from the bottom
                up.
        
                A concrete syntax tree node is a (type, value, context, nodes)
                tuple, where type is the node type (a token or symbol number),
                value is None for symbols and a string for tokens, context is
                None or an opaque value used for error reporting (typically a
                (lineno, offset) pair), and nodes is a list of children for
                symbols, and None for tokens.
        
                An abstract syntax tree node may be anything; this is entirely
                up to the converter function.
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


