# encoding: utf-8
# module lib2to3.pgen2.tokenize
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib2to3/pgen2/tokenize.pyo by generator 1.99
"""
Tokenization help for Python programs.

generate_tokens(readline) is a generator that breaks a stream of
text into Python tokens.  It accepts a readline-like method which is called
repeatedly to get the next line of input (or "" for EOF).  It generates
5-tuples with these members:

    the token type (see token.py)
    the token (a string)
    the starting (row, column) indices of the token (a 2-tuple of ints)
    the ending (row, column) indices of the token (a 2-tuple of ints)
    the original line (string)

It is designed to match the working of the Python tokenizer exactly, except
that it produces COMMENT tokens for comments and gives type OP for all
operators

Older entry points
    tokenize_loop(readline, tokeneater)
    tokenize(readline, tokeneater=printtoken)
are the same, except instead of generating tokens, tokeneater is a callback
function to which the 5 fields described above are passed as 5 arguments,
each time a new token is found.
"""

# imports
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/string.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc

# Variables with simple values

AMPER = 19
AMPEREQUAL = 42

AT = 50

BACKQUOTE = 25

Binnumber = '0[bB][01]*'

Bracket = '[][(){}]'

CIRCUMFLEX = 33
CIRCUMFLEXEQUAL = 44

COLON = 11
COMMA = 12
COMMENT = 52

Comment = '#[^\\r\\n]*'
ContStr = '([uUbB]?[rR]?\'[^\\n\'\\\\]*(?:\\\\.[^\\n\'\\\\]*)*(\'|\\\\\\r?\\n)|[uUbB]?[rR]?"[^\\n"\\\\]*(?:\\\\.[^\\n"\\\\]*)*("|\\\\\\r?\\n))'

Decnumber = '[1-9]\\d*[lL]?'

DEDENT = 6

DOT = 23

Double = '[^"\\\\]*(?:\\\\.[^"\\\\]*)*"'
Double3 = '[^"\\\\]*(?:(?:\\\\.|"(?!""))[^"\\\\]*)*"""'

DOUBLESLASH = 48
DOUBLESLASHEQUAL = 49
DOUBLESTAR = 36
DOUBLESTAREQUAL = 47

ENDMARKER = 0

EQEQUAL = 28
EQUAL = 22

ERRORTOKEN = 55

Expfloat = '\\d+[eE][-+]?\\d+'
Exponent = '[eE][-+]?\\d+'

Floatnumber = '((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)'

Funny = '((\\*\\*=?|>>=?|<<=?|<>|!=|//=?|->|[+\\-*/%&|^=<>]=?|~)|[][(){}]|(\\r?\\n|[:;.,`@]))'

GREATER = 21
GREATEREQUAL = 31

Hexnumber = '0[xX][\\da-fA-F]*[lL]?'

Ignore = '[ \\f\\t]*(\\\\\\r?\\n[ \\f\\t]*)*(#[^\\r\\n]*)?'

Imagnumber = '(\\d+[jJ]|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)[jJ])'

INDENT = 5

Intnumber = '(0[bB][01]*|0[xX][\\da-fA-F]*[lL]?|0[oO]?[0-7]*[lL]?|[1-9]\\d*[lL]?)'

LBRACE = 26

LEFTSHIFT = 34
LEFTSHIFTEQUAL = 45
LESS = 20
LESSEQUAL = 30

LPAR = 7

LSQB = 9

MINEQUAL = 38
MINUS = 15

NAME = 1

Name = '[a-zA-Z_]\\w*'

NEWLINE = 4

NL = 53

NOTEQUAL = 29

NT_OFFSET = 256

NUMBER = 2

Number = '((\\d+[jJ]|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)[jJ])|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)|(0[bB][01]*|0[xX][\\da-fA-F]*[lL]?|0[oO]?[0-7]*[lL]?|[1-9]\\d*[lL]?))'

N_TOKENS = 56

Octnumber = '0[oO]?[0-7]*[lL]?'

OP = 51

Operator = '(\\*\\*=?|>>=?|<<=?|<>|!=|//=?|->|[+\\-*/%&|^=<>]=?|~)'

PERCENT = 24
PERCENTEQUAL = 41

PlainToken = '(((\\d+[jJ]|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)[jJ])|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)|(0[bB][01]*|0[xX][\\da-fA-F]*[lL]?|0[oO]?[0-7]*[lL]?|[1-9]\\d*[lL]?))|((\\*\\*=?|>>=?|<<=?|<>|!=|//=?|->|[+\\-*/%&|^=<>]=?|~)|[][(){}]|(\\r?\\n|[:;.,`@]))|([uU]?[rR]?\'[^\\n\'\\\\]*(?:\\\\.[^\\n\'\\\\]*)*\'|[uU]?[rR]?"[^\\n"\\\\]*(?:\\\\.[^\\n"\\\\]*)*")|[a-zA-Z_]\\w*)'

PLUS = 14
PLUSEQUAL = 37

Pointfloat = '(\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?'

PseudoExtras = '(\\\\\\r?\\n|#[^\\r\\n]*|([ubUB]?[rR]?\'\'\'|[ubUB]?[rR]?"""))'
PseudoToken = '[ \\f\\t]*((\\\\\\r?\\n|#[^\\r\\n]*|([ubUB]?[rR]?\'\'\'|[ubUB]?[rR]?"""))|((\\d+[jJ]|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)[jJ])|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)|(0[bB][01]*|0[xX][\\da-fA-F]*[lL]?|0[oO]?[0-7]*[lL]?|[1-9]\\d*[lL]?))|((\\*\\*=?|>>=?|<<=?|<>|!=|//=?|->|[+\\-*/%&|^=<>]=?|~)|[][(){}]|(\\r?\\n|[:;.,`@]))|([uUbB]?[rR]?\'[^\\n\'\\\\]*(?:\\\\.[^\\n\'\\\\]*)*(\'|\\\\\\r?\\n)|[uUbB]?[rR]?"[^\\n"\\\\]*(?:\\\\.[^\\n"\\\\]*)*("|\\\\\\r?\\n))|[a-zA-Z_]\\w*)'

RARROW = 54

RBRACE = 27

RIGHTSHIFT = 35
RIGHTSHIFTEQUAL = 46

RPAR = 8

RSQB = 10

SEMI = 13

Single = "[^'\\\\]*(?:\\\\.[^'\\\\]*)*'"
Single3 = "[^'\\\\]*(?:(?:\\\\.|'(?!''))[^'\\\\]*)*'''"

SLASH = 17
SLASHEQUAL = 40

Special = '(\\r?\\n|[:;.,`@])'

STAR = 16
STAREQUAL = 39

String = '([uU]?[rR]?\'[^\\n\'\\\\]*(?:\\\\.[^\\n\'\\\\]*)*\'|[uU]?[rR]?"[^\\n"\\\\]*(?:\\\\.[^\\n"\\\\]*)*")'

STRING = 3
t = 'BR"'

tabsize = 8

TILDE = 32

Token = '[ \\f\\t]*(\\\\\\r?\\n[ \\f\\t]*)*(#[^\\r\\n]*)?(((\\d+[jJ]|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)[jJ])|((\\d+\\.\\d*|\\.\\d+)([eE][-+]?\\d+)?|\\d+[eE][-+]?\\d+)|(0[bB][01]*|0[xX][\\da-fA-F]*[lL]?|0[oO]?[0-7]*[lL]?|[1-9]\\d*[lL]?))|((\\*\\*=?|>>=?|<<=?|<>|!=|//=?|->|[+\\-*/%&|^=<>]=?|~)|[][(){}]|(\\r?\\n|[:;.,`@]))|([uU]?[rR]?\'[^\\n\'\\\\]*(?:\\\\.[^\\n\'\\\\]*)*\'|[uU]?[rR]?"[^\\n"\\\\]*(?:\\\\.[^\\n"\\\\]*)*")|[a-zA-Z_]\\w*)'

Triple = '([ubUB]?[rR]?\'\'\'|[ubUB]?[rR]?""")'

VBAR = 18
VBAREQUAL = 43

Whitespace = '[ \\f\\t]*'
x = 'tok_name'

__author__ = 'Ka-Ping Yee <ping@lfw.org>'

__credits__ = 'GvR, ESR, Tim Peters, Thomas Wouters, Fred Drake, Skip Montanaro'

# functions

def any(*choices): # reliably restored by inspect
    # no doc
    pass


def generate_tokens(readline): # reliably restored by inspect
    """
    The generate_tokens() generator requires one argment, readline, which
        must be a callable object which provides the same interface as the
        readline() method of built-in file objects. Each call to the function
        should return one line of input as a string.  Alternately, readline
        can be a callable function terminating with StopIteration:
            readline = open(myfile).next    # Example of alternate readline
    
        The generator produces 5-tuples with these members: the token type; the
        token string; a 2-tuple (srow, scol) of ints specifying the row and
        column where the token begins in the source; a 2-tuple (erow, ecol) of
        ints specifying the row and column where the token ends in the source;
        and the line on which the token was found. The line passed is the
        logical line; continuation lines are included.
    """
    pass


def group(*choices): # reliably restored by inspect
    # no doc
    pass


def ISEOF(x): # reliably restored by inspect
    # no doc
    pass


def ISNONTERMINAL(x): # reliably restored by inspect
    # no doc
    pass


def ISTERMINAL(x): # reliably restored by inspect
    # no doc
    pass


def maybe(*choices): # reliably restored by inspect
    # no doc
    pass


def printtoken(type, token, (srow, scol), (erow, ecol), line): # reliably restored by inspect
    # no doc
    pass


def tokenize(readline, tokeneater='<function printtoken at 0x100526410>'): # reliably restored by inspect
    """
    The tokenize() function accepts two parameters: one representing the
        input stream, and one providing an output mechanism for tokenize().
    
        The first parameter, readline, must be a callable object which provides
        the same interface as the readline() method of built-in file objects.
        Each call to the function should return one line of input as a string.
    
        The second parameter, tokeneater, must also be a callable object. It is
        called once for each token, with five arguments, corresponding to the
        tuples generated by generate_tokens().
    """
    pass


def tokenize_loop(readline, tokeneater): # reliably restored by inspect
    # no doc
    pass


def untokenize(iterable): # reliably restored by inspect
    """
    Transform tokens back into Python source code.
    
        Each element returned by the iterable must be a token sequence
        with at least two elements, a token number and token value.  If
        only two tokens are passed, the resulting output is poor.
    
        Round-trip invariant for full input:
            Untokenized source will match input source exactly
    
        Round-trip invariant for limited intput:
            # Output text will tokenize the back to the input
            t1 = [tok[:2] for tok in generate_tokens(f.readline)]
            newcode = untokenize(t1)
            readline = iter(newcode.splitlines(1)).next
            t2 = [tok[:2] for tokin generate_tokens(readline)]
            assert t1 == t2
    """
    pass


# classes

class StopTokenizing(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class TokenError(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

double3prog = None # (!) real value is ''

endprogs = {
    '"': None, # (!) real value is ''
    '"""': double3prog,
    "'": None, # (!) real value is ''
    "'''": None, # (!) forward: single3prog, real value is ''
    'B': None,
    'B"""': '<value is a self-reference, replaced by this string>',
    "B'''": '<value is a self-reference, replaced by this string>',
    'BR"""': '<value is a self-reference, replaced by this string>',
    "BR'''": '<value is a self-reference, replaced by this string>',
    'Br"""': '<value is a self-reference, replaced by this string>',
    "Br'''": '<value is a self-reference, replaced by this string>',
    'R': None,
    'R"""': '<value is a self-reference, replaced by this string>',
    "R'''": '<value is a self-reference, replaced by this string>',
    'U': None,
    'U"""': '<value is a self-reference, replaced by this string>',
    "U'''": '<value is a self-reference, replaced by this string>',
    'UR"""': '<value is a self-reference, replaced by this string>',
    "UR'''": '<value is a self-reference, replaced by this string>',
    'Ur"""': '<value is a self-reference, replaced by this string>',
    "Ur'''": '<value is a self-reference, replaced by this string>',
    'b': None,
    'b"""': '<value is a self-reference, replaced by this string>',
    "b'''": '<value is a self-reference, replaced by this string>',
    'bR"""': '<value is a self-reference, replaced by this string>',
    "bR'''": '<value is a self-reference, replaced by this string>',
    'br"""': '<value is a self-reference, replaced by this string>',
    "br'''": '<value is a self-reference, replaced by this string>',
    'r': None,
    'r"""': '<value is a self-reference, replaced by this string>',
    "r'''": '<value is a self-reference, replaced by this string>',
    'u': None,
    'u"""': '<value is a self-reference, replaced by this string>',
    "u'''": '<value is a self-reference, replaced by this string>',
    'uR"""': '<value is a self-reference, replaced by this string>',
    "uR'''": '<value is a self-reference, replaced by this string>',
    'ur"""': '<value is a self-reference, replaced by this string>',
    "ur'''": '<value is a self-reference, replaced by this string>',
}

pseudoprog = None # (!) real value is ''

single3prog = None # (!) real value is ''

single_quoted = {
    '"': '"',
    "'": "'",
    'B"': 'B"',
    "B'": "B'",
    'BR"': 'BR"',
    "BR'": "BR'",
    'Br"': 'Br"',
    "Br'": "Br'",
    'R"': 'R"',
    "R'": "R'",
    'U"': 'U"',
    "U'": "U'",
    'UR"': 'UR"',
    "UR'": "UR'",
    'Ur"': 'Ur"',
    "Ur'": "Ur'",
    'b"': 'b"',
    "b'": "b'",
    'bR"': 'bR"',
    "bR'": "bR'",
    'br"': 'br"',
    "br'": "br'",
    'r"': 'r"',
    "r'": "r'",
    'u"': 'u"',
    "u'": "u'",
    'uR"': 'uR"',
    "uR'": "uR'",
    'ur"': 'ur"',
    "ur'": "ur'",
}

tokenprog = None # (!) real value is ''

tok_name = {
    0: 'ENDMARKER',
    1: 'NAME',
    2: 'NUMBER',
    3: 'STRING',
    4: 'NEWLINE',
    5: 'INDENT',
    6: 'DEDENT',
    7: 'LPAR',
    8: 'RPAR',
    9: 'LSQB',
    10: 'RSQB',
    11: 'COLON',
    12: 'COMMA',
    13: 'SEMI',
    14: 'PLUS',
    15: 'MINUS',
    16: 'STAR',
    17: 'SLASH',
    18: 'VBAR',
    19: 'AMPER',
    20: 'LESS',
    21: 'GREATER',
    22: 'EQUAL',
    23: 'DOT',
    24: 'PERCENT',
    25: 'BACKQUOTE',
    26: 'LBRACE',
    27: 'RBRACE',
    28: 'EQEQUAL',
    29: 'NOTEQUAL',
    30: 'LESSEQUAL',
    31: 'GREATEREQUAL',
    32: 'TILDE',
    33: 'CIRCUMFLEX',
    34: 'LEFTSHIFT',
    35: 'RIGHTSHIFT',
    36: 'DOUBLESTAR',
    37: 'PLUSEQUAL',
    38: 'MINEQUAL',
    39: 'STAREQUAL',
    40: 'SLASHEQUAL',
    41: 'PERCENTEQUAL',
    42: 'AMPEREQUAL',
    43: 'VBAREQUAL',
    44: 'CIRCUMFLEXEQUAL',
    45: 'LEFTSHIFTEQUAL',
    46: 'RIGHTSHIFTEQUAL',
    47: 'DOUBLESTAREQUAL',
    48: 'DOUBLESLASH',
    49: 'DOUBLESLASHEQUAL',
    50: 'AT',
    51: 'OP',
    52: 'COMMENT',
    53: 'NL',
    54: 'RARROW',
    55: 'ERRORTOKEN',
    56: 'N_TOKENS',
    256: 'NT_OFFSET',
}

triple_quoted = {
    '"""': '"""',
    "'''": "'''",
    'B"""': 'B"""',
    "B'''": "B'''",
    'BR"""': 'BR"""',
    "BR'''": "BR'''",
    'Br"""': 'Br"""',
    "Br'''": "Br'''",
    'R"""': 'R"""',
    "R'''": "R'''",
    'U"""': 'U"""',
    "U'''": "U'''",
    'UR"""': 'UR"""',
    "UR'''": "UR'''",
    'Ur"""': 'Ur"""',
    "Ur'''": "Ur'''",
    'b"""': 'b"""',
    "b'''": "b'''",
    'bR"""': 'bR"""',
    "bR'''": "bR'''",
    'br"""': 'br"""',
    "br'''": "br'''",
    'r"""': 'r"""',
    "r'''": "r'''",
    'u"""': 'u"""',
    "u'''": "u'''",
    'uR"""': 'uR"""',
    "uR'''": "uR'''",
    'ur"""': 'ur"""',
    "ur'''": "ur'''",
}

Untokenizer = None # (!) real value is ''

__all__ = [
    'AMPER',
    'AMPEREQUAL',
    'AT',
    'BACKQUOTE',
    'CIRCUMFLEX',
    'CIRCUMFLEXEQUAL',
    'COLON',
    'COMMA',
    'COMMENT',
    'DEDENT',
    'DOT',
    'DOUBLESLASH',
    'DOUBLESLASHEQUAL',
    'DOUBLESTAR',
    'DOUBLESTAREQUAL',
    'ENDMARKER',
    'EQEQUAL',
    'EQUAL',
    'ERRORTOKEN',
    'GREATER',
    'GREATEREQUAL',
    'INDENT',
    'ISEOF',
    'ISNONTERMINAL',
    'ISTERMINAL',
    'LBRACE',
    'LEFTSHIFT',
    'LEFTSHIFTEQUAL',
    'LESS',
    'LESSEQUAL',
    'LPAR',
    'LSQB',
    'MINEQUAL',
    'MINUS',
    'NAME',
    'NEWLINE',
    'NL',
    'NOTEQUAL',
    'NT_OFFSET',
    'NUMBER',
    'N_TOKENS',
    'OP',
    'PERCENT',
    'PERCENTEQUAL',
    'PLUS',
    'PLUSEQUAL',
    'RARROW',
    'RBRACE',
    'RIGHTSHIFT',
    'RIGHTSHIFTEQUAL',
    'RPAR',
    'RSQB',
    'SEMI',
    'SLASH',
    'SLASHEQUAL',
    'STAR',
    'STAREQUAL',
    'STRING',
    'TILDE',
    'VBAR',
    'VBAREQUAL',
    'tok_name',
    'tokenize',
    'generate_tokens',
    'untokenize',
]

