# encoding: utf-8
# module logging.config
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/logging/config.pyo by generator 1.99
"""
Configuration functions for the logging package for Python. The core package
is based on PEP 282 and comments thereto in comp.lang.python, and influenced
by Apache's log4j system.

Should work under Python versions >= 1.5.2, except that source line
information is not available unless 'sys._getframe()' is.

Copyright (C) 2001-2008 Vinay Sajip. All Rights Reserved.

To use, simply 'import logging' and log away!
"""

# imports
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/struct.pyc
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/string.pyc
import sys as sys # <module 'sys' (built-in)>
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/types.pyc
import logging as logging # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/logging/__init__.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/socket.pyc
import thread as thread # <module 'thread' (built-in)>
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/traceback.pyc
import threading as threading # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/threading.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

DEFAULT_LOGGING_CONFIG_PORT = 9030

RESET_ERROR = 104

_listener = None

# functions

def fileConfig(fname, defaults=None, disable_existing_loggers=1): # reliably restored by inspect
    """
    Read the logging configuration from a ConfigParser-format file.
    
        This can be called several times from an application, allowing an end user
        the ability to select from various pre-canned configurations (if the
        developer provides a mechanism to present the choices and load the chosen
        configuration).
        In versions of ConfigParser which have the readfp method [typically
        shipped in 2.x versions of Python], you can pass in a file-like object
        rather than a filename, in which case the file-like object will be read
        using readfp.
    """
    pass


def listen(port=9030): # reliably restored by inspect
    """
    Start up a socket server on the specified port, and listen for new
        configurations.
    
        These will be sent as a file suitable for processing by fileConfig().
        Returns a Thread object on which you can call start() to start the server,
        and which you can join() when appropriate. To stop the server, call
        stopListening().
    """
    pass


def stopListening(): # reliably restored by inspect
    """ Stop the listening server which was created with a call to listen(). """
    pass


def _create_formatters(cp): # reliably restored by inspect
    """ Create and return formatters """
    pass


def _install_handlers(cp, formatters): # reliably restored by inspect
    """ Install and return handlers """
    pass


def _install_loggers(cp, handlers, disable_existing_loggers): # reliably restored by inspect
    """ Create and install loggers """
    pass


def _resolve(name): # reliably restored by inspect
    """ Resolve a dotted name to a global object. """
    pass


def _strip_spaces(alist): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

StreamRequestHandler = None # (!) real value is ''

ThreadingTCPServer = None # (!) real value is ''

