# encoding: utf-8
# module mhlib
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/mhlib.pyo by generator 1.99
"""
MH interface -- purely object-oriented (well, almost)

Executive summary:

import mhlib

mh = mhlib.MH()         # use default mailbox directory and profile
mh = mhlib.MH(mailbox)  # override mailbox location (default from profile)
mh = mhlib.MH(mailbox, profile) # override mailbox and profile

mh.error(format, ...)   # print error message -- can be overridden
s = mh.getprofile(key)  # profile entry (None if not set)
path = mh.getpath()     # mailbox pathname
name = mh.getcontext()  # name of current folder
mh.setcontext(name)     # set name of current folder

list = mh.listfolders() # names of top-level folders
list = mh.listallfolders() # names of all folders, including subfolders
list = mh.listsubfolders(name) # direct subfolders of given folder
list = mh.listallsubfolders(name) # all subfolders of given folder

mh.makefolder(name)     # create new folder
mh.deletefolder(name)   # delete folder -- must have no subfolders

f = mh.openfolder(name) # new open folder object

f.error(format, ...)    # same as mh.error(format, ...)
path = f.getfullname()  # folder's full pathname
path = f.getsequencesfilename() # full pathname of folder's sequences file
path = f.getmessagefilename(n)  # full pathname of message n in folder

list = f.listmessages() # list of messages in folder (as numbers)
n = f.getcurrent()      # get current message
f.setcurrent(n)         # set current message
list = f.parsesequence(seq)     # parse msgs syntax into list of messages
n = f.getlast()         # get last message (0 if no messagse)
f.setlast(n)            # set last message (internal use only)

dict = f.getsequences() # dictionary of sequences in folder {name: list}
f.putsequences(dict)    # write sequences back to folder

f.createmessage(n, fp)  # add message from file f as number n
f.removemessages(list)  # remove messages in list from folder
f.refilemessages(list, tofolder) # move messages in list to other folder
f.movemessage(n, tofolder, ton)  # move one message to a given destination
f.copymessage(n, tofolder, ton)  # copy one message to a given destination

m = f.openmessage(n)    # new open message object (costs a file descriptor)
m is a derived class of mimetools.Message(rfc822.Message), with:
s = m.getheadertext()   # text of message's headers
s = m.getheadertext(pred) # text of message's headers, filtered by pred
s = m.getbodytext()     # text of message's body, decoded
s = m.getbodytext(0)    # text of message's body, not decoded
"""

# imports
import mimetools as mimetools # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/mimetools.pyc
import shutil as shutil # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/shutil.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import sys as sys # <module 'sys' (built-in)>
import multifile as multifile # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/multifile.pyc
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
from _bisect import bisect


# Variables with simple values

FOLDER_PROTECT = 448

MH_PROFILE = '~/.mh_profile'
MH_SEQUENCES = '.mh_sequences'

PATH = '~/Mail'

# functions

def isnumeric(str): # reliably restored by inspect
    # no doc
    pass


def pickline(file, key, casefold=1): # reliably restored by inspect
    # no doc
    pass


def test(): # reliably restored by inspect
    # no doc
    pass


def updateline(file, key, value, casefold=1): # reliably restored by inspect
    # no doc
    pass


# classes

class Error(Exception):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

Folder = None # (!) real value is ''

IntSet = None # (!) real value is ''

Message = None # (!) real value is ''

MH = None # (!) real value is ''

numericprog = None # (!) real value is ''

SubMessage = None # (!) real value is ''

__all__ = [
    'MH',
    'Error',
    'Folder',
    'Message',
]

__warningregistry__ = {
    (
        'the multifile module has been deprecated since Python 2.5',
        DeprecationWarning,
        83,
    ): 
        True
    ,
}

