# encoding: utf-8
# module nntplib
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/nntplib.pyo by generator 1.99
"""
An NNTP client class based on RFC 977: Network News Transfer Protocol.

Example:

>>> from nntplib import NNTP
>>> s = NNTP('news')
>>> resp, count, first, last, name = s.group('comp.lang.python')
>>> print 'Group', name, 'has', count, 'articles, range', first, 'to', last
Group comp.lang.python has 51 articles, range 5770 to 5821
>>> resp, subs = s.xhdr('subject', first + '-' + last)
>>> resp = s.quit()
>>>

Here 'resp' is the server response line.
Error responses are turned into exceptions.

To post an article from a file:
>>> f = open(filename, 'r') # file containing article, including header
>>> resp = s.post(f)
>>>

For descriptions of all methods, read the comments in the code below.
Note that all arguments and return values representing article numbers
are strings, not numbers, since they are rarely used for calculations.
"""

# imports
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/socket.pyc

# Variables with simple values

CRLF = '\r\n'

NNTP_PORT = 119

# no functions
# classes

class NNTPError(Exception):
    """ Base class for all nntplib exceptions """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class NNTPDataError(NNTPError):
    """ Error in response data """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


error_data = NNTPDataError


class NNTPPermanentError(NNTPError):
    """ 5xx errors """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


error_perm = NNTPPermanentError


class NNTPProtocolError(NNTPError):
    """ Response does not begin with [1-5] """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


error_proto = NNTPProtocolError


class NNTPReplyError(NNTPError):
    """ Unexpected [123]xx reply """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


error_reply = NNTPReplyError


class NNTPTemporaryError(NNTPError):
    """ 4xx errors """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


error_temp = NNTPTemporaryError


# variables with complex values

LONGRESP = [
    '100',
    '215',
    '220',
    '221',
    '222',
    '224',
    '230',
    '231',
    '282',
]

NNTP = None # (!) real value is ''

__all__ = [
    'NNTP',
    'NNTPReplyError',
    'NNTPTemporaryError',
    'NNTPPermanentError',
    'NNTPProtocolError',
    'NNTPDataError',
    'error_reply',
    'error_temp',
    'error_perm',
    'error_proto',
    'error_data',
]

