# encoding: utf-8
# module numbers
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/numbers.pyo by generator 1.99
"""
Abstract Base Classes (ABCs) for numbers, according to PEP 3141.

TODO: Fill out more detailed documentation on the operators.
"""
# no imports

# functions

def abstractmethod(funcobj): # reliably restored by inspect
    """
    A decorator indicating abstract methods.
    
        Requires that the metaclass is ABCMeta or derived from it.  A
        class that has a metaclass derived from ABCMeta cannot be
        instantiated unless all of its abstract methods are overridden.
        The abstract methods can be called using any of the the normal
        'super' call mechanisms.
    
        Usage:
    
            class C(metaclass=ABCMeta):
                @abstractmethod
                def my_abstract_method(self, ...):
                    ...
    """
    pass


# classes

class ABCMeta(type):
    """
    Metaclass for defining Abstract Base Classes (ABCs).
    
        Use this metaclass to create an ABC.  An ABC can be subclassed
        directly, and then acts as a mix-in class.  You can also register
        unrelated concrete classes (even built-in classes) and unrelated
        ABCs as 'virtual subclasses' -- these and their descendants will
        be considered subclasses of the registering ABC by the built-in
        issubclass() function, but the registering ABC won't show up in
        their MRO (Method Resolution Order) nor will method
        implementations defined by the registering ABC be callable (not
        even via super()).
    """
    def register(self, *args, **kwargs): # real signature unknown
        """ Register a virtual subclass of an ABC. """
        pass

    def _dump_registry(self, *args, **kwargs): # real signature unknown
        """ Debug helper to print the ABC registry. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __instancecheck__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(mcls, name, bases, namespace): # reliably restored by inspect
        # no doc
        pass

    def __subclasscheck__(self, *args, **kwargs): # real signature unknown
        pass

    _abc_invalidation_counter = 13


class abstractproperty(property):
    """
    A decorator indicating abstract properties.
    
        Requires that the metaclass is ABCMeta or derived from it.  A
        class that has a metaclass derived from ABCMeta cannot be
        instantiated unless all of its abstract properties are overridden.
        The abstract properties can be called using any of the the normal
        'super' call mechanisms.
    
        Usage:
    
            class C(metaclass=ABCMeta):
                @abstractproperty
                def my_abstract_property(self):
                    ...
    
        This defines a read-only property; you can also define a read-write
        abstract property using the 'long' form of property declaration:
    
            class C(metaclass=ABCMeta):
                def getx(self): ...
                def setx(self, value): ...
                x = abstractproperty(getx, setx)
    """
    def __init__(self, getx, setx): # real signature unknown; restored from __doc__
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''
    __isabstractmethod__ = True


class Number(object):
    """
    All numbers inherit from this class.
    
        If you just want to check if an argument x is a number, without
        caring what kind, use isinstance(x, Number).
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __metaclass__(self, *args, **kwargs): # real signature unknown
        """
        Metaclass for defining Abstract Base Classes (ABCs).
        
            Use this metaclass to create an ABC.  An ABC can be subclassed
            directly, and then acts as a mix-in class.  You can also register
            unrelated concrete classes (even built-in classes) and unrelated
            ABCs as 'virtual subclasses' -- these and their descendants will
            be considered subclasses of the registering ABC by the built-in
            issubclass() function, but the registering ABC won't show up in
            their MRO (Method Resolution Order) nor will method
            implementations defined by the registering ABC be callable (not
            even via super()).
        """
        pass

    __weakref__ = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 9
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''
    __dict__ = None # (!) real value is ''
    __hash__ = None


class Complex(Number):
    """
    Complex defines the operations that work on the builtin complex type.
    
        In short, those are: a conversion to complex, .real, .imag, +, -,
        *, /, abs(), .conjugate, ==, and !=.
    
        If it is given heterogenous arguments, and doesn't have special
        knowledge about them, it should fall back to the builtin complex
        type as described below.
    """
    def conjugate(self): # real signature unknown; restored from __doc__
        """ (x+y*i).conjugate() returns (x-y*i). """
        pass

    def __abs__(self, *args, **kwargs): # real signature unknown
        """ Returns the Real distance from 0. Called for abs(self). """
        pass

    def __add__(self, *args, **kwargs): # real signature unknown
        """ self + other """
        pass

    def __complex__(self, *args, **kwargs): # real signature unknown
        """ Return a builtin complex instance. Called for complex(self). """
        pass

    def __div__(self, *args, **kwargs): # real signature unknown
        """
        self / other without __future__ division
        
                May promote to float.
        """
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        """ self == other """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __mul__(self, *args, **kwargs): # real signature unknown
        """ self * other """
        pass

    def __neg__(self, *args, **kwargs): # real signature unknown
        """ -self """
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        """ self != other """
        pass

    def __nonzero__(self, *args, **kwargs): # real signature unknown
        """ True if self != 0. Called for bool(self). """
        pass

    def __pos__(self, *args, **kwargs): # real signature unknown
        """ +self """
        pass

    def __pow__(self, *args, **kwargs): # real signature unknown
        """ self**exponent; should promote to float or complex when necessary. """
        pass

    def __radd__(self, *args, **kwargs): # real signature unknown
        """ other + self """
        pass

    def __rdiv__(self, *args, **kwargs): # real signature unknown
        """ other / self without __future__ division """
        pass

    def __rmul__(self, *args, **kwargs): # real signature unknown
        """ other * self """
        pass

    def __rpow__(self, *args, **kwargs): # real signature unknown
        """ base ** self """
        pass

    def __rsub__(self, *args, **kwargs): # real signature unknown
        """ other - self """
        pass

    def __rtruediv__(self, *args, **kwargs): # real signature unknown
        """ other / self with __future__ division """
        pass

    def __sub__(self, *args, **kwargs): # real signature unknown
        """ self - other """
        pass

    def __truediv__(self, *args, **kwargs): # real signature unknown
        """
        self / other with __future__ division.
        
                Should promote to float when necessary.
        """
        pass

    imag = property(lambda self: object()) # default
    real = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 9
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Real(Complex):
    """
    To Complex, Real adds the operations that work on real numbers.
    
        In short, those are: a conversion to float, trunc(), divmod,
        %, <, <=, >, and >=.
    
        Real also provides defaults for the derived operations.
    """
    def conjugate(self, *args, **kwargs): # real signature unknown
        """ Conjugate is a no-op for Reals. """
        pass

    def __complex__(self, *args, **kwargs): # real signature unknown
        """ complex(self) == complex(float(self), 0) """
        pass

    def __divmod__(self, *args, **kwargs): # real signature unknown
        """
        divmod(self, other): The pair (self // other, self % other).
        
                Sometimes this can be computed faster than the pair of
                operations.
        """
        pass

    def __float__(self, *args, **kwargs): # real signature unknown
        """
        Any Real can be converted to a native float object.
        
                Called for float(self).
        """
        pass

    def __floordiv__(self, *args, **kwargs): # real signature unknown
        """ self // other: The floor() of self/other. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __le__(self, *args, **kwargs): # real signature unknown
        """ self <= other """
        pass

    def __lt__(self, *args, **kwargs): # real signature unknown
        """
        self < other
        
                < on Reals defines a total ordering, except perhaps for NaN.
        """
        pass

    def __mod__(self, *args, **kwargs): # real signature unknown
        """ self % other """
        pass

    def __rdivmod__(self, *args, **kwargs): # real signature unknown
        """
        divmod(other, self): The pair (self // other, self % other).
        
                Sometimes this can be computed faster than the pair of
                operations.
        """
        pass

    def __rfloordiv__(self, *args, **kwargs): # real signature unknown
        """ other // self: The floor() of other/self. """
        pass

    def __rmod__(self, *args, **kwargs): # real signature unknown
        """ other % self """
        pass

    def __trunc__(self, *args, **kwargs): # real signature unknown
        """
        trunc(self): Truncates self to an Integral.
        
                Returns an Integral i such that:
                  * i>0 iff self>0;
                  * abs(i) <= abs(self);
                  * for any Integral j satisfying the first two conditions,
                    abs(i) >= abs(j) [i.e. i has "maximal" abs among those].
                i.e. "truncate towards 0".
        """
        pass

    imag = property(lambda self: object()) # default
    real = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 10
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Rational(Real):
    """ .numerator and .denominator should be in lowest terms. """
    def __float__(self, *args, **kwargs): # real signature unknown
        """
        float(self) = self.numerator / self.denominator
        
                It's important that this conversion use the integer's "true"
                division rather than casting one side to float before dividing
                so that ratios of huge integers convert without overflowing.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    denominator = property(lambda self: object()) # default
    numerator = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 11
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


class Integral(Rational):
    """ Integral adds a conversion to long and the bit-string operations. """
    def __and__(self, *args, **kwargs): # real signature unknown
        """ self & other """
        pass

    def __float__(self, *args, **kwargs): # real signature unknown
        """ float(self) == float(long(self)) """
        pass

    def __index__(self, *args, **kwargs): # real signature unknown
        """ index(self) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __invert__(self, *args, **kwargs): # real signature unknown
        """ ~self """
        pass

    def __long__(self, *args, **kwargs): # real signature unknown
        """ long(self) """
        pass

    def __lshift__(self, *args, **kwargs): # real signature unknown
        """ self << other """
        pass

    def __or__(self, *args, **kwargs): # real signature unknown
        """ self | other """
        pass

    def __pow__(self, *args, **kwargs): # real signature unknown
        """
        self ** exponent % modulus, but maybe faster.
        
                Accept the modulus argument if you want to support the
                3-argument version of pow(). Raise a TypeError if exponent < 0
                or any argument isn't Integral. Otherwise, just implement the
                2-argument version described in Complex.
        """
        pass

    def __rand__(self, *args, **kwargs): # real signature unknown
        """ other & self """
        pass

    def __rlshift__(self, *args, **kwargs): # real signature unknown
        """ other << self """
        pass

    def __ror__(self, *args, **kwargs): # real signature unknown
        """ other | self """
        pass

    def __rrshift__(self, *args, **kwargs): # real signature unknown
        """ other >> self """
        pass

    def __rshift__(self, *args, **kwargs): # real signature unknown
        """ self >> other """
        pass

    def __rxor__(self, *args, **kwargs): # real signature unknown
        """ other ^ self """
        pass

    def __xor__(self, *args, **kwargs): # real signature unknown
        """ self ^ other """
        pass

    denominator = property(lambda self: object()) # default
    numerator = property(lambda self: object()) # default

    _abc_cache = None # (!) real value is ''
    _abc_negative_cache = None # (!) real value is ''
    _abc_negative_cache_version = 12
    _abc_registry = None # (!) real value is ''
    __abstractmethods__ = None # (!) real value is ''


# variables with complex values

division = None # (!) real value is ''

__all__ = [
    'Number',
    'Complex',
    'Real',
    'Rational',
    'Integral',
]

