# encoding: utf-8
# module numpy.random.mtrand
# from /System/Library/Frameworks/Python.framework/Versions/2.6/Extras/lib/python/numpy/random/mtrand.so by generator 1.99
# no doc

# imports
import numpy as np # /System/Library/Frameworks/Python.framework/Versions/2.6/Extras/lib/python/numpy/__init__.py
import __builtin__ as __builtins__ # <module '__builtin__' (built-in)>

# functions

def beta(a, b, size=None): # real signature unknown; restored from __doc__
    """
    beta(a, b, size=None)
    
            The Beta distribution over ``[0, 1]``.
    
            The Beta distribution is a special case of the Dirichlet distribution,
            and is related to the Gamma distribution.  It has the probability
            distribution function
    
            .. math:: f(x; a,b) = \frac{1}{B(\alpha, \beta)} x^{\alpha - 1}
                                                             (1 - x)^{\beta - 1},
    
            where the normalisation, B, is the beta function,
    
            .. math:: B(\alpha, \beta) = \int_0^1 t^{\alpha - 1}
                                         (1 - t)^{\beta - 1} dt.
    
            It is often seen in Bayesian inference and order statistics.
    
            Parameters
            ----------
            a : float
                Alpha, non-negative.
            b : float
                Beta, non-negative.
            size : tuple of ints, optional
                The number of samples to draw.  The ouput is packed according to
                the size given.
    
            Returns
            -------
            out : ndarray
                Array of the given shape, containing values drawn from a
                Beta distribution.
    """
    pass


def binomial(n, p, size=None): # real signature unknown; restored from __doc__
    """
    binomial(n, p, size=None)
    
            Draw samples from a binomial distribution.
    
            Samples are drawn from a Binomial distribution with specified
            parameters, n trials and p probability of success where
            n an integer > 0 and p is in the interval [0,1]. (n may be
            input as a float, but it is truncated to an integer in use)
    
            Parameters
            ----------
            n : float (but truncated to an integer)
                    parameter, > 0.
            p : float
                    parameter, >= 0 and <=1.
            size : {tuple, int}
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            Returns
            -------
            samples : {ndarray, scalar}
                      where the values are all integers in  [0, n].
    
            See Also
            --------
            scipy.stats.distributions.binom : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Binomial distribution is
    
            .. math:: P(N) = \binom{n}{N}p^N(1-p)^{n-N},
    
            where :math:`n` is the number of trials, :math:`p` is the probability
            of success, and :math:`N` is the number of successes.
    
            When estimating the standard error of a proportion in a population by
            using a random sample, the normal distribution works well unless the
            product p*n <=5, where p = population proportion estimate, and n =
            number of samples, in which case the binomial distribution is used
            instead. For example, a sample of 15 people shows 4 who are left
            handed, and 11 who are right handed. Then p = 4/15 = 27%. 0.27*15 = 4,
            so the binomial distribution should be used in this case.
    
            References
            ----------
            .. [1] Dalgaard, Peter, "Introductory Statistics with R",
                   Springer-Verlag, 2002.
            .. [2] Glantz, Stanton A. "Primer of Biostatistics.", McGraw-Hill,
                   Fifth Edition, 2002.
            .. [3] Lentner, Marvin, "Elementary Applied Statistics", Bogden
                   and Quigley, 1972.
            .. [4] Weisstein, Eric W. "Binomial Distribution." From MathWorld--A
                   Wolfram Web Resource.
                   http://mathworld.wolfram.com/BinomialDistribution.html
            .. [5] Wikipedia, "Binomial-distribution",
                   http://en.wikipedia.org/wiki/Binomial_distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> n, p = 10, .5 # number of trials, probability of each trial
            >>> s = np.random.binomial(n, p, 1000)
            # result of flipping a coin 10 times, tested 1000 times.
    
            A real world example. A company drills 9 wild-cat oil exploration
            wells, each with an estimated probability of success of 0.1. All nine
            wells fail. What is the probability of that happening?
    
            Let's do 20,000 trials of the model, and count the number that
            generate zero positive results.
    
            >>> sum(np.random.binomial(9,0.1,20000)==0)/20000.
            answer = 0.38885, or 38%.
    """
    pass


def bytes(length): # real signature unknown; restored from __doc__
    """
    bytes(length)
    
            Return random bytes.
    
            Parameters
            ----------
            length : int
                Number of random bytes.
    
            Returns
            -------
            out : str
                String of length `N`.
    
            Examples
            --------
            >>> np.random.bytes(10)
            ' eh\x85\x022SZ\xbf\xa4' #random
    """
    pass


def chisquare(df, size=None): # real signature unknown; restored from __doc__
    """
    chisquare(df, size=None)
    
            Draw samples from a chi-square distribution.
    
            When `df` independent random variables, each with standard
            normal distributions (mean 0, variance 1), are squared and summed,
            the resulting distribution is chi-square (see Notes).  This
            distribution is often used in hypothesis testing.
    
            Parameters
            ----------
            df : int
                 Number of degrees of freedom.
            size : tuple of ints, int, optional
                 Size of the returned array.  By default, a scalar is
                 returned.
    
            Returns
            -------
            output : ndarray
                Samples drawn from the distribution, packed in a `size`-shaped
                array.
    
            Raises
            ------
            ValueError
                When `df` <= 0 or when an inappropriate `size` (e.g. ``size=-1``)
                is given.
    
            Notes
            -----
            The variable obtained by summing the squares of `df` independent,
            standard normally distributed random variables:
    
            .. math:: Q = \sum_{i=0}^{\mathtt{df}} X^2_i
    
            is chi-square distributed, denoted
    
            .. math:: Q \sim \chi^2_k.
    
            The probability density function of the chi-squared distribution is
    
            .. math:: p(x) = \frac{(1/2)^{k/2}}{\Gamma(k/2)}
                             x^{k/2 - 1} e^{-x/2},
    
            where :math:`\Gamma` is the gamma function,
    
            .. math:: \Gamma(x) = \int_0^{-\infty} t^{x - 1} e^{-t} dt.
    
            References
            ----------
            .. [1] NIST/SEMATECH e-Handbook of Statistical Methods,
                   http://www.itl.nist.gov/div898/handbook/eda/section3/eda3666.htm
            .. [2] Wikipedia, "Chi-square distribution",
                   http://en.wikipedia.org/wiki/Chi-square_distribution
    
            Examples
            --------
            >>> np.random.chisquare(2,4)
            array([ 1.89920014,  9.00867716,  3.13710533,  5.62318272])
    """
    pass


def dirichlet(alpha, size=None): # real signature unknown; restored from __doc__
    """
    dirichlet(alpha, size=None)
    
            Draw samples from the Dirichlet distribution.
    
            Draw `size` samples of dimension k from a Dirichlet distribution. A
            Dirichlet-distributed random variable can be seen as a multivariate
            generalization of a Beta distribution. Dirichlet pdf is the conjugate
            prior of a multinomial in Bayesian inference.
    
            Parameters
            ----------
            alpha : array
                Parameter of the distribution (k dimension for sample of
                dimension k).
            size : array
                Number of samples to draw.
    
            Notes
            -----
            .. math:: X \approx \prod_{i=1}^{k}{x^{\alpha_i-1}_i}
    
            Uses the following property for computation: for each dimension,
            draw a random sample y_i from a standard gamma generator of shape
            `alpha_i`, then
            :math:`X = \frac{1}{\sum_{i=1}^k{y_i}} (y_1, \ldots, y_n)` is
            Dirichlet distributed.
    
            References
            ----------
            .. [1] David McKay, "Information Theory, Inference and Learning
                   Algorithms," chapter 23,
                   http://www.inference.phy.cam.ac.uk/mackay/
    """
    pass


def exponential(scale=1.0, size=None): # real signature unknown; restored from __doc__
    """
    exponential(scale=1.0, size=None)
    
            Exponential distribution.
    
            Its probability density function is
    
            .. math:: f(x; \lambda) = \lambda \exp(-\lambda x),
    
            for ``x > 0`` and 0 elsewhere.  :math:`lambda` is
            known as the rate parameter.
    
            The exponential distribution is a continuous analogue of the
            geometric distribution.  It describes many common situations, such as
            the size of raindrops measured over many rainstorms [1]_, or the time
            between page requests to Wikipedia [2]_.
    
            Parameters
            ----------
            scale : float
                The rate parameter, :math:`\lambda`.
            size : tuple of ints
                Number of samples to draw.  The output is shaped
                according to `size`.
    
            References
            ----------
            .. [1] Peyton Z. Peebles Jr., "Probability, Random Variables and
                   Random Signal Principles", 4th ed, 2001, p. 57.
            .. [2] "Poisson Process", Wikipedia,
                   http://en.wikipedia.org/wiki/Poisson_process
    """
    pass


def f(dfnum, dfden, size=None): # real signature unknown; restored from __doc__
    """
    f(dfnum, dfden, size=None)
    
            Draw samples from a F distribution.
    
            Samples are drawn from an F distribution with specified parameters,
            `dfnum` (degrees of freedom in numerator) and `dfden` (degrees of freedom
            in denominator), where both parameters should be greater than zero.
    
            The random variate of the F distribution (also known as the
            Fisher distribution) is a continuous probability distribution
            that arises in ANOVA tests, and is the ratio of two chi-square
            variates.
    
            Parameters
            ----------
            dfnum : float
                Degrees of freedom in numerator. Should be greater than zero.
            dfden : float
                Degrees of freedom in denominator. Should be greater than zero.
            size : {tuple, int}, optional
                Output shape.  If the given shape is, e.g., ``(m, n, k)``,
                then ``m * n * k`` samples are drawn. By default only one sample
                is returned.
    
            Returns
            -------
            samples : {ndarray, scalar}
                Samples from the Fisher distribution.
    
            See Also
            --------
            scipy.stats.distributions.f : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
    
            The F statistic is used to compare in-group variances to between-group
            variances. Calculating the distribution depends on the sampling, and
            so it is a function of the respective degrees of freedom in the
            problem.  The variable `dfnum` is the number of samples minus one, the
            between-groups degrees of freedom, while `dfden` is the within-groups
            degrees of freedom, the sum of the number of samples in each group
            minus the number of groups.
    
            References
            ----------
            .. [1] Glantz, Stanton A. "Primer of Biostatistics.", McGraw-Hill,
                   Fifth Edition, 2002.
            .. [2] Wikipedia, "F-distribution",
                   http://en.wikipedia.org/wiki/F-distribution
    
            Examples
            --------
            An example from Glantz[1], pp 47-40.
            Two groups, children of diabetics (25 people) and children from people
            without diabetes (25 controls). Fasting blood glucose was measured,
            case group had a mean value of 86.1, controls had a mean value of
            82.2. Standard deviations were 2.09 and 2.49 respectively. Are these
            data consistent with the null hypothesis that the parents diabetic
            status does not affect their children's blood glucose levels?
            Calculating the F statistic from the data gives a value of 36.01.
    
            Draw samples from the distribution:
    
            >>> dfnum = 1. # between group degrees of freedom
            >>> dfden = 48. # within groups degrees of freedom
            >>> s = np.random.f(dfnum, dfden, 1000)
    
            The lower bound for the top 1% of the samples is :
    
            >>> sort(s)[-10]
            7.61988120985
    
            So there is about a 1% chance that the F statistic will exceed 7.62,
            the measured value is 36, so the null hypothesis is rejected at the 1%
            level.
    """
    pass


def gamma(shape, scale=1.0, size=None): # real signature unknown; restored from __doc__
    """
    gamma(shape, scale=1.0, size=None)
    
            Draw samples from a Gamma distribution.
    
            Samples are drawn from a Gamma distribution with specified parameters,
            `shape` (sometimes designated "k") and `scale` (sometimes designated
            "theta"), where both parameters are > 0.
    
            Parameters
            ----------
            shape : scalar > 0
                The shape of the gamma distribution.
            scale : scalar > 0, optional
                The scale of the gamma distribution.  Default is equal to 1.
            size : shape_tuple, optional
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            Returns
            -------
            out : ndarray, float
                Returns one sample unless `size` parameter is specified.
    
            See Also
            --------
            scipy.stats.distributions.gamma : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Gamma distribution is
    
            .. math:: p(x) = x^{k-1}\frac{e^{-x/\theta}}{\theta^k\Gamma(k)},
    
            where :math:`k` is the shape and :math:`\theta` the scale,
            and :math:`\Gamma` is the Gamma function.
    
            The Gamma distribution is often used to model the times to failure of
            electronic components, and arises naturally in processes for which the
            waiting times between Poisson distributed events are relevant.
    
            References
            ----------
            .. [1] Weisstein, Eric W. "Gamma Distribution." From MathWorld--A
                   Wolfram Web Resource.
                   http://mathworld.wolfram.com/GammaDistribution.html
            .. [2] Wikipedia, "Gamma-distribution",
                   http://en.wikipedia.org/wiki/Gamma-distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> shape, scale = 2., 2. # mean and dispersion
            >>> s = np.random.gamma(shape, scale, 1000)
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> import scipy.special as sps
            >>> count, bins, ignored = plt.hist(s, 50, normed=True)
            >>> y = bins**(shape-1)*((exp(-bins/scale))/\
                (sps.gamma(shape)*scale**shape))
            >>> plt.plot(bins, y, linewidth=2, color='r')
            >>> plt.show()
    """
    pass


def geometric(p, size=None): # real signature unknown; restored from __doc__
    """
    geometric(p, size=None)
    
            Draw samples from the geometric distribution.
    
            Bernoulli trials are experiments with one of two outcomes:
            success or failure (an example of such an experiment is flipping
            a coin).  The geometric distribution models the number of trials
            that must be run in order to achieve success.  It is therefore
            supported on the positive integers, ``k = 1, 2, ...``.
    
            The probability mass function of the geometric distribution is
    
            .. math:: f(k) = (1 - p)^{k - 1} p
    
            where `p` is the probability of success of an individual trial.
    
            Parameters
            ----------
            p : float
                The probability of success of an individual trial.
            size : tuple of ints
                Number of values to draw from the distribution.  The output
                is shaped according to `size`.
    
            Returns
            -------
            out : ndarray
                Samples from the geometric distribution, shaped according to
                `size`.
    
            Examples
            --------
            Draw ten thousand values from the geometric distribution,
            with the probability of an individual success equal to 0.35:
    
            >>> z = np.random.geometric(p=0.35, size=10000)
    
            How many trials succeeded after a single run?
    
            >>> (z == 1).sum() / 10000.
            0.34889999999999999 #random
    """
    pass


def get_state(): # real signature unknown; restored from __doc__
    """
    get_state()
    
            Return a tuple representing the internal state of the generator::
    
                ('MT19937', int key[624], int pos, int has_gauss, float cached_gaussian)
    """
    pass


def gumbel(loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
    """
    gumbel(loc=0.0, scale=1.0, size=None)
    
            Gumbel distribution.
    
            Draw samples from a Gumbel distribution with specified location (or mean)
            and scale (or standard deviation).
    
            The Gumbel (or Smallest Extreme Value (SEV) or the Smallest Extreme Value
            Type I) distribution is one of a class of Generalized Extreme Value (GEV)
            distributions used in modeling extreme value problems.  The Gumbel is a
            special case of the Extreme Value Type I distribution for maximums from
            distributions with "exponential-like" tails, it may be derived by
            considering a Gaussian process of measurements, and generating the pdf for
            the maximum values from that set of measurements (see examples).
    
            Parameters
            ----------
            loc : float
                The location of the mode of the distribution.
            scale : float
                The scale parameter of the distribution.
            size : tuple of ints
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            See Also
            --------
            scipy.stats.gumbel : probability density function,
                distribution or cumulative density function, etc.
            weibull, scipy.stats.genextreme
    
            Notes
            -----
            The probability density for the Gumbel distribution is
    
            .. math:: p(x) = \frac{e^{-(x - \mu)/ \beta}}{\beta} e^{ -e^{-(x - \mu)/
                      \beta}},
    
            where :math:`\mu` is the mode, a location parameter, and :math:`\beta`
            is the scale parameter.
    
            The Gumbel (named for German mathematician Emil Julius Gumbel) was used
            very early in the hydrology literature, for modeling the occurrence of
            flood events. It is also used for modeling maximum wind speed and rainfall
            rates.  It is a "fat-tailed" distribution - the probability of an event in
            the tail of the distribution is larger than if one used a Gaussian, hence
            the surprisingly frequent occurrence of 100-year floods. Floods were
            initially modeled as a Gaussian process, which underestimated the frequency
            of extreme events.
    
            It is one of a class of extreme value distributions, the Generalized
            Extreme Value (GEV) distributions, which also includes the Weibull and
            Frechet.
    
            The function has a mean of :math:`\mu + 0.57721\beta` and a variance of
            :math:`\frac{\pi^2}{6}\beta^2`.
    
            References
            ----------
            .. [1] Gumbel, E.J. (1958). Statistics of Extremes. Columbia University
                   Press.
            .. [2] Reiss, R.-D. and Thomas M. (2001), Statistical Analysis of Extreme
                   Values, from Insurance, Finance, Hydrology and Other Fields,
                   Birkhauser Verlag, Basel: Boston : Berlin.
            .. [3] Wikipedia, "Gumbel distribution",
                   http://en.wikipedia.org/wiki/Gumbel_distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> mu, beta = 0, 0.1 # location and scale
            >>> s = np.random.gumbel(mu, beta, 1000)
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> count, bins, ignored = plt.hist(s, 30, normed=True)
            >>> plt.plot(bins, (1/beta)*np.exp(-(bins - mu)/beta)
            ...          * np.exp( -np.exp( -(bins - mu) /beta) ),
            ...          linewidth=2, color='r')
            >>> plt.show()
    
            Show how an extreme value distribution can arise from a Gaussian process
            and compare to a Gaussian:
    
            >>> means = []
            >>> maxima = []
            >>> for i in range(0,1000) :
            ...    a = np.random.normal(mu, beta, 1000)
            ...    means.append(a.mean())
            ...    maxima.append(a.max())
            >>> count, bins, ignored = plt.hist(maxima, 30, normed=True)
            >>> beta = np.std(maxima)*np.pi/np.sqrt(6)
            >>> mu = np.mean(maxima) - 0.57721*beta
            >>> plt.plot(bins, (1/beta)*np.exp(-(bins - mu)/beta)
            ...          * np.exp(-np.exp(-(bins - mu)/beta)),
            ...          linewidth=2, color='r')
            >>> plt.plot(bins, 1/(beta * np.sqrt(2 * np.pi))
            ...          * np.exp(-(bins - mu)**2 / (2 * beta**2)),
            ...          linewidth=2, color='g')
            >>> plt.show()
    """
    pass


def hypergeometric(ngood, nbad, nsample, size=None): # real signature unknown; restored from __doc__
    """
    hypergeometric(ngood, nbad, nsample, size=None)
    
            Draw samples from a Hypergeometric distribution.
    
            Samples are drawn from a Hypergeometric distribution with specified
            parameters, ngood (ways to make a good selection), nbad (ways to make
            a bad selection), and nsample = number of items sampled, which is less
            than or equal to the sum ngood + nbad.
    
            Parameters
            ----------
            ngood : float (but truncated to an integer)
                    parameter, > 0.
            nbad  : float
                    parameter, >= 0.
            nsample  : float
                       parameter, > 0 and <= ngood+nbad
            size : {tuple, int}
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            Returns
            -------
            samples : {ndarray, scalar}
                      where the values are all integers in  [0, n].
    
            See Also
            --------
            scipy.stats.distributions.hypergeom : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Hypergeometric distribution is
    
            .. math:: P(x) = \frac{\binom{m}{n}\binom{N-m}{n-x}}{\binom{N}{n}},
    
            where :math:`0 \le x \le m` and :math:`n+m-N \le x \le n`
    
            for P(x) the probability of x successes, n = ngood, m = nbad, and
            N = number of samples.
    
            Consider an urn with black and white marbles in it, ngood of them
            black and nbad are white. If you draw nsample balls without
            replacement, then the Hypergeometric distribution describes the
            distribution of black balls in the drawn sample.
    
            Note that this distribution is very similar to the Binomial
            distribution, except that in this case, samples are drawn without
            replacement, whereas in the Binomial case samples are drawn with
            replacement (or the sample space is infinite). As the sample space
            becomes large, this distribution approaches the Binomial.
    
            References
            ----------
            .. [1] Lentner, Marvin, "Elementary Applied Statistics", Bogden
                   and Quigley, 1972.
            .. [2] Weisstein, Eric W. "Hypergeometric Distribution." From
                   MathWorld--A Wolfram Web Resource.
                   http://mathworld.wolfram.com/HypergeometricDistribution.html
            .. [3] Wikipedia, "Hypergeometric-distribution",
                   http://en.wikipedia.org/wiki/Hypergeometric-distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> ngood, nbad, nsamp = 100, 2, 10
            # number of good, number of bad, and number of samples
            >>> s = np.random.hypergeometric(ngood, nbad, nsamp, 1000)
            >>> hist(s)
            #   note that it is very unlikely to grab both bad items
    
            Suppose you have an urn with 15 white and 15 black marbles.
            If you pull 15 marbles at random, how likely is it that
            12 or more of them are one color?
    
            >>> s = np.random.hypergeometric(15, 15, 15, 100000)
            >>> sum(s>=12)/100000. + sum(s<=3)/100000.
            #   answer = 0.003 ... pretty unlikely!
    """
    pass


def laplace(loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
    """
    laplace(loc=0.0, scale=1.0, size=None)
    
            Laplace or double exponential distribution.
    
            It has the probability density function
    
            .. math:: f(x; \mu, \lambda) = \frac{1}{2\lambda}
                                           \exp\left(-\frac{|x - \mu|}{\lambda}\right).
    
            The Laplace distribution is similar to the Gaussian/normal distribution,
            but is sharper at the peak and has fatter tails.
    
            Parameters
            ----------
            loc : float
                The position, :math:`\mu`, of the distribution peak.
            scale : float
                :math:`\lambda`, the exponential decay.
    """
    pass


def logistic(loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
    """
    logistic(loc=0.0, scale=1.0, size=None)
    
            Draw samples from a Logistic distribution.
    
            Samples are drawn from a Logistic distribution with specified
            parameters, loc (location or mean, also median), and scale (>0).
    
            Parameters
            ----------
            loc : float
    
            scale : float > 0.
    
            size : {tuple, int}
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            Returns
            -------
            samples : {ndarray, scalar}
                      where the values are all integers in  [0, n].
    
            See Also
            --------
            scipy.stats.distributions.logistic : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Logistic distribution is
    
            .. math:: P(x) = P(x) = \frac{e^{-(x-\mu)/s}}{s(1+e^{-(x-\mu)/s})^2},
    
            where :math:`\mu` = location and :math:`s` = scale.
    
            The Logistic distribution is used in Extreme Value problems where it
            can act as a mixture of Gumbel distributions, in Epidemiology, and by
            the World Chess Federation (FIDE) where it is used in the Elo ranking
            system, assuming the performance of each player is a logistically
            distributed random variable.
    
            References
            ----------
            .. [1] Reiss, R.-D. and Thomas M. (2001), Statistical Analysis of Extreme
                   Values, from Insurance, Finance, Hydrology and Other Fields,
                   Birkhauser Verlag, Basel, pp 132-133.
            .. [2] Weisstein, Eric W. "Logistic Distribution." From
                   MathWorld--A Wolfram Web Resource.
                   http://mathworld.wolfram.com/LogisticDistribution.html
            .. [3] Wikipedia, "Logistic-distribution",
                   http://en.wikipedia.org/wiki/Logistic-distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> loc, scale = 10, 1
            >>> s = np.random.logistic(loc, scale, 10000)
            >>> count, bins, ignored = plt.hist(s, bins=50)
    
            #   plot against distribution
    
            >>> def logist(x, loc, scale):
            ...     return exp((loc-x)/scale)/(scale*(1+exp((loc-x)/scale))**2)
            >>> plt.plot(bins, logist(bins, loc, scale)*count.max()/\
            ... logist(bins, loc, scale).max())
            >>> plt.show()
    """
    pass


def lognormal(mean=0.0, sigma=1.0, size=None): # real signature unknown; restored from __doc__
    """
    lognormal(mean=0.0, sigma=1.0, size=None)
    
            Return samples drawn from a log-normal distribution.
    
            Draw samples from a log-normal distribution with specified mean, standard
            deviation, and shape. Note that the mean and standard deviation are not the
            values for the distribution itself, but of the underlying normal
            distribution it is derived from.
    
    
            Parameters
            ----------
            mean : float
                Mean value of the underlying normal distribution
            sigma : float, >0.
                Standard deviation of the underlying normal distribution
            size : tuple of ints
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            See Also
            --------
            scipy.stats.lognorm : probability density function, distribution,
                cumulative density function, etc.
    
            Notes
            -----
            A variable `x` has a log-normal distribution if `log(x)` is normally
            distributed.
    
            The probability density function for the log-normal distribution is
    
            .. math:: p(x) = \frac{1}{\sigma x \sqrt{2\pi}}
                             e^{(-\frac{(ln(x)-\mu)^2}{2\sigma^2})}
    
            where :math:`\mu` is the mean and :math:`\sigma` is the standard deviation
            of the normally distributed logarithm of the variable.
    
            A log-normal distribution results if a random variable is the *product* of
            a large number of independent, identically-distributed variables in the
            same way that a normal distribution results if the variable is the *sum*
            of a large number of independent, identically-distributed variables
            (see the last example). It is one of the so-called "fat-tailed"
            distributions.
    
            The log-normal distribution is commonly used to model the lifespan of units
            with fatigue-stress failure modes. Since this includes
            most mechanical systems, the log-normal distribution has widespread
            application.
    
            It is also commonly used to model oil field sizes, species abundance, and
            latent periods of infectious diseases.
    
            References
            ----------
            .. [1] Eckhard Limpert, Werner A. Stahel, and Markus Abbt, "Log-normal
                   Distributions across the Sciences: Keys and Clues", May 2001
                   Vol. 51 No. 5 BioScience
                   http://stat.ethz.ch/~stahel/lognormal/bioscience.pdf
            .. [2] Reiss, R.D., Thomas, M.(2001), Statistical Analysis of Extreme
                   Values, Birkhauser Verlag, Basel, pp 31-32.
            .. [3] Wikipedia, "Lognormal distribution",
                   http://en.wikipedia.org/wiki/Lognormal_distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> mu, sigma = 3., 1. # mean and standard deviation
            >>> s = np.random.lognormal(mu, sigma, 1000)
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> count, bins, ignored = plt.hist(s, 100, normed=True, align='center')
    
            >>> x = np.linspace(min(bins), max(bins), 10000)
            >>> pdf = (np.exp(-(np.log(x) - mu)**2 / (2 * sigma**2))
            ...        / (x * sigma * np.sqrt(2 * np.pi)))
    
            >>> plt.plot(x, pdf, linewidth=2, color='r')
            >>> plt.axis('tight')
            >>> plt.show()
    
            Demonstrate that taking the products of random samples from a uniform
            distribution can be fit well by a log-normal probability density function.
    
            >>> # Generate a thousand samples: each is the product of 100 random
            >>> # values, drawn from a normal distribution.
            >>> b = []
            >>> for i in range(1000):
            ...    a = 10. + np.random.random(100)
            ...    b.append(np.product(a))
    
            >>> b = np.array(b) / np.min(b) # scale values to be positive
    
            >>> count, bins, ignored = plt.hist(b, 100, normed=True, align='center')
    
            >>> sigma = np.std(np.log(b))
            >>> mu = np.mean(np.log(b))
    
            >>> x = np.linspace(min(bins), max(bins), 10000)
            >>> pdf = (np.exp(-(np.log(x) - mu)**2 / (2 * sigma**2))
            ...        / (x * sigma * np.sqrt(2 * np.pi)))
    
            >>> plt.plot(x, pdf, color='r', linewidth=2)
            >>> plt.show()
    """
    pass


def logseries(p, size=None): # real signature unknown; restored from __doc__
    """
    logseries(p, size=None)
    
            Draw samples from a Logarithmic Series distribution.
    
            Samples are drawn from a Log Series distribution with specified
            parameter, p (probability, 0 < p < 1).
    
            Parameters
            ----------
            loc : float
    
            scale : float > 0.
    
            size : {tuple, int}
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            Returns
            -------
            samples : {ndarray, scalar}
                      where the values are all integers in  [0, n].
    
            See Also
            --------
            scipy.stats.distributions.logser : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Log Series distribution is
    
            .. math:: P(k) = \frac{-p^k}{k \ln(1-p)},
    
            where p = probability.
    
            The Log Series distribution is frequently used to represent species
            richness and occurrence, first proposed by Fisher, Corbet, and
            Williams in 1943 [2].  It may also be used to model the numbers of
            occupants seen in cars [3].
    
            References
            ----------
            .. [1] Buzas, Martin A.; Culver, Stephen J.,  Understanding regional
                   species diversity through the log series distribution of
                   occurrences: BIODIVERSITY RESEARCH Diversity & Distributions,
                   Volume 5, Number 5, September 1999 , pp. 187-195(9).
            .. [2] Fisher, R.A,, A.S. Corbet, and C.B. Williams. 1943. The
                   relation between the number of species and the number of
                   individuals in a random sample of an animal population.
                   Journal of Animal Ecology, 12:42-58.
            .. [3] D. J. Hand, F. Daly, D. Lunn, E. Ostrowski, A Handbook of Small
                   Data Sets, CRC Press, 1994.
            .. [4] Wikipedia, "Logarithmic-distribution",
                   http://en.wikipedia.org/wiki/Logarithmic-distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> a = .6
            >>> s = np.random.logseries(a, 10000)
            >>> count, bins, ignored = plt.hist(s)
    
            #   plot against distribution
    
            >>> def logseries(k, p):
            ...     return -p**k/(k*log(1-p))
            >>> plt.plot(bins, logseries(bins, a)*count.max()/\
                logseries(bins, a).max(),'r')
            >>> plt.show()
    """
    pass


def multinomial(n, pvals, size=None): # real signature unknown; restored from __doc__
    """
    multinomial(n, pvals, size=None)
    
            Draw samples from a multinomial distribution.
    
            The multinomial distribution is a multivariate generalisation of the
            binomial distribution.  Take an experiment with one of ``p``
            possible outcomes.  An example of such an experiment is throwing a dice,
            where the outcome can be 1 through 6.  Each sample drawn from the
            distribution represents `n` such experiments.  Its values,
            ``X_i = [X_0, X_1, ..., X_p]``, represent the number of times the outcome
            was ``i``.
    
            Parameters
            ----------
            n : int
                Number of experiments.
            pvals : sequence of floats, length p
                Probabilities of each of the ``p`` different outcomes.  These
                should sum to 1 (however, the last element is always assumed to
                account for the remaining probability, as long as
                ``sum(pvals[:-1]) <= 1)``.
            size : tuple of ints
                Given a `size` of ``(M, N, K)``, then ``M*N*K`` samples are drawn,
                and the output shape becomes ``(M, N, K, p)``, since each sample
                has shape ``(p,)``.
    
            Examples
            --------
            Throw a dice 20 times:
    
            >>> np.random.multinomial(20, [1/6.]*6, size=1)
            array([[4, 1, 7, 5, 2, 1]])
    
            It landed 4 times on 1, once on 2, etc.
    
            Now, throw the dice 20 times, and 20 times again:
    
            >>> np.random.multinomial(20, [1/6.]*6, size=2)
            array([[3, 4, 3, 3, 4, 3],
                   [2, 4, 3, 4, 0, 7]])
    
            For the first run, we threw 3 times 1, 4 times 2, etc.  For the second,
            we threw 2 times 1, 4 times 2, etc.
    
            A loaded dice is more likely to land on number 6:
    
            >>> np.random.multinomial(100, [1/7.]*5)
            array([13, 16, 13, 16, 42])
    """
    pass


def multivariate_normal(mean, cov, size=None): # real signature unknown; restored from __doc__
    """
    multivariate_normal(mean, cov[, size])
    
            Draw random samples from a multivariate normal distribution.
    
            The multivariate normal, multinormal or Gaussian distribution is a
            generalisation of the one-dimensional normal distribution to higher
            dimensions.
    
            Such a distribution is specified by its mean and covariance matrix,
            which are analogous to the mean (average or "centre") and variance
            (standard deviation squared or "width") of the one-dimensional normal
            distribution.
    
            Parameters
            ----------
            mean : (N,) ndarray
                Mean of the N-dimensional distribution.
            cov : (N,N) ndarray
                Covariance matrix of the distribution.
            size : tuple of ints, optional
                Given a shape of, for example, (m,n,k), m*n*k samples are
                generated, and packed in an m-by-n-by-k arrangement.  Because each
                sample is N-dimensional, the output shape is (m,n,k,N).  If no
                shape is specified, a single sample is returned.
    
            Returns
            -------
            out : ndarray
                The drawn samples, arranged according to `size`.  If the
                shape given is (m,n,...), then the shape of `out` is is
                (m,n,...,N).
    
                In other words, each entry ``out[i,j,...,:]`` is an N-dimensional
                value drawn from the distribution.
    
            Notes
            -----
            The mean is a coordinate in N-dimensional space, which represents the
            location where samples are most likely to be generated.  This is
            analogous to the peak of the bell curve for the one-dimensional or
            univariate normal distribution.
    
            Covariance indicates the level to which two variables vary together.
            From the multivariate normal distribution, we draw N-dimensional
            samples, :math:`X = [x_1, x_2, ... x_N]`.  The covariance matrix
            element :math:`C_{ij}` is the covariance of :math:`x_i` and :math:`x_j`.
            The element :math:`C_{ii}` is the variance of :math:`x_i` (i.e. its
            "spread").
    
            Instead of specifying the full covariance matrix, popular
            approximations include:
    
              - Spherical covariance (`cov` is a multiple of the identity matrix)
              - Diagonal covariance (`cov` has non-negative elements, and only on
                the diagonal)
    
            This geometrical property can be seen in two dimensions by plotting
            generated data-points:
    
            >>> mean = [0,0]
            >>> cov = [[1,0],[0,100]] # diagonal covariance, points lie on x or y-axis
    
            >>> import matplotlib.pyplot as plt
            >>> x,y = np.random.multivariate_normal(mean,cov,5000).T
            >>> plt.plot(x,y,'x'); plt.axis('equal'); plt.show()
    
            Note that the covariance matrix must be non-negative definite.
    
            References
            ----------
            .. [1] A. Papoulis, "Probability, Random Variables, and Stochastic
                   Processes," 3rd ed., McGraw-Hill Companies, 1991
            .. [2] R.O. Duda, P.E. Hart, and D.G. Stork, "Pattern Classification,"
                   2nd ed., Wiley, 2001.
    
            Examples
            --------
            >>> mean = (1,2)
            >>> cov = [[1,0],[1,0]]
            >>> x = np.random.multivariate_normal(mean,cov,(3,3))
            >>> x.shape
            (3, 3, 2)
    
            The following is probably true, given that 0.6 is roughly twice the
            standard deviation:
    
            >>> print list( (x[0,0,:] - mean) < 0.6 )
            [True, True]
    """
    pass


def negative_binomial(n, p, size=None): # real signature unknown; restored from __doc__
    """
    negative_binomial(n, p, size=None)
    
            Negative Binomial distribution.
    """
    pass


def noncentral_chisquare(df, nonc, size=None): # real signature unknown; restored from __doc__
    """
    noncentral_chisquare(df, nonc, size=None)
    
            Draw samples from a noncentral chi-square distribution.
    
            The noncentral :math:`\chi^2` distribution is a generalisation of
            the :math:`\chi^2` distribution.
    
            Parameters
            ----------
            df : int
                Degrees of freedom.
            nonc : float
                Non-centrality.
            size : tuple of ints
                Shape of the output.
    """
    pass


def noncentral_f(dfnum, dfden, nonc, size=None): # real signature unknown; restored from __doc__
    """
    noncentral_f(dfnum, dfden, nonc, size=None)
    
            Noncentral F distribution.
    """
    pass


def normal(loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
    """
    normal(loc=0.0, scale=1.0, size=None)
    
            Draw random samples from a normal (Gaussian) distribution.
    
            The probability density function of the normal distribution, first
            derived by De Moivre and 200 years later by both Gauss and Laplace
            independently [2]_, is often called the bell curve because of
            its characteristic shape (see the example below).
    
            The normal distributions occurs often in nature.  For example, it
            describes the commonly occurring distribution of samples influenced
            by a large number of tiny, random disturbances, each with its own
            unique distribution [2]_.
    
            Parameters
            ----------
            loc : float
                Mean ("centre") of the distribution.
            scale : float
                Standard deviation (spread or "width") of the distribution.
            size : tuple of ints
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            See Also
            --------
            scipy.stats.distributions.norm : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Gaussian distribution is
    
            .. math:: p(x) = \frac{1}{\sqrt{ 2 \pi \sigma^2 }}
                             e^{ - \frac{ (x - \mu)^2 } {2 \sigma^2} },
    
            where :math:`\mu` is the mean and :math:`\sigma` the standard deviation.
            The square of the standard deviation, :math:`\sigma^2`, is called the
            variance.
    
            The function has its peak at the mean, and its "spread" increases with
            the standard deviation (the function reaches 0.607 times its maximum at
            :math:`x + \sigma` and :math:`x - \sigma` [2]_).  This implies that
            `numpy.random.normal` is more likely to return samples lying close to the
            mean, rather than those far away.
    
            References
            ----------
            .. [1] Wikipedia, "Normal distribution",
                   http://en.wikipedia.org/wiki/Normal_distribution
            .. [2] P. R. Peebles Jr., "Central Limit Theorem" in "Probability, Random
                   Variables and Random Signal Principles", 4th ed., 2001,
                   pp. 51, 51, 125.
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> mu, sigma = 0, 0.1 # mean and standard deviation
            >>> s = np.random.normal(mu, sigma, 1000)
    
            Verify the mean and the variance:
    
            >>> abs(mu - np.mean(s)) < 0.01
            True
    
            >>> abs(sigma - np.std(s, ddof=1)) < 0.01
            True
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> count, bins, ignored = plt.hist(s, 30, normed=True)
            >>> plt.plot(bins, 1/(sigma * np.sqrt(2 * np.pi)) *
            ...                np.exp( - (bins - mu)**2 / (2 * sigma**2) ),
            ...          linewidth=2, color='r')
            >>> plt.show()
    """
    pass


def pareto(a, size=None): # real signature unknown; restored from __doc__
    """
    pareto(a, size=None)
    
            Draw samples from a Pareto distribution with specified shape.
    
            This is a simplified version of the Generalized Pareto distribution
            (available in SciPy), with the scale set to one and the location set to
            zero. Most authors default the location to one.
    
            The Pareto distribution must be greater than zero, and is unbounded above.
            It is also known as the "80-20 rule".  In this distribution, 80 percent of
            the weights are in the lowest 20 percent of the range, while the other 20
            percent fill the remaining 80 percent of the range.
    
            Parameters
            ----------
            shape : float, > 0.
                Shape of the distribution.
            size : tuple of ints
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            See Also
            --------
            scipy.stats.distributions.genpareto.pdf : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Pareto distribution is
    
            .. math:: p(x) = \frac{am^a}{x^{a+1}}
    
            where :math:`a` is the shape and :math:`m` the location
    
            The Pareto distribution, named after the Italian economist Vilfredo Pareto,
            is a power law probability distribution useful in many real world problems.
            Outside the field of economics it is generally referred to as the Bradford
            distribution. Pareto developed the distribution to describe the
            distribution of wealth in an economy.  It has also found use in insurance,
            web page access statistics, oil field sizes, and many other problems,
            including the download frequency for projects in Sourceforge [1].  It is
            one of the so-called "fat-tailed" distributions.
    
    
            References
            ----------
            .. [1] Francis Hunt and Paul Johnson, On the Pareto Distribution of
                   Sourceforge projects.
            .. [2] Pareto, V. (1896). Course of Political Economy. Lausanne.
            .. [3] Reiss, R.D., Thomas, M.(2001), Statistical Analysis of Extreme
                   Values, Birkhauser Verlag, Basel, pp 23-30.
            .. [4] Wikipedia, "Pareto distribution",
                   http://en.wikipedia.org/wiki/Pareto_distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> a, m = 3., 1. # shape and mode
            >>> s = np.random.pareto(a, 1000) + m
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> count, bins, ignored = plt.hist(s, 100, normed=True, align='center')
            >>> fit = a*m**a/bins**(a+1)
            >>> plt.plot(bins, max(count)*fit/max(fit),linewidth=2, color='r')
            >>> plt.show()
    """
    pass


def permutation(x): # real signature unknown; restored from __doc__
    """
    permutation(x)
    
            Randomly permute a sequence, or return a permuted range.
    
            Parameters
            ----------
            x : int or array_like
                If `x` is an integer, randomly permute ``np.arange(x)``.
                If `x` is an array, make a copy and shuffle the elements
                randomly.
    
            Returns
            -------
            out : ndarray
                Permuted sequence or array range.
    
            Examples
            --------
            >>> np.random.permutation(10)
            array([1, 7, 4, 3, 0, 9, 2, 5, 8, 6])
    
            >>> np.random.permutation([1, 4, 9, 12, 15])
            array([15,  1,  9,  4, 12])
    """
    pass


def poisson(lam=1.0, size=None): # real signature unknown; restored from __doc__
    """
    poisson(lam=1.0, size=None)
    
            Poisson distribution.
    """
    pass


def power(a, size=None): # real signature unknown; restored from __doc__
    """
    power(a, size=None)
    
            Power distribution.
    """
    pass


def rand(d0, d1, *more, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
    """
    rand(d0, d1, ..., dn)
    
            Random values in a given shape.
    
            Create an array of the given shape and propagate it with
            random samples from a uniform distribution
            over ``[0, 1)``.
    
            Parameters
            ----------
            d0, d1, ..., dn : int
                Shape of the output.
    
            Returns
            -------
            out : ndarray, shape ``(d0, d1, ..., dn)``
                Random values.
    
            See Also
            --------
            random
    
            Notes
            -----
            This is a convenience function. If you want an interface that
            takes a shape-tuple as the first argument, refer to
            `random`.
    
            Examples
            --------
            >>> np.random.rand(3,2)
            array([[ 0.14022471,  0.96360618],  #random
                   [ 0.37601032,  0.25528411],  #random
                   [ 0.49313049,  0.94909878]]) #random
    """
    pass


def randint(low, high=None, size=None): # real signature unknown; restored from __doc__
    """
    randint(low, high=None, size=None)
    
            Return random integers x such that low <= x < high.
    
            If high is None, then 0 <= x < low.
    """
    pass


def randn(d0, d1, *more, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
    """
    randn(d0, d1, ..., dn)
    
            Returns zero-mean, unit-variance Gaussian random numbers in an
            array of shape (d0, d1, ..., dn).
    
            Note:  This is a convenience function. If you want an
                        interface that takes a tuple as the first argument
                        use numpy.random.standard_normal(shape_tuple).
    """
    pass


def random_integers(low, high=None, size=None): # real signature unknown; restored from __doc__
    """
    random_integers(low, high=None, size=None)
    
            Return random integers x such that low <= x <= high.
    
            If high is None, then 1 <= x <= low.
    """
    pass


def random_sample(size=None): # real signature unknown; restored from __doc__
    """
    random_sample(size=None)
    
            Return random floats in the half-open interval [0.0, 1.0).
    """
    pass


def rayleigh(scale=1.0, size=None): # real signature unknown; restored from __doc__
    """
    rayleigh(scale=1.0, size=None)
    
            Rayleigh distribution.
    """
    pass


def seed(seed=None): # real signature unknown; restored from __doc__
    """
    seed(seed=None)
    
            Seed the generator.
    
            seed can be an integer, an array (or other sequence) of integers of any
            length, or None. If seed is None, then RandomState will try to read data
            from /dev/urandom (or the Windows analogue) if available or seed from
            the clock otherwise.
    """
    pass


def set_state(state): # real signature unknown; restored from __doc__
    """
    set_state(state)
    
            Set the state from a tuple.
    
            state = ('MT19937', int key[624], int pos, int has_gauss, float cached_gaussian)
    
            For backwards compatibility, the following form is also accepted
            although it is missing some information about the cached Gaussian value.
    
            state = ('MT19937', int key[624], int pos)
    """
    pass


def shuffle(x): # real signature unknown; restored from __doc__
    """
    shuffle(x)
    
            Modify a sequence in-place by shuffling its contents.
    """
    pass


def standard_cauchy(size=None): # real signature unknown; restored from __doc__
    """
    standard_cauchy(size=None)
    
            Standard Cauchy with mode=0.
    """
    pass


def standard_exponential(size=None): # real signature unknown; restored from __doc__
    """
    standard_exponential(size=None)
    
            Standard exponential distribution (scale=1).
    """
    pass


def standard_gamma(shape, size=None): # real signature unknown; restored from __doc__
    """
    standard_gamma(shape, size=None)
    
            Standard Gamma distribution.
    """
    pass


def standard_normal(size=None): # real signature unknown; restored from __doc__
    """
    standard_normal(size=None)
    
            Standard Normal distribution (mean=0, stdev=1).
    """
    pass


def standard_t(df, size=None): # real signature unknown; restored from __doc__
    """
    standard_t(df, size=None)
    
            Standard Student's t distribution with df degrees of freedom.
    """
    pass


def triangular(left, mode, right, size=None): # real signature unknown; restored from __doc__
    """
    triangular(left, mode, right, size=None)
    
            Triangular distribution starting at left, peaking at mode, and
            ending at right (left <= mode <= right).
    """
    pass


def uniform(low=0.0, high=1.0, size=1): # real signature unknown; restored from __doc__
    """
    uniform(low=0.0, high=1.0, size=1)
    
            Draw samples from a uniform distribution.
    
            Samples are uniformly distributed over the half-open interval
            ``[low, high)`` (includes low, but excludes high).  In other words,
            any value within the given interval is equally likely to be drawn
            by `uniform`.
    
            Parameters
            ----------
            low : float, optional
                Lower boundary of the output interval.  All values generated will be
                greater than or equal to low.  The default value is 0.
            high : float
                Upper boundary of the output interval.  All values generated will be
                less than high.  The default value is 1.0.
            size : tuple of ints, int, optional
                Shape of output.  If the given size is, for example, (m,n,k),
                m*n*k samples are generated.  If no shape is specified, a single sample
                is returned.
    
            Returns
            -------
            out : ndarray
                Drawn samples, with shape `size`.
    
            See Also
            --------
            randint : Discrete uniform distribution, yielding integers.
            random_integers : Discrete uniform distribution over the closed interval
                              ``[low, high]``.
            random_sample : Floats uniformly distributed over ``[0, 1)``.
            random : Alias for `random_sample`.
            rand : Convenience function that accepts dimensions as input, e.g.,
                   ``rand(2,2)`` would generate a 2-by-2 array of floats, uniformly
                   distributed over ``[0, 1)``.
    
            Notes
            -----
            The probability density function of the uniform distribution is
    
            .. math:: p(x) = \frac{1}{b - a}
    
            anywhere within the interval ``[a, b)``, and zero elsewhere.
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> s = np.random.uniform(-1,0,1000)
    
            All values are within the given interval:
    
            >>> np.all(s >= -1)
            True
    
            >>> np.all(s < 0)
            True
    
            Display the histogram of the samples, along with the
            probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> count, bins, ignored = plt.hist(s, 15, normed=True)
            >>> plt.plot(bins, np.ones_like(bins), linewidth=2, color='r')
            >>> plt.show()
    """
    pass


def vonmises(mu=0.0, kappa=1.0, size=None): # real signature unknown; restored from __doc__
    """
    vonmises(mu=0.0, kappa=1.0, size=None)
    
            Draw samples from a von Mises distribution.
    
            Samples are drawn from a von Mises distribution with specified mode (mu)
            and dispersion (kappa), on the interval [-pi, pi].
    
            The von Mises distribution (also known as the circular normal
            distribution) is a continuous probability distribution on the circle. It
            may be thought of as the circular analogue of the normal distribution.
    
            Parameters
            ----------
            mu : float
                Mode ("center") of the distribution.
            kappa : float, >= 0.
                Dispersion of the distribution.
            size : {tuple, int}
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            Returns
            -------
            samples : {ndarray, scalar}
                The returned samples live on the unit circle [-\pi, \pi].
    
            See Also
            --------
            scipy.stats.distributions.vonmises : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the von Mises distribution is
    
            .. math:: p(x) = \frac{e^{\kappa cos(x-\mu)}}{2\pi I_0(\kappa)},
    
            where :math:`\mu` is the mode and :math:`\kappa` the dispersion,
            and :math:`I_0(\kappa)` is the modified Bessel function of order 0.
    
            The von Mises, named for Richard Edler von Mises, born in
            Austria-Hungary, in what is now the Ukraine. He fled to the United
            States in 1939 and became a professor at Harvard. He worked in
            probability theory, aerodynamics, fluid mechanics, and philosophy of
            science.
    
            References
            ----------
            .. [1] Abramowitz, M. and Stegun, I. A. (ed.), Handbook of Mathematical
                   Functions, National Bureau of Standards, 1964; reprinted Dover
                   Publications, 1965.
            .. [2] von Mises, Richard, 1964, Mathematical Theory of Probability
                   and Statistics (New York: Academic Press).
            .. [3] Wikipedia, "Von Mises distribution",
                   http://en.wikipedia.org/wiki/Von_Mises_distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> mu, kappa = 0.0, 4.0 # mean and dispersion
            >>> s = np.random.vonmises(mu, kappa, 1000)
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> import scipy.special as sps
            >>> count, bins, ignored = plt.hist(s, 50, normed=True)
            >>> x = arange(-pi, pi, 2*pi/50.)
            >>> y = -np.exp(kappa*np.cos(x-mu))/(2*pi*sps.jn(0,kappa))
            >>> plt.plot(x, y/max(y), linewidth=2, color='r')
            >>> plt.show()
    """
    pass


def wald(mean, scale, size=None): # real signature unknown; restored from __doc__
    """
    wald(mean, scale, size=None)
    
            Wald (inverse Gaussian) distribution.
    """
    pass


def weibull(a, size=None): # real signature unknown; restored from __doc__
    """
    weibull(a, size=None)
    
            Weibull distribution.
    
            Draw samples from a 1-parameter Weibull distribution with the given
            shape parameter.
    
            .. math:: X = (-ln(U))^{1/a}
    
            Here, U is drawn from the uniform distribution over (0,1].
    
            The more common 2-parameter Weibull, including a scale parameter
            :math:`\lambda` is just :math:`X = \lambda(-ln(U))^{1/a}`.
    
            The Weibull (or Type III asymptotic extreme value distribution for smallest
            values, SEV Type III, or Rosin-Rammler distribution) is one of a class of
            Generalized Extreme Value (GEV) distributions used in modeling extreme
            value problems.  This class includes the Gumbel and Frechet distributions.
    
            Parameters
            ----------
            a : float
                Shape of the distribution.
            size : tuple of ints
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            See Also
            --------
            scipy.stats.distributions.weibull : probability density function,
                distribution or cumulative density function, etc.
    
            gumbel, scipy.stats.distributions.genextreme
    
            Notes
            -----
            The probability density for the Weibull distribution is
    
            .. math:: p(x) = \frac{a}
                             {\lambda}(\frac{x}{\lambda})^{a-1}e^{-(x/\lambda)^a},
    
            where :math:`a` is the shape and :math:`\lambda` the scale.
    
            The function has its peak (the mode) at
            :math:`\lambda(\frac{a-1}{a})^{1/a}`.
    
            When ``a = 1``, the Weibull distribution reduces to the exponential
            distribution.
    
            References
            ----------
            .. [1] Waloddi Weibull, Professor, Royal Technical University, Stockholm,
                   1939 "A Statistical Theory Of The Strength Of Materials",
                   Ingeniorsvetenskapsakademiens Handlingar Nr 151, 1939,
                   Generalstabens Litografiska Anstalts Forlag, Stockholm.
            .. [2] Waloddi Weibull, 1951 "A Statistical Distribution Function of Wide
                   Applicability",  Journal Of Applied Mechanics ASME Paper.
            .. [3] Wikipedia, "Weibull distribution",
                   http://en.wikipedia.org/wiki/Weibull_distribution
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> a = 5. # shape
            >>> s = np.random.weibull(a, 1000)
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> def weib(x,n,a):
            ...     return (a/n)*(x/n)**(a-1)*exp(-(x/n)**a)
    
            >>> count, bins, ignored = plt.hist(numpy.random.weibull(5.,1000))
            >>> scale = count.max()/weib(x, 1., 5.).max()
            >>> x = arange(1,100.)/50.
            >>> plt.plot(x, weib(x, 1., 5.)*scale)
            >>> plt.show()
    """
    pass


def zipf(a, size=None): # real signature unknown; restored from __doc__
    """
    zipf(a, size=None)
    
            Draw samples from a Zipf distribution.
    
            Samples are drawn from a Zipf distribution with specified parameter (a),
            where a > 1.
    
            The zipf distribution (also known as the zeta
            distribution) is a continuous probability distribution that satisfies
            Zipf's law, where the frequency of an item is inversely proportional to
            its rank in a frequency table.
    
            Parameters
            ----------
            a : float
                parameter, > 1.
            size : {tuple, int}
                Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                ``m * n * k`` samples are drawn.
    
            Returns
            -------
            samples : {ndarray, scalar}
                The returned samples are greater than or equal to one.
    
            See Also
            --------
            scipy.stats.distributions.zipf : probability density function,
                distribution or cumulative density function, etc.
    
            Notes
            -----
            The probability density for the Zipf distribution is
    
            .. math:: p(x) = \frac{x^{-a}}{\zeta(a)},
    
            where :math:`\zeta` is the Riemann Zeta function.
    
            Named after the American linguist George Kingsley Zipf, who noted that
            the frequency of any word in a sample of a language is inversely
            proportional to its rank in the frequency table.
    
    
            References
            ----------
            .. [1] Weisstein, Eric W. "Zipf Distribution." From MathWorld--A Wolfram
                   Web Resource. http://mathworld.wolfram.com/ZipfDistribution.html
            .. [2] Wikipedia, "Zeta distribution",
                   http://en.wikipedia.org/wiki/Zeta_distribution
            .. [3] Wikipedia, "Zipf's Law",
                   http://en.wikipedia.org/wiki/Zipf%27s_law
            .. [4] Zipf, George Kingsley (1932): Selected Studies of the Principle
                   of Relative Frequency in Language. Cambridge (Mass.).
    
            Examples
            --------
            Draw samples from the distribution:
    
            >>> a = 2. # parameter
            >>> s = np.random.zipf(a, 1000)
    
            Display the histogram of the samples, along with
            the probability density function:
    
            >>> import matplotlib.pyplot as plt
            >>> import scipy.special as sps
            Truncate s values at 50 so plot is interesting
            >>> count, bins, ignored = plt.hist(s[s<50], 50, normed=True)
            >>> x = arange(1., 50.)
            >>> y = x**(-a)/sps.zetac(a)
            >>> plt.plot(x, y/max(y), linewidth=2, color='r')
            >>> plt.show()
    """
    pass


# classes

class RandomState(object):
    """
    RandomState(seed=None)
    
        Container for the Mersenne Twister PRNG.
    
        `RandomState` exposes a number of methods for generating random numbers
        drawn from a variety of probability distributions. In addition to the
        distribution-specific arguments, each method takes a keyword argument
        `size` that defaults to ``None``. If `size` is ``None``, then a single
        value is generated and returned. If `size` is an integer, then a 1-D
        numpy array filled with generated values is returned. If size is a tuple,
        then a numpy array with that shape is filled and returned.
    
        Parameters
        ----------
        seed : array_like, int, optional
            Random seed initializing the PRNG.
            Can be an integer, an array (or other sequence) of integers of
            any length, or ``None``.
            If `seed` is ``None``, then `RandomState` will try to read data from
            ``/dev/urandom`` (or the Windows analogue) if available or seed from
            the clock otherwise.
    """
    def beta(self, a, b, size=None): # real signature unknown; restored from __doc__
        """
        beta(a, b, size=None)
        
                The Beta distribution over ``[0, 1]``.
        
                The Beta distribution is a special case of the Dirichlet distribution,
                and is related to the Gamma distribution.  It has the probability
                distribution function
        
                .. math:: f(x; a,b) = \frac{1}{B(\alpha, \beta)} x^{\alpha - 1}
                                                                 (1 - x)^{\beta - 1},
        
                where the normalisation, B, is the beta function,
        
                .. math:: B(\alpha, \beta) = \int_0^1 t^{\alpha - 1}
                                             (1 - t)^{\beta - 1} dt.
        
                It is often seen in Bayesian inference and order statistics.
        
                Parameters
                ----------
                a : float
                    Alpha, non-negative.
                b : float
                    Beta, non-negative.
                size : tuple of ints, optional
                    The number of samples to draw.  The ouput is packed according to
                    the size given.
        
                Returns
                -------
                out : ndarray
                    Array of the given shape, containing values drawn from a
                    Beta distribution.
        """
        pass

    def binomial(self, n, p, size=None): # real signature unknown; restored from __doc__
        """
        binomial(n, p, size=None)
        
                Draw samples from a binomial distribution.
        
                Samples are drawn from a Binomial distribution with specified
                parameters, n trials and p probability of success where
                n an integer > 0 and p is in the interval [0,1]. (n may be
                input as a float, but it is truncated to an integer in use)
        
                Parameters
                ----------
                n : float (but truncated to an integer)
                        parameter, > 0.
                p : float
                        parameter, >= 0 and <=1.
                size : {tuple, int}
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                Returns
                -------
                samples : {ndarray, scalar}
                          where the values are all integers in  [0, n].
        
                See Also
                --------
                scipy.stats.distributions.binom : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Binomial distribution is
        
                .. math:: P(N) = \binom{n}{N}p^N(1-p)^{n-N},
        
                where :math:`n` is the number of trials, :math:`p` is the probability
                of success, and :math:`N` is the number of successes.
        
                When estimating the standard error of a proportion in a population by
                using a random sample, the normal distribution works well unless the
                product p*n <=5, where p = population proportion estimate, and n =
                number of samples, in which case the binomial distribution is used
                instead. For example, a sample of 15 people shows 4 who are left
                handed, and 11 who are right handed. Then p = 4/15 = 27%. 0.27*15 = 4,
                so the binomial distribution should be used in this case.
        
                References
                ----------
                .. [1] Dalgaard, Peter, "Introductory Statistics with R",
                       Springer-Verlag, 2002.
                .. [2] Glantz, Stanton A. "Primer of Biostatistics.", McGraw-Hill,
                       Fifth Edition, 2002.
                .. [3] Lentner, Marvin, "Elementary Applied Statistics", Bogden
                       and Quigley, 1972.
                .. [4] Weisstein, Eric W. "Binomial Distribution." From MathWorld--A
                       Wolfram Web Resource.
                       http://mathworld.wolfram.com/BinomialDistribution.html
                .. [5] Wikipedia, "Binomial-distribution",
                       http://en.wikipedia.org/wiki/Binomial_distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> n, p = 10, .5 # number of trials, probability of each trial
                >>> s = np.random.binomial(n, p, 1000)
                # result of flipping a coin 10 times, tested 1000 times.
        
                A real world example. A company drills 9 wild-cat oil exploration
                wells, each with an estimated probability of success of 0.1. All nine
                wells fail. What is the probability of that happening?
        
                Let's do 20,000 trials of the model, and count the number that
                generate zero positive results.
        
                >>> sum(np.random.binomial(9,0.1,20000)==0)/20000.
                answer = 0.38885, or 38%.
        """
        pass

    def bytes(self, length): # real signature unknown; restored from __doc__
        """
        bytes(length)
        
                Return random bytes.
        
                Parameters
                ----------
                length : int
                    Number of random bytes.
        
                Returns
                -------
                out : str
                    String of length `N`.
        
                Examples
                --------
                >>> np.random.bytes(10)
                ' eh\x85\x022SZ\xbf\xa4' #random
        """
        pass

    def chisquare(self, df, size=None): # real signature unknown; restored from __doc__
        """
        chisquare(df, size=None)
        
                Draw samples from a chi-square distribution.
        
                When `df` independent random variables, each with standard
                normal distributions (mean 0, variance 1), are squared and summed,
                the resulting distribution is chi-square (see Notes).  This
                distribution is often used in hypothesis testing.
        
                Parameters
                ----------
                df : int
                     Number of degrees of freedom.
                size : tuple of ints, int, optional
                     Size of the returned array.  By default, a scalar is
                     returned.
        
                Returns
                -------
                output : ndarray
                    Samples drawn from the distribution, packed in a `size`-shaped
                    array.
        
                Raises
                ------
                ValueError
                    When `df` <= 0 or when an inappropriate `size` (e.g. ``size=-1``)
                    is given.
        
                Notes
                -----
                The variable obtained by summing the squares of `df` independent,
                standard normally distributed random variables:
        
                .. math:: Q = \sum_{i=0}^{\mathtt{df}} X^2_i
        
                is chi-square distributed, denoted
        
                .. math:: Q \sim \chi^2_k.
        
                The probability density function of the chi-squared distribution is
        
                .. math:: p(x) = \frac{(1/2)^{k/2}}{\Gamma(k/2)}
                                 x^{k/2 - 1} e^{-x/2},
        
                where :math:`\Gamma` is the gamma function,
        
                .. math:: \Gamma(x) = \int_0^{-\infty} t^{x - 1} e^{-t} dt.
        
                References
                ----------
                .. [1] NIST/SEMATECH e-Handbook of Statistical Methods,
                       http://www.itl.nist.gov/div898/handbook/eda/section3/eda3666.htm
                .. [2] Wikipedia, "Chi-square distribution",
                       http://en.wikipedia.org/wiki/Chi-square_distribution
        
                Examples
                --------
                >>> np.random.chisquare(2,4)
                array([ 1.89920014,  9.00867716,  3.13710533,  5.62318272])
        """
        pass

    def dirichlet(self, alpha, size=None): # real signature unknown; restored from __doc__
        """
        dirichlet(alpha, size=None)
        
                Draw samples from the Dirichlet distribution.
        
                Draw `size` samples of dimension k from a Dirichlet distribution. A
                Dirichlet-distributed random variable can be seen as a multivariate
                generalization of a Beta distribution. Dirichlet pdf is the conjugate
                prior of a multinomial in Bayesian inference.
        
                Parameters
                ----------
                alpha : array
                    Parameter of the distribution (k dimension for sample of
                    dimension k).
                size : array
                    Number of samples to draw.
        
                Notes
                -----
                .. math:: X \approx \prod_{i=1}^{k}{x^{\alpha_i-1}_i}
        
                Uses the following property for computation: for each dimension,
                draw a random sample y_i from a standard gamma generator of shape
                `alpha_i`, then
                :math:`X = \frac{1}{\sum_{i=1}^k{y_i}} (y_1, \ldots, y_n)` is
                Dirichlet distributed.
        
                References
                ----------
                .. [1] David McKay, "Information Theory, Inference and Learning
                       Algorithms," chapter 23,
                       http://www.inference.phy.cam.ac.uk/mackay/
        """
        pass

    def exponential(self, scale=1.0, size=None): # real signature unknown; restored from __doc__
        """
        exponential(scale=1.0, size=None)
        
                Exponential distribution.
        
                Its probability density function is
        
                .. math:: f(x; \lambda) = \lambda \exp(-\lambda x),
        
                for ``x > 0`` and 0 elsewhere.  :math:`lambda` is
                known as the rate parameter.
        
                The exponential distribution is a continuous analogue of the
                geometric distribution.  It describes many common situations, such as
                the size of raindrops measured over many rainstorms [1]_, or the time
                between page requests to Wikipedia [2]_.
        
                Parameters
                ----------
                scale : float
                    The rate parameter, :math:`\lambda`.
                size : tuple of ints
                    Number of samples to draw.  The output is shaped
                    according to `size`.
        
                References
                ----------
                .. [1] Peyton Z. Peebles Jr., "Probability, Random Variables and
                       Random Signal Principles", 4th ed, 2001, p. 57.
                .. [2] "Poisson Process", Wikipedia,
                       http://en.wikipedia.org/wiki/Poisson_process
        """
        pass

    def f(self, dfnum, dfden, size=None): # real signature unknown; restored from __doc__
        """
        f(dfnum, dfden, size=None)
        
                Draw samples from a F distribution.
        
                Samples are drawn from an F distribution with specified parameters,
                `dfnum` (degrees of freedom in numerator) and `dfden` (degrees of freedom
                in denominator), where both parameters should be greater than zero.
        
                The random variate of the F distribution (also known as the
                Fisher distribution) is a continuous probability distribution
                that arises in ANOVA tests, and is the ratio of two chi-square
                variates.
        
                Parameters
                ----------
                dfnum : float
                    Degrees of freedom in numerator. Should be greater than zero.
                dfden : float
                    Degrees of freedom in denominator. Should be greater than zero.
                size : {tuple, int}, optional
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``,
                    then ``m * n * k`` samples are drawn. By default only one sample
                    is returned.
        
                Returns
                -------
                samples : {ndarray, scalar}
                    Samples from the Fisher distribution.
        
                See Also
                --------
                scipy.stats.distributions.f : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
        
                The F statistic is used to compare in-group variances to between-group
                variances. Calculating the distribution depends on the sampling, and
                so it is a function of the respective degrees of freedom in the
                problem.  The variable `dfnum` is the number of samples minus one, the
                between-groups degrees of freedom, while `dfden` is the within-groups
                degrees of freedom, the sum of the number of samples in each group
                minus the number of groups.
        
                References
                ----------
                .. [1] Glantz, Stanton A. "Primer of Biostatistics.", McGraw-Hill,
                       Fifth Edition, 2002.
                .. [2] Wikipedia, "F-distribution",
                       http://en.wikipedia.org/wiki/F-distribution
        
                Examples
                --------
                An example from Glantz[1], pp 47-40.
                Two groups, children of diabetics (25 people) and children from people
                without diabetes (25 controls). Fasting blood glucose was measured,
                case group had a mean value of 86.1, controls had a mean value of
                82.2. Standard deviations were 2.09 and 2.49 respectively. Are these
                data consistent with the null hypothesis that the parents diabetic
                status does not affect their children's blood glucose levels?
                Calculating the F statistic from the data gives a value of 36.01.
        
                Draw samples from the distribution:
        
                >>> dfnum = 1. # between group degrees of freedom
                >>> dfden = 48. # within groups degrees of freedom
                >>> s = np.random.f(dfnum, dfden, 1000)
        
                The lower bound for the top 1% of the samples is :
        
                >>> sort(s)[-10]
                7.61988120985
        
                So there is about a 1% chance that the F statistic will exceed 7.62,
                the measured value is 36, so the null hypothesis is rejected at the 1%
                level.
        """
        pass

    def gamma(self, shape, scale=1.0, size=None): # real signature unknown; restored from __doc__
        """
        gamma(shape, scale=1.0, size=None)
        
                Draw samples from a Gamma distribution.
        
                Samples are drawn from a Gamma distribution with specified parameters,
                `shape` (sometimes designated "k") and `scale` (sometimes designated
                "theta"), where both parameters are > 0.
        
                Parameters
                ----------
                shape : scalar > 0
                    The shape of the gamma distribution.
                scale : scalar > 0, optional
                    The scale of the gamma distribution.  Default is equal to 1.
                size : shape_tuple, optional
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                Returns
                -------
                out : ndarray, float
                    Returns one sample unless `size` parameter is specified.
        
                See Also
                --------
                scipy.stats.distributions.gamma : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Gamma distribution is
        
                .. math:: p(x) = x^{k-1}\frac{e^{-x/\theta}}{\theta^k\Gamma(k)},
        
                where :math:`k` is the shape and :math:`\theta` the scale,
                and :math:`\Gamma` is the Gamma function.
        
                The Gamma distribution is often used to model the times to failure of
                electronic components, and arises naturally in processes for which the
                waiting times between Poisson distributed events are relevant.
        
                References
                ----------
                .. [1] Weisstein, Eric W. "Gamma Distribution." From MathWorld--A
                       Wolfram Web Resource.
                       http://mathworld.wolfram.com/GammaDistribution.html
                .. [2] Wikipedia, "Gamma-distribution",
                       http://en.wikipedia.org/wiki/Gamma-distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> shape, scale = 2., 2. # mean and dispersion
                >>> s = np.random.gamma(shape, scale, 1000)
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> import scipy.special as sps
                >>> count, bins, ignored = plt.hist(s, 50, normed=True)
                >>> y = bins**(shape-1)*((exp(-bins/scale))/\
                    (sps.gamma(shape)*scale**shape))
                >>> plt.plot(bins, y, linewidth=2, color='r')
                >>> plt.show()
        """
        pass

    def geometric(self, p, size=None): # real signature unknown; restored from __doc__
        """
        geometric(p, size=None)
        
                Draw samples from the geometric distribution.
        
                Bernoulli trials are experiments with one of two outcomes:
                success or failure (an example of such an experiment is flipping
                a coin).  The geometric distribution models the number of trials
                that must be run in order to achieve success.  It is therefore
                supported on the positive integers, ``k = 1, 2, ...``.
        
                The probability mass function of the geometric distribution is
        
                .. math:: f(k) = (1 - p)^{k - 1} p
        
                where `p` is the probability of success of an individual trial.
        
                Parameters
                ----------
                p : float
                    The probability of success of an individual trial.
                size : tuple of ints
                    Number of values to draw from the distribution.  The output
                    is shaped according to `size`.
        
                Returns
                -------
                out : ndarray
                    Samples from the geometric distribution, shaped according to
                    `size`.
        
                Examples
                --------
                Draw ten thousand values from the geometric distribution,
                with the probability of an individual success equal to 0.35:
        
                >>> z = np.random.geometric(p=0.35, size=10000)
        
                How many trials succeeded after a single run?
        
                >>> (z == 1).sum() / 10000.
                0.34889999999999999 #random
        """
        pass

    def get_state(self): # real signature unknown; restored from __doc__
        """
        get_state()
        
                Return a tuple representing the internal state of the generator::
        
                    ('MT19937', int key[624], int pos, int has_gauss, float cached_gaussian)
        """
        pass

    def gumbel(self, loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
        """
        gumbel(loc=0.0, scale=1.0, size=None)
        
                Gumbel distribution.
        
                Draw samples from a Gumbel distribution with specified location (or mean)
                and scale (or standard deviation).
        
                The Gumbel (or Smallest Extreme Value (SEV) or the Smallest Extreme Value
                Type I) distribution is one of a class of Generalized Extreme Value (GEV)
                distributions used in modeling extreme value problems.  The Gumbel is a
                special case of the Extreme Value Type I distribution for maximums from
                distributions with "exponential-like" tails, it may be derived by
                considering a Gaussian process of measurements, and generating the pdf for
                the maximum values from that set of measurements (see examples).
        
                Parameters
                ----------
                loc : float
                    The location of the mode of the distribution.
                scale : float
                    The scale parameter of the distribution.
                size : tuple of ints
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                See Also
                --------
                scipy.stats.gumbel : probability density function,
                    distribution or cumulative density function, etc.
                weibull, scipy.stats.genextreme
        
                Notes
                -----
                The probability density for the Gumbel distribution is
        
                .. math:: p(x) = \frac{e^{-(x - \mu)/ \beta}}{\beta} e^{ -e^{-(x - \mu)/
                          \beta}},
        
                where :math:`\mu` is the mode, a location parameter, and :math:`\beta`
                is the scale parameter.
        
                The Gumbel (named for German mathematician Emil Julius Gumbel) was used
                very early in the hydrology literature, for modeling the occurrence of
                flood events. It is also used for modeling maximum wind speed and rainfall
                rates.  It is a "fat-tailed" distribution - the probability of an event in
                the tail of the distribution is larger than if one used a Gaussian, hence
                the surprisingly frequent occurrence of 100-year floods. Floods were
                initially modeled as a Gaussian process, which underestimated the frequency
                of extreme events.
        
                It is one of a class of extreme value distributions, the Generalized
                Extreme Value (GEV) distributions, which also includes the Weibull and
                Frechet.
        
                The function has a mean of :math:`\mu + 0.57721\beta` and a variance of
                :math:`\frac{\pi^2}{6}\beta^2`.
        
                References
                ----------
                .. [1] Gumbel, E.J. (1958). Statistics of Extremes. Columbia University
                       Press.
                .. [2] Reiss, R.-D. and Thomas M. (2001), Statistical Analysis of Extreme
                       Values, from Insurance, Finance, Hydrology and Other Fields,
                       Birkhauser Verlag, Basel: Boston : Berlin.
                .. [3] Wikipedia, "Gumbel distribution",
                       http://en.wikipedia.org/wiki/Gumbel_distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> mu, beta = 0, 0.1 # location and scale
                >>> s = np.random.gumbel(mu, beta, 1000)
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> count, bins, ignored = plt.hist(s, 30, normed=True)
                >>> plt.plot(bins, (1/beta)*np.exp(-(bins - mu)/beta)
                ...          * np.exp( -np.exp( -(bins - mu) /beta) ),
                ...          linewidth=2, color='r')
                >>> plt.show()
        
                Show how an extreme value distribution can arise from a Gaussian process
                and compare to a Gaussian:
        
                >>> means = []
                >>> maxima = []
                >>> for i in range(0,1000) :
                ...    a = np.random.normal(mu, beta, 1000)
                ...    means.append(a.mean())
                ...    maxima.append(a.max())
                >>> count, bins, ignored = plt.hist(maxima, 30, normed=True)
                >>> beta = np.std(maxima)*np.pi/np.sqrt(6)
                >>> mu = np.mean(maxima) - 0.57721*beta
                >>> plt.plot(bins, (1/beta)*np.exp(-(bins - mu)/beta)
                ...          * np.exp(-np.exp(-(bins - mu)/beta)),
                ...          linewidth=2, color='r')
                >>> plt.plot(bins, 1/(beta * np.sqrt(2 * np.pi))
                ...          * np.exp(-(bins - mu)**2 / (2 * beta**2)),
                ...          linewidth=2, color='g')
                >>> plt.show()
        """
        pass

    def hypergeometric(self, ngood, nbad, nsample, size=None): # real signature unknown; restored from __doc__
        """
        hypergeometric(ngood, nbad, nsample, size=None)
        
                Draw samples from a Hypergeometric distribution.
        
                Samples are drawn from a Hypergeometric distribution with specified
                parameters, ngood (ways to make a good selection), nbad (ways to make
                a bad selection), and nsample = number of items sampled, which is less
                than or equal to the sum ngood + nbad.
        
                Parameters
                ----------
                ngood : float (but truncated to an integer)
                        parameter, > 0.
                nbad  : float
                        parameter, >= 0.
                nsample  : float
                           parameter, > 0 and <= ngood+nbad
                size : {tuple, int}
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                Returns
                -------
                samples : {ndarray, scalar}
                          where the values are all integers in  [0, n].
        
                See Also
                --------
                scipy.stats.distributions.hypergeom : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Hypergeometric distribution is
        
                .. math:: P(x) = \frac{\binom{m}{n}\binom{N-m}{n-x}}{\binom{N}{n}},
        
                where :math:`0 \le x \le m` and :math:`n+m-N \le x \le n`
        
                for P(x) the probability of x successes, n = ngood, m = nbad, and
                N = number of samples.
        
                Consider an urn with black and white marbles in it, ngood of them
                black and nbad are white. If you draw nsample balls without
                replacement, then the Hypergeometric distribution describes the
                distribution of black balls in the drawn sample.
        
                Note that this distribution is very similar to the Binomial
                distribution, except that in this case, samples are drawn without
                replacement, whereas in the Binomial case samples are drawn with
                replacement (or the sample space is infinite). As the sample space
                becomes large, this distribution approaches the Binomial.
        
                References
                ----------
                .. [1] Lentner, Marvin, "Elementary Applied Statistics", Bogden
                       and Quigley, 1972.
                .. [2] Weisstein, Eric W. "Hypergeometric Distribution." From
                       MathWorld--A Wolfram Web Resource.
                       http://mathworld.wolfram.com/HypergeometricDistribution.html
                .. [3] Wikipedia, "Hypergeometric-distribution",
                       http://en.wikipedia.org/wiki/Hypergeometric-distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> ngood, nbad, nsamp = 100, 2, 10
                # number of good, number of bad, and number of samples
                >>> s = np.random.hypergeometric(ngood, nbad, nsamp, 1000)
                >>> hist(s)
                #   note that it is very unlikely to grab both bad items
        
                Suppose you have an urn with 15 white and 15 black marbles.
                If you pull 15 marbles at random, how likely is it that
                12 or more of them are one color?
        
                >>> s = np.random.hypergeometric(15, 15, 15, 100000)
                >>> sum(s>=12)/100000. + sum(s<=3)/100000.
                #   answer = 0.003 ... pretty unlikely!
        """
        pass

    def laplace(self, loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
        """
        laplace(loc=0.0, scale=1.0, size=None)
        
                Laplace or double exponential distribution.
        
                It has the probability density function
        
                .. math:: f(x; \mu, \lambda) = \frac{1}{2\lambda}
                                               \exp\left(-\frac{|x - \mu|}{\lambda}\right).
        
                The Laplace distribution is similar to the Gaussian/normal distribution,
                but is sharper at the peak and has fatter tails.
        
                Parameters
                ----------
                loc : float
                    The position, :math:`\mu`, of the distribution peak.
                scale : float
                    :math:`\lambda`, the exponential decay.
        """
        pass

    def logistic(self, loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
        """
        logistic(loc=0.0, scale=1.0, size=None)
        
                Draw samples from a Logistic distribution.
        
                Samples are drawn from a Logistic distribution with specified
                parameters, loc (location or mean, also median), and scale (>0).
        
                Parameters
                ----------
                loc : float
        
                scale : float > 0.
        
                size : {tuple, int}
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                Returns
                -------
                samples : {ndarray, scalar}
                          where the values are all integers in  [0, n].
        
                See Also
                --------
                scipy.stats.distributions.logistic : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Logistic distribution is
        
                .. math:: P(x) = P(x) = \frac{e^{-(x-\mu)/s}}{s(1+e^{-(x-\mu)/s})^2},
        
                where :math:`\mu` = location and :math:`s` = scale.
        
                The Logistic distribution is used in Extreme Value problems where it
                can act as a mixture of Gumbel distributions, in Epidemiology, and by
                the World Chess Federation (FIDE) where it is used in the Elo ranking
                system, assuming the performance of each player is a logistically
                distributed random variable.
        
                References
                ----------
                .. [1] Reiss, R.-D. and Thomas M. (2001), Statistical Analysis of Extreme
                       Values, from Insurance, Finance, Hydrology and Other Fields,
                       Birkhauser Verlag, Basel, pp 132-133.
                .. [2] Weisstein, Eric W. "Logistic Distribution." From
                       MathWorld--A Wolfram Web Resource.
                       http://mathworld.wolfram.com/LogisticDistribution.html
                .. [3] Wikipedia, "Logistic-distribution",
                       http://en.wikipedia.org/wiki/Logistic-distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> loc, scale = 10, 1
                >>> s = np.random.logistic(loc, scale, 10000)
                >>> count, bins, ignored = plt.hist(s, bins=50)
        
                #   plot against distribution
        
                >>> def logist(x, loc, scale):
                ...     return exp((loc-x)/scale)/(scale*(1+exp((loc-x)/scale))**2)
                >>> plt.plot(bins, logist(bins, loc, scale)*count.max()/\
                ... logist(bins, loc, scale).max())
                >>> plt.show()
        """
        pass

    def lognormal(self, mean=0.0, sigma=1.0, size=None): # real signature unknown; restored from __doc__
        """
        lognormal(mean=0.0, sigma=1.0, size=None)
        
                Return samples drawn from a log-normal distribution.
        
                Draw samples from a log-normal distribution with specified mean, standard
                deviation, and shape. Note that the mean and standard deviation are not the
                values for the distribution itself, but of the underlying normal
                distribution it is derived from.
        
        
                Parameters
                ----------
                mean : float
                    Mean value of the underlying normal distribution
                sigma : float, >0.
                    Standard deviation of the underlying normal distribution
                size : tuple of ints
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                See Also
                --------
                scipy.stats.lognorm : probability density function, distribution,
                    cumulative density function, etc.
        
                Notes
                -----
                A variable `x` has a log-normal distribution if `log(x)` is normally
                distributed.
        
                The probability density function for the log-normal distribution is
        
                .. math:: p(x) = \frac{1}{\sigma x \sqrt{2\pi}}
                                 e^{(-\frac{(ln(x)-\mu)^2}{2\sigma^2})}
        
                where :math:`\mu` is the mean and :math:`\sigma` is the standard deviation
                of the normally distributed logarithm of the variable.
        
                A log-normal distribution results if a random variable is the *product* of
                a large number of independent, identically-distributed variables in the
                same way that a normal distribution results if the variable is the *sum*
                of a large number of independent, identically-distributed variables
                (see the last example). It is one of the so-called "fat-tailed"
                distributions.
        
                The log-normal distribution is commonly used to model the lifespan of units
                with fatigue-stress failure modes. Since this includes
                most mechanical systems, the log-normal distribution has widespread
                application.
        
                It is also commonly used to model oil field sizes, species abundance, and
                latent periods of infectious diseases.
        
                References
                ----------
                .. [1] Eckhard Limpert, Werner A. Stahel, and Markus Abbt, "Log-normal
                       Distributions across the Sciences: Keys and Clues", May 2001
                       Vol. 51 No. 5 BioScience
                       http://stat.ethz.ch/~stahel/lognormal/bioscience.pdf
                .. [2] Reiss, R.D., Thomas, M.(2001), Statistical Analysis of Extreme
                       Values, Birkhauser Verlag, Basel, pp 31-32.
                .. [3] Wikipedia, "Lognormal distribution",
                       http://en.wikipedia.org/wiki/Lognormal_distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> mu, sigma = 3., 1. # mean and standard deviation
                >>> s = np.random.lognormal(mu, sigma, 1000)
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> count, bins, ignored = plt.hist(s, 100, normed=True, align='center')
        
                >>> x = np.linspace(min(bins), max(bins), 10000)
                >>> pdf = (np.exp(-(np.log(x) - mu)**2 / (2 * sigma**2))
                ...        / (x * sigma * np.sqrt(2 * np.pi)))
        
                >>> plt.plot(x, pdf, linewidth=2, color='r')
                >>> plt.axis('tight')
                >>> plt.show()
        
                Demonstrate that taking the products of random samples from a uniform
                distribution can be fit well by a log-normal probability density function.
        
                >>> # Generate a thousand samples: each is the product of 100 random
                >>> # values, drawn from a normal distribution.
                >>> b = []
                >>> for i in range(1000):
                ...    a = 10. + np.random.random(100)
                ...    b.append(np.product(a))
        
                >>> b = np.array(b) / np.min(b) # scale values to be positive
        
                >>> count, bins, ignored = plt.hist(b, 100, normed=True, align='center')
        
                >>> sigma = np.std(np.log(b))
                >>> mu = np.mean(np.log(b))
        
                >>> x = np.linspace(min(bins), max(bins), 10000)
                >>> pdf = (np.exp(-(np.log(x) - mu)**2 / (2 * sigma**2))
                ...        / (x * sigma * np.sqrt(2 * np.pi)))
        
                >>> plt.plot(x, pdf, color='r', linewidth=2)
                >>> plt.show()
        """
        pass

    def logseries(self, p, size=None): # real signature unknown; restored from __doc__
        """
        logseries(p, size=None)
        
                Draw samples from a Logarithmic Series distribution.
        
                Samples are drawn from a Log Series distribution with specified
                parameter, p (probability, 0 < p < 1).
        
                Parameters
                ----------
                loc : float
        
                scale : float > 0.
        
                size : {tuple, int}
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                Returns
                -------
                samples : {ndarray, scalar}
                          where the values are all integers in  [0, n].
        
                See Also
                --------
                scipy.stats.distributions.logser : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Log Series distribution is
        
                .. math:: P(k) = \frac{-p^k}{k \ln(1-p)},
        
                where p = probability.
        
                The Log Series distribution is frequently used to represent species
                richness and occurrence, first proposed by Fisher, Corbet, and
                Williams in 1943 [2].  It may also be used to model the numbers of
                occupants seen in cars [3].
        
                References
                ----------
                .. [1] Buzas, Martin A.; Culver, Stephen J.,  Understanding regional
                       species diversity through the log series distribution of
                       occurrences: BIODIVERSITY RESEARCH Diversity & Distributions,
                       Volume 5, Number 5, September 1999 , pp. 187-195(9).
                .. [2] Fisher, R.A,, A.S. Corbet, and C.B. Williams. 1943. The
                       relation between the number of species and the number of
                       individuals in a random sample of an animal population.
                       Journal of Animal Ecology, 12:42-58.
                .. [3] D. J. Hand, F. Daly, D. Lunn, E. Ostrowski, A Handbook of Small
                       Data Sets, CRC Press, 1994.
                .. [4] Wikipedia, "Logarithmic-distribution",
                       http://en.wikipedia.org/wiki/Logarithmic-distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> a = .6
                >>> s = np.random.logseries(a, 10000)
                >>> count, bins, ignored = plt.hist(s)
        
                #   plot against distribution
        
                >>> def logseries(k, p):
                ...     return -p**k/(k*log(1-p))
                >>> plt.plot(bins, logseries(bins, a)*count.max()/\
                    logseries(bins, a).max(),'r')
                >>> plt.show()
        """
        pass

    def multinomial(self, n, pvals, size=None): # real signature unknown; restored from __doc__
        """
        multinomial(n, pvals, size=None)
        
                Draw samples from a multinomial distribution.
        
                The multinomial distribution is a multivariate generalisation of the
                binomial distribution.  Take an experiment with one of ``p``
                possible outcomes.  An example of such an experiment is throwing a dice,
                where the outcome can be 1 through 6.  Each sample drawn from the
                distribution represents `n` such experiments.  Its values,
                ``X_i = [X_0, X_1, ..., X_p]``, represent the number of times the outcome
                was ``i``.
        
                Parameters
                ----------
                n : int
                    Number of experiments.
                pvals : sequence of floats, length p
                    Probabilities of each of the ``p`` different outcomes.  These
                    should sum to 1 (however, the last element is always assumed to
                    account for the remaining probability, as long as
                    ``sum(pvals[:-1]) <= 1)``.
                size : tuple of ints
                    Given a `size` of ``(M, N, K)``, then ``M*N*K`` samples are drawn,
                    and the output shape becomes ``(M, N, K, p)``, since each sample
                    has shape ``(p,)``.
        
                Examples
                --------
                Throw a dice 20 times:
        
                >>> np.random.multinomial(20, [1/6.]*6, size=1)
                array([[4, 1, 7, 5, 2, 1]])
        
                It landed 4 times on 1, once on 2, etc.
        
                Now, throw the dice 20 times, and 20 times again:
        
                >>> np.random.multinomial(20, [1/6.]*6, size=2)
                array([[3, 4, 3, 3, 4, 3],
                       [2, 4, 3, 4, 0, 7]])
        
                For the first run, we threw 3 times 1, 4 times 2, etc.  For the second,
                we threw 2 times 1, 4 times 2, etc.
        
                A loaded dice is more likely to land on number 6:
        
                >>> np.random.multinomial(100, [1/7.]*5)
                array([13, 16, 13, 16, 42])
        """
        pass

    def multivariate_normal(self, mean, cov, size=None): # real signature unknown; restored from __doc__
        """
        multivariate_normal(mean, cov[, size])
        
                Draw random samples from a multivariate normal distribution.
        
                The multivariate normal, multinormal or Gaussian distribution is a
                generalisation of the one-dimensional normal distribution to higher
                dimensions.
        
                Such a distribution is specified by its mean and covariance matrix,
                which are analogous to the mean (average or "centre") and variance
                (standard deviation squared or "width") of the one-dimensional normal
                distribution.
        
                Parameters
                ----------
                mean : (N,) ndarray
                    Mean of the N-dimensional distribution.
                cov : (N,N) ndarray
                    Covariance matrix of the distribution.
                size : tuple of ints, optional
                    Given a shape of, for example, (m,n,k), m*n*k samples are
                    generated, and packed in an m-by-n-by-k arrangement.  Because each
                    sample is N-dimensional, the output shape is (m,n,k,N).  If no
                    shape is specified, a single sample is returned.
        
                Returns
                -------
                out : ndarray
                    The drawn samples, arranged according to `size`.  If the
                    shape given is (m,n,...), then the shape of `out` is is
                    (m,n,...,N).
        
                    In other words, each entry ``out[i,j,...,:]`` is an N-dimensional
                    value drawn from the distribution.
        
                Notes
                -----
                The mean is a coordinate in N-dimensional space, which represents the
                location where samples are most likely to be generated.  This is
                analogous to the peak of the bell curve for the one-dimensional or
                univariate normal distribution.
        
                Covariance indicates the level to which two variables vary together.
                From the multivariate normal distribution, we draw N-dimensional
                samples, :math:`X = [x_1, x_2, ... x_N]`.  The covariance matrix
                element :math:`C_{ij}` is the covariance of :math:`x_i` and :math:`x_j`.
                The element :math:`C_{ii}` is the variance of :math:`x_i` (i.e. its
                "spread").
        
                Instead of specifying the full covariance matrix, popular
                approximations include:
        
                  - Spherical covariance (`cov` is a multiple of the identity matrix)
                  - Diagonal covariance (`cov` has non-negative elements, and only on
                    the diagonal)
        
                This geometrical property can be seen in two dimensions by plotting
                generated data-points:
        
                >>> mean = [0,0]
                >>> cov = [[1,0],[0,100]] # diagonal covariance, points lie on x or y-axis
        
                >>> import matplotlib.pyplot as plt
                >>> x,y = np.random.multivariate_normal(mean,cov,5000).T
                >>> plt.plot(x,y,'x'); plt.axis('equal'); plt.show()
        
                Note that the covariance matrix must be non-negative definite.
        
                References
                ----------
                .. [1] A. Papoulis, "Probability, Random Variables, and Stochastic
                       Processes," 3rd ed., McGraw-Hill Companies, 1991
                .. [2] R.O. Duda, P.E. Hart, and D.G. Stork, "Pattern Classification,"
                       2nd ed., Wiley, 2001.
        
                Examples
                --------
                >>> mean = (1,2)
                >>> cov = [[1,0],[1,0]]
                >>> x = np.random.multivariate_normal(mean,cov,(3,3))
                >>> x.shape
                (3, 3, 2)
        
                The following is probably true, given that 0.6 is roughly twice the
                standard deviation:
        
                >>> print list( (x[0,0,:] - mean) < 0.6 )
                [True, True]
        """
        pass

    def negative_binomial(self, n, p, size=None): # real signature unknown; restored from __doc__
        """
        negative_binomial(n, p, size=None)
        
                Negative Binomial distribution.
        """
        pass

    def noncentral_chisquare(self, df, nonc, size=None): # real signature unknown; restored from __doc__
        """
        noncentral_chisquare(df, nonc, size=None)
        
                Draw samples from a noncentral chi-square distribution.
        
                The noncentral :math:`\chi^2` distribution is a generalisation of
                the :math:`\chi^2` distribution.
        
                Parameters
                ----------
                df : int
                    Degrees of freedom.
                nonc : float
                    Non-centrality.
                size : tuple of ints
                    Shape of the output.
        """
        pass

    def noncentral_f(self, dfnum, dfden, nonc, size=None): # real signature unknown; restored from __doc__
        """
        noncentral_f(dfnum, dfden, nonc, size=None)
        
                Noncentral F distribution.
        """
        pass

    def normal(self, loc=0.0, scale=1.0, size=None): # real signature unknown; restored from __doc__
        """
        normal(loc=0.0, scale=1.0, size=None)
        
                Draw random samples from a normal (Gaussian) distribution.
        
                The probability density function of the normal distribution, first
                derived by De Moivre and 200 years later by both Gauss and Laplace
                independently [2]_, is often called the bell curve because of
                its characteristic shape (see the example below).
        
                The normal distributions occurs often in nature.  For example, it
                describes the commonly occurring distribution of samples influenced
                by a large number of tiny, random disturbances, each with its own
                unique distribution [2]_.
        
                Parameters
                ----------
                loc : float
                    Mean ("centre") of the distribution.
                scale : float
                    Standard deviation (spread or "width") of the distribution.
                size : tuple of ints
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                See Also
                --------
                scipy.stats.distributions.norm : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Gaussian distribution is
        
                .. math:: p(x) = \frac{1}{\sqrt{ 2 \pi \sigma^2 }}
                                 e^{ - \frac{ (x - \mu)^2 } {2 \sigma^2} },
        
                where :math:`\mu` is the mean and :math:`\sigma` the standard deviation.
                The square of the standard deviation, :math:`\sigma^2`, is called the
                variance.
        
                The function has its peak at the mean, and its "spread" increases with
                the standard deviation (the function reaches 0.607 times its maximum at
                :math:`x + \sigma` and :math:`x - \sigma` [2]_).  This implies that
                `numpy.random.normal` is more likely to return samples lying close to the
                mean, rather than those far away.
        
                References
                ----------
                .. [1] Wikipedia, "Normal distribution",
                       http://en.wikipedia.org/wiki/Normal_distribution
                .. [2] P. R. Peebles Jr., "Central Limit Theorem" in "Probability, Random
                       Variables and Random Signal Principles", 4th ed., 2001,
                       pp. 51, 51, 125.
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> mu, sigma = 0, 0.1 # mean and standard deviation
                >>> s = np.random.normal(mu, sigma, 1000)
        
                Verify the mean and the variance:
        
                >>> abs(mu - np.mean(s)) < 0.01
                True
        
                >>> abs(sigma - np.std(s, ddof=1)) < 0.01
                True
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> count, bins, ignored = plt.hist(s, 30, normed=True)
                >>> plt.plot(bins, 1/(sigma * np.sqrt(2 * np.pi)) *
                ...                np.exp( - (bins - mu)**2 / (2 * sigma**2) ),
                ...          linewidth=2, color='r')
                >>> plt.show()
        """
        pass

    def pareto(self, a, size=None): # real signature unknown; restored from __doc__
        """
        pareto(a, size=None)
        
                Draw samples from a Pareto distribution with specified shape.
        
                This is a simplified version of the Generalized Pareto distribution
                (available in SciPy), with the scale set to one and the location set to
                zero. Most authors default the location to one.
        
                The Pareto distribution must be greater than zero, and is unbounded above.
                It is also known as the "80-20 rule".  In this distribution, 80 percent of
                the weights are in the lowest 20 percent of the range, while the other 20
                percent fill the remaining 80 percent of the range.
        
                Parameters
                ----------
                shape : float, > 0.
                    Shape of the distribution.
                size : tuple of ints
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                See Also
                --------
                scipy.stats.distributions.genpareto.pdf : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Pareto distribution is
        
                .. math:: p(x) = \frac{am^a}{x^{a+1}}
        
                where :math:`a` is the shape and :math:`m` the location
        
                The Pareto distribution, named after the Italian economist Vilfredo Pareto,
                is a power law probability distribution useful in many real world problems.
                Outside the field of economics it is generally referred to as the Bradford
                distribution. Pareto developed the distribution to describe the
                distribution of wealth in an economy.  It has also found use in insurance,
                web page access statistics, oil field sizes, and many other problems,
                including the download frequency for projects in Sourceforge [1].  It is
                one of the so-called "fat-tailed" distributions.
        
        
                References
                ----------
                .. [1] Francis Hunt and Paul Johnson, On the Pareto Distribution of
                       Sourceforge projects.
                .. [2] Pareto, V. (1896). Course of Political Economy. Lausanne.
                .. [3] Reiss, R.D., Thomas, M.(2001), Statistical Analysis of Extreme
                       Values, Birkhauser Verlag, Basel, pp 23-30.
                .. [4] Wikipedia, "Pareto distribution",
                       http://en.wikipedia.org/wiki/Pareto_distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> a, m = 3., 1. # shape and mode
                >>> s = np.random.pareto(a, 1000) + m
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> count, bins, ignored = plt.hist(s, 100, normed=True, align='center')
                >>> fit = a*m**a/bins**(a+1)
                >>> plt.plot(bins, max(count)*fit/max(fit),linewidth=2, color='r')
                >>> plt.show()
        """
        pass

    def permutation(self, x): # real signature unknown; restored from __doc__
        """
        permutation(x)
        
                Randomly permute a sequence, or return a permuted range.
        
                Parameters
                ----------
                x : int or array_like
                    If `x` is an integer, randomly permute ``np.arange(x)``.
                    If `x` is an array, make a copy and shuffle the elements
                    randomly.
        
                Returns
                -------
                out : ndarray
                    Permuted sequence or array range.
        
                Examples
                --------
                >>> np.random.permutation(10)
                array([1, 7, 4, 3, 0, 9, 2, 5, 8, 6])
        
                >>> np.random.permutation([1, 4, 9, 12, 15])
                array([15,  1,  9,  4, 12])
        """
        pass

    def poisson(self, lam=1.0, size=None): # real signature unknown; restored from __doc__
        """
        poisson(lam=1.0, size=None)
        
                Poisson distribution.
        """
        pass

    def power(self, a, size=None): # real signature unknown; restored from __doc__
        """
        power(a, size=None)
        
                Power distribution.
        """
        pass

    def rand(self, d0, d1, *more, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        rand(d0, d1, ..., dn)
        
                Random values in a given shape.
        
                Create an array of the given shape and propagate it with
                random samples from a uniform distribution
                over ``[0, 1)``.
        
                Parameters
                ----------
                d0, d1, ..., dn : int
                    Shape of the output.
        
                Returns
                -------
                out : ndarray, shape ``(d0, d1, ..., dn)``
                    Random values.
        
                See Also
                --------
                random
        
                Notes
                -----
                This is a convenience function. If you want an interface that
                takes a shape-tuple as the first argument, refer to
                `random`.
        
                Examples
                --------
                >>> np.random.rand(3,2)
                array([[ 0.14022471,  0.96360618],  #random
                       [ 0.37601032,  0.25528411],  #random
                       [ 0.49313049,  0.94909878]]) #random
        """
        pass

    def randint(self, low, high=None, size=None): # real signature unknown; restored from __doc__
        """
        randint(low, high=None, size=None)
        
                Return random integers x such that low <= x < high.
        
                If high is None, then 0 <= x < low.
        """
        pass

    def randn(self, d0, d1, *more, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        randn(d0, d1, ..., dn)
        
                Returns zero-mean, unit-variance Gaussian random numbers in an
                array of shape (d0, d1, ..., dn).
        
                Note:  This is a convenience function. If you want an
                            interface that takes a tuple as the first argument
                            use numpy.random.standard_normal(shape_tuple).
        """
        pass

    def random_integers(self, low, high=None, size=None): # real signature unknown; restored from __doc__
        """
        random_integers(low, high=None, size=None)
        
                Return random integers x such that low <= x <= high.
        
                If high is None, then 1 <= x <= low.
        """
        pass

    def random_sample(self, size=None): # real signature unknown; restored from __doc__
        """
        random_sample(size=None)
        
                Return random floats in the half-open interval [0.0, 1.0).
        """
        pass

    def rayleigh(self, scale=1.0, size=None): # real signature unknown; restored from __doc__
        """
        rayleigh(scale=1.0, size=None)
        
                Rayleigh distribution.
        """
        pass

    def seed(self, seed=None): # real signature unknown; restored from __doc__
        """
        seed(seed=None)
        
                Seed the generator.
        
                seed can be an integer, an array (or other sequence) of integers of any
                length, or None. If seed is None, then RandomState will try to read data
                from /dev/urandom (or the Windows analogue) if available or seed from
                the clock otherwise.
        """
        pass

    def set_state(self, state): # real signature unknown; restored from __doc__
        """
        set_state(state)
        
                Set the state from a tuple.
        
                state = ('MT19937', int key[624], int pos, int has_gauss, float cached_gaussian)
        
                For backwards compatibility, the following form is also accepted
                although it is missing some information about the cached Gaussian value.
        
                state = ('MT19937', int key[624], int pos)
        """
        pass

    def shuffle(self, x): # real signature unknown; restored from __doc__
        """
        shuffle(x)
        
                Modify a sequence in-place by shuffling its contents.
        """
        pass

    def standard_cauchy(self, size=None): # real signature unknown; restored from __doc__
        """
        standard_cauchy(size=None)
        
                Standard Cauchy with mode=0.
        """
        pass

    def standard_exponential(self, size=None): # real signature unknown; restored from __doc__
        """
        standard_exponential(size=None)
        
                Standard exponential distribution (scale=1).
        """
        pass

    def standard_gamma(self, shape, size=None): # real signature unknown; restored from __doc__
        """
        standard_gamma(shape, size=None)
        
                Standard Gamma distribution.
        """
        pass

    def standard_normal(self, size=None): # real signature unknown; restored from __doc__
        """
        standard_normal(size=None)
        
                Standard Normal distribution (mean=0, stdev=1).
        """
        pass

    def standard_t(self, df, size=None): # real signature unknown; restored from __doc__
        """
        standard_t(df, size=None)
        
                Standard Student's t distribution with df degrees of freedom.
        """
        pass

    def tomaxint(self, size=None): # real signature unknown; restored from __doc__
        """
        tomaxint(size=None)
        
                Uniformly sample discrete random integers `x` such that
                ``0 <= x <= sys.maxint``.
        
                Parameters
                ----------
                size : tuple of ints, int, optional
                    Shape of output.  If the given size is, for example, (m,n,k),
                    m*n*k samples are generated.  If no shape is specified, a single sample
                    is returned.
        
                Returns
                -------
                out : ndarray
                    Drawn samples, with shape `size`.
        
                See Also
                --------
                randint : Uniform sampling over a given half-open interval of integers.
                random_integers : Uniform sampling over a given closed interval of
                    integers.
        """
        pass

    def triangular(self, left, mode, right, size=None): # real signature unknown; restored from __doc__
        """
        triangular(left, mode, right, size=None)
        
                Triangular distribution starting at left, peaking at mode, and
                ending at right (left <= mode <= right).
        """
        pass

    def uniform(self, low=0.0, high=1.0, size=1): # real signature unknown; restored from __doc__
        """
        uniform(low=0.0, high=1.0, size=1)
        
                Draw samples from a uniform distribution.
        
                Samples are uniformly distributed over the half-open interval
                ``[low, high)`` (includes low, but excludes high).  In other words,
                any value within the given interval is equally likely to be drawn
                by `uniform`.
        
                Parameters
                ----------
                low : float, optional
                    Lower boundary of the output interval.  All values generated will be
                    greater than or equal to low.  The default value is 0.
                high : float
                    Upper boundary of the output interval.  All values generated will be
                    less than high.  The default value is 1.0.
                size : tuple of ints, int, optional
                    Shape of output.  If the given size is, for example, (m,n,k),
                    m*n*k samples are generated.  If no shape is specified, a single sample
                    is returned.
        
                Returns
                -------
                out : ndarray
                    Drawn samples, with shape `size`.
        
                See Also
                --------
                randint : Discrete uniform distribution, yielding integers.
                random_integers : Discrete uniform distribution over the closed interval
                                  ``[low, high]``.
                random_sample : Floats uniformly distributed over ``[0, 1)``.
                random : Alias for `random_sample`.
                rand : Convenience function that accepts dimensions as input, e.g.,
                       ``rand(2,2)`` would generate a 2-by-2 array of floats, uniformly
                       distributed over ``[0, 1)``.
        
                Notes
                -----
                The probability density function of the uniform distribution is
        
                .. math:: p(x) = \frac{1}{b - a}
        
                anywhere within the interval ``[a, b)``, and zero elsewhere.
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> s = np.random.uniform(-1,0,1000)
        
                All values are within the given interval:
        
                >>> np.all(s >= -1)
                True
        
                >>> np.all(s < 0)
                True
        
                Display the histogram of the samples, along with the
                probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> count, bins, ignored = plt.hist(s, 15, normed=True)
                >>> plt.plot(bins, np.ones_like(bins), linewidth=2, color='r')
                >>> plt.show()
        """
        pass

    def vonmises(self, mu=0.0, kappa=1.0, size=None): # real signature unknown; restored from __doc__
        """
        vonmises(mu=0.0, kappa=1.0, size=None)
        
                Draw samples from a von Mises distribution.
        
                Samples are drawn from a von Mises distribution with specified mode (mu)
                and dispersion (kappa), on the interval [-pi, pi].
        
                The von Mises distribution (also known as the circular normal
                distribution) is a continuous probability distribution on the circle. It
                may be thought of as the circular analogue of the normal distribution.
        
                Parameters
                ----------
                mu : float
                    Mode ("center") of the distribution.
                kappa : float, >= 0.
                    Dispersion of the distribution.
                size : {tuple, int}
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                Returns
                -------
                samples : {ndarray, scalar}
                    The returned samples live on the unit circle [-\pi, \pi].
        
                See Also
                --------
                scipy.stats.distributions.vonmises : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the von Mises distribution is
        
                .. math:: p(x) = \frac{e^{\kappa cos(x-\mu)}}{2\pi I_0(\kappa)},
        
                where :math:`\mu` is the mode and :math:`\kappa` the dispersion,
                and :math:`I_0(\kappa)` is the modified Bessel function of order 0.
        
                The von Mises, named for Richard Edler von Mises, born in
                Austria-Hungary, in what is now the Ukraine. He fled to the United
                States in 1939 and became a professor at Harvard. He worked in
                probability theory, aerodynamics, fluid mechanics, and philosophy of
                science.
        
                References
                ----------
                .. [1] Abramowitz, M. and Stegun, I. A. (ed.), Handbook of Mathematical
                       Functions, National Bureau of Standards, 1964; reprinted Dover
                       Publications, 1965.
                .. [2] von Mises, Richard, 1964, Mathematical Theory of Probability
                       and Statistics (New York: Academic Press).
                .. [3] Wikipedia, "Von Mises distribution",
                       http://en.wikipedia.org/wiki/Von_Mises_distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> mu, kappa = 0.0, 4.0 # mean and dispersion
                >>> s = np.random.vonmises(mu, kappa, 1000)
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> import scipy.special as sps
                >>> count, bins, ignored = plt.hist(s, 50, normed=True)
                >>> x = arange(-pi, pi, 2*pi/50.)
                >>> y = -np.exp(kappa*np.cos(x-mu))/(2*pi*sps.jn(0,kappa))
                >>> plt.plot(x, y/max(y), linewidth=2, color='r')
                >>> plt.show()
        """
        pass

    def wald(self, mean, scale, size=None): # real signature unknown; restored from __doc__
        """
        wald(mean, scale, size=None)
        
                Wald (inverse Gaussian) distribution.
        """
        pass

    def weibull(self, a, size=None): # real signature unknown; restored from __doc__
        """
        weibull(a, size=None)
        
                Weibull distribution.
        
                Draw samples from a 1-parameter Weibull distribution with the given
                shape parameter.
        
                .. math:: X = (-ln(U))^{1/a}
        
                Here, U is drawn from the uniform distribution over (0,1].
        
                The more common 2-parameter Weibull, including a scale parameter
                :math:`\lambda` is just :math:`X = \lambda(-ln(U))^{1/a}`.
        
                The Weibull (or Type III asymptotic extreme value distribution for smallest
                values, SEV Type III, or Rosin-Rammler distribution) is one of a class of
                Generalized Extreme Value (GEV) distributions used in modeling extreme
                value problems.  This class includes the Gumbel and Frechet distributions.
        
                Parameters
                ----------
                a : float
                    Shape of the distribution.
                size : tuple of ints
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                See Also
                --------
                scipy.stats.distributions.weibull : probability density function,
                    distribution or cumulative density function, etc.
        
                gumbel, scipy.stats.distributions.genextreme
        
                Notes
                -----
                The probability density for the Weibull distribution is
        
                .. math:: p(x) = \frac{a}
                                 {\lambda}(\frac{x}{\lambda})^{a-1}e^{-(x/\lambda)^a},
        
                where :math:`a` is the shape and :math:`\lambda` the scale.
        
                The function has its peak (the mode) at
                :math:`\lambda(\frac{a-1}{a})^{1/a}`.
        
                When ``a = 1``, the Weibull distribution reduces to the exponential
                distribution.
        
                References
                ----------
                .. [1] Waloddi Weibull, Professor, Royal Technical University, Stockholm,
                       1939 "A Statistical Theory Of The Strength Of Materials",
                       Ingeniorsvetenskapsakademiens Handlingar Nr 151, 1939,
                       Generalstabens Litografiska Anstalts Forlag, Stockholm.
                .. [2] Waloddi Weibull, 1951 "A Statistical Distribution Function of Wide
                       Applicability",  Journal Of Applied Mechanics ASME Paper.
                .. [3] Wikipedia, "Weibull distribution",
                       http://en.wikipedia.org/wiki/Weibull_distribution
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> a = 5. # shape
                >>> s = np.random.weibull(a, 1000)
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> def weib(x,n,a):
                ...     return (a/n)*(x/n)**(a-1)*exp(-(x/n)**a)
        
                >>> count, bins, ignored = plt.hist(numpy.random.weibull(5.,1000))
                >>> scale = count.max()/weib(x, 1., 5.).max()
                >>> x = arange(1,100.)/50.
                >>> plt.plot(x, weib(x, 1., 5.)*scale)
                >>> plt.show()
        """
        pass

    def zipf(self, a, size=None): # real signature unknown; restored from __doc__
        """
        zipf(a, size=None)
        
                Draw samples from a Zipf distribution.
        
                Samples are drawn from a Zipf distribution with specified parameter (a),
                where a > 1.
        
                The zipf distribution (also known as the zeta
                distribution) is a continuous probability distribution that satisfies
                Zipf's law, where the frequency of an item is inversely proportional to
                its rank in a frequency table.
        
                Parameters
                ----------
                a : float
                    parameter, > 1.
                size : {tuple, int}
                    Output shape.  If the given shape is, e.g., ``(m, n, k)``, then
                    ``m * n * k`` samples are drawn.
        
                Returns
                -------
                samples : {ndarray, scalar}
                    The returned samples are greater than or equal to one.
        
                See Also
                --------
                scipy.stats.distributions.zipf : probability density function,
                    distribution or cumulative density function, etc.
        
                Notes
                -----
                The probability density for the Zipf distribution is
        
                .. math:: p(x) = \frac{x^{-a}}{\zeta(a)},
        
                where :math:`\zeta` is the Riemann Zeta function.
        
                Named after the American linguist George Kingsley Zipf, who noted that
                the frequency of any word in a sample of a language is inversely
                proportional to its rank in the frequency table.
        
        
                References
                ----------
                .. [1] Weisstein, Eric W. "Zipf Distribution." From MathWorld--A Wolfram
                       Web Resource. http://mathworld.wolfram.com/ZipfDistribution.html
                .. [2] Wikipedia, "Zeta distribution",
                       http://en.wikipedia.org/wiki/Zeta_distribution
                .. [3] Wikipedia, "Zipf's Law",
                       http://en.wikipedia.org/wiki/Zipf%27s_law
                .. [4] Zipf, George Kingsley (1932): Selected Studies of the Principle
                       of Relative Frequency in Language. Cambridge (Mass.).
        
                Examples
                --------
                Draw samples from the distribution:
        
                >>> a = 2. # parameter
                >>> s = np.random.zipf(a, 1000)
        
                Display the histogram of the samples, along with
                the probability density function:
        
                >>> import matplotlib.pyplot as plt
                >>> import scipy.special as sps
                Truncate s values at 50 so plot is interesting
                >>> count, bins, ignored = plt.hist(s[s<50], 50, normed=True)
                >>> x = arange(1., 50.)
                >>> y = x**(-a)/sps.zetac(a)
                >>> plt.plot(x, y/max(y), linewidth=2, color='r')
                >>> plt.show()
        """
        pass

    def __getstate__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, seed=None): # real signature unknown; restored from __doc__
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __reduce__(self, *args, **kwargs): # real signature unknown
        pass

    def __setstate__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

_rand = None # (!) real value is ''

