# encoding: utf-8
# module os
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyo by generator 1.99
"""
OS routines for Mac, NT, or Posix depending on what system we're on.

This exports:
  - all functions from posix, nt, os2, or ce, e.g. unlink, stat, etc.
  - os.path is one of the modules posixpath, or ntpath
  - os.name is 'posix', 'nt', 'os2', 'ce' or 'riscos'
  - os.curdir is a string representing the current directory ('.' or ':')
  - os.pardir is a string representing the parent directory ('..' or '::')
  - os.sep is the (or a most common) pathname separator ('/' or ':' or '\\')
  - os.extsep is the extension separator ('.' or '/')
  - os.altsep is the alternate pathname separator (None or '/')
  - os.pathsep is the component separator used in $PATH etc
  - os.linesep is the line separator in text files ('\r' or '\n' or '\r\n')
  - os.defpath is the default search path for executables
  - os.devnull is the file path of the null device ('/dev/null', etc.)

Programs that import and use 'os' stand a better chance of being
portable between different platforms.  Of course, they must then
only use functions that are defined by all platforms (e.g., unlink
and opendir), and leave all pathname manipulation to os.path
(e.g., split and join).
"""

# imports
import copy_reg as _copy_reg # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/copy_reg.pyc
import UserDict as UserDict # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/UserDict.pyc
import errno as errno # <module 'errno' (built-in)>
import posixpath as path # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/posixpath.pyc
import sys as sys # <module 'sys' (built-in)>
from exceptions import error

from posix import (WCOREDUMP, WEXITSTATUS, WIFCONTINUED, WIFEXITED, 
    WIFSIGNALED, WIFSTOPPED, WSTOPSIG, WTERMSIG, _exit, abort, access, chdir, 
    chflags, chmod, chown, chroot, close, closerange, confstr, ctermid, dup, 
    dup2, execv, execve, fchdir, fchmod, fchown, fdopen, fork, forkpty, 
    fpathconf, fstat, fstatvfs, fsync, ftruncate, getcwd, getcwdu, getegid, 
    geteuid, getgid, getgroups, getloadavg, getlogin, getpgid, getpgrp, 
    getpid, getppid, getsid, getuid, isatty, kill, killpg, lchflags, lchmod, 
    lchown, link, listdir, lseek, lstat, major, makedev, minor, mkdir, mkfifo, 
    mknod, nice, open, openpty, pathconf, pipe, popen, putenv, read, readlink, 
    remove, rename, rmdir, setegid, seteuid, setgid, setgroups, setpgid, 
    setpgrp, setregid, setreuid, setsid, setuid, stat, stat_float_times, 
    stat_result, statvfs, statvfs_result, strerror, symlink, sysconf, system, 
    tcgetpgrp, tcsetpgrp, tempnam, times, tmpfile, tmpnam, ttyname, umask, 
    uname, unlink, unsetenv, utime, wait, wait3, wait4, waitpid, write)


# Variables with simple values

altsep = None

curdir = '.'

defpath = ':/bin:/usr/bin'
devnull = '/dev/null'

extsep = '.'

EX_CANTCREAT = 73
EX_CONFIG = 78
EX_DATAERR = 65
EX_IOERR = 74
EX_NOHOST = 68
EX_NOINPUT = 66
EX_NOPERM = 77
EX_NOUSER = 67
EX_OK = 0
EX_OSERR = 71
EX_OSFILE = 72
EX_PROTOCOL = 76
EX_SOFTWARE = 70
EX_TEMPFAIL = 75
EX_UNAVAILABLE = 69
EX_USAGE = 64

F_OK = 0

linesep = '\n'

name = 'posix'

NGROUPS_MAX = 16

O_APPEND = 8
O_ASYNC = 64
O_CREAT = 512
O_DIRECTORY = 1048576
O_DSYNC = 4194304
O_EXCL = 2048
O_EXLOCK = 32
O_NDELAY = 4
O_NOCTTY = 131072
O_NOFOLLOW = 256
O_NONBLOCK = 4
O_RDONLY = 0
O_RDWR = 2
O_SHLOCK = 16
O_SYNC = 128
O_TRUNC = 1024
O_WRONLY = 1

pardir = '..'
pathsep = ':'

P_NOWAIT = 1
P_NOWAITO = 1
P_WAIT = 0

R_OK = 4

SEEK_CUR = 1
SEEK_END = 2
SEEK_SET = 0

sep = '/'

TMP_MAX = 308915776

WCONTINUED = 16

WNOHANG = 1

WUNTRACED = 2

W_OK = 2

X_OK = 1

# functions

def execl(file, *args): # reliably restored by inspect
    """
    execl(file, *args)
    
        Execute the executable file with argument list args, replacing the
        current process.
    """
    pass


def execle(file, *args): # reliably restored by inspect
    """
    execle(file, *args, env)
    
        Execute the executable file with argument list args and
        environment env, replacing the current process.
    """
    pass


def execlp(file, *args): # reliably restored by inspect
    """
    execlp(file, *args)
    
        Execute the executable file (which is searched for along $PATH)
        with argument list args, replacing the current process.
    """
    pass


def execlpe(file, *args): # reliably restored by inspect
    """
    execlpe(file, *args, env)
    
        Execute the executable file (which is searched for along $PATH)
        with argument list args and environment env, replacing the current
        process.
    """
    pass


def execvp(file, args): # reliably restored by inspect
    """
    execp(file, args)
    
        Execute the executable file (which is searched for along $PATH)
        with argument list args, replacing the current process.
        args may be a list or tuple of strings.
    """
    pass


def execvpe(file, args, env): # reliably restored by inspect
    """
    execvpe(file, args, env)
    
        Execute the executable file (which is searched for along $PATH)
        with argument list args and environment env , replacing the
        current process.
        args may be a list or tuple of strings.
    """
    pass


def getenv(key, default=None): # reliably restored by inspect
    """
    Get an environment variable, return None if it doesn't exist.
        The optional second argument can specify an alternate default.
    """
    pass


def makedirs(name, mode=511): # reliably restored by inspect
    """
    makedirs(path [, mode=0777])
    
        Super-mkdir; create a leaf directory and all intermediate ones.
        Works like mkdir, except that any intermediate path segment (not
        just the rightmost) will be created if it does not exist.  This is
        recursive.
    """
    pass


def popen2(cmd, mode=None, bufsize=-1): # reliably restored by inspect
    """
    Execute the shell command 'cmd' in a sub-process.  On UNIX, 'cmd'
                may be a sequence, in which case arguments will be passed directly to
                the program without shell intervention (as with os.spawnv()).  If 'cmd'
                is a string it will be passed to the shell (as with os.system()). If
                'bufsize' is specified, it sets the buffer size for the I/O pipes.  The
                file objects (child_stdin, child_stdout) are returned.
    """
    pass


def popen3(cmd, mode=None, bufsize=-1): # reliably restored by inspect
    """
    Execute the shell command 'cmd' in a sub-process.  On UNIX, 'cmd'
                may be a sequence, in which case arguments will be passed directly to
                the program without shell intervention (as with os.spawnv()).  If 'cmd'
                is a string it will be passed to the shell (as with os.system()). If
                'bufsize' is specified, it sets the buffer size for the I/O pipes.  The
                file objects (child_stdin, child_stdout, child_stderr) are returned.
    """
    pass


def popen4(cmd, mode=None, bufsize=-1): # reliably restored by inspect
    """
    Execute the shell command 'cmd' in a sub-process.  On UNIX, 'cmd'
                may be a sequence, in which case arguments will be passed directly to
                the program without shell intervention (as with os.spawnv()).  If 'cmd'
                is a string it will be passed to the shell (as with os.system()). If
                'bufsize' is specified, it sets the buffer size for the I/O pipes.  The
                file objects (child_stdin, child_stdout_stderr) are returned.
    """
    pass


def removedirs(name): # reliably restored by inspect
    """
    removedirs(path)
    
        Super-rmdir; remove a leaf directory and all empty intermediate
        ones.  Works like rmdir except that, if the leaf directory is
        successfully removed, directories corresponding to rightmost path
        segments will be pruned away until either the whole path is
        consumed or an error occurs.  Errors during this latter phase are
        ignored -- they generally mean that a directory was not empty.
    """
    pass


def renames(old, new): # reliably restored by inspect
    """
    renames(old, new)
    
        Super-rename; create directories as necessary and delete any left
        empty.  Works like rename, except creation of any intermediate
        directories needed to make the new pathname good is attempted
        first.  After the rename, directories corresponding to rightmost
        path segments of the old name will be pruned way until either the
        whole path is consumed or a nonempty directory is found.
    
        Note: this function can fail with the new directory structure made
        if you lack permissions needed to unlink the leaf directory or
        file.
    """
    pass


def spawnl(mode, file, *args): # reliably restored by inspect
    """
    spawnl(mode, file, *args) -> integer
    
    Execute file with arguments from args in a subprocess.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def spawnle(mode, file, *args): # reliably restored by inspect
    """
    spawnle(mode, file, *args, env) -> integer
    
    Execute file with arguments from args in a subprocess with the
    supplied environment.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def spawnlp(mode, file, *args): # reliably restored by inspect
    """
    spawnlp(mode, file, *args) -> integer
    
    Execute file (which is looked for along $PATH) with arguments from
    args in a subprocess with the supplied environment.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def spawnlpe(mode, file, *args): # reliably restored by inspect
    """
    spawnlpe(mode, file, *args, env) -> integer
    
    Execute file (which is looked for along $PATH) with arguments from
    args in a subprocess with the supplied environment.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def spawnv(mode, file, args): # reliably restored by inspect
    """
    spawnv(mode, file, args) -> integer
    
    Execute file with arguments from args in a subprocess.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def spawnve(mode, file, args, env): # reliably restored by inspect
    """
    spawnve(mode, file, args, env) -> integer
    
    Execute file with arguments from args in a subprocess with the
    specified environment.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def spawnvp(mode, file, args): # reliably restored by inspect
    """
    spawnvp(mode, file, args) -> integer
    
    Execute file (which is looked for along $PATH) with arguments from
    args in a subprocess.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def spawnvpe(mode, file, args, env): # reliably restored by inspect
    """
    spawnvpe(mode, file, args, env) -> integer
    
    Execute file (which is looked for along $PATH) with arguments from
    args in a subprocess with the supplied environment.
    If mode == P_NOWAIT return the pid of the process.
    If mode == P_WAIT return the process's exit code if it exits normally;
    otherwise return -SIG, where SIG is the signal that killed it.
    """
    pass


def urandom(n): # reliably restored by inspect
    """
    urandom(n) -> str
    
            Return a string of n random bytes suitable for cryptographic use.
    """
    pass


def walk(top, topdown=True, onerror=None, followlinks=False): # reliably restored by inspect
    """
    Directory tree generator.
    
        For each directory in the directory tree rooted at top (including top
        itself, but excluding '.' and '..'), yields a 3-tuple
    
            dirpath, dirnames, filenames
    
        dirpath is a string, the path to the directory.  dirnames is a list of
        the names of the subdirectories in dirpath (excluding '.' and '..').
        filenames is a list of the names of the non-directory files in dirpath.
        Note that the names in the lists are just names, with no path components.
        To get a full path (which begins with top) to a file or directory in
        dirpath, do os.path.join(dirpath, name).
    
        If optional arg 'topdown' is true or not specified, the triple for a
        directory is generated before the triples for any of its subdirectories
        (directories are generated top down).  If topdown is false, the triple
        for a directory is generated after the triples for all of its
        subdirectories (directories are generated bottom up).
    
        When topdown is true, the caller can modify the dirnames list in-place
        (e.g., via del or slice assignment), and walk will only recurse into the
        subdirectories whose names remain in dirnames; this can be used to prune
        the search, or to impose a specific order of visiting.  Modifying
        dirnames when topdown is false is ineffective, since the directories in
        dirnames have already been generated by the time dirnames itself is
        generated.
    
        By default errors from the os.listdir() call are ignored.  If
        optional arg 'onerror' is specified, it should be a function; it
        will be called with one argument, an os.error instance.  It can
        report the error to continue with the walk, or raise the exception
        to abort the walk.  Note that the filename is available as the
        filename attribute of the exception object.
    
        By default, os.walk does not follow symbolic links to subdirectories on
        systems that support them.  In order to get this functionality, set the
        optional argument 'followlinks' to true.
    
        Caution:  if you pass a relative pathname for top, don't change the
        current working directory between resumptions of walk.  walk never
        changes the current directory, and assumes that the client doesn't
        either.
    
        Example:
    
        import os
        from os.path import join, getsize
        for root, dirs, files in os.walk('python/Lib/email'):
            print root, "consumes",
            print sum([getsize(join(root, name)) for name in files]),
            print "bytes in", len(files), "non-directory files"
            if 'CVS' in dirs:
                dirs.remove('CVS')  # don't visit CVS directories
    """
    pass


def _execvpe(file, args, env=None): # reliably restored by inspect
    # no doc
    pass


def _exists(name): # reliably restored by inspect
    # no doc
    pass


def _get_exports_list(module): # reliably restored by inspect
    # no doc
    pass


def _make_statvfs_result(tup, dict): # reliably restored by inspect
    # no doc
    pass


def _make_stat_result(tup, dict): # reliably restored by inspect
    # no doc
    pass


def _pickle_statvfs_result(sr): # reliably restored by inspect
    # no doc
    pass


def _pickle_stat_result(sr): # reliably restored by inspect
    # no doc
    pass


def _spawnvef(mode, file, args, env, func): # reliably restored by inspect
    # no doc
    pass


# no classes
# variables with complex values

confstr_names = {
    'CS_DARWIN_USER_CACHE_DIR': 65538,
    'CS_DARWIN_USER_DIR': 65536,
    'CS_DARWIN_USER_TEMP_DIR': 65537,
    'CS_PATH': 1,
    'CS_XBS5_ILP32_OFF32_CFLAGS': 20,
    'CS_XBS5_ILP32_OFF32_LDFLAGS': 21,
    'CS_XBS5_ILP32_OFF32_LIBS': 22,
    'CS_XBS5_ILP32_OFF32_LINTFLAGS': 23,
    'CS_XBS5_ILP32_OFFBIG_CFLAGS': 24,
    'CS_XBS5_ILP32_OFFBIG_LDFLAGS': 25,
    'CS_XBS5_ILP32_OFFBIG_LIBS': 26,
    'CS_XBS5_ILP32_OFFBIG_LINTFLAGS': 27,
    'CS_XBS5_LP64_OFF64_CFLAGS': 28,
    'CS_XBS5_LP64_OFF64_LDFLAGS': 29,
    'CS_XBS5_LP64_OFF64_LIBS': 30,
    'CS_XBS5_LP64_OFF64_LINTFLAGS': 31,
    'CS_XBS5_LPBIG_OFFBIG_CFLAGS': 32,
    'CS_XBS5_LPBIG_OFFBIG_LDFLAGS': 33,
    'CS_XBS5_LPBIG_OFFBIG_LIBS': 34,
    'CS_XBS5_LPBIG_OFFBIG_LINTFLAGS': 35,
}

environ = None # (!) real value is ''

pathconf_names = {
    'PC_ASYNC_IO': 17,
    'PC_CHOWN_RESTRICTED': 7,
    'PC_FILESIZEBITS': 18,
    'PC_LINK_MAX': 1,
    'PC_MAX_CANON': 2,
    'PC_MAX_INPUT': 3,
    'PC_NAME_MAX': 4,
    'PC_NO_TRUNC': 8,
    'PC_PATH_MAX': 5,
    'PC_PIPE_BUF': 6,
    'PC_PRIO_IO': 19,
    'PC_SYNC_IO': 25,
    'PC_VDISABLE': 9,
}

sysconf_names = {
    'SC_2_CHAR_TERM': 20,
    'SC_2_C_BIND': 18,
    'SC_2_C_DEV': 19,
    'SC_2_FORT_DEV': 21,
    'SC_2_FORT_RUN': 22,
    'SC_2_LOCALEDEF': 23,
    'SC_2_SW_DEV': 24,
    'SC_2_UPE': 25,
    'SC_2_VERSION': 17,
    'SC_AIO_LISTIO_MAX': 42,
    'SC_AIO_MAX': 43,
    'SC_AIO_PRIO_DELTA_MAX': 44,
    'SC_ARG_MAX': 1,
    'SC_ASYNCHRONOUS_IO': 28,
    'SC_ATEXIT_MAX': 107,
    'SC_BC_BASE_MAX': 9,
    'SC_BC_DIM_MAX': 10,
    'SC_BC_SCALE_MAX': 11,
    'SC_BC_STRING_MAX': 12,
    'SC_CHILD_MAX': 2,
    'SC_CLK_TCK': 3,
    'SC_COLL_WEIGHTS_MAX': 13,
    'SC_DELAYTIMER_MAX': 45,
    'SC_EXPR_NEST_MAX': 14,
    'SC_FSYNC': 38,
    'SC_GETGR_R_SIZE_MAX': 70,
    'SC_GETPW_R_SIZE_MAX': 71,
    'SC_IOV_MAX': 56,
    'SC_JOB_CONTROL': 6,
    'SC_LINE_MAX': 15,
    'SC_LOGIN_NAME_MAX': 73,
    'SC_MAPPED_FILES': 47,
    'SC_MEMLOCK': 30,
    'SC_MEMLOCK_RANGE': 31,
    'SC_MEMORY_PROTECTION': 32,
    'SC_MESSAGE_PASSING': 33,
    'SC_MQ_OPEN_MAX': 46,
    'SC_MQ_PRIO_MAX': 75,
    'SC_NGROUPS_MAX': 4,
    'SC_NPROCESSORS_CONF': 57,
    'SC_NPROCESSORS_ONLN': 58,
    'SC_OPEN_MAX': 5,
    'SC_PAGESIZE': 29,
    'SC_PAGE_SIZE': 29,
    'SC_PASS_MAX': 131,
    'SC_PRIORITIZED_IO': 34,
    'SC_PRIORITY_SCHEDULING': 35,
    'SC_REALTIME_SIGNALS': 36,
    'SC_RE_DUP_MAX': 16,
    'SC_RTSIG_MAX': 48,
    'SC_SAVED_IDS': 7,
    'SC_SEMAPHORES': 37,
    'SC_SEM_NSEMS_MAX': 49,
    'SC_SEM_VALUE_MAX': 50,
    'SC_SHARED_MEMORY_OBJECTS': 39,
    'SC_SIGQUEUE_MAX': 51,
    'SC_STREAM_MAX': 26,
    'SC_SYNCHRONIZED_IO': 40,
    'SC_THREADS': 96,
    'SC_THREAD_ATTR_STACKADDR': 82,
    'SC_THREAD_ATTR_STACKSIZE': 83,
    'SC_THREAD_DESTRUCTOR_ITERATIONS': 85,
    'SC_THREAD_KEYS_MAX': 86,
    'SC_THREAD_PRIORITY_SCHEDULING': 89,
    'SC_THREAD_PRIO_INHERIT': 87,
    'SC_THREAD_PRIO_PROTECT': 88,
    'SC_THREAD_PROCESS_SHARED': 90,
    'SC_THREAD_SAFE_FUNCTIONS': 91,
    'SC_THREAD_STACK_MIN': 93,
    'SC_THREAD_THREADS_MAX': 94,
    'SC_TIMERS': 41,
    'SC_TIMER_MAX': 52,
    'SC_TTY_NAME_MAX': 101,
    'SC_TZNAME_MAX': 27,
    'SC_VERSION': 8,
    'SC_XBS5_ILP32_OFF32': 122,
    'SC_XBS5_ILP32_OFFBIG': 123,
    'SC_XBS5_LP64_OFF64': 124,
    'SC_XBS5_LPBIG_OFFBIG': 125,
    'SC_XOPEN_CRYPT': 108,
    'SC_XOPEN_ENH_I18N': 109,
    'SC_XOPEN_LEGACY': 110,
    'SC_XOPEN_REALTIME': 111,
    'SC_XOPEN_REALTIME_THREADS': 112,
    'SC_XOPEN_SHM': 113,
    'SC_XOPEN_UNIX': 115,
    'SC_XOPEN_VERSION': 116,
    'SC_XOPEN_XCU_VERSION': 121,
}

_Environ = None # (!) real value is ''

__all__ = [
    'altsep',
    'curdir',
    'pardir',
    'sep',
    'extsep',
    'pathsep',
    'linesep',
    'defpath',
    'name',
    'path',
    'devnull',
    'SEEK_SET',
    'SEEK_CUR',
    'SEEK_END',
    'EX_CANTCREAT',
    'EX_CONFIG',
    'EX_DATAERR',
    'EX_IOERR',
    'EX_NOHOST',
    'EX_NOINPUT',
    'EX_NOPERM',
    'EX_NOUSER',
    'EX_OK',
    'EX_OSERR',
    'EX_OSFILE',
    'EX_PROTOCOL',
    'EX_SOFTWARE',
    'EX_TEMPFAIL',
    'EX_UNAVAILABLE',
    'EX_USAGE',
    'F_OK',
    'NGROUPS_MAX',
    'O_APPEND',
    'O_ASYNC',
    'O_CREAT',
    'O_DIRECTORY',
    'O_DSYNC',
    'O_EXCL',
    'O_EXLOCK',
    'O_NDELAY',
    'O_NOCTTY',
    'O_NOFOLLOW',
    'O_NONBLOCK',
    'O_RDONLY',
    'O_RDWR',
    'O_SHLOCK',
    'O_SYNC',
    'O_TRUNC',
    'O_WRONLY',
    'R_OK',
    'TMP_MAX',
    'WCONTINUED',
    'WCOREDUMP',
    'WEXITSTATUS',
    'WIFCONTINUED',
    'WIFEXITED',
    'WIFSIGNALED',
    'WIFSTOPPED',
    'WNOHANG',
    'WSTOPSIG',
    'WTERMSIG',
    'WUNTRACED',
    'W_OK',
    'X_OK',
    'abort',
    'access',
    'chdir',
    'chflags',
    'chmod',
    'chown',
    'chroot',
    'close',
    'closerange',
    'confstr',
    'confstr_names',
    'ctermid',
    'dup',
    'dup2',
    'environ',
    'error',
    'execv',
    'execve',
    'fchdir',
    'fchmod',
    'fchown',
    'fdopen',
    'fork',
    'forkpty',
    'fpathconf',
    'fstat',
    'fstatvfs',
    'fsync',
    'ftruncate',
    'getcwd',
    'getcwdu',
    'getegid',
    'geteuid',
    'getgid',
    'getgroups',
    'getloadavg',
    'getlogin',
    'getpgid',
    'getpgrp',
    'getpid',
    'getppid',
    'getsid',
    'getuid',
    'isatty',
    'kill',
    'killpg',
    'lchflags',
    'lchmod',
    'lchown',
    'link',
    'listdir',
    'lseek',
    'lstat',
    'major',
    'makedev',
    'minor',
    'mkdir',
    'mkfifo',
    'mknod',
    'nice',
    'open',
    'openpty',
    'pathconf',
    'pathconf_names',
    'pipe',
    'popen',
    'putenv',
    'read',
    'readlink',
    'remove',
    'rename',
    'rmdir',
    'setegid',
    'seteuid',
    'setgid',
    'setgroups',
    'setpgid',
    'setpgrp',
    'setregid',
    'setreuid',
    'setsid',
    'setuid',
    'stat',
    'stat_float_times',
    'stat_result',
    'statvfs',
    'statvfs_result',
    'strerror',
    'symlink',
    'sysconf',
    'sysconf_names',
    'system',
    'tcgetpgrp',
    'tcsetpgrp',
    'tempnam',
    'times',
    'tmpfile',
    'tmpnam',
    'ttyname',
    'umask',
    'uname',
    'unlink',
    'unsetenv',
    'utime',
    'wait',
    'wait3',
    'wait4',
    'waitpid',
    'write',
    'makedirs',
    'removedirs',
    'renames',
    'walk',
    'execl',
    'execle',
    'execlp',
    'execlpe',
    'execvp',
    'execvpe',
    'getenv',
    'spawnv',
    'spawnve',
    'spawnl',
    'spawnle',
    'spawnvp',
    'spawnvpe',
    'spawnlp',
    'spawnlpe',
    'popen2',
    'popen3',
    'popen4',
]

