# encoding: utf-8
# module plistlib
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/plistlib.pyo by generator 1.99
"""
plistlib.py -- a tool to generate and parse MacOSX .plist files.

The PropertyList (.plist) file format is a simple XML pickle supporting
basic object types, like dictionaries, lists, numbers and strings.
Usually the top level object is a dictionary.

To write out a plist file, use the writePlist(rootObject, pathOrFile)
function. 'rootObject' is the top level object, 'pathOrFile' is a
filename or a (writable) file object.

To parse a plist from a file, use the readPlist(pathOrFile) function,
with a file name or a (readable) file object as the only argument. It
returns the top level object (again, usually a dictionary).

To work with plist data in strings, you can use readPlistFromString()
and writePlistToString().

Values can be strings, integers, floats, booleans, tuples, lists,
dictionaries, Data or datetime.datetime objects. String values (including
dictionary keys) may be unicode strings -- they will be written out as
UTF-8.

The <data> plist type is supported through the Data class. This is a
thin wrapper around a Python string.

Generate Plist example:

    pl = dict(
        aString="Doodah",
        aList=["A", "B", 12, 32.1, [1, 2, 3]],
        aFloat=0.1,
        anInt=728,
        aDict=dict(
            anotherString="<hello & hi there!>",
            aUnicodeValue=u'M�ig, Ma�,
            aTrueValue=True,
            aFalseValue=False,
        ),
        someData=Data("<binary gunk>"),
        someMoreData=Data("<lots of binary gunk>" * 10),
        aDate=datetime.datetime.fromtimestamp(time.mktime(time.gmtime())),
    )
    # unicode keys are possible, but a little awkward to use:
    pl[u'�enraa'] = "That was a unicode key."
    writePlist(pl, fileName)

Parse Plist example:

    pl = readPlist(pathOrFile)
    print pl["aKey"]
"""

# imports
import datetime as datetime # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/datetime.so
import binascii as binascii # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/binascii.so
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import warnings as warnings # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/warnings.pyc
from cStringIO import StringIO


# Variables with simple values

PLISTHEADER = '<?xml version="1.0" encoding="UTF-8"?>\n<!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">\n'

# functions

def readPlist(pathOrFile): # reliably restored by inspect
    """
    Read a .plist file. 'pathOrFile' may either be a file name or a
        (readable) file object. Return the unpacked root object (which
        usually is a dictionary).
    """
    pass


def readPlistFromResource(path, restype=None, resid=0): # reliably restored by inspect
    """ Read plst resource from the resource fork of path. """
    pass


def readPlistFromString(data): # reliably restored by inspect
    """ Read a plist data from a string. Return the root object. """
    pass


def writePlist(rootObject, pathOrFile): # reliably restored by inspect
    """
    Write 'rootObject' to a .plist file. 'pathOrFile' may either be a
        file name or a (writable) file object.
    """
    pass


def writePlistToResource(rootObject, path, restype=None, resid=0): # reliably restored by inspect
    """ Write 'rootObject' as a plst resource to the resource fork of path. """
    pass


def writePlistToString(rootObject): # reliably restored by inspect
    """ Return 'rootObject' as a plist-formatted string. """
    pass


def _dateFromString(s): # reliably restored by inspect
    # no doc
    pass


def _dateToString(d): # reliably restored by inspect
    # no doc
    pass


def _encodeBase64(s, maxlinelength=76): # reliably restored by inspect
    # no doc
    pass


def _escapeAndEncode(text): # reliably restored by inspect
    # no doc
    pass


# classes

class _InternalDict(dict):
    # no doc
    def __delattr__(self, *args, **kwargs): # real signature unknown
        pass

    def __getattr__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __setattr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class Dict(_InternalDict):
    # no doc
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class Plist(_InternalDict):
    """
    This class has been deprecated. Use readPlist() and writePlist()
        functions instead, together with regular dict objects.
    """
    @classmethod
    def fromFile(cls, *args, **kwargs): # real signature unknown
        """ Deprecated. Use the readPlist() function instead. """
        pass

    def write(self, *args, **kwargs): # real signature unknown
        """ Deprecated. Use the writePlist() function instead. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

Data = None # (!) real value is ''

DumbXMLWriter = None # (!) real value is ''

PlistParser = None # (!) real value is ''

PlistWriter = None # (!) real value is ''

_controlCharPat = None # (!) real value is ''

_dateParser = None # (!) real value is ''

__all__ = [
    'readPlist',
    'writePlist',
    'readPlistFromString',
    'writePlistToString',
    'readPlistFromResource',
    'writePlistToResource',
    'Plist',
    'Data',
    'Dict',
]

