# encoding: utf-8
# module py_compile
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/py_compile.pyo by generator 1.99
"""
Routine to "compile" a .py file to a .pyc (or .pyo) file.

This module has intimate knowledge of the format of .pyc files.
"""

# imports
import marshal as marshal # <module 'marshal' (built-in)>
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/traceback.pyc
import __builtin__ as __builtin__ # <module '__builtin__' (built-in)>
import sys as sys # <module 'sys' (built-in)>
import imp as imp # <module 'imp' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

MAGIC = '\xd1\xf2\r\n'

# functions

def compile(file, cfile=None, dfile=None, doraise=False): # reliably restored by inspect
    """
    Byte-compile one Python source file to Python bytecode.
    
        Arguments:
    
        file:    source filename
        cfile:   target filename; defaults to source with 'c' or 'o' appended
                 ('c' normally, 'o' in optimizing mode, giving .pyc or .pyo)
        dfile:   purported filename; defaults to source (this is the filename
                 that will show up in error messages)
        doraise: flag indicating whether or not an exception should be
                 raised when a compile error is found. If an exception
                 occurs and this flag is set to False, a string
                 indicating the nature of the exception will be printed,
                 and the function will return to the caller. If an
                 exception occurs and this flag is set to True, a
                 PyCompileError exception will be raised.
    
        Note that it isn't necessary to byte-compile Python modules for
        execution efficiency -- Python itself byte-compiles a module when
        it is loaded, and if it can, writes out the bytecode to the
        corresponding .pyc (or .pyo) file.
    
        However, if a Python installation is shared between users, it is a
        good idea to byte-compile all modules upon installation, since
        other users may not be able to write in the source directories,
        and thus they won't be able to write the .pyc/.pyo file, and then
        they would be byte-compiling every module each time it is loaded.
        This can slow down program start-up considerably.
    
        See compileall.py for a script/module that uses this module to
        byte-compile all installed files (or all files in selected
        directories).
    """
    pass


def main(args=None): # reliably restored by inspect
    """
    Compile several source files.
    
        The files named in 'args' (or on the command line, if 'args' is
        not specified) are compiled and the resulting bytecode is cached
        in the normal manner.  This function does not search a directory
        structure to locate source files; it only compiles files named
        explicitly.
    """
    pass


def set_creator_type(file): # reliably restored by inspect
    # no doc
    pass


def wr_long(f, x): # reliably restored by inspect
    """ Internal; write a 32-bit int to a file in little-endian order. """
    pass


# classes

class PyCompileError(Exception):
    """
    Exception raised when an error occurs while attempting to
        compile the file.
    
        To raise this exception, use
    
            raise PyCompileError(exc_type,exc_value,file[,msg])
    
        where
    
            exc_type:   exception type to be used in error message
                        type name can be accesses as class variable
                        'exc_type_name'
    
            exc_value:  exception value to be used in error message
                        can be accesses as class variable 'exc_value'
    
            file:       name of file being compiled to be used in error message
                        can be accesses as class variable 'file'
    
            msg:        string message to be written as error message
                        If no value is given, a default exception message will be given,
                        consistent with 'standard' py_compile output.
                        message (or default) can be accesses as class variable 'msg'
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


# variables with complex values

__all__ = [
    'compile',
    'main',
    'PyCompileError',
]

