# encoding: utf-8
# module smtplib
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/smtplib.pyo by generator 1.99
"""
SMTP/ESMTP client class.

This should follow RFC 821 (SMTP), RFC 1869 (ESMTP), RFC 2554 (SMTP
Authentication) and RFC 2487 (Secure SMTP over TLS).

Notes:

Please remember, when doing ESMTP, that the names of the SMTP service
extensions are NOT the same thing as the option keywords for the RCPT
and MAIL commands!

Example:

  >>> import smtplib
  >>> s=smtplib.SMTP("localhost")
  >>> print s.help()
  This is Sendmail version 8.8.4
  Topics:
      HELO    EHLO    MAIL    RCPT    DATA
      RSET    NOOP    QUIT    HELP    VRFY
      EXPN    VERB    ETRN    DSN
  For more info use "HELP <topic>".
  To report bugs in the implementation send email to
      sendmail-bugs@sendmail.org.
  For local information send email to Postmaster at your site.
  End of HELP info
  >>> s.putcmd("vrfy","someone@here")
  >>> s.getreply()
  (250, "Somebody OverHere <somebody@here.my.org>")
  >>> s.quit()
"""

# imports
import base64 as base64 # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/base64.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import email as email # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/email/__init__.pyc
import socket as socket # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/socket.pyc
import ssl as ssl # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/ssl.pyc
import hmac as hmac # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/hmac.pyc

# Variables with simple values

CRLF = '\r\n'

LMTP_PORT = 2003

SMTP_PORT = 25

SMTP_SSL_PORT = 465

_have_ssl = True

# functions

def encode_base64(s, binary=True, maxlinelen=76, eol=None): # reliably restored by inspect
    """
    Encode a string with base64.
    
        Each line will be wrapped at, at most, maxlinelen characters (defaults to
        76 characters).
    
        If binary is False, end-of-line characters will be converted to the
        canonical email end-of-line sequence \r\n.  Otherwise they will be left
        verbatim (this is the default).
    
        Each line of encoded text will end with eol, which defaults to "\n".  Set
        this to "
    " if you will be using the result of this function directly
        in an email.
    """
    pass


def quoteaddr(addr): # reliably restored by inspect
    """
    Quote a subset of the email addresses defined by RFC 821.
    
        Should be able to handle anything rfc822.parseaddr can handle.
    """
    pass


def quotedata(data): # reliably restored by inspect
    """
    Quote data for email.
    
        Double leading '.', and change Unix newline '\n', or Mac '\r' into
        Internet CRLF end-of-line.
    """
    pass


# classes

class SMTPException(Exception):
    """ Base class for all exceptions raised by this module. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class SMTPResponseException(SMTPException):
    """
    Base class for all exceptions that include an SMTP error code.
    
        These exceptions are generated in some instances when the SMTP
        server returns an error code.  The error code is stored in the
        `smtp_code' attribute of the error, and the `smtp_error' attribute
        is set to the error message.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SMTPAuthenticationError(SMTPResponseException):
    """
    Authentication error.
    
        Most probably the server didn't accept the username/password
        combination provided.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SMTPConnectError(SMTPResponseException):
    """ Error during connection establishment. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SMTPDataError(SMTPResponseException):
    """ The SMTP server didn't accept the data. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SMTPHeloError(SMTPResponseException):
    """ The server refused our HELO reply. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SMTPRecipientsRefused(SMTPException):
    """
    All recipient addresses refused.
    
        The errors for each recipient are accessible through the attribute
        'recipients', which is a dictionary of exactly the same sort as
        SMTP.sendmail() returns.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SMTPSenderRefused(SMTPResponseException):
    """
    Sender address refused.
    
        In addition to the attributes set by on all SMTPResponseException
        exceptions, this sets `sender' to the string that the SMTP refused.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class SMTPServerDisconnected(SMTPException):
    """
    Not connected to any SMTP server.
    
        This exception is raised when the server unexpectedly disconnects,
        or when an attempt is made to use the SMTP instance before
        connecting it to a server.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


# variables with complex values

LMTP = None # (!) real value is ''

OLDSTYLE_AUTH = None # (!) real value is ''

SMTP = None # (!) real value is ''

SMTP_SSL = None # (!) real value is ''

SSLFakeFile = None # (!) real value is ''

stderr = None # (!) real value is ''

__all__ = [
    'SMTPException',
    'SMTPServerDisconnected',
    'SMTPResponseException',
    'SMTPSenderRefused',
    'SMTPRecipientsRefused',
    'SMTPDataError',
    'SMTPConnectError',
    'SMTPHeloError',
    'SMTPAuthenticationError',
    'quoteaddr',
    'quotedata',
    'SMTP',
    'SMTP_SSL',
]

