# encoding: utf-8
# module sndhdr
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/sndhdr.pyo by generator 1.99
"""
Routines to help recognizing sound files.

Function whathdr() recognizes various types of sound file headers.
It understands almost all headers that SOX can decode.

The return tuple contains the following items, in this order:
- file type (as SOX understands it)
- sampling rate (0 if unknown or hard to decode)
- number of channels (0 if unknown or hard to decode)
- number of frames in the file (-1 if unknown or hard to decode)
- number of bits/sample, or 'U' for U-LAW, or 'A' for A-LAW

If the file doesn't have a recognizable type, it returns None.
If the file can't be opened, IOError is raised.

To compute the total time, divide the number of frames by the
sampling rate (a frame contains a sample for each channel).

Function what() calls whathdr().  (It used to also use some
heuristics for raw data, but this doesn't work very well.)

Finally, the function test() is a simple main program that calls
what() for all files mentioned on the argument list.  For directory
arguments it calls what() for all files in that directory.  Default
argument is "." (testing all files in the current directory).  The
option -r tells it to recurse down directories found inside
explicitly given directories.
"""
# no imports

# functions

def get_long_be(s): # reliably restored by inspect
    # no doc
    pass


def get_long_le(s): # reliably restored by inspect
    # no doc
    pass


def get_short_be(s): # reliably restored by inspect
    # no doc
    pass


def get_short_le(s): # reliably restored by inspect
    # no doc
    pass


def test(): # reliably restored by inspect
    # no doc
    pass


def testall(list, recursive, toplevel): # reliably restored by inspect
    # no doc
    pass


def test_8svx(h, f): # reliably restored by inspect
    # no doc
    pass


def test_aifc(h, f): # reliably restored by inspect
    # no doc
    pass


def test_au(h, f): # reliably restored by inspect
    # no doc
    pass


def test_hcom(h, f): # reliably restored by inspect
    # no doc
    pass


def test_sndr(h, f): # reliably restored by inspect
    # no doc
    pass


def test_sndt(h, f): # reliably restored by inspect
    # no doc
    pass


def test_voc(h, f): # reliably restored by inspect
    # no doc
    pass


def test_wav(h, f): # reliably restored by inspect
    # no doc
    pass


def what(filename): # reliably restored by inspect
    """ Guess the type of a sound file """
    pass


def whathdr(filename): # reliably restored by inspect
    """ Recognize sound headers """
    pass


# no classes
# variables with complex values

tests = [
    test_aifc,
    test_au,
    test_hcom,
    test_voc,
    test_wav,
    test_8svx,
    test_sndt,
    test_sndr,
]

__all__ = [
    'what',
    'whathdr',
]

