# encoding: utf-8
# module tarfile
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/tarfile.pyo by generator 1.99
""" Read from and write to tar format archives. """

# imports
import struct as struct # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/struct.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc
import errno as errno # <module 'errno' (built-in)>
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc
import operator as operator # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/operator.so
import pwd as pwd # <module 'pwd' (built-in)>
import copy as copy # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/copy.pyc
import shutil as shutil # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/shutil.pyc
import grp as grp # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/grp.so
import stat as stat # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/stat.pyc
import sys as sys # <module 'sys' (built-in)>
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/time.so

# Variables with simple values

AREGTYPE = '\x00'

BLKTYPE = '4'
BLOCKSIZE = 512

CHRTYPE = '3'

CONTTYPE = '7'

DEFAULT_FORMAT = 1

DIRTYPE = '5'

ENCODING = 'utf-8'

FIFOTYPE = '6'

GNUTYPE_LONGLINK = 'K'
GNUTYPE_LONGNAME = 'L'
GNUTYPE_SPARSE = 'S'

GNU_FORMAT = 1
GNU_MAGIC = 'ustar  \x00'

LENGTH_LINK = 100
LENGTH_NAME = 100
LENGTH_PREFIX = 155

LNKTYPE = '1'

NUL = '\x00'

PAX_FORMAT = 2

POSIX_MAGIC = 'ustar\x0000'

RECORDSIZE = 10240
REGTYPE = '0'

SOLARIS_XHDTYPE = 'X'

SYMTYPE = '2'

S_IFBLK = 24576
S_IFCHR = 8192
S_IFDIR = 16384
S_IFIFO = 4096
S_IFLNK = 40960
S_IFREG = 32768

TAR_GZIPPED = 8
TAR_PLAIN = 0

TGEXEC = 8
TGREAD = 32
TGWRITE = 16

TOEXEC = 1
TOREAD = 4
TOWRITE = 2

TSGID = 1024
TSUID = 2048
TSVTX = 512

TUEXEC = 64
TUREAD = 256
TUWRITE = 128

USTAR_FORMAT = 0

version = '0.9.0'

XGLTYPE = 'g'

XHDTYPE = 'x'

__author__ = 'Lars Gust\xe4bel (lars@gustaebel.de)'

__credits__ = 'Gustavo Niemeyer, Niels Gust\xe4bel, Richard Townsend.'

__cvsid__ = '$Id: tarfile.py 65514 2008-08-04 21:23:07Z brett.cannon $'

__date__ = '$Date: 2008-08-04 17:23:07 -0400 (Mon, 04 Aug 2008) $'

__version__ = '$Revision: 65514 $'

# functions

def bltn_open(*args, **kwargs): # real signature unknown
    """
    open(name[, mode[, buffering]]) -> file object
    
    Open a file using the file() type, returns a file object.  This is the
    preferred way to open a file.
    """
    pass


def calc_chksums(buf): # reliably restored by inspect
    """
    Calculate the checksum for a member's header by summing up all
           characters except for the chksum field which is treated as if
           it was filled with spaces. According to the GNU tar sources,
           some tars (Sun and NeXT) calculate chksum with signed char,
           which will be different if there are chars in the buffer with
           the high bit set. So we calculate two checksums, unsigned and
           signed.
    """
    pass


def copyfileobj(src, dst, length=None): # reliably restored by inspect
    """
    Copy length bytes from fileobj src to fileobj dst.
           If length is None, copy the entire content.
    """
    pass


def filemode(mode): # reliably restored by inspect
    """
    Convert a file's mode to a string of the form
           -rwxrwxrwx.
           Used by TarFile.list()
    """
    pass


def is_tarfile(name): # reliably restored by inspect
    """
    Return True if name points to a tar archive that we
           are able to handle, else return False.
    """
    pass


def itn(n, digits=8, format=1): # reliably restored by inspect
    """ Convert a python number to a number field. """
    pass


def normpath(path): # reliably restored by inspect
    """ Normalize path, eliminating double slashes, etc. """
    pass


def nti(s): # reliably restored by inspect
    """ Convert a number field to a python number. """
    pass


def nts(s): # reliably restored by inspect
    """ Convert a null-terminated string field to a python string. """
    pass


def open(*args, **kwargs): # real signature unknown
    """
    Open a tar archive for reading, writing or appending. Return
               an appropriate TarFile class.
    
               mode:
               'r' or 'r:*' open for reading with transparent compression
               'r:'         open for reading exclusively uncompressed
               'r:gz'       open for reading with gzip compression
               'r:bz2'      open for reading with bzip2 compression
               'a' or 'a:'  open for appending, creating the file if necessary
               'w' or 'w:'  open for writing without compression
               'w:gz'       open for writing with gzip compression
               'w:bz2'      open for writing with bzip2 compression
    
               'r|*'        open a stream of tar blocks with transparent compression
               'r|'         open an uncompressed stream of tar blocks for reading
               'r|gz'       open a gzip compressed stream of tar blocks
               'r|bz2'      open a bzip2 compressed stream of tar blocks
               'w|'         open an uncompressed stream for writing
               'w|gz'       open a gzip compressed stream for writing
               'w|bz2'      open a bzip2 compressed stream for writing
    """
    pass


def stn(s, length): # reliably restored by inspect
    """ Convert a python string to a null-terminated string buffer. """
    pass


def uts(s, encoding, errors): # reliably restored by inspect
    """ Convert a unicode object to a string. """
    pass


# classes

class TarError(Exception):
    """ Base exception. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default


class CompressionError(TarError):
    """ Exception for unavailable compression methods. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class ExFileObject(object):
    """
    File-like object for reading an archive member.
           Is returned by TarFile.extractfile().
    """
    def close(self, *args, **kwargs): # real signature unknown
        """ Close the file object. """
        pass

    def read(self, *args, **kwargs): # real signature unknown
        """
        Read at most size bytes from the file. If size is not
                   present or None, read all data until EOF is reached.
        """
        pass

    def readline(self, *args, **kwargs): # real signature unknown
        """
        Read one entire line from the file. If size is present
                   and non-negative, return a string with at most that
                   size, which may be an incomplete line.
        """
        pass

    def readlines(self, *args, **kwargs): # real signature unknown
        """ Return a list with all remaining lines. """
        pass

    def seek(self, *args, **kwargs): # real signature unknown
        """ Seek to a position in the file. """
        pass

    def tell(self, *args, **kwargs): # real signature unknown
        """ Return the current file position. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        """ Get an iterator over the file's lines. """
        pass

    __weakref__ = property(lambda self: object()) # default

    blocksize = 1024
    __dict__ = None # (!) real value is ''


class ExtractError(TarError):
    """ General exception for extract errors. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class HeaderError(TarError):
    """ Exception for invalid headers. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class ReadError(TarError):
    """ Exception for unreadble tar archives. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class StreamError(TarError):
    """ Exception for unsupported operations on stream-like TarFiles. """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass


class TarFile(object):
    """ The TarFile Class provides an interface to tar archives. """
    def add(self, *args, **kwargs): # real signature unknown
        """
        Add the file `name' to the archive. `name' may be any type of file
                   (directory, fifo, symbolic link, etc.). If given, `arcname'
                   specifies an alternative name for the file in the archive.
                   Directories are added recursively by default. This can be avoided by
                   setting `recursive' to False. `exclude' is a function that should
                   return True for each filename to be excluded.
        """
        pass

    def addfile(self, *args, **kwargs): # real signature unknown
        """
        Add the TarInfo object `tarinfo' to the archive. If `fileobj' is
                   given, tarinfo.size bytes are read from it and added to the archive.
                   You can create TarInfo objects using gettarinfo().
                   On Windows platforms, `fileobj' should always be opened with mode
                   'rb' to avoid irritation about the file size.
        """
        pass

    @classmethod
    def bz2open(cls, *args, **kwargs): # real signature unknown
        """
        Open bzip2 compressed tar archive name for reading or writing.
                   Appending is not allowed.
        """
        pass

    def chmod(self, *args, **kwargs): # real signature unknown
        """ Set file permissions of targetpath according to tarinfo. """
        pass

    def chown(self, *args, **kwargs): # real signature unknown
        """ Set owner of targetpath according to tarinfo. """
        pass

    def close(self, *args, **kwargs): # real signature unknown
        """
        Close the TarFile. In write-mode, two finishing zero blocks are
                   appended to the archive.
        """
        pass

    def extract(self, *args, **kwargs): # real signature unknown
        """
        Extract a member from the archive to the current working directory,
                   using its full name. Its file information is extracted as accurately
                   as possible. `member' may be a filename or a TarInfo object. You can
                   specify a different directory using `path'.
        """
        pass

    def extractall(self, *args, **kwargs): # real signature unknown
        """
        Extract all members from the archive to the current working
                   directory and set owner, modification time and permissions on
                   directories afterwards. `path' specifies a different directory
                   to extract to. `members' is optional and must be a subset of the
                   list returned by getmembers().
        """
        pass

    def extractfile(self, *args, **kwargs): # real signature unknown
        """
        Extract a member from the archive as a file object. `member' may be
                   a filename or a TarInfo object. If `member' is a regular file, a
                   file-like object is returned. If `member' is a link, a file-like
                   object is constructed from the link's target. If `member' is none of
                   the above, None is returned.
                   The file-like object is read-only and provides the following
                   methods: read(), readline(), readlines(), seek() and tell()
        """
        pass

    def fileobject(self, *args, **kwargs): # real signature unknown
        """
        File-like object for reading an archive member.
               Is returned by TarFile.extractfile().
        """
        pass

    def getmember(self, *args, **kwargs): # real signature unknown
        """
        Return a TarInfo object for member `name'. If `name' can not be
                   found in the archive, KeyError is raised. If a member occurs more
                   than once in the archive, its last occurence is assumed to be the
                   most up-to-date version.
        """
        pass

    def getmembers(self, *args, **kwargs): # real signature unknown
        """
        Return the members of the archive as a list of TarInfo objects. The
                   list has the same order as the members in the archive.
        """
        pass

    def getnames(self, *args, **kwargs): # real signature unknown
        """
        Return the members of the archive as a list of their names. It has
                   the same order as the list returned by getmembers().
        """
        pass

    def gettarinfo(self, *args, **kwargs): # real signature unknown
        """
        Create a TarInfo object for either the file `name' or the file
                   object `fileobj' (using os.fstat on its file descriptor). You can
                   modify some of the TarInfo's attributes before you add it using
                   addfile(). If given, `arcname' specifies an alternative name for the
                   file in the archive.
        """
        pass

    @classmethod
    def gzopen(cls, *args, **kwargs): # real signature unknown
        """
        Open gzip compressed tar archive name for reading or writing.
                   Appending is not allowed.
        """
        pass

    def list(self, *args, **kwargs): # real signature unknown
        """
        Print a table of contents to sys.stdout. If `verbose' is False, only
                   the names of the members are printed. If it is True, an `ls -l'-like
                   output is produced.
        """
        pass

    def makedev(self, *args, **kwargs): # real signature unknown
        """ Make a character or block device called targetpath. """
        pass

    def makedir(self, *args, **kwargs): # real signature unknown
        """ Make a directory called targetpath. """
        pass

    def makefifo(self, *args, **kwargs): # real signature unknown
        """ Make a fifo called targetpath. """
        pass

    def makefile(self, *args, **kwargs): # real signature unknown
        """ Make a file called targetpath. """
        pass

    def makelink(self, *args, **kwargs): # real signature unknown
        """
        Make a (symbolic) link called targetpath. If it cannot be created
                  (platform limitation), we try to make a copy of the referenced file
                  instead of a link.
        """
        pass

    def makeunknown(self, *args, **kwargs): # real signature unknown
        """
        Make a file from a TarInfo object with an unknown type
                   at targetpath.
        """
        pass

    def next(self, *args, **kwargs): # real signature unknown
        """
        Return the next member of the archive as a TarInfo object, when
                   TarFile is opened for reading. Return None if there is no more
                   available.
        """
        pass

    @classmethod
    def open(cls, *args, **kwargs): # real signature unknown
        """
        Open a tar archive for reading, writing or appending. Return
                   an appropriate TarFile class.
        
                   mode:
                   'r' or 'r:*' open for reading with transparent compression
                   'r:'         open for reading exclusively uncompressed
                   'r:gz'       open for reading with gzip compression
                   'r:bz2'      open for reading with bzip2 compression
                   'a' or 'a:'  open for appending, creating the file if necessary
                   'w' or 'w:'  open for writing without compression
                   'w:gz'       open for writing with gzip compression
                   'w:bz2'      open for writing with bzip2 compression
        
                   'r|*'        open a stream of tar blocks with transparent compression
                   'r|'         open an uncompressed stream of tar blocks for reading
                   'r|gz'       open a gzip compressed stream of tar blocks
                   'r|bz2'      open a bzip2 compressed stream of tar blocks
                   'w|'         open an uncompressed stream for writing
                   'w|gz'       open a gzip compressed stream for writing
                   'w|bz2'      open a bzip2 compressed stream for writing
        """
        pass

    def tarinfo(self): # real signature unknown; restored from __doc__
        """
        Informational class which holds the details about an
               archive member given by a tar header block.
               TarInfo objects are returned by TarFile.getmember(),
               TarFile.getmembers() and TarFile.gettarinfo() and are
               usually created internally.
        """
        pass

    @classmethod
    def taropen(cls, *args, **kwargs): # real signature unknown
        """ Open uncompressed tar archive name for reading or writing. """
        pass

    def utime(self, *args, **kwargs): # real signature unknown
        """ Set modification time of targetpath according to tarinfo. """
        pass

    def _check(self, *args, **kwargs): # real signature unknown
        """
        Check if TarFile is still open, and if the operation's mode
                   corresponds to TarFile's mode.
        """
        pass

    def _dbg(self, *args, **kwargs): # real signature unknown
        """ Write debugging output to sys.stderr. """
        pass

    def _extract_member(self, *args, **kwargs): # real signature unknown
        """
        Extract the TarInfo object tarinfo to a physical
                   file called targetpath.
        """
        pass

    def _getmember(self, *args, **kwargs): # real signature unknown
        """
        Find an archive member by name from bottom to top.
                   If tarinfo is given, it is used as the starting point.
        """
        pass

    def _getposix(self, *args, **kwargs): # real signature unknown
        pass

    def _load(self, *args, **kwargs): # real signature unknown
        """
        Read through the entire archive file and look for readable
                   members.
        """
        pass

    def _setposix(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Open an (uncompressed) tar archive `name'. `mode' is either 'r' to
                   read from an existing archive, 'a' to append data to an existing
                   file or 'w' to create a new file overwriting an existing one. `mode'
                   defaults to 'r'.
                   If `fileobj' is given, it is used for reading or writing data. If it
                   can be determined, `mode' is overridden by `fileobj's mode.
                   `fileobj' is not closed, when TarFile is closed.
        """
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        """ Provide an iterator object. """
        pass

    posix = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    debug = 0
    dereference = False
    encoding = 'utf-8'
    errorlevel = 0
    errors = None
    format = 1
    ignore_zeros = False
    OPEN_METH = {
        'bz2': 'bz2open',
        'gz': 'gzopen',
        'tar': 'taropen',
    }
    __dict__ = None # (!) real value is ''


class TarInfo(object):
    """
    Informational class which holds the details about an
           archive member given by a tar header block.
           TarInfo objects are returned by TarFile.getmember(),
           TarFile.getmembers() and TarFile.gettarinfo() and are
           usually created internally.
    """
    def create_gnu_header(self, *args, **kwargs): # real signature unknown
        """ Return the object as a GNU header block sequence. """
        pass

    @classmethod
    def create_pax_global_header(cls, *args, **kwargs): # real signature unknown
        """ Return the object as a pax global header block sequence. """
        pass

    def create_pax_header(self, *args, **kwargs): # real signature unknown
        """
        Return the object as a ustar header block. If it cannot be
                   represented this way, prepend a pax extended header sequence
                   with supplement information.
        """
        pass

    def create_ustar_header(self, *args, **kwargs): # real signature unknown
        """ Return the object as a ustar header block. """
        pass

    @classmethod
    def frombuf(cls, *args, **kwargs): # real signature unknown
        """ Construct a TarInfo object from a 512 byte string buffer. """
        pass

    @classmethod
    def fromtarfile(cls, *args, **kwargs): # real signature unknown
        """
        Return the next TarInfo object from TarFile object
                   tarfile.
        """
        pass

    def get_info(self, *args, **kwargs): # real signature unknown
        """ Return the TarInfo's attributes as a dictionary. """
        pass

    def isblk(self, *args, **kwargs): # real signature unknown
        pass

    def ischr(self, *args, **kwargs): # real signature unknown
        pass

    def isdev(self, *args, **kwargs): # real signature unknown
        pass

    def isdir(self, *args, **kwargs): # real signature unknown
        pass

    def isfifo(self, *args, **kwargs): # real signature unknown
        pass

    def isfile(self, *args, **kwargs): # real signature unknown
        pass

    def islnk(self, *args, **kwargs): # real signature unknown
        pass

    def isreg(self, *args, **kwargs): # real signature unknown
        pass

    def issparse(self, *args, **kwargs): # real signature unknown
        pass

    def issym(self, *args, **kwargs): # real signature unknown
        pass

    def tobuf(self, *args, **kwargs): # real signature unknown
        """ Return a tar header as a string of 512 byte blocks. """
        pass

    def _apply_pax_info(self, *args, **kwargs): # real signature unknown
        """
        Replace fields with supplemental information from a previous
                   pax extended or global header.
        """
        pass

    def _block(self, *args, **kwargs): # real signature unknown; NOTE: unreliably restored from __doc__ 
        """
        Round up a byte count by BLOCKSIZE and return it,
                   e.g. _block(834) => 1024.
        """
        pass

    @classmethod
    def _create_gnu_long_header(cls, *args, **kwargs): # real signature unknown
        """
        Return a GNUTYPE_LONGNAME or GNUTYPE_LONGLINK sequence
                   for name.
        """
        pass

    def _create_header(info, format): # reliably restored by inspect
        """
        Return a header block. info is a dictionary with file
                   information, format must be one of the *_FORMAT constants.
        """
        pass

    @classmethod
    def _create_pax_generic_header(cls, *args, **kwargs): # real signature unknown
        """
        Return a POSIX.1-2001 extended or global header sequence
                   that contains a list of keyword, value pairs. The values
                   must be unicode objects.
        """
        pass

    def _create_payload(payload): # reliably restored by inspect
        """
        Return the string payload filled with zero bytes
                   up to the next 512 byte border.
        """
        pass

    def _getlinkpath(self, *args, **kwargs): # real signature unknown
        pass

    def _getpath(self, *args, **kwargs): # real signature unknown
        pass

    def _posix_split_name(self, *args, **kwargs): # real signature unknown
        """
        Split a name longer than 100 chars into a prefix
                   and a name part.
        """
        pass

    def _proc_builtin(self, *args, **kwargs): # real signature unknown
        """
        Process a builtin type or an unknown type which
                   will be treated as a regular file.
        """
        pass

    def _proc_gnulong(self, *args, **kwargs): # real signature unknown
        """
        Process the blocks that hold a GNU longname
                   or longlink member.
        """
        pass

    def _proc_member(self, *args, **kwargs): # real signature unknown
        """
        Choose the right processing method depending on
                   the type and call it.
        """
        pass

    def _proc_pax(self, *args, **kwargs): # real signature unknown
        """
        Process an extended or global header as described in
                   POSIX.1-2001.
        """
        pass

    def _proc_sparse(self, *args, **kwargs): # real signature unknown
        """ Process a GNU sparse header plus extra headers. """
        pass

    def _setlinkpath(self, *args, **kwargs): # real signature unknown
        pass

    def _setpath(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Construct a TarInfo object. name is the optional name
                   of the member.
        """
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    linkpath = property(lambda self: object()) # default
    path = property(lambda self: object()) # default
    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _BZ2Proxy(object):
    """
    Small proxy class that enables external file object
           support for "r:bz2" and "w:bz2" modes. This is actually
           a workaround for a limitation in bz2 module's BZ2File
           class which (unlike gzip.GzipFile) has no support for
           a file object argument.
    """
    def close(self, *args, **kwargs): # real signature unknown
        pass

    def init(self, *args, **kwargs): # real signature unknown
        pass

    def read(self, *args, **kwargs): # real signature unknown
        pass

    def seek(self, *args, **kwargs): # real signature unknown
        pass

    def tell(self, *args, **kwargs): # real signature unknown
        pass

    def write(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    blocksize = 16384
    __dict__ = None # (!) real value is ''


class _FileInFile(object):
    """
    A thin wrapper around an existing file object that
           provides a part of its data as an individual file
           object.
    """
    def read(self, *args, **kwargs): # real signature unknown
        """ Read data from the file. """
        pass

    def readnormal(self, *args, **kwargs): # real signature unknown
        """ Read operation for regular files. """
        pass

    def readsparse(self, *args, **kwargs): # real signature unknown
        """ Read operation for sparse files. """
        pass

    def readsparsesection(self, *args, **kwargs): # real signature unknown
        """ Read a single section of a sparse file. """
        pass

    def seek(self, *args, **kwargs): # real signature unknown
        """ Seek to a position in the file. """
        pass

    def tell(self, *args, **kwargs): # real signature unknown
        """ Return the current file position. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _ringbuffer(list):
    """
    Ringbuffer class which increases performance
           over a regular list.
    """
    def find(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _StreamProxy(object):
    """
    Small proxy class that enables transparent compression
           detection for the Stream interface (mode 'r|*').
    """
    def close(self, *args, **kwargs): # real signature unknown
        pass

    def getcomptype(self, *args, **kwargs): # real signature unknown
        pass

    def read(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


# variables with complex values

filemode_table = (
    (
        (
            40960,
            'l',
        ),
        (
            32768,
            '-',
        ),
        (
            24576,
            'b',
        ),
        (
            16384,
            'd',
        ),
        (
            8192,
            'c',
        ),
        (
            4096,
            'p',
        ),
    ),
    (
        (
            256,
            'r',
        ),
    ),
    (
        (
            128,
            'w',
        ),
    ),
    (
        (
            2112,
            's',
        ),
        (
            2048,
            'S',
        ),
        (
            64,
            'x',
        ),
    ),
    (
        (
            32,
            'r',
        ),
    ),
    (
        (
            16,
            'w',
        ),
    ),
    (
        (
            1032,
            's',
        ),
        (
            1024,
            'S',
        ),
        (
            8,
            'x',
        ),
    ),
    (
        (
            4,
            'r',
        ),
    ),
    (
        (
            2,
            'w',
        ),
    ),
    (
        (
            513,
            't',
        ),
        (
            512,
            'T',
        ),
        (
            1,
            'x',
        ),
    ),
)

GNU_TYPES = (
    'L',
    'K',
    'S',
)

PAX_FIELDS = (
    'path',
    'linkpath',
    'size',
    'mtime',
    'uid',
    'gid',
    'uname',
    'gname',
)

PAX_NUMBER_FIELDS = {
    'atime': float,
    'ctime': '<value is a self-reference, replaced by this string>',
    'gid': int,
    'mtime': '<value is a self-reference, replaced by this string>',
    'size': '<value is a self-reference, replaced by this string>',
    'uid': '<value is a self-reference, replaced by this string>',
}

REGULAR_TYPES = (
    '0',
    '\x00',
    '7',
    'S',
)

SUPPORTED_TYPES = (
    '0',
    '\x00',
    '1',
    '2',
    '5',
    '6',
    '7',
    '3',
    '4',
    'L',
    'K',
    'S',
)

TarFileCompat = None # (!) real value is ''

TarIter = None # (!) real value is ''

_data = None # (!) real value is ''

_hole = None # (!) real value is ''

_LowLevelFile = None # (!) real value is ''

_section = None # (!) real value is ''

_Stream = None # (!) real value is ''

__all__ = [
    'TarFile',
    'TarInfo',
    'is_tarfile',
    'TarError',
]

