# encoding: utf-8
# module textwrap
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/textwrap.pyo by generator 1.99
""" Text wrapping and filling. """

# imports
import string as string # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/string.pyc
import re as re # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/re.pyc

# Variables with simple values

_whitespace = '\t\n\x0b\x0c\r '

__revision__ = '$Id: textwrap.py 65349 2008-08-01 01:34:05Z brett.cannon $'

# functions

def dedent(text): # reliably restored by inspect
    """
    Remove any common leading whitespace from every line in `text`.
    
        This can be used to make triple-quoted strings line up with the left
        edge of the display, while still presenting them in the source code
        in indented form.
    
        Note that tabs and spaces are both treated as whitespace, but they
        are not equal: the lines "  hello" and "	hello" are
        considered to have no common leading whitespace.  (This behaviour is
        new in Python 2.5; older versions of this module incorrectly
        expanded tabs before searching for common leading whitespace.)
    """
    pass


def fill(text, width=70, **kwargs): # reliably restored by inspect
    """
    Fill a single paragraph of text, returning a new string.
    
        Reformat the single paragraph in 'text' to fit in lines of no more
        than 'width' columns, and return a new string containing the entire
        wrapped paragraph.  As with wrap(), tabs are expanded and other
        whitespace characters converted to space.  See TextWrapper class for
        available keyword args to customize wrapping behaviour.
    """
    pass


def wrap(text, width=70, **kwargs): # reliably restored by inspect
    """
    Wrap a single paragraph of text, returning a list of wrapped lines.
    
        Reformat the single paragraph in 'text' so it fits in lines of no
        more than 'width' columns, and return a list of wrapped lines.  By
        default, tabs in 'text' are expanded with string.expandtabs(), and
        all other whitespace characters (including newline) are converted to
        space.  See TextWrapper class for available keyword args to customize
        wrapping behaviour.
    """
    pass


# no classes
# variables with complex values

TextWrapper = None # (!) real value is ''

_leading_whitespace_re = None # (!) real value is ''

_whitespace_only_re = None # (!) real value is ''

__all__ = [
    'TextWrapper',
    'wrap',
    'fill',
]

