# encoding: utf-8
# module unittest
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/unittest.pyo by generator 1.99
"""
Python unit testing framework, based on Erich Gamma's JUnit and Kent Beck's
Smalltalk testing framework.

This module contains the core framework classes that form the basis of
specific test cases and suites (TestCase, TestSuite etc.), and also a
text-based utility class for running the tests and reporting the results
 (TextTestRunner).

Simple usage:

    import unittest

    class IntegerArithmenticTestCase(unittest.TestCase):
        def testAdd(self):  ## test method names begin 'test*'
            self.assertEquals((1 + 2), 3)
            self.assertEquals(0 + 1, 1)
        def testMultiply(self):
            self.assertEquals((0 * 10), 0)
            self.assertEquals((5 * 8), 40)

    if __name__ == '__main__':
        unittest.main()

Further information is available in the bundled documentation, and from

  http://docs.python.org/lib/module-unittest.html

Copyright (c) 1999-2003 Steve Purcell
This module is free software, and you may redistribute it and/or modify
it under the same terms as Python itself, so long as this copyright message
and disclaimer are retained in their original form.

IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF
THIS CODE, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE.  THE CODE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS,
AND THERE IS NO OBLIGATION WHATSOEVER TO PROVIDE MAINTENANCE,
SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
"""

# imports
import sys as sys # <module 'sys' (built-in)>
import types as types # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/types.pyc
import traceback as traceback # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/traceback.pyc
import time as time # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/lib-dynload/time.so
import os as os # /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/os.pyc

# Variables with simple values

__author__ = 'Steve Purcell'

__email__ = 'stephen_purcell at yahoo dot com'

__unittest = 1

__version__ = '1.63'

# functions

def findTestCases(module, prefix=None, sortUsing=cmp, suiteClass="<class 'unittest.TestSuite'>"): # reliably restored by inspect
    # no doc
    pass


def getTestCaseNames(testCaseClass, prefix, sortUsing=cmp): # reliably restored by inspect
    # no doc
    pass


def makeSuite(testCaseClass, prefix=None, sortUsing=cmp, suiteClass="<class 'unittest.TestSuite'>"): # reliably restored by inspect
    # no doc
    pass


def _CmpToKey(mycmp): # reliably restored by inspect
    """ Convert a cmp= function into a key= function """
    pass


def _makeLoader(prefix, sortUsing, suiteClass=None): # reliably restored by inspect
    # no doc
    pass


def _strclass(cls): # reliably restored by inspect
    # no doc
    pass


# classes

class TestCase(object):
    """
    A class whose instances are single test cases.
    
        By default, the test code itself should be placed in a method named
        'runTest'.
    
        If the fixture may be used for many test cases, create as
        many test methods as are needed. When instantiating such a TestCase
        subclass, specify in the constructor arguments the name of the test method
        that the instance is to execute.
    
        Test authors should subclass TestCase for their own tests. Construction
        and deconstruction of the test's environment ('fixture') can be
        implemented by overriding the 'setUp' and 'tearDown' methods respectively.
    
        If it is necessary to override the __init__ method, the base class
        __init__ method must always be called. It is important that subclasses
        should not change the signature of their __init__ method, since instances
        of the classes are instantiated automatically by parts of the framework
        in order to be run.
    """
    def assertAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        """
        pass

    def assertAlmostEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        """
        pass

    def assertEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by the '=='
                   operator.
        """
        pass

    def assertEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by the '=='
                   operator.
        """
        pass

    def assertFalse(self, *args, **kwargs): # real signature unknown
        """ Fail the test if the expression is true. """
        pass

    def assertNotAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        """
        pass

    def assertNotAlmostEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        """
        pass

    def assertNotEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by the '=='
                   operator.
        """
        pass

    def assertNotEquals(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by the '=='
                   operator.
        """
        pass

    def assertRaises(self, *args, **kwargs): # real signature unknown
        """
        Fail unless an exception of class excClass is thrown
                   by callableObj when invoked with arguments args and keyword
                   arguments kwargs. If a different type of exception is
                   thrown, it will not be caught, and the test case will be
                   deemed to have suffered an error, exactly as for an
                   unexpected exception.
        """
        pass

    def assertTrue(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the expression is true. """
        pass

    def assert_(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the expression is true. """
        pass

    def countTestCases(self, *args, **kwargs): # real signature unknown
        pass

    def debug(self, *args, **kwargs): # real signature unknown
        """ Run the test without collecting errors in a TestResult """
        pass

    def defaultTestResult(self, *args, **kwargs): # real signature unknown
        pass

    def fail(self, *args, **kwargs): # real signature unknown
        """ Fail immediately, with the given message. """
        pass

    def failIf(self, *args, **kwargs): # real signature unknown
        """ Fail the test if the expression is true. """
        pass

    def failIfAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        """
        pass

    def failIfEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are equal as determined by the '=='
                   operator.
        """
        pass

    def failUnless(self, *args, **kwargs): # real signature unknown
        """ Fail the test unless the expression is true. """
        pass

    def failUnlessAlmostEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by their
                   difference rounded to the given number of decimal places
                   (default 7) and comparing to zero.
        
                   Note that decimal places (from zero) are usually not the same
                   as significant digits (measured from the most signficant digit).
        """
        pass

    def failUnlessEqual(self, *args, **kwargs): # real signature unknown
        """
        Fail if the two objects are unequal as determined by the '=='
                   operator.
        """
        pass

    def failUnlessRaises(self, *args, **kwargs): # real signature unknown
        """
        Fail unless an exception of class excClass is thrown
                   by callableObj when invoked with arguments args and keyword
                   arguments kwargs. If a different type of exception is
                   thrown, it will not be caught, and the test case will be
                   deemed to have suffered an error, exactly as for an
                   unexpected exception.
        """
        pass

    def failureException(self, *args, **kwargs): # real signature unknown
        """ Assertion failed. """
        pass

    def id(self, *args, **kwargs): # real signature unknown
        pass

    def run(self, *args, **kwargs): # real signature unknown
        pass

    def setUp(self, *args, **kwargs): # real signature unknown
        """ Hook method for setting up the test fixture before exercising it. """
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        """
        Returns a one-line description of the test, or None if no
                description has been provided.
        
                The default implementation of this method returns the first line of
                the specified test method's docstring.
        """
        pass

    def tearDown(self, *args, **kwargs): # real signature unknown
        """ Hook method for deconstructing the test fixture after testing it. """
        pass

    def _exc_info(self, *args, **kwargs): # real signature unknown
        """
        Return a version of sys.exc_info() with the traceback frame
                   minimised; usually the top level of the traceback frame is not
                   needed.
        """
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Create an instance of the class that will use the named test
                   method when executed. Raises a ValueError if the instance does
                   not have a method with the specified name.
        """
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class FunctionTestCase(TestCase):
    """
    A test case that wraps a test function.
    
        This is useful for slipping pre-existing test functions into the
        unittest framework. Optionally, set-up and tidy-up functions can be
        supplied. As with TestCase, the tidy-up ('tearDown') function will
        always be called if the set-up ('setUp') function ran successfully.
    """
    def id(self, *args, **kwargs): # real signature unknown
        pass

    def runTest(self, *args, **kwargs): # real signature unknown
        pass

    def setUp(self, *args, **kwargs): # real signature unknown
        pass

    def shortDescription(self, *args, **kwargs): # real signature unknown
        pass

    def tearDown(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __hash__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass


class TestProgram(object):
    """
    A command-line program that runs a set of tests; this is primarily
           for making test modules conveniently executable.
    """
    def createTests(self, *args, **kwargs): # real signature unknown
        pass

    def parseArgs(self, *args, **kwargs): # real signature unknown
        pass

    def runTests(self, *args, **kwargs): # real signature unknown
        pass

    def usageExit(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    USAGE = "Usage: %(progName)s [options] [test] [...]\n\nOptions:\n  -h, --help       Show this message\n  -v, --verbose    Verbose output\n  -q, --quiet      Minimal output\n\nExamples:\n  %(progName)s                               - run default set of tests\n  %(progName)s MyTestSuite                   - run suite 'MyTestSuite'\n  %(progName)s MyTestCase.testSomething      - run MyTestCase.testSomething\n  %(progName)s MyTestCase                    - run all 'test*' test methods\n                                               in MyTestCase\n"
    __dict__ = None # (!) real value is ''


main = TestProgram


class TestLoader(object):
    """
    This class is responsible for loading tests according to various
        criteria and returning them wrapped in a TestSuite
    """
    def getTestCaseNames(self, *args, **kwargs): # real signature unknown
        """ Return a sorted sequence of method names found within testCaseClass """
        pass

    def loadTestsFromModule(self, *args, **kwargs): # real signature unknown
        """ Return a suite of all tests cases contained in the given module """
        pass

    def loadTestsFromName(self, *args, **kwargs): # real signature unknown
        """
        Return a suite of all tests cases given a string specifier.
        
                The name may resolve either to a module, a test case class, a
                test method within a test case class, or a callable object which
                returns a TestCase or TestSuite instance.
        
                The method optionally resolves the names relative to a given module.
        """
        pass

    def loadTestsFromNames(self, *args, **kwargs): # real signature unknown
        """
        Return a suite of all tests cases found using the given sequence
                of string specifiers. See 'loadTestsFromName()'.
        """
        pass

    def loadTestsFromTestCase(self, *args, **kwargs): # real signature unknown
        """ Return a suite of all tests cases contained in testCaseClass """
        pass

    def sortTestMethodsUsing(self, *args, **kwargs): # real signature unknown
        """
        cmp(x, y) -> integer
        
        Return negative if x<y, zero if x==y, positive if x>y.
        """
        pass

    def suiteClass(self, *args, **kwargs): # real signature unknown
        """
        A test suite is a composite test consisting of a number of TestCases.
        
            For use, create an instance of TestSuite, then add test case instances.
            When all tests have been added, the suite can be passed to a test
            runner, such as TextTestRunner. It will run the individual test cases
            in the order in which they were added, aggregating the results. When
            subclassing, do not forget to call the base class constructor.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    testMethodPrefix = 'test'
    __dict__ = None # (!) real value is ''


class TestResult(object):
    """
    Holder for test result information.
    
        Test results are automatically managed by the TestCase and TestSuite
        classes, and do not need to be explicitly manipulated by writers of tests.
    
        Each instance holds the total number of tests run, and collections of
        failures and errors that occurred among those test runs. The collections
        contain tuples of (testcase, exceptioninfo), where exceptioninfo is the
        formatted traceback of the error that occurred.
    """
    def addError(self, *args, **kwargs): # real signature unknown
        """
        Called when an error has occurred. 'err' is a tuple of values as
                returned by sys.exc_info().
        """
        pass

    def addFailure(self, *args, **kwargs): # real signature unknown
        """
        Called when an error has occurred. 'err' is a tuple of values as
                returned by sys.exc_info().
        """
        pass

    def addSuccess(self, *args, **kwargs): # real signature unknown
        """ Called when a test has completed successfully """
        pass

    def startTest(self, *args, **kwargs): # real signature unknown
        """ Called when the given test is about to be run """
        pass

    def stop(self, *args, **kwargs): # real signature unknown
        """ Indicates that the tests should be aborted """
        pass

    def stopTest(self, *args, **kwargs): # real signature unknown
        """ Called when the given test has been run """
        pass

    def wasSuccessful(self, *args, **kwargs): # real signature unknown
        """ Tells whether or not this result was a success """
        pass

    def _count_relevant_tb_levels(self, *args, **kwargs): # real signature unknown
        pass

    def _exc_info_to_string(self, *args, **kwargs): # real signature unknown
        """ Converts a sys.exc_info()-style tuple of values into a string. """
        pass

    def _is_relevant_tb_level(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class TestSuite(object):
    """
    A test suite is a composite test consisting of a number of TestCases.
    
        For use, create an instance of TestSuite, then add test case instances.
        When all tests have been added, the suite can be passed to a test
        runner, such as TextTestRunner. It will run the individual test cases
        in the order in which they were added, aggregating the results. When
        subclassing, do not forget to call the base class constructor.
    """
    def addTest(self, *args, **kwargs): # real signature unknown
        pass

    def addTests(self, *args, **kwargs): # real signature unknown
        pass

    def countTestCases(self, *args, **kwargs): # real signature unknown
        pass

    def debug(self, *args, **kwargs): # real signature unknown
        """ Run the tests without collecting errors in a TestResult """
        pass

    def run(self, *args, **kwargs): # real signature unknown
        pass

    def __call__(self, *args, **kwargs): # real signature unknown
        pass

    def __eq__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __iter__(self, *args, **kwargs): # real signature unknown
        pass

    def __ne__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''
    __hash__ = None


class TextTestRunner(object):
    """
    A test runner class that displays results in textual form.
    
        It prints out the names of tests as they are run, errors as they
        occur, and a summary of the results at the end of the test run.
    """
    def run(self, *args, **kwargs): # real signature unknown
        """ Run the given test case or test suite. """
        pass

    def _makeResult(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class _TextTestResult(TestResult):
    """
    A test result class that can print formatted text results to a stream.
    
        Used by TextTestRunner.
    """
    def addError(self, *args, **kwargs): # real signature unknown
        pass

    def addFailure(self, *args, **kwargs): # real signature unknown
        pass

    def addSuccess(self, *args, **kwargs): # real signature unknown
        pass

    def getDescription(self, *args, **kwargs): # real signature unknown
        pass

    def printErrorList(self, *args, **kwargs): # real signature unknown
        pass

    def printErrors(self, *args, **kwargs): # real signature unknown
        pass

    def startTest(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    separator1 = '======================================================================'
    separator2 = '----------------------------------------------------------------------'


class _WritelnDecorator(object):
    """ Used to decorate file-like objects with a handy 'writeln' method """
    def writeln(self, *args, **kwargs): # real signature unknown
        pass

    def __getattr__(self, *args, **kwargs): # real signature unknown
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object()) # default

    __dict__ = None # (!) real value is ''


class __metaclass__(object):
    """
    type(object) -> the object's type
    type(name, bases, dict) -> a new type
    """
    def mro(self): # real signature unknown; restored from __doc__
        """
        mro() -> list
        return a type's method resolution order
        """
        return []

    def __base__(self, *args, **kwargs): # real signature unknown
        """ The most base type """
        pass

    def __call__(self, *more): # real signature unknown; restored from __doc__
        """ x.__call__(...) <==> x(...) """
        pass

    def __cmp__(self, y): # real signature unknown; restored from __doc__
        """ x.__cmp__(y) <==> cmp(x,y) """
        pass

    def __delattr__(self, name): # real signature unknown; restored from __doc__
        """ x.__delattr__('name') <==> del x.name """
        pass

    def __eq__(self, y): # real signature unknown; restored from __doc__
        """ x.__eq__(y) <==> x==y """
        pass

    def __getattribute__(self, name): # real signature unknown; restored from __doc__
        """ x.__getattribute__('name') <==> x.name """
        pass

    def __ge__(self, y): # real signature unknown; restored from __doc__
        """ x.__ge__(y) <==> x>=y """
        pass

    def __gt__(self, y): # real signature unknown; restored from __doc__
        """ x.__gt__(y) <==> x>y """
        pass

    def __hash__(self): # real signature unknown; restored from __doc__
        """ x.__hash__() <==> hash(x) """
        pass

    def __init__(self, p_object): # real signature unknown; restored from __doc__
        pass

    def __instancecheck__(self, *args, **kwargs): # real signature unknown
        pass

    def __le__(self, y): # real signature unknown; restored from __doc__
        """ x.__le__(y) <==> x<=y """
        pass

    def __lt__(self, y): # real signature unknown; restored from __doc__
        """ x.__lt__(y) <==> x<y """
        pass

    @staticmethod # known case of __new__
    def __new__(S, *more): # real signature unknown; restored from __doc__
        """ T.__new__(S, ...) -> a new object with type S, a subtype of T """
        pass

    def __ne__(self, y): # real signature unknown; restored from __doc__
        """ x.__ne__(y) <==> x!=y """
        pass

    def __repr__(self): # real signature unknown; restored from __doc__
        """ x.__repr__() <==> repr(x) """
        pass

    def __setattr__(self, name, value): # real signature unknown; restored from __doc__
        """ x.__setattr__('name', value) <==> x.name = value """
        pass

    def __subclasscheck__(self, *args, **kwargs): # real signature unknown
        pass

    def __subclasses__(self): # real signature unknown; restored from __doc__
        """ __subclasses__() -> list of immediate subclasses """
        return []

    __abstractmethods__ = property(lambda self: object()) # default

    __bases__ = (
        object,
    )
    __basicsize__ = 872
    __dictoffset__ = 264
    __dict__ = None # (!) real value is ''
    __flags__ = 2148423147
    __itemsize__ = 40
    __mro__ = (
        type,
        object,
    )
    __name__ = 'type'
    __weakrefoffset__ = 368


# variables with complex values

defaultTestLoader = None # (!) real value is ''

__all__ = [
    'TestResult',
    'TestCase',
    'TestSuite',
    'TextTestRunner',
    'TestLoader',
    'FunctionTestCase',
    'main',
    'defaultTestLoader',
    'getTestCaseNames',
    'makeSuite',
    'findTestCases',
]

