# encoding: utf-8
# module xml.sax.__init__
# from /System/Library/Frameworks/Python.framework/Versions/2.6/lib/python2.6/xml/sax/__init__.pyo by generator 1.99
"""
Simple API for XML (SAX) implementation for Python.

This module provides an implementation of the SAX 2 interface;
information about the Java version of the interface can be found at
http://www.megginson.com/SAX/.  The Python version of the interface is
documented at <...>.

This package contains the following modules:

handler -- Base classes and constants which define the SAX 2 API for
           the 'client-side' of SAX for Python.

saxutils -- Implementation of the convenience classes commonly used to
            work with SAX.

xmlreader -- Base classes and constants which define the SAX 2 API for
             the parsers used with SAX for Python.

expatreader -- Driver that allows use of the Expat parser with SAX.
"""

# imports
import xml.sax._exceptions as __xml_sax__exceptions


# Variables with simple values

_false = 0

_key = 'python.xml.sax.parser'

# functions

def make_parser(parser_list='[]'): # reliably restored by inspect
    """
    Creates and returns a SAX parser.
    
        Creates the first parser it is able to instantiate of the ones
        given in the list created by doing parser_list +
        default_parser_list.  The lists must contain the names of Python
        modules containing both a SAX parser and a create_parser function.
    """
    pass


def parse(source, handler, errorHandler='<xml.sax.handler.ErrorHandler instance at 0x1005710e0>'): # reliably restored by inspect
    # no doc
    pass


def parseString(string, handler, errorHandler='<xml.sax.handler.ErrorHandler instance at 0x100571128>'): # reliably restored by inspect
    # no doc
    pass


def _create_parser(parser_name): # reliably restored by inspect
    # no doc
    pass


# classes

class SAXException(Exception):
    """
    Encapsulate an XML error or warning. This class can contain
        basic error or warning information from either the XML parser or
        the application: you can subclass it to provide additional
        functionality, or to add localization. Note that although you will
        receive a SAXException as the argument to the handlers in the
        ErrorHandler interface, you are not actually required to throw
        the exception; instead, you can simply read the information in
        it.
    """
    def getException(self, *args, **kwargs): # real signature unknown
        """ Return the embedded exception, or None if there was none. """
        pass

    def getMessage(self, *args, **kwargs): # real signature unknown
        """ Return a message for this exception. """
        pass

    def __getitem__(self, *args, **kwargs): # real signature unknown
        """
        Avoids weird error messages if someone does exception[ix] by
                mistake, since Exception has __getitem__ defined.
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """ Create a string representation of the exception. """
        pass

    __weakref__ = property(lambda self: object()) # default


class SAXNotRecognizedException(__xml_sax__exceptions.SAXException):
    """
    Exception class for an unrecognized identifier.
    
        An XMLReader will raise this exception when it is confronted with an
        unrecognized feature or property. SAX applications and extensions may
        use this class for similar purposes.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass


class SAXNotSupportedException(__xml_sax__exceptions.SAXException):
    """
    Exception class for an unsupported operation.
    
        An XMLReader will raise this exception when a service it cannot
        perform is requested (specifically setting a state or value). SAX
        applications and extensions may use this class for similar
        purposes.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass


class SAXParseException(__xml_sax__exceptions.SAXException):
    """
    Encapsulate an XML parse error or warning.
    
        This exception will include information for locating the error in
        the original XML document. Note that although the application will
        receive a SAXParseException as the argument to the handlers in the
        ErrorHandler interface, the application is not actually required
        to throw the exception; instead, it can simply read the
        information in it and take a different action.
    
        Since this exception is a subclass of SAXException, it inherits
        the ability to wrap another exception.
    """
    def getColumnNumber(self, *args, **kwargs): # real signature unknown
        """
        The column number of the end of the text where the exception
                occurred.
        """
        pass

    def getLineNumber(self, *args, **kwargs): # real signature unknown
        """ The line number of the end of the text where the exception occurred. """
        pass

    def getPublicId(self, *args, **kwargs): # real signature unknown
        """ Get the public identifier of the entity where the exception occurred. """
        pass

    def getSystemId(self, *args, **kwargs): # real signature unknown
        """ Get the system identifier of the entity where the exception occurred. """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        """ Creates the exception. The exception parameter is allowed to be None. """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """ Create a string representation of the exception. """
        pass


class SAXReaderNotAvailable(__xml_sax__exceptions.SAXNotSupportedException):
    """
    Exception class for a missing driver.
    
        An XMLReader module (driver) should raise this exception when it
        is first imported, e.g. when a support module cannot be imported.
        It also may be raised during parsing, e.g. if executing an external
        program is not permitted.
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        """
        Creates an exception. The message is required, but the exception
                is optional.
        """
        pass


# variables with complex values

ContentHandler = None # (!) real value is ''

default_parser_list = [
    'xml.sax.expatreader',
]

ErrorHandler = None # (!) real value is ''

InputSource = None # (!) real value is ''

