; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-pc-linux -mattr=+sse2 < %s | FileCheck %s --check-prefix=SSE2
; RUN: llc -mtriple=x86_64-pc-linux -mattr=+sse4.2 < %s | FileCheck %s --check-prefix=SSE42
; RUN: llc -mtriple=x86_64-pc-linux -mattr=+avx < %s | FileCheck %s --check-prefix=AVX
; RUN: llc -mtriple=x86_64-pc-linux -mattr=+avx2 < %s | FileCheck %s --check-prefix=AVX2

define void @v3i64(<2 x i64> %a, <2 x i64> %b, <3 x i64>* %p) {
; SSE2-LABEL: v3i64:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    movq %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v3i64:
; SSE42:       # BB#0:
; SSE42-NEXT:    pextrq $1, %xmm0, 16(%rdi)
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE42-NEXT:    movdqa %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v3i64:
; AVX:       # BB#0:
; AVX-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX-NEXT:    vpermilpd {{.*#+}} ymm2 = ymm2[0,0,3,2]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3]
; AVX-NEXT:    vpextrq $1, %xmm0, 16(%rdi)
; AVX-NEXT:    vmovapd %xmm1, (%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: v3i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpextrq $1, %xmm0, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <2 x i64> %a, <2 x i64> %b, <3 x i32> <i32 0, i32 2, i32 1>
  store <3 x i64> %r, <3 x i64>* %p
  ret void
}

define void @v3i32(<2 x i32> %a, <2 x i32> %b, <3 x i32>* %p) {
; SSE2-LABEL: v3i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v3i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm1, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v3i32:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5,6,7]
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm1, (%rdi)
; AVX-NEXT:    retq
;
; AVX2-LABEL: v3i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpbroadcastd %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX2-NEXT:    vmovq %xmm1, (%rdi)
; AVX2-NEXT:    retq
  %r = shufflevector <2 x i32> %a, <2 x i32> %b, <3 x i32> <i32 0, i32 2, i32 1>
  store <3 x i32> %r, <3 x i32>* %p
  ret void
}

define void @v5i16(<4 x i16> %a, <4 x i16> %b, <5 x i16>* %p) {
; SSE2-LABEL: v5i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    movw %ax, 8(%rdi)
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v5i16:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,0,2,3,4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,2,2,3,4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE42-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE42-NEXT:    pextrw $6, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm2, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v5i16:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[2,0,2,3,4,5,6,7]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm0[0,2,2,3,4,5,6,7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vpextrw $6, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm1, (%rdi)
; AVX-NEXT:    retq
;
; AVX2-LABEL: v5i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[2,0,2,3,4,5,6,7]
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX2-NEXT:    vpextrw $6, %xmm0, 8(%rdi)
; AVX2-NEXT:    vmovq %xmm1, (%rdi)
; AVX2-NEXT:    retq
  %r = shufflevector <4 x i16> %a, <4 x i16> %b, <5 x i32> <i32 0, i32 5, i32 1, i32 6, i32 3>
  store <5 x i16> %r, <5 x i16>* %p
  ret void
}

define void @v5i32(<4 x i32> %a, <4 x i32> %b, <5 x i32>* %p) {
; SSE2-LABEL: v5i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movd %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v5i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm1[2,3],xmm2[4,5],xmm1[6,7]
; SSE42-NEXT:    pextrd $3, %xmm0, 16(%rdi)
; SSE42-NEXT:    movdqa %xmm2, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v5i32:
; AVX:       # BB#0:
; AVX-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,0,1]
; AVX-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[3,1,2,2,7,5,6,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vpextrd $3, %xmm0, 16(%rdi)
; AVX-NEXT:    vmovaps %xmm1, (%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: v5i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = <0,5,1,6,3,u,u,u>
; AVX2-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpextrd $3, %xmm0, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <4 x i32> %a, <4 x i32> %b, <5 x i32> <i32 0, i32 5, i32 1, i32 6, i32 3>
  store <5 x i32> %r, <5 x i32>* %p
  ret void
}

define void @v7i8(<4 x i8> %a, <4 x i8> %b, <7 x i8>* %p) {
; SSE2-LABEL: v7i8:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm1, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,255,0,255,0,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,5,7]
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,1,3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE2-NEXT:    movb -{{[0-9]+}}(%rsp), %al
; SSE2-NEXT:    movb %al, 6(%rdi)
; SSE2-NEXT:    movd %xmm0, (%rdi)
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 4(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v7i8:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0],zero,xmm0[12],zero,xmm0[4],zero,zero,xmm0[u,u,u,u,u,u,u,u,u]
; SSE42-NEXT:    pextrb $0, %xmm1, 6(%rdi)
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = zero,xmm1[8],zero,xmm1[8],zero,xmm1[12,0,u,u,u,u,u,u,u,u,u]
; SSE42-NEXT:    por %xmm0, %xmm1
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm1[0],zero,xmm1[1],zero
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero
; SSE42-NEXT:    pextrw $4, %xmm1, 4(%rdi)
; SSE42-NEXT:    movd %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v7i8:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0],zero,xmm0[12],zero,xmm0[4],zero,zero,xmm0[u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm1[8],zero,xmm1[8],zero,xmm1[12,0,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX-NEXT:    vpextrb $0, %xmm1, 6(%rdi)
; AVX-NEXT:    vpextrw $4, %xmm0, 4(%rdi)
; AVX-NEXT:    vmovd %xmm2, (%rdi)
; AVX-NEXT:    retq
;
; AVX2-LABEL: v7i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0],zero,xmm0[12],zero,xmm0[4],zero,zero,xmm0[u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm1[8],zero,xmm1[8],zero,xmm1[12,0,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX2-NEXT:    vpextrb $0, %xmm1, 6(%rdi)
; AVX2-NEXT:    vpextrw $4, %xmm0, 4(%rdi)
; AVX2-NEXT:    vmovd %xmm2, (%rdi)
; AVX2-NEXT:    retq
  %r = shufflevector <4 x i8> %a, <4 x i8> %b, <7 x i32> <i32 0, i32 6, i32 3, i32 6, i32 1, i32 7, i32 4>
  store <7 x i8> %r, <7 x i8>* %p
  ret void
}

define void @v7i16(<4 x i16> %a, <4 x i16> %b, <7 x i16>* %p) {
; SSE2-LABEL: v7i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,65535,0,65535,0,65535,65535,65535]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,1,0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,0,2,0,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,6,4,7]
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, 12(%rdi)
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v7i16:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; SSE42-NEXT:    pextrw $0, %xmm1, 12(%rdi)
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[8,9,8,9,4,5,8,9,0,1,12,13,0,1,14,15]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5,6,7]
; SSE42-NEXT:    pextrd $2, %xmm1, 8(%rdi)
; SSE42-NEXT:    movq %xmm1, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v7i16:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[8,9,8,9,4,5,8,9,0,1,12,13,0,1,14,15]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5,6,7]
; AVX-NEXT:    vpextrw $0, %xmm1, 12(%rdi)
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX2-LABEL: v7i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[8,9,8,9,4,5,8,9,0,1,12,13,0,1,14,15]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5,6,7]
; AVX2-NEXT:    vpextrw $0, %xmm1, 12(%rdi)
; AVX2-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    retq
  %r = shufflevector <4 x i16> %a, <4 x i16> %b, <7 x i32> <i32 0, i32 6, i32 3, i32 6, i32 1, i32 7, i32 4>
  store <7 x i16> %r, <7 x i16>* %p
  ret void
}


define void @v7i32(<4 x i32> %a, <4 x i32> %b, <7 x i32>* %p) {
; SSE2-LABEL: v7i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,1,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,1,0,3]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,3]
; SSE2-NEXT:    movd %xmm1, 24(%rdi)
; SSE2-NEXT:    movlps %xmm0, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm3, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v7i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqa %xmm1, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4,5],xmm0[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,3,2]
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,3,0,3]
; SSE42-NEXT:    movd %xmm1, 24(%rdi)
; SSE42-NEXT:    movq %xmm2, 16(%rdi)
; SSE42-NEXT:    movdqa %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v7i32:
; AVX:       # BB#0:
; AVX-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[0,2,3,2,5,7,4,u]
; AVX-NEXT:    vmovd %xmm1, 24(%rdi)
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vmovlps %xmm1, 16(%rdi)
; AVX-NEXT:    vmovaps %xmm0, (%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: v7i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = <0,6,3,6,1,7,4,u>
; AVX2-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vmovd %xmm1, 24(%rdi)
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <4 x i32> %a, <4 x i32> %b, <7 x i32> <i32 0, i32 6, i32 3, i32 6, i32 1, i32 7, i32 4>
  store <7 x i32> %r, <7 x i32>* %p
  ret void
}

define void @v12i8(<8 x i8> %a, <8 x i8> %b, <12 x i8>* %p) {
; SSE2-LABEL: v12i8:
; SSE2:       # BB#0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,255,255,0,255,255,0,255,255,0,255,255,255,255]
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[3,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,1,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,1,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,6,4]
; SSE2-NEXT:    packuswb %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v12i8:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = zero,zero,xmm1[0],zero,zero,xmm1[2],zero,zero,xmm1[4],zero,zero,xmm1[6,u,u,u,u]
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,8],zero,xmm0[2,10],zero,xmm0[4,12],zero,xmm0[6,14],zero,xmm0[u,u,u,u]
; SSE42-NEXT:    por %xmm1, %xmm0
; SSE42-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v12i8:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[0],zero,zero,xmm1[2],zero,zero,xmm1[4],zero,zero,xmm1[6,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8],zero,xmm0[2,10],zero,xmm0[4,12],zero,xmm0[6,14],zero,xmm0[u,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX2-LABEL: v12i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[0],zero,zero,xmm1[2],zero,zero,xmm1[4],zero,zero,xmm1[6,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8],zero,xmm0[2,10],zero,xmm0[4,12],zero,xmm0[6,14],zero,xmm0[u,u,u,u]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    retq
  %r = shufflevector <8 x i8> %a, <8 x i8> %b, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i8> %r, <12 x i8>* %p
  ret void
}

define void @v12i16(<8 x i16> %a, <8 x i16> %b, <12 x i16>* %p) {
; SSE2-LABEL: v12i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,0,0,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm0[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,1,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,5,6,4]
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    pandn %xmm2, %xmm3
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,1,3,4,5,6,7]
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movq %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm3, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v12i16:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[3,1,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,1,3,4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm2[0],xmm3[1,2],xmm2[3,4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,3]
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,8,9,2,3,10,11,10,11,4,5,12,13]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; SSE42-NEXT:    movdqa %xmm0, (%rdi)
; SSE42-NEXT:    movq %xmm3, 16(%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v12i16:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[3,1,2,3]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,3,1,3,4,5,6,7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1,2],xmm2[3],xmm3[4,5,6,7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,0,3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,8,9,2,3,10,11,10,11,4,5,12,13]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX-NEXT:    vmovq %xmm2, 16(%rdi)
; AVX-NEXT:    retq
;
; AVX2-LABEL: v12i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,8,9,u,u,2,3,10,11,u,u,4,5,12,13,20,21,u,u,u,u,22,23,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,0,1,u,u,u,u,2,3,u,u,u,u,u,u,22,23,30,31,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,255,255,0,0,0,0,255,255,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <8 x i16> %a, <8 x i16> %b, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i16> %r, <12 x i16>* %p
  ret void
}

define void @v12i32(<8 x i32> %a, <8 x i32> %b, <12 x i32>* %p) {
; SSE2-LABEL: v12i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[2,3,0,1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[3,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[3,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm1[0],xmm7[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,3,0,1]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1]
; SSE2-NEXT:    movdqa %xmm1, 32(%rdi)
; SSE2-NEXT:    movdqa %xmm5, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v12i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    movd %xmm1, %eax
; SSE42-NEXT:    pextrd $1, %xmm0, %ecx
; SSE42-NEXT:    pextrd $2, %xmm0, %edx
; SSE42-NEXT:    pextrd $3, %xmm0, %esi
; SSE42-NEXT:    pinsrd $1, %eax, %xmm0
; SSE42-NEXT:    movd %xmm2, %eax
; SSE42-NEXT:    pinsrd $2, %eax, %xmm0
; SSE42-NEXT:    pinsrd $3, %ecx, %xmm0
; SSE42-NEXT:    pextrd $1, %xmm2, %eax
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,2,3]
; SSE42-NEXT:    pinsrd $1, %eax, %xmm3
; SSE42-NEXT:    pinsrd $2, %edx, %xmm3
; SSE42-NEXT:    pextrd $2, %xmm1, %eax
; SSE42-NEXT:    pinsrd $3, %eax, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; SSE42-NEXT:    pinsrd $1, %esi, %xmm4
; SSE42-NEXT:    pextrd $3, %xmm1, %eax
; SSE42-NEXT:    pinsrd $2, %eax, %xmm4
; SSE42-NEXT:    pextrd $3, %xmm2, %eax
; SSE42-NEXT:    pinsrd $3, %eax, %xmm4
; SSE42-NEXT:    movdqa %xmm4, 32(%rdi)
; SSE42-NEXT:    movdqa %xmm3, 16(%rdi)
; SSE42-NEXT:    movdqa %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v12i32:
; AVX:       # BB#0:
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX-NEXT:    vmovsldup {{.*#+}} ymm2 = ymm2[0,0,2,2,4,4,6,6]
; AVX-NEXT:    vpermilps {{.*#+}} ymm3 = ymm0[0,u,u,1,5,u,u,6]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4,5],ymm2[6],ymm3[7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = xmm1[0,0]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm3, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,3],xmm3[3,3]
; AVX-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,1]
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX-NEXT:    vmovaps %xmm0, 32(%rdi)
; AVX-NEXT:    vmovaps %ymm2, (%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: v12i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[3,3,2,3,7,7,6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0],xmm3[1,2],xmm2[3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = <0,4,u,1,5,u,2,6>
; AVX2-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpbroadcastq %xmm1, %ymm1
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa %ymm0, (%rdi)
; AVX2-NEXT:    vmovdqa %xmm2, 32(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <8 x i32> %a, <8 x i32> %b, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i32> %r, <12 x i32>* %p
  ret void
}

define void @pr29025(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <12 x i8> *%p) {
; SSE2-LABEL: pr29025:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movdqa %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movdqa %xmm1, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm6 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3],xmm5[4],xmm6[4],xmm5[5],xmm6[5],xmm5[6],xmm6[6],xmm5[7],xmm6[7]
; SSE2-NEXT:    movd {{.*#+}} xmm6 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm7 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1],xmm5[2],xmm7[2],xmm5[3],xmm7[3],xmm5[4],xmm7[4],xmm5[5],xmm7[5],xmm5[6],xmm7[6],xmm5[7],xmm7[7]
; SSE2-NEXT:    movd {{.*#+}} xmm7 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1],xmm1[2],xmm3[2],xmm1[3],xmm3[3],xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3],xmm1[4],xmm5[4],xmm1[5],xmm5[5],xmm1[6],xmm5[6],xmm1[7],xmm5[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3],xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE2-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3],xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm7[0],xmm2[1],xmm7[1],xmm2[2],xmm7[2],xmm2[3],xmm7[3],xmm2[4],xmm7[4],xmm2[5],xmm7[5],xmm2[6],xmm7[6],xmm2[7],xmm7[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: pr29025:
; SSE42:       # BB#0:
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    pextrb $4, %xmm0, %ecx
; SSE42-NEXT:    pextrb $8, %xmm0, %edx
; SSE42-NEXT:    pextrb $12, %xmm0, %esi
; SSE42-NEXT:    pinsrb $1, %eax, %xmm0
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    pinsrb $2, %eax, %xmm0
; SSE42-NEXT:    pinsrb $3, %ecx, %xmm0
; SSE42-NEXT:    pextrb $4, %xmm1, %eax
; SSE42-NEXT:    pinsrb $4, %eax, %xmm0
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    pinsrb $5, %eax, %xmm0
; SSE42-NEXT:    pinsrb $6, %edx, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    pinsrb $7, %eax, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    pinsrb $8, %eax, %xmm0
; SSE42-NEXT:    pinsrb $9, %esi, %xmm0
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    pinsrb $10, %eax, %xmm0
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    pinsrb $11, %eax, %xmm0
; SSE42-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: pr29025:
; AVX:       # BB#0:
; AVX-NEXT:    vpextrb $0, %xmm1, %eax
; AVX-NEXT:    vpinsrb $1, %eax, %xmm0, %xmm3
; AVX-NEXT:    vpextrb $0, %xmm2, %eax
; AVX-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrb $4, %xmm0, %eax
; AVX-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrb $4, %xmm1, %eax
; AVX-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrb $4, %xmm2, %eax
; AVX-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrb $8, %xmm0, %eax
; AVX-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrb $8, %xmm1, %eax
; AVX-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrb $8, %xmm2, %eax
; AVX-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrb $12, %xmm0, %eax
; AVX-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm0
; AVX-NEXT:    vpextrb $12, %xmm1, %eax
; AVX-NEXT:    vpinsrb $10, %eax, %xmm0, %xmm0
; AVX-NEXT:    vpextrb $12, %xmm2, %eax
; AVX-NEXT:    vpinsrb $11, %eax, %xmm0, %xmm0
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX2-LABEL: pr29025:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX2-NEXT:    vpinsrb $1, %eax, %xmm0, %xmm3
; AVX2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX2-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vpextrb $4, %xmm0, %eax
; AVX2-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vpextrb $4, %xmm1, %eax
; AVX2-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX2-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vpextrb $8, %xmm0, %eax
; AVX2-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX2-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vpextrb $12, %xmm0, %eax
; AVX2-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm0
; AVX2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX2-NEXT:    vpinsrb $10, %eax, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX2-NEXT:    vpinsrb $11, %eax, %xmm0, %xmm0
; AVX2-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    retq
  %s1 = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s2 = shufflevector <4 x i8> %c, <4 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %r = shufflevector <8 x i8> %s1, <8 x i8> %s2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i8> %r, <12 x i8>* %p, align 1
  ret void
}
