; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-pc-linux -mattr=+sse2 | FileCheck %s --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-pc-linux -mattr=+sse4.2 | FileCheck %s --check-prefix=SSE --check-prefix=SSE42
; RUN: llc < %s -mtriple=x86_64-pc-linux -mattr=+avx | FileCheck %s --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-pc-linux -mattr=+avx2 | FileCheck %s --check-prefix=AVX --check-prefix=AVX2

define void @v3i64(<2 x i64> %a, <2 x i64> %b, <3 x i64>* %p) nounwind {
; SSE2-LABEL: v3i64:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    movq %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v3i64:
; SSE42:       # BB#0:
; SSE42-NEXT:    pextrq $1, %xmm0, 16(%rdi)
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE42-NEXT:    movdqa %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: v3i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpextrq $1, %xmm0, 16(%rdi)
; AVX1-NEXT:    vmovapd %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v3i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpextrq $1, %xmm0, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <2 x i64> %a, <2 x i64> %b, <3 x i32> <i32 0, i32 2, i32 1>
  store <3 x i64> %r, <3 x i64>* %p
  ret void
}
define void @v3f64(<2 x double> %a, <2 x double> %b, <3 x double>* %p) nounwind {
; SSE-LABEL: v3f64:
; SSE:       # BB#0:
; SSE-NEXT:    movhpd %xmm0, 16(%rdi)
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movapd %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v3f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vmovhpd %xmm0, 16(%rdi)
; AVX1-NEXT:    vmovapd %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v3f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vmovhpd %xmm0, 16(%rdi)
; AVX2-NEXT:    vmovapd %xmm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <2 x double> %a, <2 x double> %b, <3 x i32> <i32 0, i32 2, i32 1>
  store <3 x double> %r, <3 x double>* %p
  ret void
}

define void @v3i32(<2 x i32> %a, <2 x i32> %b, <3 x i32>* %p) nounwind {
; SSE2-LABEL: v3i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v3i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm1, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: v3i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5,6,7]
; AVX1-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX1-NEXT:    vmovq %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v3i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpbroadcastd %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX2-NEXT:    vmovq %xmm1, (%rdi)
; AVX2-NEXT:    retq
  %r = shufflevector <2 x i32> %a, <2 x i32> %b, <3 x i32> <i32 0, i32 2, i32 1>
  store <3 x i32> %r, <3 x i32>* %p
  ret void
}

define void @v5i16(<4 x i16> %a, <4 x i16> %b, <5 x i16>* %p) nounwind {
; SSE2-LABEL: v5i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    movw %ax, 8(%rdi)
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v5i16:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,0,2,3,4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,2,2,3,4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE42-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE42-NEXT:    pextrw $6, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm2, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v5i16:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[2,0,2,3,4,5,6,7]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm0[0,2,2,3,4,5,6,7]
; AVX-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vpextrw $6, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm1, (%rdi)
; AVX-NEXT:    retq
  %r = shufflevector <4 x i16> %a, <4 x i16> %b, <5 x i32> <i32 0, i32 5, i32 1, i32 6, i32 3>
  store <5 x i16> %r, <5 x i16>* %p
  ret void
}

define void @v5i32(<4 x i32> %a, <4 x i32> %b, <5 x i32>* %p) nounwind {
; SSE2-LABEL: v5i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movd %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v5i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm1[2,3],xmm2[4,5],xmm1[6,7]
; SSE42-NEXT:    pextrd $3, %xmm0, 16(%rdi)
; SSE42-NEXT:    movdqa %xmm2, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: v5i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,1],xmm1[1,2]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,2,1,3]
; AVX1-NEXT:    vpextrd $3, %xmm0, 16(%rdi)
; AVX1-NEXT:    vmovaps %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v5i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = <0,5,1,6,3,u,u,u>
; AVX2-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpextrd $3, %xmm0, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <4 x i32> %a, <4 x i32> %b, <5 x i32> <i32 0, i32 5, i32 1, i32 6, i32 3>
  store <5 x i32> %r, <5 x i32>* %p
  ret void
}

define void @v5f32(<4 x float> %a, <4 x float> %b, <5 x float>* %p) nounwind {
; SSE2-LABEL: v5f32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[1,2]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2,1,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, 16(%rdi)
; SSE2-NEXT:    movaps %xmm2, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v5f32:
; SSE42:       # BB#0:
; SSE42-NEXT:    extractps $3, %xmm0, 16(%rdi)
; SSE42-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[1,2]
; SSE42-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE42-NEXT:    movaps %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: v5f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,1],xmm1[1,2]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,2,1,3]
; AVX1-NEXT:    vextractps $3, %xmm0, 16(%rdi)
; AVX1-NEXT:    vmovaps %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v5f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovaps {{.*#+}} ymm2 = <0,5,1,6,3,u,u,u>
; AVX2-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vextractps $3, %xmm0, 16(%rdi)
; AVX2-NEXT:    vmovaps %xmm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <4 x float> %a, <4 x float> %b, <5 x i32> <i32 0, i32 5, i32 1, i32 6, i32 3>
  store <5 x float> %r, <5 x float>* %p
  ret void
}

define void @v7i8(<4 x i8> %a, <4 x i8> %b, <7 x i8>* %p) nounwind {
; SSE2-LABEL: v7i8:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,65535,0,65535,0,65535,65535,65535]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,2,0,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,4,7]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    packuswb %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm2, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movb -{{[0-9]+}}(%rsp), %al
; SSE2-NEXT:    movb %al, 6(%rdi)
; SSE2-NEXT:    movd %xmm0, (%rdi)
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    movw %ax, 4(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v7i8:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; SSE42-NEXT:    pextrb $0, %xmm1, 6(%rdi)
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[8,9,8,9,4,5,8,9,0,1,12,13,0,1,14,15]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5,6,7]
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u]
; SSE42-NEXT:    pextrw $2, %xmm1, 4(%rdi)
; SSE42-NEXT:    movd %xmm1, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v7i8:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[8,9,8,9,4,5,8,9,0,1,12,13,0,1,14,15]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5,6,7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpextrb $0, %xmm1, 6(%rdi)
; AVX-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX-NEXT:    vmovd %xmm0, (%rdi)
; AVX-NEXT:    retq
  %r = shufflevector <4 x i8> %a, <4 x i8> %b, <7 x i32> <i32 0, i32 6, i32 3, i32 6, i32 1, i32 7, i32 4>
  store <7 x i8> %r, <7 x i8>* %p
  ret void
}

define void @v7i16(<4 x i16> %a, <4 x i16> %b, <7 x i16>* %p) nounwind {
; SSE2-LABEL: v7i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,65535,0,65535,0,65535,65535,65535]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,1,0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,0,2,0,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,6,4,7]
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, 12(%rdi)
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v7i16:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; SSE42-NEXT:    pextrw $0, %xmm1, 12(%rdi)
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[8,9,8,9,4,5,8,9,0,1,12,13,0,1,14,15]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5,6,7]
; SSE42-NEXT:    pextrd $2, %xmm1, 8(%rdi)
; SSE42-NEXT:    movq %xmm1, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v7i16:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,3,1,3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[8,9,8,9,4,5,8,9,0,1,12,13,0,1,14,15]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5,6,7]
; AVX-NEXT:    vpextrw $0, %xmm1, 12(%rdi)
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
  %r = shufflevector <4 x i16> %a, <4 x i16> %b, <7 x i32> <i32 0, i32 6, i32 3, i32 6, i32 1, i32 7, i32 4>
  store <7 x i16> %r, <7 x i16>* %p
  ret void
}


define void @v7i32(<4 x i32> %a, <4 x i32> %b, <7 x i32>* %p) nounwind {
; SSE2-LABEL: v7i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,1,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,1,0,3]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,3]
; SSE2-NEXT:    movd %xmm1, 24(%rdi)
; SSE2-NEXT:    movlps %xmm0, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm3, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v7i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqa %xmm1, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4,5],xmm0[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,3,2]
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,3,0,3]
; SSE42-NEXT:    movd %xmm1, 24(%rdi)
; SSE42-NEXT:    movq %xmm2, 16(%rdi)
; SSE42-NEXT:    movdqa %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: v7i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vblendps {{.*#+}} xmm2 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[0,2,3,2]
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,3,0,3]
; AVX1-NEXT:    vmovss %xmm1, 24(%rdi)
; AVX1-NEXT:    vmovlps %xmm0, 16(%rdi)
; AVX1-NEXT:    vmovaps %xmm2, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v7i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<def>
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = <0,6,3,6,1,7,4,u>
; AVX2-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vmovd %xmm1, 24(%rdi)
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <4 x i32> %a, <4 x i32> %b, <7 x i32> <i32 0, i32 6, i32 3, i32 6, i32 1, i32 7, i32 4>
  store <7 x i32> %r, <7 x i32>* %p
  ret void
}

define void @v12i8(<8 x i8> %a, <8 x i8> %b, <12 x i8>* %p) nounwind {
; SSE2-LABEL: v12i8:
; SSE2:       # BB#0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,255,255,0,255,255,0,255,255,0,255,255,255,255]
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[3,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,1,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,1,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,6,4]
; SSE2-NEXT:    packuswb %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v12i8:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = zero,zero,xmm1[0],zero,zero,xmm1[2],zero,zero,xmm1[4],zero,zero,xmm1[6,u,u,u,u]
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,8],zero,xmm0[2,10],zero,xmm0[4,12],zero,xmm0[6,14],zero,xmm0[u,u,u,u]
; SSE42-NEXT:    por %xmm1, %xmm0
; SSE42-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: v12i8:
; AVX:       # BB#0:
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[0],zero,zero,xmm1[2],zero,zero,xmm1[4],zero,zero,xmm1[6,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8],zero,xmm0[2,10],zero,xmm0[4,12],zero,xmm0[6,14],zero,xmm0[u,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
  %r = shufflevector <8 x i8> %a, <8 x i8> %b, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i8> %r, <12 x i8>* %p
  ret void
}

define void @v12i16(<8 x i16> %a, <8 x i16> %b, <12 x i16>* %p) nounwind {
; SSE2-LABEL: v12i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,0,0,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm0[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,1,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,5,6,4]
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    pandn %xmm2, %xmm3
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,1,3,4,5,6,7]
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movq %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm3, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v12i16:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[3,1,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,1,3,4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm2[0],xmm3[1,2],xmm2[3,4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,3]
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,8,9,2,3,10,11,10,11,4,5,12,13]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; SSE42-NEXT:    movdqa %xmm0, (%rdi)
; SSE42-NEXT:    movq %xmm3, 16(%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: v12i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,3,1,3,4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1,2],xmm2[3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,0,3]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,8,9,2,3,10,11,10,11,4,5,12,13]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX1-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX1-NEXT:    vmovq %xmm2, 16(%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v12i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[3,1,2,3]
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,3,1,3,4,5,6,7]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1,2],xmm2[3],xmm3[4,5,6,7]
; AVX2-NEXT:    vpbroadcastd %xmm1, %xmm1
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,8,9,2,3,10,11,10,11,4,5,12,13]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX2-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX2-NEXT:    vmovq %xmm2, 16(%rdi)
; AVX2-NEXT:    retq
  %r = shufflevector <8 x i16> %a, <8 x i16> %b, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i16> %r, <12 x i16>* %p
  ret void
}

define void @v12i32(<8 x i32> %a, <8 x i32> %b, <12 x i32>* %p) nounwind {
; SSE2-LABEL: v12i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,1,0,1]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm3[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0,2]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,0],xmm1[1,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm1[2,2]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm4[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[0,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,3,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,2]
; SSE2-NEXT:    movaps %xmm0, 32(%rdi)
; SSE2-NEXT:    movaps %xmm4, 16(%rdi)
; SSE2-NEXT:    movaps %xmm3, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: v12i32:
; SSE42:       # BB#0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[0,0,1,1]
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,1,0,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm3[2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,1,0,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5],xmm4[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[1,1,2,2]
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm2[2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1,2,3],xmm0[4,5],xmm4[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,2,3,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm2[0,1,2,3],xmm0[4,5],xmm2[6,7]
; SSE42-NEXT:    movdqa %xmm0, 32(%rdi)
; SSE42-NEXT:    movdqa %xmm4, 16(%rdi)
; SSE42-NEXT:    movdqa %xmm3, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: v12i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX1-NEXT:    vmovsldup {{.*#+}} ymm2 = ymm2[0,0,2,2,4,4,6,6]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm3 = ymm0[0,u,u,1,5,u,u,6]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4,5],ymm2[6],ymm3[7]
; AVX1-NEXT:    vmovddup {{.*#+}} xmm3 = xmm1[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm3, %ymm3
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,3],xmm3[3,3]
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,1]
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX1-NEXT:    vmovaps %xmm0, 32(%rdi)
; AVX1-NEXT:    vmovaps %ymm2, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v12i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[3,3,2,3,7,7,6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0],xmm3[1,2],xmm2[3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = <0,4,u,1,5,u,2,6>
; AVX2-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpbroadcastq %xmm1, %ymm1
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa %ymm0, (%rdi)
; AVX2-NEXT:    vmovdqa %xmm2, 32(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %r = shufflevector <8 x i32> %a, <8 x i32> %b, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i32> %r, <12 x i32>* %p
  ret void
}

define void @pr29025(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <12 x i8> *%p) nounwind {
; SSE2-LABEL: pr29025:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255]
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    packuswb %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[3,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,1,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,1,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,6,4]
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,0,255,255,0,255,255,0,255,255,0,255,255,255,255]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    packuswb %xmm2, %xmm2
; SSE2-NEXT:    packuswb %xmm2, %xmm2
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,1,1,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE2-NEXT:    pandn %xmm2, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movq %xmm1, (%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: pr29025:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; SSE42-NEXT:    pshufb %xmm3, %xmm1
; SSE42-NEXT:    pshufb %xmm3, %xmm0
; SSE42-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE42-NEXT:    pshufb %xmm3, %xmm2
; SSE42-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,8,1,2,10,3,4,12,5,6,14,7,u,u,u,u]
; SSE42-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE42-NEXT:    movq %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: pr29025:
; AVX:       # BB#0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX-NEXT:    vpshufb %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,1,2,10,3,4,12,5,6,14,7,u,u,u,u]
; AVX-NEXT:    vpextrd $2, %xmm0, 8(%rdi)
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
  %s1 = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s2 = shufflevector <4 x i8> %c, <4 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %r = shufflevector <8 x i8> %s1, <8 x i8> %s2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i8> %r, <12 x i8>* %p, align 1
  ret void
}

define void @interleave_24i8_out(<24 x i8>* %p, <8 x i8>* %q1, <8 x i8>* %q2, <8 x i8>* %q3) nounwind {
; SSE2-LABEL: interleave_24i8_out:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqu (%rdi), %xmm0
; SSE2-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,0,255,255,0,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm2[8],xmm4[9],xmm2[9],xmm4[10],xmm2[10],xmm4[11],xmm2[11],xmm4[12],xmm2[12],xmm4[13],xmm2[13],xmm4[14],xmm2[14],xmm4[15],xmm2[15]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,65535,65535,0,65535,65535,0]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    pand %xmm5, %xmm3
; SSE2-NEXT:    pandn %xmm4, %xmm5
; SSE2-NEXT:    por %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[0,2,1,3]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,5]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,2,1,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    packuswb %xmm0, %xmm3
; SSE2-NEXT:    movq %xmm3, (%rsi)
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [0,255,255,0,255,255,0,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm2[8],xmm4[9],xmm2[9],xmm4[10],xmm2[10],xmm4[11],xmm2[11],xmm4[12],xmm2[12],xmm4[13],xmm2[13],xmm4[14],xmm2[14],xmm4[15],xmm2[15]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    pand %xmm5, %xmm3
; SSE2-NEXT:    pandn %xmm4, %xmm5
; SSE2-NEXT:    por %xmm3, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[2,1,0,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[1,2,3,0,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,6,7,4]
; SSE2-NEXT:    packuswb %xmm0, %xmm3
; SSE2-NEXT:    movq %xmm3, (%rdx)
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [255,0,255,255,0,255,255,0,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm0, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,0,65535,65535,0,65535]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,1,2,0]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE2-NEXT:    packuswb %xmm0, %xmm0
; SSE2-NEXT:    movq %xmm0, (%rcx)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: interleave_24i8_out:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqu (%rdi), %xmm0
; SSE42-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE42-NEXT:    movdqa %xmm1, %xmm2
; SSE42-NEXT:    pshufb {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,xmm2[2,5,u,u,u,u,u,u,u,u]
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    pshufb {{.*#+}} xmm3 = xmm3[0,3,6,9,12,15],zero,zero,xmm3[u,u,u,u,u,u,u,u]
; SSE42-NEXT:    por %xmm2, %xmm3
; SSE42-NEXT:    movq %xmm3, (%rsi)
; SSE42-NEXT:    movdqa %xmm1, %xmm2
; SSE42-NEXT:    pshufb {{.*#+}} xmm2 = zero,zero,zero,zero,zero,xmm2[0,3,6,u,u,u,u,u,u,u,u]
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    pshufb {{.*#+}} xmm3 = xmm3[1,4,7,10,13],zero,zero,zero,xmm3[u,u,u,u,u,u,u,u]
; SSE42-NEXT:    por %xmm2, %xmm3
; SSE42-NEXT:    movq %xmm3, (%rdx)
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm1[1,4,7,u,u,u,u,u,u,u,u]
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[2,5,8,11,14],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; SSE42-NEXT:    por %xmm1, %xmm0
; SSE42-NEXT:    movq %xmm0, (%rcx)
; SSE42-NEXT:    retq
;
; AVX-LABEL: interleave_24i8_out:
; AVX:       # BB#0:
; AVX-NEXT:    vmovdqu (%rdi), %xmm0
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,xmm1[2,5,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0,3,6,9,12,15],zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vmovq %xmm2, (%rsi)
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,zero,xmm1[0,3,6,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[1,4,7,10,13],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vmovq %xmm2, (%rdx)
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm1[1,4,7,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,5,8,11,14],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rcx)
; AVX-NEXT:    retq
  %wide.vec = load <24 x i8>, <24 x i8>* %p, align 4
  %s1 = shufflevector <24 x i8> %wide.vec, <24 x i8> undef, <8 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21>
  %s2 = shufflevector <24 x i8> %wide.vec, <24 x i8> undef, <8 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22>
  %s3 = shufflevector <24 x i8> %wide.vec, <24 x i8> undef, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>
  store <8 x i8> %s1, <8 x i8>* %q1, align 4
  store <8 x i8> %s2, <8 x i8>* %q2, align 4
  store <8 x i8> %s3, <8 x i8>* %q3, align 4
  ret void
}

define void @interleave_24i8_in(<24 x i8>* %p, <8 x i8>* %q1, <8 x i8>* %q2, <8 x i8>* %q3) nounwind {
; SSE2-LABEL: interleave_24i8_in:
; SSE2:       # BB#0:
; SSE2-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,2,2]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[0,1,3,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,6,7]
; SSE2-NEXT:    pandn %xmm2, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,2,2,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,5,4,5]
; SSE2-NEXT:    packuswb %xmm5, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,1,0,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,0,0,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,5,6,6]
; SSE2-NEXT:    pandn %xmm5, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,1,0,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE2-NEXT:    packuswb %xmm0, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,0,255,255,0,255,255,0,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,3,3,4,5,6,7]
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movq %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqu %xmm4, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: interleave_24i8_in:
; SSE42:       # BB#0:
; SSE42-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE42-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE42-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE42-NEXT:    movdqa %xmm0, %xmm1
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,8],zero,xmm1[1,9],zero,xmm1[2,10],zero,xmm1[3,11],zero,xmm1[4,12],zero,xmm1[5]
; SSE42-NEXT:    movdqa %xmm2, %xmm3
; SSE42-NEXT:    pshufb {{.*#+}} xmm3 = zero,zero,xmm3[0],zero,zero,xmm3[1],zero,zero,xmm3[2],zero,zero,xmm3[3],zero,zero,xmm3[4],zero
; SSE42-NEXT:    por %xmm1, %xmm3
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[13],zero,xmm0[6,14],zero,xmm0[7,15],zero,xmm0[u,u,u,u,u,u,u,u]
; SSE42-NEXT:    pshufb {{.*#+}} xmm2 = zero,xmm2[5],zero,zero,xmm2[6],zero,zero,xmm2[7,u,u,u,u,u,u,u,u]
; SSE42-NEXT:    por %xmm0, %xmm2
; SSE42-NEXT:    movq %xmm2, 16(%rdi)
; SSE42-NEXT:    movdqu %xmm3, (%rdi)
; SSE42-NEXT:    retq
;
; AVX-LABEL: interleave_24i8_in:
; AVX:       # BB#0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,8],zero,xmm0[1,9],zero,xmm0[2,10],zero,xmm0[3,11],zero,xmm0[4,12],zero,xmm0[5]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,xmm2[0],zero,zero,xmm2[1],zero,zero,xmm2[2],zero,zero,xmm2[3],zero,zero,xmm2[4],zero
; AVX-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[13],zero,xmm0[6,14],zero,xmm0[7,15],zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = zero,xmm2[5],zero,zero,xmm2[6],zero,zero,xmm2[7,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, 16(%rdi)
; AVX-NEXT:    vmovdqu %xmm1, (%rdi)
; AVX-NEXT:    retq
  %s1 = load <8 x i8>, <8 x i8>* %q1, align 4
  %s2 = load <8 x i8>, <8 x i8>* %q2, align 4
  %s3 = load <8 x i8>, <8 x i8>* %q3, align 4
  %t1 = shufflevector <8 x i8> %s1, <8 x i8> %s2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i8> %s3, <8 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %interleaved = shufflevector <16 x i8> %t1, <16 x i8> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i8> %interleaved, <24 x i8>* %p, align 4
  ret void
}


define void @interleave_24i16_out(<24 x i16>* %p, <8 x i16>* %q1, <8 x i16>* %q2, <8 x i16>* %q3) nounwind {
; SSE2-LABEL: interleave_24i16_out:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqu (%rdi), %xmm3
; SSE2-NEXT:    movdqu 16(%rdi), %xmm2
; SSE2-NEXT:    movdqu 32(%rdi), %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,0,65535,65535,0]
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    pandn %xmm2, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[0,1,2,1]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,6,5]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm4[2,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pandn %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm3, %xmm6
; SSE2-NEXT:    pand %xmm4, %xmm6
; SSE2-NEXT:    por %xmm5, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm6[2,1,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5,4,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[1,2,3,0,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,5,6,7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,65535,65535,0,0,0]
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm7 = xmm8[0,3,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,0,3]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,5,6]
; SSE2-NEXT:    movdqa %xmm6, %xmm0
; SSE2-NEXT:    pandn %xmm7, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pandn %xmm3, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[3,1,2,0]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,0,3,4,5,6,7]
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm8[0,1,2,3,4,7,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,4,5]
; SSE2-NEXT:    pandn %xmm3, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    movups %xmm1, (%rsi)
; SSE2-NEXT:    movdqu %xmm0, (%rdx)
; SSE2-NEXT:    movdqu %xmm6, (%rcx)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: interleave_24i16_out:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqu (%rdi), %xmm0
; SSE42-NEXT:    movdqu 16(%rdi), %xmm1
; SSE42-NEXT:    movdqu 32(%rdi), %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,1,2,1]
; SSE42-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,5]
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0],xmm1[1],xmm4[2,3],xmm1[4],xmm4[5,6],xmm1[7]
; SSE42-NEXT:    pshufb {{.*#+}} xmm4 = xmm4[0,1,6,7,12,13,2,3,8,9,14,15,12,13,14,15]
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5],xmm3[6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm3
; SSE42-NEXT:    pshufb {{.*#+}} xmm3 = xmm3[0,1,6,7,4,5,6,7,0,1,0,1,6,7,12,13]
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm5[0,1],xmm1[2],xmm5[3,4],xmm1[5],xmm5[6,7]
; SSE42-NEXT:    pshufb {{.*#+}} xmm5 = xmm5[2,3,8,9,14,15,4,5,10,11,10,11,8,9,14,15]
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4],xmm3[5,6,7]
; SSE42-NEXT:    pshufb {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,6,7,8,9,2,3,8,9,14,15]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm0[2],xmm1[3,4],xmm0[5],xmm1[6,7]
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[4,5,10,11,0,1,6,7,12,13,14,15,0,1,2,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm2[5,6,7]
; SSE42-NEXT:    movdqu %xmm4, (%rsi)
; SSE42-NEXT:    movdqu %xmm5, (%rdx)
; SSE42-NEXT:    movdqu %xmm1, (%rcx)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: interleave_24i16_out:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovdqu 32(%rdi), %xmm0
; AVX1-NEXT:    vmovdqu (%rdi), %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm1[0],xmm2[1],xmm1[2,3],xmm2[4],xmm1[5,6],xmm2[7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,6,7,12,13,2,3,8,9,14,15,12,13,14,15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[0,1,2,1]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,6,5]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5],xmm4[6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm1[0,1],xmm2[2],xmm1[3,4],xmm2[5],xmm1[6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[2,3,8,9,14,15,4,5,10,11,10,11,8,9,14,15]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[0,1,6,7,4,5,6,7,0,1,0,1,6,7,12,13]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2,3,4],xmm5[5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2],xmm2[3,4],xmm1[5],xmm2[6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,5,10,11,0,1,6,7,12,13,14,15,0,1,2,3]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,7,8,9,2,3,8,9,14,15]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3,4],xmm0[5,6,7]
; AVX1-NEXT:    vmovdqu %xmm3, (%rsi)
; AVX1-NEXT:    vmovdqu %xmm4, (%rdx)
; AVX1-NEXT:    vmovdqu %xmm0, (%rcx)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: interleave_24i16_out:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovdqu (%rdi), %ymm0
; AVX2-NEXT:    vmovdqu 32(%rdi), %xmm1
; AVX2-NEXT:    vpblendw {{.*#+}} ymm2 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2,3],xmm3[4],xmm2[5,6],xmm3[7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,1,6,7,12,13,2,3,8,9,14,15,4,5,10,11]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm3 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7],ymm1[8],ymm0[9,10],ymm1[11],ymm0[12,13],ymm1[14],ymm0[15]
; AVX2-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3,4],xmm4[5],xmm3[6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[2,3,8,9,14,15,4,5,10,11,0,1,6,7,12,13]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7],ymm0[8],ymm1[9],ymm0[10,11],ymm1[12],ymm0[13,14],ymm1[15]
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,10,11,0,1,6,7,12,13,2,3,8,9,14,15]
; AVX2-NEXT:    vmovdqu %xmm2, (%rsi)
; AVX2-NEXT:    vmovdqu %xmm3, (%rdx)
; AVX2-NEXT:    vmovdqu %xmm0, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %wide.vec = load <24 x i16>, <24 x i16>* %p, align 4
  %s1 = shufflevector <24 x i16> %wide.vec, <24 x i16> undef, <8 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21>
  %s2 = shufflevector <24 x i16> %wide.vec, <24 x i16> undef, <8 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22>
  %s3 = shufflevector <24 x i16> %wide.vec, <24 x i16> undef, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>
  store <8 x i16> %s1, <8 x i16>* %q1, align 4
  store <8 x i16> %s2, <8 x i16>* %q2, align 4
  store <8 x i16> %s3, <8 x i16>* %q3, align 4
  ret void
}

define void @interleave_24i16_in(<24 x i16>* %p, <8 x i16>* %q1, <8 x i16>* %q2, <8 x i16>* %q3) nounwind {
; SSE2-LABEL: interleave_24i16_in:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqu (%rsi), %xmm3
; SSE2-NEXT:    movdqu (%rdx), %xmm2
; SSE2-NEXT:    movdqu (%rcx), %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[0,0,0,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    pandn %xmm4, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,3,3,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[1,1,2,2]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,2,2,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,5,4,5]
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    por %xmm5, %xmm3
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    pandn %xmm4, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm2[0,1,3,3,4,5,6,7]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,3,2,0,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,6,7]
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    por %xmm5, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,65535,65535,0,65535,65535,0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,2]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    por %xmm1, %xmm5
; SSE2-NEXT:    pand %xmm0, %xmm5
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm4[0,1,2,3,4,4,6,7]
; SSE2-NEXT:    pandn %xmm1, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movdqu %xmm0, 16(%rdi)
; SSE2-NEXT:    movdqu %xmm2, 32(%rdi)
; SSE2-NEXT:    movdqu %xmm3, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: interleave_24i16_in:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqu (%rsi), %xmm0
; SSE42-NEXT:    movdqu (%rdx), %xmm1
; SSE42-NEXT:    movdqu (%rcx), %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,2,2]
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,3,3,3]
; SSE42-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE42-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,0,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm0[0,1],xmm5[2],xmm0[3,4],xmm5[5],xmm0[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,2,2]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm3[1],xmm0[2,3],xmm3[4],xmm0[5,6],xmm3[7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[0,1,3,3,4,5,6,7]
; SSE42-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm0[0,1],xmm3[2],xmm0[3,4],xmm3[5],xmm0[6,7]
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE42-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[4,5,6,7,4,5,8,9,10,11,10,11,12,13,14,15]
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm1[0,1],xmm4[2],xmm1[3,4],xmm4[5],xmm1[6,7]
; SSE42-NEXT:    movdqu %xmm4, 32(%rdi)
; SSE42-NEXT:    movdqu %xmm3, 16(%rdi)
; SSE42-NEXT:    movdqu %xmm5, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: interleave_24i16_in:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovdqu (%rsi), %xmm0
; AVX1-NEXT:    vmovdqu (%rdx), %xmm1
; AVX1-NEXT:    vmovdqu (%rcx), %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,2,2]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm1[0,1,3,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3,4],xmm4[5],xmm3[6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[1,1,2,2]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0],xmm3[1,2],xmm4[3],xmm3[4,5],xmm4[6],xmm3[7]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,0,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2],xmm4[3,4],xmm5[5],xmm4[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX1-NEXT:    vmovdqu %xmm0, 32(%rdi)
; AVX1-NEXT:    vmovups %ymm3, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: interleave_24i16_in:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovdqu (%rsi), %xmm0
; AVX2-NEXT:    vmovdqu (%rdx), %xmm1
; AVX2-NEXT:    vmovdqu (%rcx), %xmm2
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX2-NEXT:    vpshufb {{.*#+}} ymm4 = ymm3[0,1,2,3,6,7,2,3,8,9,8,9,4,5,6,7,16,17,18,19,22,23,18,19,24,25,24,25,20,21,22,23]
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm3[2,3,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,1,u,u,u,u,2,3,u,u,u,u,4,5,u,u,22,23,u,u,u,u,24,25,u,u,u,u,26,27]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7],ymm4[8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14],ymm3[15]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX2-NEXT:    vpermd %ymm2, %ymm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-NEXT:    vmovdqu %xmm0, 32(%rdi)
; AVX2-NEXT:    vmovdqu %ymm3, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %s1 = load <8 x i16>, <8 x i16>* %q1, align 4
  %s2 = load <8 x i16>, <8 x i16>* %q2, align 4
  %s3 = load <8 x i16>, <8 x i16>* %q3, align 4
  %t1 = shufflevector <8 x i16> %s1, <8 x i16> %s2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i16> %s3, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %interleaved = shufflevector <16 x i16> %t1, <16 x i16> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i16> %interleaved, <24 x i16>* %p, align 4
  ret void
}

define void @interleave_24i32_out(<24 x i32>* %p, <8 x i32>* %q1, <8 x i32>* %q2, <8 x i32>* %q3) nounwind {
; SSE2-LABEL: interleave_24i32_out:
; SSE2:       # BB#0:
; SSE2-NEXT:    movups 80(%rdi), %xmm5
; SSE2-NEXT:    movups 64(%rdi), %xmm8
; SSE2-NEXT:    movups (%rdi), %xmm0
; SSE2-NEXT:    movups 16(%rdi), %xmm6
; SSE2-NEXT:    movups 32(%rdi), %xmm2
; SSE2-NEXT:    movups 48(%rdi), %xmm1
; SSE2-NEXT:    movaps %xmm1, %xmm3
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm8[2,3]
; SSE2-NEXT:    movaps %xmm5, %xmm4
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,0],xmm3[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,0]
; SSE2-NEXT:    movaps %xmm0, %xmm4
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,3],xmm6[2,3]
; SSE2-NEXT:    movaps %xmm2, %xmm7
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,0],xmm4[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm7[2,0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[2,3,0,1]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm6[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm6[3,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[0,1,0,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm0[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,0],xmm8[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm8[3,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[0,1,0,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm5[2,0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm5[0],xmm10[1],xmm5[1]
; SSE2-NEXT:    movsd {{.*#+}} xmm9 = xmm10[0],xmm9[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSE2-NEXT:    movsd {{.*#+}} xmm7 = xmm2[0],xmm7[1]
; SSE2-NEXT:    movups %xmm3, 16(%rsi)
; SSE2-NEXT:    movups %xmm4, (%rsi)
; SSE2-NEXT:    movups %xmm1, 16(%rdx)
; SSE2-NEXT:    movups %xmm0, (%rdx)
; SSE2-NEXT:    movupd %xmm7, 16(%rcx)
; SSE2-NEXT:    movupd %xmm9, (%rcx)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: interleave_24i32_out:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqu 80(%rdi), %xmm9
; SSE42-NEXT:    movdqu 64(%rdi), %xmm10
; SSE42-NEXT:    movdqu (%rdi), %xmm4
; SSE42-NEXT:    movdqu 16(%rdi), %xmm2
; SSE42-NEXT:    movdqu 32(%rdi), %xmm11
; SSE42-NEXT:    movdqu 48(%rdi), %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm8 = xmm11[0,1,0,1]
; SSE42-NEXT:    movdqa %xmm2, %xmm7
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1],xmm4[2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[2,3,0,1]
; SSE42-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,3],xmm2[2,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5],xmm8[6,7]
; SSE42-NEXT:    movdqa %xmm10, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm5[2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[2,3,0,1]
; SSE42-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,3],xmm10[2,3]
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[0,1,0,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm5[0,1,2,3,4,5],xmm3[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm11[0,1,2,2]
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,0,3,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5],xmm5[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,0,3,3]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[0,1,2,2]
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm1[0,1,2,3,4,5],xmm5[6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm6 = xmm6[0,1],xmm2[2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[0,1,0,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm6[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm10[2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm9[0,1,0,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    movdqu %xmm3, 16(%rsi)
; SSE42-NEXT:    movdqu %xmm4, (%rsi)
; SSE42-NEXT:    movdqu %xmm5, 16(%rdx)
; SSE42-NEXT:    movdqu %xmm7, (%rdx)
; SSE42-NEXT:    movdqu %xmm2, 16(%rcx)
; SSE42-NEXT:    movdqu %xmm1, (%rcx)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: interleave_24i32_out:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    vmovups 64(%rdi), %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = zero,zero,xmm2[2],xmm3[1]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm6
; AVX1-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm6[2],xmm5[3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[0,3,2,1]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm6 = xmm6[0,3,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX1-NEXT:    vblendpd {{.*#+}} ymm4 = ymm5[0,1,2],ymm4[3]
; AVX1-NEXT:    vblendps {{.*#+}} xmm5 = xmm2[0,1],xmm3[2],xmm2[3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[0,0,3,2]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm6, %xmm7
; AVX1-NEXT:    vblendps {{.*#+}} xmm6 = xmm7[0],xmm6[1,2],xmm7[3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm6 = xmm6[1,0,3,2]
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm7 = xmm7[1,1,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm6
; AVX1-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3,4],ymm5[5,6,7]
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,1,0,3]
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5,6,7]
; AVX1-NEXT:    vmovupd %ymm4, (%rsi)
; AVX1-NEXT:    vmovups %ymm5, (%rdx)
; AVX1-NEXT:    vmovups %ymm0, (%rcx)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: interleave_24i32_out:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovdqu (%rdi), %ymm0
; AVX2-NEXT:    vmovdqu 32(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu 64(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,u,u,2,5>
; AVX2-NEXT:    vpermd %ymm2, %ymm3, %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = <0,3,6,1,4,7,u,u>
; AVX2-NEXT:    vpermd %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm3[6,7]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,u,u,u,0,3,6>
; AVX2-NEXT:    vpermd %ymm2, %ymm4, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = <1,4,7,2,5,u,u,u>
; AVX2-NEXT:    vpermd %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = <2,5,0,3,6,u,u,u>
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} ymm1 = ymm2[0,1,0,3,4,5,4,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-NEXT:    vmovdqu %ymm3, (%rsi)
; AVX2-NEXT:    vmovdqu %ymm4, (%rdx)
; AVX2-NEXT:    vmovdqu %ymm0, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %wide.vec = load <24 x i32>, <24 x i32>* %p, align 4
  %s1 = shufflevector <24 x i32> %wide.vec, <24 x i32> undef, <8 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21>
  %s2 = shufflevector <24 x i32> %wide.vec, <24 x i32> undef, <8 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22>
  %s3 = shufflevector <24 x i32> %wide.vec, <24 x i32> undef, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>
  store <8 x i32> %s1, <8 x i32>* %q1, align 4
  store <8 x i32> %s2, <8 x i32>* %q2, align 4
  store <8 x i32> %s3, <8 x i32>* %q3, align 4
  ret void
}

define void @interleave_24i32_in(<24 x i32>* %p, <8 x i32>* %q1, <8 x i32>* %q2, <8 x i32>* %q3) nounwind {
; SSE2-LABEL: interleave_24i32_in:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqu (%rsi), %xmm5
; SSE2-NEXT:    movdqu 16(%rsi), %xmm2
; SSE2-NEXT:    movdqu (%rdx), %xmm6
; SSE2-NEXT:    movdqu 16(%rdx), %xmm1
; SSE2-NEXT:    movdqu (%rcx), %xmm7
; SSE2-NEXT:    movdqu 16(%rcx), %xmm4
; SSE2-NEXT:    movdqa %xmm5, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,1,0,1]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm3[0,2]
; SSE2-NEXT:    movdqa %xmm7, %xmm3
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,0],xmm6[1,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm6[2,2]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm7 = xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm3[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm5[0,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,3,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm5[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm6[0,2]
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,1,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,1,0,1]
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm6[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm7[0,2]
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,0],xmm1[1,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm1[2,2]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm7[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm2[0,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[0,3,2,2]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[0,2]
; SSE2-NEXT:    movups %xmm2, 80(%rdi)
; SSE2-NEXT:    movups %xmm7, 64(%rdi)
; SSE2-NEXT:    movups %xmm6, 48(%rdi)
; SSE2-NEXT:    movups %xmm5, 32(%rdi)
; SSE2-NEXT:    movups %xmm3, 16(%rdi)
; SSE2-NEXT:    movups %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: interleave_24i32_in:
; SSE42:       # BB#0:
; SSE42-NEXT:    movdqu (%rsi), %xmm5
; SSE42-NEXT:    movdqu 16(%rsi), %xmm2
; SSE42-NEXT:    movdqu (%rdx), %xmm6
; SSE42-NEXT:    movdqu 16(%rdx), %xmm1
; SSE42-NEXT:    movdqu (%rcx), %xmm7
; SSE42-NEXT:    movdqu 16(%rcx), %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,1,1]
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[0,1,0,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,3],xmm3[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,1,0,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm3[0,1,2,3],xmm0[4,5],xmm3[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,2,2]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm7[2,3],xmm3[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm5[4,5],xmm3[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,3,0,1]
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,3,2,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1],xmm5[2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[2,2,3,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm7[0,1,2,3],xmm5[4,5],xmm7[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,1,1]
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[0,1,0,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1],xmm6[2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[0,1,0,1]
; SSE42-NEXT:    pblendw {{.*#+}} xmm6 = xmm7[0,1,2,3],xmm6[4,5],xmm7[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[1,1,2,2]
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1],xmm4[2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1,2,3],xmm2[4,5],xmm7[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,3,0,1]
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,3,2,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm2[2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm4[0,1,2,3],xmm1[4,5],xmm4[6,7]
; SSE42-NEXT:    movdqu %xmm1, 80(%rdi)
; SSE42-NEXT:    movdqu %xmm7, 64(%rdi)
; SSE42-NEXT:    movdqu %xmm6, 48(%rdi)
; SSE42-NEXT:    movdqu %xmm5, 32(%rdi)
; SSE42-NEXT:    movdqu %xmm3, 16(%rdi)
; SSE42-NEXT:    movdqu %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: interleave_24i32_in:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovups (%rsi), %ymm0
; AVX1-NEXT:    vmovups (%rdx), %ymm1
; AVX1-NEXT:    vmovupd (%rcx), %ymm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm0[2,0],xmm1[2,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm3 = xmm1[1,1],xmm3[0,2]
; AVX1-NEXT:    vshufps {{.*#+}} xmm4 = xmm1[0,0],xmm0[0,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[2,0],xmm0[2,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = xmm2[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm4, %ymm4
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vshufps {{.*#+}} xmm6 = xmm5[3,0],xmm4[3,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm6 = xmm4[2,1],xmm6[0,2]
; AVX1-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[1,0],xmm5[1,0]
; AVX1-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[2,0],xmm5[2,2]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX1-NEXT:    vpermilpd {{.*#+}} ymm5 = ymm0[1,1,3,3]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX1-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,2]
; AVX1-NEXT:    vpermilpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1],ymm2[2,3],ymm0[4],ymm2[5,6],ymm0[7]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-NEXT:    vmovups %ymm0, 32(%rdi)
; AVX1-NEXT:    vmovups %ymm4, 64(%rdi)
; AVX1-NEXT:    vmovups %ymm3, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: interleave_24i32_in:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovdqu (%rsi), %ymm0
; AVX2-NEXT:    vmovdqu (%rdx), %ymm1
; AVX2-NEXT:    vmovdqu (%rcx), %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[1,0,2,2]
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-NEXT:    vpbroadcastq %xmm2, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,1,3,3]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm5 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2,3],ymm4[4],ymm5[5,6],ymm4[7]
; AVX2-NEXT:    vpbroadcastq 24(%rsi), %ymm5
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0],ymm0[1],ymm2[2,3],ymm0[4],ymm2[5,6],ymm0[7]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovdqu %ymm0, 32(%rdi)
; AVX2-NEXT:    vmovdqu %ymm4, 64(%rdi)
; AVX2-NEXT:    vmovdqu %ymm3, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %s1 = load <8 x i32>, <8 x i32>* %q1, align 4
  %s2 = load <8 x i32>, <8 x i32>* %q2, align 4
  %s3 = load <8 x i32>, <8 x i32>* %q3, align 4
  %t1 = shufflevector <8 x i32> %s1, <8 x i32> %s2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i32> %s3, <8 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %interleaved = shufflevector <16 x i32> %t1, <16 x i32> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i32> %interleaved, <24 x i32>* %p, align 4
  ret void
}

define <2 x double> @wrongorder(<4 x double> %A, <8 x double>* %P) #0 {
; SSE2-LABEL: wrongorder:
; SSE2:       # BB#0:
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    movaps %xmm0, 48(%rdi)
; SSE2-NEXT:    movaps %xmm0, 32(%rdi)
; SSE2-NEXT:    movaps %xmm0, 16(%rdi)
; SSE2-NEXT:    movaps %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: wrongorder:
; SSE42:       # BB#0:
; SSE42-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSE42-NEXT:    movapd %xmm0, 48(%rdi)
; SSE42-NEXT:    movapd %xmm0, 32(%rdi)
; SSE42-NEXT:    movapd %xmm0, 16(%rdi)
; SSE42-NEXT:    movapd %xmm0, (%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: wrongorder:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm1
; AVX1-NEXT:    vmovaps %ymm1, 32(%rdi)
; AVX1-NEXT:    vmovaps %ymm1, (%rdi)
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: wrongorder:
; AVX2:       # BB#0:
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm1
; AVX2-NEXT:    vmovapd %ymm1, 32(%rdi)
; AVX2-NEXT:    vmovapd %ymm1, (%rdi)
; AVX2-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %shuffle = shufflevector <4 x double> %A, <4 x double> %A, <8 x i32> zeroinitializer
  store <8 x double> %shuffle, <8 x double>* %P, align 64
  %m2 = load <8 x double>, <8 x double>* %P, align 64
  store <8 x double> %m2, <8 x double>* %P, align 64
  %m3 = load <8 x double>, <8 x double>* %P, align 64
  %m4 = shufflevector <8 x double> %m3, <8 x double> undef, <2 x i32> <i32 2, i32 0>
  ret <2 x double> %m4
}
