; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mcpu=corei7 | FileCheck %s

; Check that a <4 x float> compare is generated and that we are
; not stuck in an endless loop.

define void @cmp_2_floats() {
; CHECK-LABEL: cmp_2_floats:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    cmpordps %xmm0, %xmm0
; CHECK-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; CHECK-NEXT:    psllq $32, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; CHECK-NEXT:    pslld $31, %xmm0
; CHECK-NEXT:    blendvps %xmm0, %xmm0
; CHECK-NEXT:    movlps %xmm0, (%rax)
; CHECK-NEXT:    retq
entry:
  %0 = fcmp oeq <2 x float> undef, undef
  %1 = select <2 x i1> %0, <2 x float> undef, <2 x float> undef
  store <2 x float> %1, <2 x float>* undef
  ret void
}

define void @cmp_2_doubles() {
; CHECK-LABEL: cmp_2_doubles:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    cmpordpd %xmm0, %xmm0
; CHECK-NEXT:    blendvpd %xmm0, %xmm0
; CHECK-NEXT:    movapd %xmm0, (%rax)
; CHECK-NEXT:    retq
entry:
  %0 = fcmp oeq <2 x double> undef, undef
  %1 = select <2 x i1> %0, <2 x double> undef, <2 x double> undef
  store <2 x double> %1, <2 x double>* undef
  ret void
}

define void @mp_11193(<8 x float> * nocapture %aFOO, <8 x float>* nocapture %RET) nounwind {
; CHECK-LABEL: mp_11193:
; CHECK:       # BB#0: # %allocas
; CHECK-NEXT:    movl $-1082130432, (%rsi) # imm = 0xBF800000
; CHECK-NEXT:    retq
allocas:
  %bincmp = fcmp olt <8 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 9.000000e+00, float 1.000000e+00, float 9.000000e+00, float 1.000000e+00> , <float 3.000000e+00, float 3.000000e+00, float 3.000000e+00, float 3.000000e+00, float 3.000000e+00, float 3.000000e+00, float 3.000000e+00, float 3.000000e+00>
  %t = extractelement <8 x i1> %bincmp, i32 0
  %ft = sitofp i1 %t to float
  %pp = bitcast <8 x float>* %RET to float*
  store float %ft, float* %pp
  ret void
}

