; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefix=X64

define void @test_512(i512* %a, i512* %b, i512* %out) nounwind {
; X32-LABEL: test_512:
; X32:       # BB#0:
; X32-NEXT:    pushl %ebp
; X32-NEXT:    movl %esp, %ebp
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %esi
; X32-NEXT:    andl $-8, %esp
; X32-NEXT:    subl $632, %esp # imm = 0x278
; X32-NEXT:    movl 12(%ebp), %ecx
; X32-NEXT:    movl 8(%ebp), %ebx
; X32-NEXT:    movl (%ebx), %edi
; X32-NEXT:    movl 4(%ebx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 8(%ebx), %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 12(%ebx), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 8(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 12(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl (%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 4(%ecx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %ecx
; X32-NEXT:    pushl %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %edx
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    seto %al
; X32-NEXT:    lahf
; X32-NEXT:    movl %eax, %eax
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 60(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 56(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 52(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 48(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 44(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 40(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 36(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 32(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 28(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 24(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 20(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 16(%ebx), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %eax, %eax
; X32-NEXT:    addb $127, %al
; X32-NEXT:    sahf
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 12(%ebp), %ecx
; X32-NEXT:    movl 28(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 24(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 20(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 16(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 44(%ecx), %edi
; X32-NEXT:    movl 40(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 36(%ecx), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl 32(%ecx), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl 60(%ecx)
; X32-NEXT:    pushl 56(%ecx)
; X32-NEXT:    pushl 52(%ecx)
; X32-NEXT:    pushl 48(%ecx)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    pushl %ecx
; X32-NEXT:    movl %ecx, %ebx
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %edi
; X32-NEXT:    movl %esi, %ebx
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl %esi, %edi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi # 4-byte Reload
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl %esi
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl $0
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl {{[0-9]+}}(%esp) # 4-byte Folded Reload
; X32-NEXT:    pushl %eax
; X32-NEXT:    calll __multi3
; X32-NEXT:    addl $32, %esp
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    addl %edx, %eax
; X32-NEXT:    adcl %esi, %ecx
; X32-NEXT:    movl $0, %edx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    sbbl %esi, %esi
; X32-NEXT:    andl $1, %esi
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    addl %edi, %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    adcl %edx, %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    adcl %esi, %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    adcl %esi, %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    addl %eax, %esi
; X32-NEXT:    adcl %ecx, %edi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl %ecx, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    addl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    addl %edx, %eax
; X32-NEXT:    adcl %esi, %ecx
; X32-NEXT:    movl $0, %edx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    sbbl %esi, %esi
; X32-NEXT:    andl $1, %esi
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    addl %esi, %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl %edi, %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    adcl %ebx, %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    addl %eax, %edx
; X32-NEXT:    adcl %ecx, %esi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl %eax, {{[0-9]+}}(%esp) # 4-byte Folded Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl %eax, {{[0-9]+}}(%esp) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi # 4-byte Folded Reload
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edi # 4-byte Folded Reload
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl $0, %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl $0, %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl $0, %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    sbbl %eax, %eax
; X32-NEXT:    andl $1, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx # 4-byte Reload
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi # 4-byte Folded Reload
; X32-NEXT:    movl $0, %edi
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    sbbl %ebx, %ebx
; X32-NEXT:    andl $1, %ebx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    addl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl %edi, %edx
; X32-NEXT:    adcl %ebx, %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    addl %eax, {{[0-9]+}}(%esp) # 4-byte Folded Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl %eax, {{[0-9]+}}(%esp) # 4-byte Folded Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl %eax, {{[0-9]+}}(%esp) # 4-byte Folded Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi # 4-byte Folded Reload
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    addl %edi, %edx
; X32-NEXT:    adcl %ebx, %esi
; X32-NEXT:    movl $0, %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    sbbl %ecx, %ecx
; X32-NEXT:    andl $1, %ecx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    addl %edx, %edi
; X32-NEXT:    movl %edi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ebx
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    addl %eax, %edi
; X32-NEXT:    adcl %ecx, %ebx
; X32-NEXT:    movl $0, %eax
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    sbbl %edx, %edx
; X32-NEXT:    andl $1, %edx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    addl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl %esi, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    addl %edi, %ecx
; X32-NEXT:    adcl %ebx, %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl %edx, %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    addl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %esi # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax # 4-byte Reload
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx # 4-byte Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    addl {{[0-9]+}}(%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[0-9]+}}(%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[0-9]+}}(%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    movl 16(%ebp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, 16(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, 20(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, 24(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, 28(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, (%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, 4(%eax)
; X32-NEXT:    movl %ecx, 8(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, 32(%eax)
; X32-NEXT:    movl %edx, 12(%eax)
; X32-NEXT:    movl %edi, 36(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, 40(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, 44(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, 48(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, 52(%eax)
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, 56(%eax)
; X32-NEXT:    movl %esi, 60(%eax)
; X32-NEXT:    leal -12(%ebp), %esp
; X32-NEXT:    popl %esi
; X32-NEXT:    popl %edi
; X32-NEXT:    popl %ebx
; X32-NEXT:    popl %ebp
; X32-NEXT:    retl
;
; X64-LABEL: test_512:
; X64:       # BB#0:
; X64-NEXT:    pushq %rbp
; X64-NEXT:    pushq %r15
; X64-NEXT:    pushq %r14
; X64-NEXT:    pushq %r13
; X64-NEXT:    pushq %r12
; X64-NEXT:    pushq %rbx
; X64-NEXT:    subq $56, %rsp
; X64-NEXT:    movq %rdx, {{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq 24(%rdi), %rcx
; X64-NEXT:    movq 16(%rdi), %r15
; X64-NEXT:    movq %rsi, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq (%rsi), %r11
; X64-NEXT:    movq 8(%rsi), %rbp
; X64-NEXT:    movq %r15, %rax
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rdx, %r8
; X64-NEXT:    movq %rax, %r10
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    movq %rcx, %r14
; X64-NEXT:    movq %r14, {{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    addq %r10, %rsi
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    movq %r15, %rax
; X64-NEXT:    mulq %rbp
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %r9
; X64-NEXT:    addq %rsi, %r9
; X64-NEXT:    adcq $0, %rcx
; X64-NEXT:    addq %rbx, %rcx
; X64-NEXT:    sbbq %rax, %rax
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    movq %r15, %rbx
; X64-NEXT:    movq %rbx, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rbx, %rdx
; X64-NEXT:    imulq %rbp, %rdx
; X64-NEXT:    movq %rdx, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rbp, %r12
; X64-NEXT:    movq %r12, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    leaq (%r8,%rdx), %rbp
; X64-NEXT:    imulq %r11, %r14
; X64-NEXT:    movq %r14, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    addq %r14, %rbp
; X64-NEXT:    addq %r10, %rcx
; X64-NEXT:    adcq %rax, %rbp
; X64-NEXT:    xorl %r14d, %r14d
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %r14
; X64-NEXT:    movq %rdx, %r10
; X64-NEXT:    movq %r10, {{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    movq %rsi, {{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rbx, %rax
; X64-NEXT:    mulq %r14
; X64-NEXT:    movq %rdx, %r14
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    addq %rsi, %rbx
; X64-NEXT:    adcq %r10, %r14
; X64-NEXT:    addq %rcx, %rbx
; X64-NEXT:    adcq %rbp, %r14
; X64-NEXT:    movq %rdi, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq (%rdi), %rax
; X64-NEXT:    movq %rax, %r13
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rdx, %rsi
; X64-NEXT:    movq %rsi, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq 8(%rdi), %rax
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    addq %rcx, %rbp
; X64-NEXT:    adcq $0, %rdx
; X64-NEXT:    movq %rdx, (%rsp) # 8-byte Spill
; X64-NEXT:    movq %r13, %rax
; X64-NEXT:    mulq %r12
; X64-NEXT:    addq %rbp, %rax
; X64-NEXT:    movq %rax, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq $0, %rdx
; X64-NEXT:    movq %rdx, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    addq %rsi, %r8
; X64-NEXT:    movq %r8, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq %rax, %r9
; X64-NEXT:    movq %r9, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    adcq $0, %r14
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rcx # 8-byte Reload
; X64-NEXT:    movq 16(%rcx), %r10
; X64-NEXT:    movq %r13, %rax
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rdx, %r8
; X64-NEXT:    movq %rax, %r15
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq %rdi, %r12
; X64-NEXT:    movq %r12, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    addq %r15, %rdi
; X64-NEXT:    adcq $0, %rbp
; X64-NEXT:    movq 24(%rcx), %rsi
; X64-NEXT:    movq %r13, %rcx
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rsi, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rdx, %r13
; X64-NEXT:    movq %rax, %r9
; X64-NEXT:    addq %rdi, %r9
; X64-NEXT:    adcq $0, %r13
; X64-NEXT:    addq %rbp, %r13
; X64-NEXT:    sbbq %rax, %rax
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    movq %rcx, %rdx
; X64-NEXT:    movq %rcx, %rdi
; X64-NEXT:    imulq %rsi, %rdx
; X64-NEXT:    movq %rdx, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %r12, %rbp
; X64-NEXT:    imulq %r10, %rbp
; X64-NEXT:    leaq (%r8,%rdx), %rcx
; X64-NEXT:    addq %rbp, %rcx
; X64-NEXT:    addq %r15, %r13
; X64-NEXT:    adcq %rax, %rcx
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    xorl %esi, %esi
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rdx, %r15
; X64-NEXT:    movq %rax, %r12
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    xorl %esi, %esi
; X64-NEXT:    movq %rdx, {{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rax, {{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    addq %rax, %r12
; X64-NEXT:    adcq %rdx, %r15
; X64-NEXT:    addq %r13, %r12
; X64-NEXT:    adcq %rcx, %r15
; X64-NEXT:    addq %r8, -{{[0-9]+}}(%rsp) # 8-byte Folded Spill
; X64-NEXT:    adcq -{{[0-9]+}}(%rsp), %r9 # 8-byte Folded Reload
; X64-NEXT:    movq %r9, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq $0, %r12
; X64-NEXT:    adcq $0, %r15
; X64-NEXT:    addq %rbx, %r12
; X64-NEXT:    adcq %r14, %r15
; X64-NEXT:    movq %r15, %r8
; X64-NEXT:    adcq $0, %rsi
; X64-NEXT:    movq %rsi, %r13
; X64-NEXT:    sbbq %r15, %r15
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq -{{[0-9]+}}(%rsp) # 8-byte Folded Reload
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    addq -{{[0-9]+}}(%rsp), %rbx # 8-byte Folded Reload
; X64-NEXT:    addq -{{[0-9]+}}(%rsp), %rbx # 8-byte Folded Reload
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    movq %rdi, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %r14
; X64-NEXT:    addq %rbp, %r14
; X64-NEXT:    addq -{{[0-9]+}}(%rsp), %r14 # 8-byte Folded Reload
; X64-NEXT:    andl $1, %r15d
; X64-NEXT:    addq %rsi, %rax
; X64-NEXT:    adcq %rbx, %r14
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rbx # 8-byte Reload
; X64-NEXT:    addq (%rsp), %rbx # 8-byte Folded Reload
; X64-NEXT:    sbbq %rsi, %rsi
; X64-NEXT:    movq %rdi, %rdx
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rdi # 8-byte Reload
; X64-NEXT:    imulq %rdi, %rdx
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rcx # 8-byte Reload
; X64-NEXT:    addq %rcx, %rdx
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rbp # 8-byte Reload
; X64-NEXT:    imulq %r11, %rbp
; X64-NEXT:    addq %rdx, %rbp
; X64-NEXT:    andl $1, %esi
; X64-NEXT:    movq %rbx, %rdx
; X64-NEXT:    addq -{{[0-9]+}}(%rsp), %rdx # 8-byte Folded Reload
; X64-NEXT:    movq %rdx, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq %rsi, %rbp
; X64-NEXT:    movq %rbp, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    addq %rdx, %rax
; X64-NEXT:    adcq %rbp, %r14
; X64-NEXT:    addq %rcx, %r12
; X64-NEXT:    adcq -{{[0-9]+}}(%rsp), %r8 # 8-byte Folded Reload
; X64-NEXT:    movq %r8, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq %r13, %rax
; X64-NEXT:    movq %rax, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq %r15, %r14
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rcx # 8-byte Reload
; X64-NEXT:    movq 32(%rcx), %rsi
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rbp # 8-byte Reload
; X64-NEXT:    imulq %rsi, %rbp
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    addq %rbp, %rdx
; X64-NEXT:    movq 40(%rcx), %r8
; X64-NEXT:    imulq %r8, %r10
; X64-NEXT:    addq %rdx, %r10
; X64-NEXT:    movq 48(%rcx), %rax
; X64-NEXT:    movq %rcx, %rbp
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    imulq %rdi, %rcx
; X64-NEXT:    movq %rdi, %r9
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rax, %r15
; X64-NEXT:    addq %rcx, %rdx
; X64-NEXT:    movq 56(%rbp), %rdi
; X64-NEXT:    imulq %r11, %rdi
; X64-NEXT:    addq %rdx, %rdi
; X64-NEXT:    addq %rbx, %r15
; X64-NEXT:    adcq %r10, %rdi
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rdx, %r10
; X64-NEXT:    movq %r10, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq %rax, %r13
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    addq %r13, %rcx
; X64-NEXT:    adcq $0, %rbp
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    movq %rax, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    addq %rbp, %rbx
; X64-NEXT:    sbbq %rax, %rax
; X64-NEXT:    imulq %r8, %r11
; X64-NEXT:    movq %r9, %rcx
; X64-NEXT:    imulq %rsi, %rcx
; X64-NEXT:    addq %r10, %r11
; X64-NEXT:    addq %r11, %rcx
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    addq %r13, %rbx
; X64-NEXT:    adcq %rax, %rcx
; X64-NEXT:    addq %r15, %rbx
; X64-NEXT:    adcq %rdi, %rcx
; X64-NEXT:    movq %rcx, -{{[0-9]+}}(%rsp) # 8-byte Spill
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rcx # 8-byte Reload
; X64-NEXT:    movq 56(%rcx), %rsi
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %r10 # 8-byte Reload
; X64-NEXT:    imulq %r10, %rsi
; X64-NEXT:    movq 48(%rcx), %rdi
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rax, %r9
; X64-NEXT:    addq %rsi, %rdx
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %r8 # 8-byte Reload
; X64-NEXT:    imulq %r8, %rdi
; X64-NEXT:    addq %rdx, %rdi
; X64-NEXT:    movq 32(%rcx), %rsi
; X64-NEXT:    movq 40(%rcx), %rbp
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rax # 8-byte Reload
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    imulq %rbp, %rcx
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rax, %r15
; X64-NEXT:    addq %rcx, %rdx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax # 8-byte Reload
; X64-NEXT:    imulq %rsi, %rax
; X64-NEXT:    addq %rdx, %rax
; X64-NEXT:    addq %r9, %r15
; X64-NEXT:    adcq %rdi, %rax
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rdx, %r13
; X64-NEXT:    movq %rax, %r9
; X64-NEXT:    movq %rbp, %rax
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rdx, %rdi
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    addq %r9, %rcx
; X64-NEXT:    adcq $0, %rdi
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    adcq $0, %rdx
; X64-NEXT:    addq %rdi, %rdx
; X64-NEXT:    sbbq %rcx, %rcx
; X64-NEXT:    imulq %r8, %rsi
; X64-NEXT:    imulq %r10, %rbp
; X64-NEXT:    addq %r13, %rsi
; X64-NEXT:    addq %rsi, %rbp
; X64-NEXT:    andl $1, %ecx
; X64-NEXT:    addq %r9, %rdx
; X64-NEXT:    adcq %rcx, %rbp
; X64-NEXT:    addq %r15, %rdx
; X64-NEXT:    adcq %r11, %rbp
; X64-NEXT:    addq -{{[0-9]+}}(%rsp), %r13 # 8-byte Folded Reload
; X64-NEXT:    adcq -{{[0-9]+}}(%rsp), %rax # 8-byte Folded Reload
; X64-NEXT:    adcq %rbx, %rdx
; X64-NEXT:    adcq -{{[0-9]+}}(%rsp), %rbp # 8-byte Folded Reload
; X64-NEXT:    addq %r12, %r13
; X64-NEXT:    adcq -{{[0-9]+}}(%rsp), %rax # 8-byte Folded Reload
; X64-NEXT:    adcq -{{[0-9]+}}(%rsp), %rdx # 8-byte Folded Reload
; X64-NEXT:    adcq %r14, %rbp
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi # 8-byte Reload
; X64-NEXT:    addq {{[0-9]+}}(%rsp), %rsi # 8-byte Folded Reload
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx # 8-byte Reload
; X64-NEXT:    adcq {{[0-9]+}}(%rsp), %rcx # 8-byte Folded Reload
; X64-NEXT:    addq -{{[0-9]+}}(%rsp), %rsi # 8-byte Folded Reload
; X64-NEXT:    movq %rsi, %rdi
; X64-NEXT:    adcq -{{[0-9]+}}(%rsp), %rcx # 8-byte Folded Reload
; X64-NEXT:    movq %rcx, %rsi
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx # 8-byte Reload
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rbx # 8-byte Reload
; X64-NEXT:    movq %rbx, 16(%rcx)
; X64-NEXT:    movq -{{[0-9]+}}(%rsp), %rbx # 8-byte Reload
; X64-NEXT:    movq %rbx, 24(%rcx)
; X64-NEXT:    movq %rdi, (%rcx)
; X64-NEXT:    movq %r13, 32(%rcx)
; X64-NEXT:    movq %rsi, 8(%rcx)
; X64-NEXT:    movq %rax, 40(%rcx)
; X64-NEXT:    movq %rdx, 48(%rcx)
; X64-NEXT:    movq %rbp, 56(%rcx)
; X64-NEXT:    addq $56, %rsp
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    popq %rbp
; X64-NEXT:    retq
  %av = load i512, i512* %a
  %bv = load i512, i512* %b
  %r = mul i512 %av, %bv
  store i512 %r, i512* %out
  ret void
}
