; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=skx | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=knl | FileCheck %s -check-prefix=NoVLX

define zeroext i32 @test_vpcmpeqb_v16i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqb %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqb_v16i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqb (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqb_v16i1_v32i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqb %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqb_v16i1_v32i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqb (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqb_v16i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqb %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqb_v16i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqb (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqb_v16i1_v64i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqb %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqb_v16i1_v64i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqb (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp eq <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqb_v32i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqb %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp eq <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqb_v32i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqb (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp eq <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqb_v32i1_v64i1_mask(i32 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqb %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp eq <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqb_v32i1_v64i1_mask_mem(i32 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqb (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp eq <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpeqw_v8i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpeqw_v8i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqw_v8i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpeqw_v8i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpeqw_v8i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqw_v8i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqw_v8i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqw_v8i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqw_v8i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqw_v8i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqw_v8i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqw_v8i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp eq <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpeqw_v16i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqw_v16i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqw_v16i1_v32i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqw_v16i1_v32i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqw_v16i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqw_v16i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqw_v16i1_v64i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqw_v16i1_v64i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp eq <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqw_v32i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp eq <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqw_v32i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqw_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqw (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp eq <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqw_v32i1_v64i1_mask(i32 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp eq <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqw_v32i1_v64i1_mask_mem(i32 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqw_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqw (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp eq <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpeqd_v4i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpeqd_v4i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpeqd_v4i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpeqd_v4i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpeqd_v4i1_v8i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpeqd_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpeqd_v4i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpeqd_v4i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqd_v4i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpeqd_v4i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpeqd_v4i1_v16i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqd_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpeqd_v4i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqd_v4i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqd_v4i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqd_v4i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpeqd_v4i1_v32i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqd_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqd_v4i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqd_v4i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqd_v4i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqd_v4i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqd_v4i1_v64i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqd_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpeqd_v8i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpeqd_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpeqd_v8i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpeqd_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqd_v8i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpeqd_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpeqd_v8i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpeqd_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpeqd_v8i1_v16i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpeqd_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqd_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpeqd_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpeqd_v8i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqd_v8i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqd_v8i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqd_v8i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpeqd_v8i1_v32i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqd_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqd_v8i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqd_v8i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqd_v8i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqd_v8i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqd_v8i1_v64i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqd_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpeqd_v16i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqd_v16i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqd_v16i1_v32i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqd_v16i1_v32i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpeqd_v16i1_v32i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqd_v16i1_v32i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to16}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqd_v16i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqd_v16i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqd_v16i1_v64i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqd_v16i1_v64i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqd_v16i1_v64i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqd_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqd (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqd_v16i1_v64i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqd_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqd (%rsi){1to16}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i4 @test_vpcmpeqq_v2i1_v4i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_vpcmpeqq_v2i1_v4i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpeqq_v2i1_v4i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}

define zeroext i4 @test_masked_vpcmpeqq_v2i1_v4i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i4 @test_vpcmpeqq_v2i1_v4i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpeqq_v2i1_v4i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i8 @test_vpcmpeqq_v2i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpeqq_v2i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpeqq_v2i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpeqq_v2i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpeqq_v2i1_v8i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpeqq_v2i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpeqq_v2i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpeqq_v2i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqq_v2i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpeqq_v2i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpeqq_v2i1_v16i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqq_v2i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpeqq_v2i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqq_v2i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqq_v2i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqq_v2i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpeqq_v2i1_v32i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqq_v2i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqq_v2i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqq_v2i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqq_v2i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqq_v2i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqq_v2i1_v64i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqq_v2i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp eq <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpeqq_v4i1_v8i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpeqq_v4i1_v8i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpeqq_v4i1_v8i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpeqq_v4i1_v8i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpeqq_v4i1_v8i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpeqq_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpeqq_v4i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpeqq_v4i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqq_v4i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpeqq_v4i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpeqq_v4i1_v16i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqq_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpeqq_v4i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqq_v4i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqq_v4i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqq_v4i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpeqq_v4i1_v32i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqq_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqq_v4i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqq_v4i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqq_v4i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqq_v4i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqq_v4i1_v64i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqq_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpeqq_v8i1_v16i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpeqq_v8i1_v16i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqq_v8i1_v16i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpeqq_v8i1_v16i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpeqq_v8i1_v16i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpeqq_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpeqq_v8i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpeqq_v8i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqq_v8i1_v32i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpeqq_v8i1_v32i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpeqq_v8i1_v32i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpeqq_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpeqq_v8i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpeqq_v8i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqq_v8i1_v64i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpeqq_v8i1_v64i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpeqq_v8i1_v64i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpeqq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpeqq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpeqq_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpeqq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpeqq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp eq <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpsgtb_v16i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtb %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtb_v16i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtb (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtb_v16i1_v32i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtb %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtb_v16i1_v32i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtb (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtb_v16i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtb %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtb_v16i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtb (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtb_v16i1_v64i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtb %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtb_v16i1_v64i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtb (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sgt <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtb_v32i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtb %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp sgt <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtb_v32i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtb (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp sgt <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtb_v32i1_v64i1_mask(i32 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtb %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp sgt <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtb_v32i1_v64i1_mask_mem(i32 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtb (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp sgt <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpsgtw_v8i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgtw_v8i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtw_v8i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgtw_v8i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgtw_v8i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtw_v8i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtw_v8i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtw_v8i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtw_v8i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtw_v8i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtw_v8i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtw_v8i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sgt <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpsgtw_v16i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtw_v16i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtw_v16i1_v32i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtw_v16i1_v32i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtw_v16i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtw_v16i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtw_v16i1_v64i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtw_v16i1_v64i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sgt <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtw_v32i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp sgt <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtw_v32i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtw_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtw (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp sgt <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtw_v32i1_v64i1_mask(i32 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp sgt <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtw_v32i1_v64i1_mask_mem(i32 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtw_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtw (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp sgt <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpsgtd_v4i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpsgtd_v4i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgtd_v4i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpsgtd_v4i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpsgtd_v4i1_v8i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgtd_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpsgtd_v4i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgtd_v4i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtd_v4i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgtd_v4i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgtd_v4i1_v16i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtd_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgtd_v4i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtd_v4i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtd_v4i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtd_v4i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgtd_v4i1_v32i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtd_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtd_v4i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtd_v4i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtd_v4i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtd_v4i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtd_v4i1_v64i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtd_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpsgtd_v8i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpsgtd_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgtd_v8i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpsgtd_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtd_v8i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpsgtd_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgtd_v8i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpsgtd_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgtd_v8i1_v16i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpsgtd_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtd_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpsgtd_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgtd_v8i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtd_v8i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtd_v8i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtd_v8i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgtd_v8i1_v32i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtd_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtd_v8i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtd_v8i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtd_v8i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtd_v8i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtd_v8i1_v64i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtd_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpsgtd_v16i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtd_v16i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtd_v16i1_v32i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtd_v16i1_v32i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgtd_v16i1_v32i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtd_v16i1_v32i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to16}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtd_v16i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtd_v16i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtd_v16i1_v64i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtd_v16i1_v64i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtd_v16i1_v64i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtd_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtd (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtd_v16i1_v64i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtd_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtd (%rsi){1to16}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i4 @test_vpcmpsgtq_v2i1_v4i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_vpcmpsgtq_v2i1_v4i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpsgtq_v2i1_v4i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}

define zeroext i4 @test_masked_vpcmpsgtq_v2i1_v4i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i4 @test_vpcmpsgtq_v2i1_v4i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpsgtq_v2i1_v4i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i8 @test_vpcmpsgtq_v2i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpsgtq_v2i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgtq_v2i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpsgtq_v2i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpsgtq_v2i1_v8i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgtq_v2i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpsgtq_v2i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgtq_v2i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtq_v2i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgtq_v2i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgtq_v2i1_v16i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtq_v2i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgtq_v2i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtq_v2i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtq_v2i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtq_v2i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgtq_v2i1_v32i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtq_v2i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtq_v2i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtq_v2i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtq_v2i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtq_v2i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtq_v2i1_v64i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtq_v2i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sgt <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpsgtq_v4i1_v8i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpsgtq_v4i1_v8i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgtq_v4i1_v8i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpsgtq_v4i1_v8i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpsgtq_v4i1_v8i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgtq_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpsgtq_v4i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgtq_v4i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtq_v4i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgtq_v4i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgtq_v4i1_v16i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtq_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgtq_v4i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtq_v4i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtq_v4i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtq_v4i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgtq_v4i1_v32i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtq_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtq_v4i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtq_v4i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtq_v4i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtq_v4i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtq_v4i1_v64i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtq_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpsgtq_v8i1_v16i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgtq_v8i1_v16i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtq_v8i1_v16i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgtq_v8i1_v16i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgtq_v8i1_v16i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgtq_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgtq_v8i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgtq_v8i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtq_v8i1_v32i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgtq_v8i1_v32i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgtq_v8i1_v32i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgtq_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgtq_v8i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgtq_v8i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtq_v8i1_v64i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgtq_v8i1_v64i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgtq_v8i1_v64i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgtq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpgtq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgtq_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgtq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpgtq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sgt <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpsgeb_v16i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleb %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgeb_v16i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltb (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgeb_v16i1_v32i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleb %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgeb_v16i1_v32i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltb (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgeb_v16i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleb %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgeb_v16i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltb (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeb_v16i1_v64i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleb %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgeb_v16i1_v64i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltb (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp sge <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgeb_v32i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleb %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp sge <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgeb_v32i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltb (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp sge <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeb_v32i1_v64i1_mask(i32 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleb %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp sge <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgeb_v32i1_v64i1_mask_mem(i32 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltb (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp sge <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpsgew_v8i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmplew %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgew_v8i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgew_v8i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmplew %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgew_v8i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgew_v8i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmplew %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgew_v8i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgew_v8i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmplew %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgew_v8i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgew_v8i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmplew %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgew_v8i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgew_v8i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmplew %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgew_v8i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp sge <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpsgew_v16i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmplew %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgew_v16i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgew_v16i1_v32i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmplew %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgew_v16i1_v32i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgew_v16i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmplew %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgew_v16i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgew_v16i1_v64i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmplew %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgew_v16i1_v64i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp sge <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgew_v32i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmplew %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp sge <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgew_v32i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgew_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltw (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp sge <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgew_v32i1_v64i1_mask(i32 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmplew %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp sge <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgew_v32i1_v64i1_mask_mem(i32 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgew_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltw (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp sge <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpsged_v4i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpsged_v4i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsged_v4i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpsged_v4i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpsged_v4i1_v8i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %xmm1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsged_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpsged_v4i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsged_v4i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsged_v4i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsged_v4i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsged_v4i1_v16i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %xmm1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsged_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsged_v4i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsged_v4i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsged_v4i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsged_v4i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsged_v4i1_v32i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %xmm1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsged_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsged_v4i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsged_v4i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsged_v4i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsged_v4i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsged_v4i1_v64i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %xmm1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsged_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpsged_v8i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpsged_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpcmpled %zmm0, %zmm1, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsged_v8i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpsged_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpled %zmm0, %zmm1, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsged_v8i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpsged_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpled %zmm0, %zmm1, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsged_v8i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpsged_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpled %zmm0, %zmm1, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsged_v8i1_v16i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %ymm1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpsged_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpled %zmm0, %zmm1, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsged_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %ymm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpsged_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpled %zmm0, %zmm1, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsged_v8i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsged_v8i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsged_v8i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsged_v8i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsged_v8i1_v32i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %ymm1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsged_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %ymm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsged_v8i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsged_v8i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsged_v8i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsged_v8i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsged_v8i1_v64i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %ymm1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsged_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %ymm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpsged_v16i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsged_v16i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsged_v16i1_v32i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsged_v16i1_v32i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsged_v16i1_v32i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %zmm1
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsged_v16i1_v32i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %zmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsged_v16i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsged_v16i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsged_v16i1_v64i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsged_v16i1_v64i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltd (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsged_v16i1_v64i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsged_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rdi), %zmm1
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsged_v16i1_v64i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsged_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastd (%rsi), %zmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpled %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i4 @test_vpcmpsgeq_v2i1_v4i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_vpcmpsgeq_v2i1_v4i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpsgeq_v2i1_v4i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}

define zeroext i4 @test_masked_vpcmpsgeq_v2i1_v4i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i4 @test_vpcmpsgeq_v2i1_v4i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %xmm1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpsgeq_v2i1_v4i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i8 @test_vpcmpsgeq_v2i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpsgeq_v2i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgeq_v2i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpsgeq_v2i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpsgeq_v2i1_v8i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %xmm1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgeq_v2i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpsgeq_v2i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgeq_v2i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgeq_v2i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgeq_v2i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgeq_v2i1_v16i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %xmm1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgeq_v2i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgeq_v2i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgeq_v2i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgeq_v2i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgeq_v2i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgeq_v2i1_v32i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %xmm1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgeq_v2i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgeq_v2i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgeq_v2i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeq_v2i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgeq_v2i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgeq_v2i1_v64i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %xmm1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeq_v2i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %xmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %xmm0, %xmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp sge <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpsgeq_v4i1_v8i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpsgeq_v4i1_v8i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgeq_v4i1_v8i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpsgeq_v4i1_v8i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpsgeq_v4i1_v8i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %ymm1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpsgeq_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %ymm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpsgeq_v4i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgeq_v4i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgeq_v4i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgeq_v4i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgeq_v4i1_v16i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %ymm1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgeq_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %ymm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgeq_v4i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgeq_v4i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgeq_v4i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgeq_v4i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgeq_v4i1_v32i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %ymm1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgeq_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %ymm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgeq_v4i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgeq_v4i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeq_v4i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgeq_v4i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgeq_v4i1_v64i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %ymm1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeq_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %ymm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %ymm0, %ymm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpsgeq_v8i1_v16i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpsgeq_v8i1_v16i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgeq_v8i1_v16i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpsgeq_v8i1_v16i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpsgeq_v8i1_v16i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %zmm1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpsgeq_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %zmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpsgeq_v8i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpsgeq_v8i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgeq_v8i1_v32i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpsgeq_v8i1_v32i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpsgeq_v8i1_v32i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %zmm1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpsgeq_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %zmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpsgeq_v8i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpsgeq_v8i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpnltq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeq_v8i1_v64i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpsgeq_v8i1_v64i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpnltq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpsgeq_v8i1_v64i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpsgeq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rdi), %zmm1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpsgeq_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpsgeq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpbroadcastq (%rsi), %zmm1
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpleq %zmm0, %zmm1, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp sge <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpultb_v16i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltub %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultb_v16i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltub (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultb_v16i1_v32i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultb_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltub %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultb_v16i1_v32i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultb_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltub (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultb_v16i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltub %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultb_v16i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltub (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultb_v16i1_v64i1_mask(i16 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultb_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltub %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %1 = bitcast <2 x i64> %__b to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultb_v16i1_v64i1_mask_mem(i16 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultb_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltub (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <16 x i8>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <16 x i8>
  %2 = icmp ult <16 x i8> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultb_v32i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltub %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp ult <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultb_v32i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltub (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp ult <32 x i8> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultb_v32i1_v64i1_mask(i32 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultb_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltub %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %1 = bitcast <4 x i64> %__b to <32 x i8>
  %2 = icmp ult <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultb_v32i1_v64i1_mask_mem(i32 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultb_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltub (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <32 x i8>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <32 x i8>
  %2 = icmp ult <32 x i8> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpultw_v8i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpultw_v8i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultw_v8i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpultw_v8i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpultw_v8i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultw_v8i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultw_v8i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultw_v8i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultw_v8i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultw_v8i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultw_v8i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %1 = bitcast <2 x i64> %__b to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultw_v8i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <8 x i16>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <8 x i16>
  %2 = icmp ult <8 x i16> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpultw_v16i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultw_v16i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultw_v16i1_v32i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultw_v16i1_v32i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultw_v16i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultw_v16i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultw_v16i1_v64i1_mask(i16 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %1 = bitcast <4 x i64> %__b to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultw_v16i1_v64i1_mask_mem(i16 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <16 x i16>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <16 x i16>
  %2 = icmp ult <16 x i16> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultw_v32i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp ult <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultw_v32i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultw_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuw (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp ult <32 x i16> %0, %1
  %3 = shufflevector <32 x i1> %2, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultw_v32i1_v64i1_mask(i32 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v32i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %1 = bitcast <8 x i64> %__b to <32 x i16>
  %2 = icmp ult <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultw_v32i1_v64i1_mask_mem(i32 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultw_v32i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuw (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <32 x i16>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <32 x i16>
  %2 = icmp ult <32 x i16> %0, %1
  %3 = bitcast i32 %__u to <32 x i1>
  %4 = and <32 x i1> %2, %3
  %5 = shufflevector <32 x i1> %4, <32 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpultd_v4i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpultd_v4i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpultd_v4i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpultd_v4i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpultd_v4i1_v8i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpultd_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpultd_v4i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpultd_v4i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultd_v4i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpultd_v4i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpultd_v4i1_v16i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultd_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpultd_v4i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultd_v4i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultd_v4i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultd_v4i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpultd_v4i1_v32i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultd_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultd_v4i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultd_v4i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultd_v4i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %1 = bitcast <2 x i64> %__b to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultd_v4i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x i32>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultd_v4i1_v64i1_mask_mem_b(<2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultd_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to4}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <4 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <4 x i32> %vec, <4 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpultd_v8i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpultd_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpcmpltud %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpultd_v8i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpultd_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpltud %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultd_v8i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpultd_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpltud %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpultd_v8i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpultd_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovdqa (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpltud %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpultd_v8i1_v16i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vpcmpultd_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rdi), %ymm1
; NoVLX-NEXT:    vpcmpltud %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultd_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_masked_vpcmpultd_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vpbroadcastd (%rsi), %ymm1
; NoVLX-NEXT:    kmovw %edi, %k1
; NoVLX-NEXT:    vpcmpltud %zmm1, %zmm0, %k0 {%k1}
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpultd_v8i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultd_v8i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultd_v8i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultd_v8i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpultd_v8i1_v32i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultd_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultd_v8i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultd_v8i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultd_v8i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %1 = bitcast <4 x i64> %__b to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultd_v8i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultd_v8i1_v64i1_mask_mem_b(<4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultd_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to8}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <8 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <8 x i32> %vec, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i32 @test_vpcmpultd_v16i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultd_v16i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultd_v16i1_v32i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultd_v16i1_v32i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpultd_v16i1_v32i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultd_v16i1_v32i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to16}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultd_v16i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultd_v16i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultd_v16i1_v64i1_mask(i16 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %1 = bitcast <8 x i64> %__b to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultd_v16i1_v64i1_mask_mem(i16 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x i32>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %2, %3
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultd_v16i1_v64i1_mask_mem_b(<8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultd_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltud (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultd_v16i1_v64i1_mask_mem_b(i16 zeroext %__u, <8 x i64> %__a, i32* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultd_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltud (%rsi){1to16}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x i32>
  %load = load i32, i32* %__b
  %vec = insertelement <16 x i32> undef, i32 %load, i32 0
  %1 = shufflevector <16 x i32> %vec, <16 x i32> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <16 x i32> %0, %1
  %3 = bitcast i16 %__u to <16 x i1>
  %4 = and <16 x i1> %3, %2
  %5 = shufflevector <16 x i1> %4, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i4 @test_vpcmpultq_v2i1_v4i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_vpcmpultq_v2i1_v4i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpultq_v2i1_v4i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}

define zeroext i4 @test_masked_vpcmpultq_v2i1_v4i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i4 @test_vpcmpultq_v2i1_v4i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_masked_vpcmpultq_v2i1_v4i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %6 = bitcast <4 x i1> %5 to i4
  ret i4 %6
}


define zeroext i8 @test_vpcmpultq_v2i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpultq_v2i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpultq_v2i1_v8i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpultq_v2i1_v8i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpultq_v2i1_v8i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpultq_v2i1_v8i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpultq_v2i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpultq_v2i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultq_v2i1_v16i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpultq_v2i1_v16i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpultq_v2i1_v16i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultq_v2i1_v16i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpultq_v2i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultq_v2i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultq_v2i1_v32i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultq_v2i1_v32i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpultq_v2i1_v32i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultq_v2i1_v32i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultq_v2i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultq_v2i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultq_v2i1_v64i1_mask(i8 zeroext %__u, <2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %xmm1, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %1 = bitcast <2 x i64> %__b to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultq_v2i1_v64i1_mask_mem(i8 zeroext %__u, <2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x i64>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %2, %extract.i
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultq_v2i1_v64i1_mask_mem_b(<2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultq_v2i1_v64i1_mask_mem_b(i8 zeroext %__u, <2 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to2}, %xmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <2 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <2 x i64> %vec, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %2 = icmp ult <2 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %4 = and <2 x i1> %extract.i, %2
  %5 = shufflevector <2 x i1> %4, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i8 @test_vpcmpultq_v4i1_v8i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vpcmpultq_v4i1_v8i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpultq_v4i1_v8i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}

define zeroext i8 @test_masked_vpcmpultq_v4i1_v8i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i8 @test_vpcmpultq_v4i1_v8i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_masked_vpcmpultq_v4i1_v8i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <8 x i1> %5 to i8
  ret i8 %6
}


define zeroext i16 @test_vpcmpultq_v4i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpultq_v4i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultq_v4i1_v16i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpultq_v4i1_v16i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpultq_v4i1_v16i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultq_v4i1_v16i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpultq_v4i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultq_v4i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultq_v4i1_v32i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultq_v4i1_v32i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpultq_v4i1_v32i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultq_v4i1_v32i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultq_v4i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultq_v4i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultq_v4i1_v64i1_mask(i8 zeroext %__u, <4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %ymm1, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %1 = bitcast <4 x i64> %__b to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultq_v4i1_v64i1_mask_mem(i8 zeroext %__u, <4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x i64>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %2, %extract.i
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultq_v4i1_v64i1_mask_mem_b(<4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultq_v4i1_v64i1_mask_mem_b(i8 zeroext %__u, <4 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to4}, %ymm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <4 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <4 x i64> %vec, <4 x i64> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <4 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %extract.i = shufflevector <8 x i1> %3, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = and <4 x i1> %extract.i, %2
  %5 = shufflevector <4 x i1> %4, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i16 @test_vpcmpultq_v8i1_v16i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vpcmpultq_v8i1_v16i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultq_v8i1_v16i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}

define zeroext i16 @test_masked_vpcmpultq_v8i1_v16i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i16 @test_vpcmpultq_v8i1_v16i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_masked_vpcmpultq_v8i1_v16i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <16 x i1> %5 to i16
  ret i16 %6
}


define zeroext i32 @test_vpcmpultq_v8i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vpcmpultq_v8i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultq_v8i1_v32i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}

define zeroext i32 @test_masked_vpcmpultq_v8i1_v32i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i32 @test_vpcmpultq_v8i1_v32i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_masked_vpcmpultq_v8i1_v32i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <32 x i1> %5 to i32
  ret i32 %6
}


define zeroext i64 @test_vpcmpultq_v8i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vpcmpultq_v8i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultq_v8i1_v64i1_mask(i8 zeroext %__u, <8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq %zmm1, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %1 = bitcast <8 x i64> %__b to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}

define zeroext i64 @test_masked_vpcmpultq_v8i1_v64i1_mask_mem(i8 zeroext %__u, <8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi), %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x i64>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %2, %3
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


define zeroext i64 @test_vpcmpultq_v8i1_v64i1_mask_mem_b(<8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vpcmpultq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vpcmpltuq (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_masked_vpcmpultq_v8i1_v64i1_mask_mem_b(i8 zeroext %__u, <8 x i64> %__a, i64* %__b) local_unnamed_addr {
; CHECK-LABEL: test_masked_vpcmpultq_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vpcmpltuq (%rsi){1to8}, %zmm0, %k0 {%k1}
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x i64>
  %load = load i64, i64* %__b
  %vec = insertelement <8 x i64> undef, i64 %load, i32 0
  %1 = shufflevector <8 x i64> %vec, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = icmp ult <8 x i64> %0, %1
  %3 = bitcast i8 %__u to <8 x i1>
  %4 = and <8 x i1> %3, %2
  %5 = shufflevector <8 x i1> %4, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = bitcast <64 x i1> %5 to i64
  ret i64 %6
}


declare i16 @llvm.x86.avx512.mask.cmp.ps.512(<16 x float> , <16 x float> , i32, i16, i32)
define zeroext i8 @test_vcmpoeqps_v4i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %1 = bitcast <2 x i64> %__b to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vcmpoeqps_v4i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vcmpoeqps_v4i1_v8i1_mask_mem_b(<2 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load float, float* %__b
  %vec = insertelement <4 x float> undef, float %load, i32 0
  %1 = shufflevector <4 x float> %vec, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}


define zeroext i16 @test_vcmpoeqps_v4i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %1 = bitcast <2 x i64> %__b to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqps_v4i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqps_v4i1_v16i1_mask_mem_b(<2 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load float, float* %__b
  %vec = insertelement <4 x float> undef, float %load, i32 0
  %1 = shufflevector <4 x float> %vec, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}


define zeroext i32 @test_vcmpoeqps_v4i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %1 = bitcast <2 x i64> %__b to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqps_v4i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqps_v4i1_v32i1_mask_mem_b(<2 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load float, float* %__b
  %vec = insertelement <4 x float> undef, float %load, i32 0
  %1 = shufflevector <4 x float> %vec, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}


define zeroext i64 @test_vcmpoeqps_v4i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %1 = bitcast <2 x i64> %__b to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqps_v4i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <4 x float>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqps_v4i1_v64i1_mask_mem_b(<2 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to4}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <4 x float>
  %load = load float, float* %__b
  %vec = insertelement <4 x float> undef, float %load, i32 0
  %1 = shufflevector <4 x float> %vec, <4 x float> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x float> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}


define zeroext i16 @test_vcmpoeqps_v8i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vcmpoeqps_v8i1_v16i1_mask:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM1<def> %YMM1<kill> %ZMM1<def>
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vcmpeqps %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %1 = bitcast <4 x i64> %__b to <8 x float>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqps_v8i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vcmpoeqps_v8i1_v16i1_mask_mem:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vmovaps (%rdi), %ymm1
; NoVLX-NEXT:    vcmpeqps %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x float>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqps_v8i1_v16i1_mask_mem_b(<4 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; NoVLX-LABEL: test_vcmpoeqps_v8i1_v16i1_mask_mem_b:
; NoVLX:       ## BB#0: ## %entry
; NoVLX-NEXT:    ## kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; NoVLX-NEXT:    vbroadcastss (%rdi), %ymm1
; NoVLX-NEXT:    vcmpeqps %zmm1, %zmm0, %k0
; NoVLX-NEXT:    kshiftlw $8, %k0, %k0
; NoVLX-NEXT:    kshiftrw $8, %k0, %k0
; NoVLX-NEXT:    kmovw %k0, %eax
; NoVLX-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %load = load float, float* %__b
  %vec = insertelement <8 x float> undef, float %load, i32 0
  %1 = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}


define zeroext i32 @test_vcmpoeqps_v8i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %1 = bitcast <4 x i64> %__b to <8 x float>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqps_v8i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x float>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqps_v8i1_v32i1_mask_mem_b(<4 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %load = load float, float* %__b
  %vec = insertelement <8 x float> undef, float %load, i32 0
  %1 = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}


define zeroext i64 @test_vcmpoeqps_v8i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %1 = bitcast <4 x i64> %__b to <8 x float>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqps_v8i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <8 x float>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqps_v8i1_v64i1_mask_mem_b(<4 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to8}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <8 x float>
  %load = load float, float* %__b
  %vec = insertelement <8 x float> undef, float %load, i32 0
  %1 = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <8 x float> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}


define zeroext i32 @test_vcmpoeqps_v16i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %1 = bitcast <8 x i64> %__b to <16 x float>
  %2 = fcmp oeq <16 x float> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqps_v16i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x float>
  %2 = fcmp oeq <16 x float> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqps_v16i1_v32i1_mask_mem_b(<8 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %load = load float, float* %__b
  %vec = insertelement <16 x float> undef, float %load, i32 0
  %1 = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <16 x float> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}


define zeroext i32 @test_vcmpoeqps_v16i1_v32i1_sae_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v32i1_sae_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpleps {sae}, %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %1 = bitcast <8 x i64> %__b to <16 x float>
  %2 = call i16 @llvm.x86.avx512.mask.cmp.ps.512(<16 x float> %0, <16 x float> %1, i32 2, i16 -1, i32 8)
  %3 = zext i16 %2 to i32
  ret i32 %3
}


define zeroext i64 @test_vcmpoeqps_v16i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %1 = bitcast <8 x i64> %__b to <16 x float>
  %2 = fcmp oeq <16 x float> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqps_v16i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <16 x float>
  %2 = fcmp oeq <16 x float> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqps_v16i1_v64i1_mask_mem_b(<8 x i64> %__a, float* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqps (%rdi){1to16}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %load = load float, float* %__b
  %vec = insertelement <16 x float> undef, float %load, i32 0
  %1 = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <16 x float> %0, %1
  %3 = shufflevector <16 x i1> %2, <16 x i1> zeroinitializer, <64 x i32> <i32 0,i32 1,i32 2,i32 3,i32 4,i32 5,i32 6,i32 7,i32 8,i32 9,i32 10,i32 11,i32 12,i32 13,i32 14,i32 15,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31,i32 16,i32 17,i32 18,i32 19,i32 20,i32 21,i32 22,i32 23,i32 24,i32 25,i32 26,i32 27,i32 28,i32 29,i32 30,i32 31>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}


define zeroext i64 @test_vcmpoeqps_v16i1_v64i1_sae_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqps_v16i1_v64i1_sae_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpleps {sae}, %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    movzwl %ax, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <16 x float>
  %1 = bitcast <8 x i64> %__b to <16 x float>
  %2 = call i16 @llvm.x86.avx512.mask.cmp.ps.512(<16 x float> %0, <16 x float> %1, i32 2, i16 -1, i32 8)
  %3 = zext i16 %2 to i64
  ret i64 %3
}


declare i8 @llvm.x86.avx512.mask.cmp.pd.512(<8 x double> , <8 x double> , i32, i8, i32)
define zeroext i4 @test_vcmpoeqpd_v2i1_v4i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v4i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %1 = bitcast <2 x i64> %__b to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_vcmpoeqpd_v2i1_v4i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v4i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}

define zeroext i4 @test_vcmpoeqpd_v2i1_v4i1_mask_mem_b(<2 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v4i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load double, double* %__b
  %vec = insertelement <2 x double> undef, double %load, i32 0
  %1 = shufflevector <2 x double> %vec, <2 x double> undef, <2 x i32> <i32 0, i32 0>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i1> %3 to i4
  ret i4 %4
}


define zeroext i8 @test_vcmpoeqpd_v2i1_v8i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %1 = bitcast <2 x i64> %__b to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vcmpoeqpd_v2i1_v8i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vcmpoeqpd_v2i1_v8i1_mask_mem_b(<2 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load double, double* %__b
  %vec = insertelement <2 x double> undef, double %load, i32 0
  %1 = shufflevector <2 x double> %vec, <2 x double> undef, <2 x i32> <i32 0, i32 0>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}


define zeroext i16 @test_vcmpoeqpd_v2i1_v16i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %1 = bitcast <2 x i64> %__b to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqpd_v2i1_v16i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqpd_v2i1_v16i1_mask_mem_b(<2 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load double, double* %__b
  %vec = insertelement <2 x double> undef, double %load, i32 0
  %1 = shufflevector <2 x double> %vec, <2 x double> undef, <2 x i32> <i32 0, i32 0>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}


define zeroext i32 @test_vcmpoeqpd_v2i1_v32i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %1 = bitcast <2 x i64> %__b to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqpd_v2i1_v32i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqpd_v2i1_v32i1_mask_mem_b(<2 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load double, double* %__b
  %vec = insertelement <2 x double> undef, double %load, i32 0
  %1 = shufflevector <2 x double> %vec, <2 x double> undef, <2 x i32> <i32 0, i32 0>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}


define zeroext i64 @test_vcmpoeqpd_v2i1_v64i1_mask(<2 x i64> %__a, <2 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %xmm1, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %1 = bitcast <2 x i64> %__b to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqpd_v2i1_v64i1_mask_mem(<2 x i64> %__a, <2 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load <2 x i64>, <2 x i64>* %__b
  %1 = bitcast <2 x i64> %load to <2 x double>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqpd_v2i1_v64i1_mask_mem_b(<2 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v2i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to2}, %xmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__a to <2 x double>
  %load = load double, double* %__b
  %vec = insertelement <2 x double> undef, double %load, i32 0
  %1 = shufflevector <2 x double> %vec, <2 x double> undef, <2 x i32> <i32 0, i32 0>
  %2 = fcmp oeq <2 x double> %0, %1
  %3 = shufflevector <2 x i1> %2, <2 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}


define zeroext i8 @test_vcmpoeqpd_v4i1_v8i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v8i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %1 = bitcast <4 x i64> %__b to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vcmpoeqpd_v4i1_v8i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v8i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}

define zeroext i8 @test_vcmpoeqpd_v4i1_v8i1_mask_mem_b(<4 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v8i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load double, double* %__b
  %vec = insertelement <4 x double> undef, double %load, i32 0
  %1 = shufflevector <4 x double> %vec, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <8 x i1> %3 to i8
  ret i8 %4
}


define zeroext i16 @test_vcmpoeqpd_v4i1_v16i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %1 = bitcast <4 x i64> %__b to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqpd_v4i1_v16i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqpd_v4i1_v16i1_mask_mem_b(<4 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load double, double* %__b
  %vec = insertelement <4 x double> undef, double %load, i32 0
  %1 = shufflevector <4 x double> %vec, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}


define zeroext i32 @test_vcmpoeqpd_v4i1_v32i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %1 = bitcast <4 x i64> %__b to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqpd_v4i1_v32i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqpd_v4i1_v32i1_mask_mem_b(<4 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load double, double* %__b
  %vec = insertelement <4 x double> undef, double %load, i32 0
  %1 = shufflevector <4 x double> %vec, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}


define zeroext i64 @test_vcmpoeqpd_v4i1_v64i1_mask(<4 x i64> %__a, <4 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %1 = bitcast <4 x i64> %__b to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqpd_v4i1_v64i1_mask_mem(<4 x i64> %__a, <4 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load <4 x i64>, <4 x i64>* %__b
  %1 = bitcast <4 x i64> %load to <4 x double>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqpd_v4i1_v64i1_mask_mem_b(<4 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v4i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to4}, %ymm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__a to <4 x double>
  %load = load double, double* %__b
  %vec = insertelement <4 x double> undef, double %load, i32 0
  %1 = shufflevector <4 x double> %vec, <4 x double> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <4 x double> %0, %1
  %3 = shufflevector <4 x i1> %2, <4 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}


define zeroext i16 @test_vcmpoeqpd_v8i1_v16i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v16i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %1 = bitcast <8 x i64> %__b to <8 x double>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqpd_v8i1_v16i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v16i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x double>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i16 @test_vcmpoeqpd_v8i1_v16i1_mask_mem_b(<8 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v16i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %load = load double, double* %__b
  %vec = insertelement <8 x double> undef, double %load, i32 0
  %1 = shufflevector <8 x double> %vec, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}


define zeroext i16 @test_vcmpoeqpd_v8i1_v16i1_sae_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v16i1_sae_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmplepd {sae}, %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %1 = bitcast <8 x i64> %__b to <8 x double>
  %2 = call i8 @llvm.x86.avx512.mask.cmp.pd.512(<8 x double> %0, <8 x double> %1, i32 2, i8 -1, i32 8)
  %3 = zext i8 %2 to i16
  ret i16 %3
}


define zeroext i32 @test_vcmpoeqpd_v8i1_v32i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v32i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %1 = bitcast <8 x i64> %__b to <8 x double>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqpd_v8i1_v32i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v32i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x double>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}

define zeroext i32 @test_vcmpoeqpd_v8i1_v32i1_mask_mem_b(<8 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v32i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %load = load double, double* %__b
  %vec = insertelement <8 x double> undef, double %load, i32 0
  %1 = shufflevector <8 x double> %vec, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <32 x i1> %3 to i32
  ret i32 %4
}


define zeroext i32 @test_vcmpoeqpd_v8i1_v32i1_sae_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v32i1_sae_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmplepd {sae}, %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovb %k0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %1 = bitcast <8 x i64> %__b to <8 x double>
  %2 = call i8 @llvm.x86.avx512.mask.cmp.pd.512(<8 x double> %0, <8 x double> %1, i32 2, i8 -1, i32 8)
  %3 = zext i8 %2 to i32
  ret i32 %3
}


define zeroext i64 @test_vcmpoeqpd_v8i1_v64i1_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v64i1_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %1 = bitcast <8 x i64> %__b to <8 x double>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqpd_v8i1_v64i1_mask_mem(<8 x i64> %__a, <8 x i64>* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v64i1_mask_mem:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi), %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %load = load <8 x i64>, <8 x i64>* %__b
  %1 = bitcast <8 x i64> %load to <8 x double>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}

define zeroext i64 @test_vcmpoeqpd_v8i1_v64i1_mask_mem_b(<8 x i64> %__a, double* %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v64i1_mask_mem_b:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmpeqpd (%rdi){1to8}, %zmm0, %k0
; CHECK-NEXT:    kmovq %k0, %rax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %load = load double, double* %__b
  %vec = insertelement <8 x double> undef, double %load, i32 0
  %1 = shufflevector <8 x double> %vec, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %2 = fcmp oeq <8 x double> %0, %1
  %3 = shufflevector <8 x i1> %2, <8 x i1> zeroinitializer, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = bitcast <64 x i1> %3 to i64
  ret i64 %4
}


define zeroext i64 @test_vcmpoeqpd_v8i1_v64i1_sae_mask(<8 x i64> %__a, <8 x i64> %__b) local_unnamed_addr {
; CHECK-LABEL: test_vcmpoeqpd_v8i1_v64i1_sae_mask:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    vcmplepd {sae}, %zmm1, %zmm0, %k0
; CHECK-NEXT:    kmovd %k0, %eax
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__a to <8 x double>
  %1 = bitcast <8 x i64> %__b to <8 x double>
  %2 = call i8 @llvm.x86.avx512.mask.cmp.pd.512(<8 x double> %0, <8 x double> %1, i32 2, i8 -1, i32 8)
  %3 = zext i8 %2 to i64
  ret i64 %3
}



